/* $Id: kModulePage.cpp,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kModulePage - Module overview dialog. (to be notebook page)
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */


/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kContainer.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"
#include "kModuleRecord.h"
#include "kModuleContainer.h"
#include "kObjectRecord.h"
#include "kObjectContainer.h"
#include "kModulePage.h"
#include "kModuleDetails.h"
#include "kTaskMgr_defs.h"
#include "kTaskMgr.h"


/**
 * Forwards to the container.
 * @param     usId     Container id.
 * @param     pRecord  Pointer to the record which is selected by either the key
 */
VOID kModulePage::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    pContainer->cnrContextMenu(usId, pRecord);
}


/**
 * Forwards to the container.
 */
VOID kModulePage::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    pContainer->cnrEnter(usId, hwndCnr, pRecord, fKey);
}



/**
 * Create a all modules overview page.
 * @param     pNtbk  Pointer to notebook object.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Throws kError on error.
 */
kModulePage::kModulePage(kNotebookBase *pNtbk) throw (kError)
    : kNotebookPageBase(DL_KMODULEPAGE, NULLHANDLE, pNtbk),
    pContainer(NULL)
{
    /*
     * Container border size
     */
    ptlBorder.x = 5;
    ptlBorder.y = 4;
    WinMapDlgPoints(hwnd, &ptlBorder, 1, TRUE);

    /*
     * Create detail container
     */
    pContainer = new kModuleContainer(hwnd, KMODPG_CNR);
    pContainer->update();
}



/**
 * Create a import module page.
 * @param     pNtbk  Pointer to notebook object.
 * @param     hMTE   Handle to module which we are to show the imported modules for.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark    Throws kError on error.
 */
kModulePage::kModulePage(kNotebookBase *pNtbk, USHORT hMTE) throw (kError)
    : kNotebookPageBase(DL_KMODULEPAGE, NULLHANDLE, pNtbk),
    pContainer(NULL)
{
    /*
     * Container border size
     */
    ptlBorder.x = 5;
    ptlBorder.y = 4;
    WinMapDlgPoints(hwnd, &ptlBorder, 1, TRUE);

    /*
     * Create detail container
     */
    pContainer = new kModuleContainer(hwnd, KMODPG_CNR, hMTE);
    pContainer->update();
}



/**
 * Desctructor stub.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * @remark
 */
kModulePage::~kModulePage()
{
    if (pContainer != NULL)
        delete pContainer;
    pContainer = NULL;
}


/**
 * Move and size the container and dialog.
 * @param     prctlPage  New size of dialog.
 */
VOID  kModulePage::ntfySized(LONG cx, LONG cy)
{
    /*
     * Resize the dialog
     */
    resizeAndMove(
        0,
        0,
        cx,
        cy);

    /*
     * Resize the container.
     */
    pContainer->resizeAndMove(
        ptlBorder.x,
        ptlBorder.y,
        cx - ptlBorder.x*2,
        cy - ptlBorder.y*2
        );
}

