/* $Id: kModuleContainer.h,v 1.1 2000/04/29 19:06:35 stknut Exp $
 *
 * kModuleContainer - generic module container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */
#ifndef _kModuleContainer_h_
#define _kModuleContainer_h_




/**
 * Generic module container.
 * @author      knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
class kModuleContainer : public kDetailCnr
{
private:
    /** @cat private data */
    USHORT              hMTE;           /* 0xFFFF: all, < 0xFFFF: dependant/imported modules. */
    kMenuBase *         pMenuModule;    /* Pointer to record menu. */
    kMenuBase *         pMenuCnrAll;    /* Pointer to container menu. */
    kModuleRecord *     pCurRecord;     /* Pointer to the current record actual for menu action. */
    USHORT              usSortId;       /* MenuId of the currently selected sorting menu choice. */

    /** @cat private methods */
    BOOL    kInsertAllModules();
    BOOL    kInsertImpModules();

    /** @cat private events */
    VOID    menuEnd(USHORT usMenuId, HWND hwndMnu); //WM_MENUEND
    VOID    command(USHORT usCmd, USHORT usSource, BOOL fPointer); //WM_COMMAND

    SHORT   sortCallBack(kCnrMiniRecord *pRecord1, kCnrMiniRecord *pRecord2);

public:
    /**
     * hMTE = 0xFFFF: View all modules
     * hMTE < 0xFFFF: View dependants of this module
     */
    kModuleContainer(HWND hwndDlg, ULONG ulCnrId, USHORT hMTE = 0xFFFF) throw (kError);
    ~kModuleContainer();

    /** @cat events which sorrily have to be invoked from the outside... */
    VOID  cnrContextMenu(USHORT usId, PRECORDCORE pRecord);
    VOID  cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey);

    VOID  update();
};


#endif

