/* $Id: kModuleContainer.cpp,v 1.1 2000/04/29 19:06:34 stknut Exp $
 *
 * kModuleContainer - generic module container.
 *
 * Copyright (c) 2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 *
 */

/*******************************************************************************
*   Defined Constants And Macros                                               *
*******************************************************************************/
#define INCL_WIN
#define INCL_GPI
#define INCL_BASE


/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>
#ifdef USE_KLIB
    #include <kAssert.h>
    #include <kLog.h>
    #include <kHeap.h>
#else
    #include <malloc.h>
#endif
#include <memory.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

#include "kBase.h"
#include "kError.h"
#include "kDlgBase.h"
#include "kMenuBase.h"
#include "kClickDlg.h"
#include "kContainer.h"
#include "kNotebookBase.h"
#include "kNotebookPageBase.h"

#include "kQuerySysState.h"
#include "kDetailBase.h"
#include "kModuleRecord.h"
#include "kModuleContainer.h"
#include "kObjectRecord.h"
#include "kObjectContainer.h"
#include "kModuleDetails.h"
#include "kTaskMgr.h"
#include "kTaskMgr_defs.h"


/**
 * Updates the content of the container if ALL modules are to be included. (hMTE = 0xFFFF)
 * @returns   success indicator.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
BOOL   kModuleContainer::kInsertAllModules()
{
    qsLrec_t *      pCur;
    int             c;

    ASSERT(hMTE == 0xFFFF);

    /*
     * Loop thru all MTE records and count them
     */
    #if 0
    for (c = 0, pCur = QSGetMteFirstData(); pCur != NULL; pCur = (qsLrec_t*)pCur->pNextRec)
        c++;
    #else
    c = 0;
    pCur = QSGetMteFirstData();
    while (pCur != NULL)
        {
        c++;
        /*
         * Bug detected in OS/2 FP13. Probably a problem which occurs
         * in _LDRSysMteInfo when qsCheckCache is calle before writing
         * object info. The result is that the cache flushed and the
         * attempt of updating the qsLrec_t next and object pointer is
         * not done. This used to work earlier and on Aurora AFAIK.
         *
         * The fix for this problem is to check if the pObjInfo is NULL
         * while the number of objects isn't 0 and correct this. pNextRec
         * will also be NULL at this time. This will be have to corrected
         * before we exit the loop or moves to the next record.
         * There is also a nasty alignment of the object info... Hope
         * I got it right. (This aligment seems new to FP13.)
         */
        if (pCur->pObjInfo == NULL /*&& pCur->pNextRec == NULL*/ && pCur->ctObj != 0)
            {
            pCur->pObjInfo = (qsLObjrec_t*)(
                (char*)pCur
                + ((sizeof(qsLrec_t)                     /* size of the lib record */
                   + pCur->ctImpMod * sizeof(short)    /* size of the array of imported modules */
                   + strlen((char*)pCur->pName) + 1    /* size of the filename */
                   + 3) & ~3UL));                          /* the size is align on 4 bytes boundrary */
            pCur->pNextRec = (qsLrec_t*)((char*)pCur->pObjInfo
                                         + sizeof(qsLObjrec_t) * pCur->ctObj);
            }

        /* next */
        pCur = (qsLrec_t*)pCur->pNextRec;
        }

    #endif

    if (c > 0)
    {
        kModuleRecord  *pCurCnrRec, *pCnrRec;

        /*
         * Allocate container records for all the MTEs
         */
        pCurCnrRec = pCnrRec = (kModuleRecord*)allocMiniRec(sizeof(kModuleRecord), c);
        if (pCurCnrRec == NULL)
            return FALSE;               /* FIXME: complain about this! */

        /*
         * Loop thru the list of processes and update the container.
         */
        pCur = QSGetMteFirstData();
        while (pCur != NULL)
        {
            /*
             * Init and set the record.
             */
            pCurCnrRec->init();
            pCurCnrRec->set(pCur);


            /* next */
            pCur = (qsLrec_t*)pCur->pNextRec;
            pCurCnrRec = (kModuleRecord*)pCurCnrRec->getNext();
        }

        /*
         * Insert the record at bottom of the container.
         */
        return insertAtTop(pCnrRec, c);
    }


    return TRUE;

}




/**
 * Inserts the imported module info into the container for it.
 * @returns   success indicator.
 * @param     pMteRec  Pointer to the mte record for the module
 */
BOOL kModuleContainer::kInsertImpModules()
{
    qsLrec_t *pMteRec;

    ASSERT(hMTE < 0xFFFF);

    /* Find the module indentified by hMTE */
    pMteRec = QSGetMteData(hMTE);
    if (pMteRec != NULL)
    {
        int c = (int)pMteRec->ctImpMod;
        int i;

        /* Are there any at all? */
        if (c > 0)
        {
            kModuleRecord * pCnrRec,
                          * pCurCnrRec;
            PUSHORT         pahmte = (PUSHORT)((int)pMteRec + sizeof(qsLrec_t));

            /*
             * Allocate container records.
             */
            pCurCnrRec = pCnrRec = (kModuleRecord*)allocMiniRec(sizeof(kModuleRecord), c);
            if (pCurCnrRec == NULL)
                return FALSE;               /* FIXME - complain about this! */

            /*
             * Fill the records with data.
             */
            for (i = 0; i < c; i++, pCurCnrRec = (kModuleRecord*)pCurCnrRec->getNext())
            {
                qsLrec_t *pMteImpRec;

                /*
                 * Initiate record.
                 */
                pCurCnrRec->init();

                /*
                 * Get Mte record.
                 */
                pMteImpRec = QSGetMteData(pahmte[i]);
                if (pMteImpRec != NULL)
                    pCurCnrRec->set(pMteImpRec);
                else
                    pCurCnrRec->set(pahmte[i]);
            }

            /*
             * Insert records
             */
            return insertAtTop(pCnrRec, c);
        }
    }
    else
        return FALSE;

    return TRUE;
}


/**
 * Menu is closing. Remove emphasis.
 * @param     usMenuId  Menu id.
 * @param     hwndMnu   Handle to menu window.
 */
VOID kModuleContainer::menuEnd(USHORT usMenuId, HWND hwndMnu)
{
    setRecordEmphasis(pCurRecord, FALSE, CRA_SOURCE);
    hwndMnu = hwndMnu;
    usMenuId = usMenuId;
}


/**
 * Command events.
 * @param     usCmd     Control id which send/posted the message.
 * @param     usSource  Source id.
 * @param     fPointer  Mouse pointer flag.
 * @remark    dismisses the dialog if DID_OK or DID_CANCEL.
 */
VOID  kModuleContainer::command(USHORT usCmd, USHORT usSource, BOOL fPointer)
{
    switch (usCmd)
    {
        case IDM_CNR_MOD_DETAILS:
            if (pCurRecord)
            {
                try
                {
                    new kModuleDetails(pCurRecord->gethMte(), hwndCnr)->show();
                }
                catch(kError err)
                {
                    err.logError();
                    err.showError(kTaskMgr::pszErrorTitle);
                }
            }
            break;

        case IDM_CNR_MOD_ALL_REFRESH:
            update();
            break;

        case IDM_CNR_MOD_ALL_SORT_HMTE:
        case IDM_CNR_MOD_ALL_SORT_TYPE:
        case IDM_CNR_MOD_ALL_SORT_IMPMODS:
        case IDM_CNR_MOD_ALL_SORT_OBJECTS:
        case IDM_CNR_MOD_ALL_SORT_NAME:
            if (usSortId != usCmd)
            {
                usSortId = usCmd;
                pMenuCnrAll->checkMenuItem(IDM_CNR_MOD_ALL_SORT_HMTE   , usCmd == IDM_CNR_MOD_ALL_SORT_HMTE);
                pMenuCnrAll->checkMenuItem(IDM_CNR_MOD_ALL_SORT_TYPE   , usCmd == IDM_CNR_MOD_ALL_SORT_TYPE);
                pMenuCnrAll->checkMenuItem(IDM_CNR_MOD_ALL_SORT_IMPMODS, usCmd == IDM_CNR_MOD_ALL_SORT_IMPMODS);
                pMenuCnrAll->checkMenuItem(IDM_CNR_MOD_ALL_SORT_OBJECTS, usCmd == IDM_CNR_MOD_ALL_SORT_OBJECTS);
                pMenuCnrAll->checkMenuItem(IDM_CNR_MOD_ALL_SORT_NAME   , usCmd == IDM_CNR_MOD_ALL_SORT_NAME);

                /* resort container */
                enableSorting();
            }
            else
            {
                usSortId = 0xFFFF;
                disableSorting();
                pMenuCnrAll->checkMenuItem(usCmd, FALSE);
            }
            break;

    }

    usSource = usSource;
    fPointer = fPointer;
}


/**
 * Record sort callback function - compares two records.
 * @returns   >  0  when pRecord1  >  pRecord2
 *            <  0  when pRecord1  <  pRecord2
 *            == 0  when pRecord1 ==  pRecord2
 * @param     pRecord1  Pointer to first record.
 * @param     pRecord2  Pointer to second record.
 */
SHORT  kModuleContainer::sortCallBack(kCnrMiniRecord *pRecord1, kCnrMiniRecord *pRecord2)
{
    kModuleRecord * pRec1 = (kModuleRecord *)pRecord1;
    kModuleRecord * pRec2 = (kModuleRecord *)pRecord2;

    if (pRec1 != NULL && pRec2 != NULL)
    {
        int iTmp = 1;
        switch (usSortId)
        {
            case IDM_CNR_MOD_ALL_SORT_HMTE:
                iTmp = pRec1->gethMte() - pRec2->gethMte();
                break;

            case IDM_CNR_MOD_ALL_SORT_TYPE:
                iTmp = strcmp(pRec1->getType(), pRec2->getType());
                break;

            case IDM_CNR_MOD_ALL_SORT_IMPMODS:
                iTmp = strcmp(pRec1->getImpMods(), pRec2->getImpMods());
                break;

            case IDM_CNR_MOD_ALL_SORT_OBJECTS:
                iTmp = strcmp(pRec1->getObjects(), pRec2->getObjects());
                break;

            case IDM_CNR_MOD_ALL_SORT_NAME:
                iTmp = strcmp(pRec1->getName(), pRec2->getName());
                break;
        }
        return (SHORT)((iTmp > 0) ? 1 : (iTmp < 0) ? -1 : 0);
    }
    return 1;
}



/**
 * Constructor.
 * @returns
 * @param     hwndDlg   Handle to dialog window.
 * @param     ulCnrId   ID of the container dialog item in hwndDlg.
 * @param     hMte      hMTE = 0xFFFF:  View all modules
 *                      hMTE < 0xFFFF: View dependants of this module
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
kModuleContainer::kModuleContainer(HWND hwndDlg, ULONG ulCnrId, USHORT hMTE/* = 0xFFFF*/) throw(kError)
    : kDetailCnr(WinWindowFromID(hwndDlg, ulCnrId),
                 0,
                 hMTE == 0xFFFF ? "Executable Module Overview" : "Imported Modules",
                 kModuleRecord::cFieldInfo,
                 (PFIELDINFO)&kModuleRecord::aFieldInfo[0]),
    hMTE(hMTE), pCurRecord(NULL)
{
    /*
     * Create menus.
     */
    pMenuModule = new kMenuBase(IDM_CNR_MODULE, NULLHANDLE, hwndCnr, TRUE);
    pMenuCnrAll = new kMenuBase(IDM_CNR_MODULE_ALL, NULLHANDLE, hwndCnr, TRUE);
}


/**
 * Destructor.
 */
kModuleContainer::~kModuleContainer()
{
    if (pMenuModule != NULL)
        delete pMenuModule;
    if (pMenuCnrAll != NULL)
        delete pMenuCnrAll;
}


/**
 * Displays the popup menu for the container.
 * @param     usId     Container id.
 * @param     pRecord  Pointer to the record which is selected by either the key
 */
VOID kModuleContainer::cnrContextMenu(USHORT usId, PRECORDCORE pRecord)
{
    if (pMenuModule && pMenuCnrAll)
    {
        pCurRecord = (kModuleRecord*)pRecord;
        setRecordEmphasis(pCurRecord, TRUE, CRA_SOURCE);
        if (pRecord != NULL)
            pMenuModule->popup();
        else
            pMenuCnrAll->popup();
    }
    usId = usId;
}


/**
 * Enter or double click on record in the container.
 * This action will bring up the detail dialog for the record.
 */
VOID kModuleContainer::cnrEnter(USHORT usId, HWND hwndCnr, PRECORDCORE pRecord, ULONG fKey)
{
    if (pRecord != NULL)
    {
        pCurRecord = (kModuleRecord*)pRecord;
        command(IDM_CNR_MOD_DETAILS, 0, 0);
    }
    usId = usId;
    fKey = fKey;
    hwndCnr = hwndCnr;
}



/**
 * Updates the contents of the container.
 * @author    knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 */
VOID  kModuleContainer::update()
{
    /*
     * Delete all records in the container!
     */
    removeAllRecords();

    /*
     * Insert records
     */
    if (hMTE == 0xFFFF)
        kInsertAllModules();
    else
        kInsertImpModules();
}

