/***************************************************************************\
* install.cmd - this installs the Donkey package              950728
*
* Copyright (c) 1995 Martin Lafaix. All Rights Reserved.
\***************************************************************************/

signal on halt; trace off

/* Load the RexxUtil functions */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

/* Initialisation */
arg opt _
if opt = '-DEBUG' | opt = '/DEBUG' then debug = 1
if opt = '/REMOVE' | opt = '-REMOVE' then signal remove
if opt = '-SAVE' | opt = '/SAVE' then
   parse value _ with file .

call ansisetup
say LWhi||BBlu'Abcd'
call header

step0:
'@cls'
say '    Ŀ'
say '     'LBro'Step 0'LWhi' - Initialisation                                             '
say '    '
say      
say '      When you see the following message and want to agree -- that is,'
say '      using the translation table associated with the default code page'
say '      --, what is your answer ?'
say
say BWhi||Blu||sysgetmessage(1745)||LWhi||BBlu
step0a:
call charout ,'      Default answer: 'LGre
pull YES
call charout ,LWhi

hlpname = getfilepath(LRed"Donkey"LWhi" Help file", ,
                      "DONKEY.HLP", ,
                      SysSearchPath("HELP","DONKEY.HLP"))

startupdir = getfilepath(LRed"Donkey"LWhi" DLL", ,
                         "DONKEYHK.DLL", ,
                         SysSearchPath("PATH", "DONKEYHK.DLL"))
if translate(right(startupdir,12)) = "DONKEYHK.DLL" then
   startupdir = left(startupdir, length(startupdir)-12)
if right(startupdir,1) = "\" then
   startupdir = left(startupdir,length(startupdir)-1)
 
say
say '      Default answer is'LGre YES LWhi
say '      help file is'LGre hlpname LWhi
say '      DLL path is'LGre startupdir LWhi
say
if isnotcorrect() then signal step0a

if opt = '/SAVE' | opt = '-SAVE' then
   do
      call lineout file, '/* 'file' - an non-interactive script produced by DONKEY 'date(s)'*/'
      call lineout file
      call lineout file, "Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'"
      call lineout file, "Call SysLoadFuncs"
      call lineout file, 'YES="'YES'"'
      call lineout file, 'hlpname="'hlpname'"'
      call lineout file, 'startupdir="'startupdir'"'
      call lineout file
   end

step1:
'@cls'
say '    Ŀ'
say '     'LBro'Step 1'LWhi' - Creating the 'LRed'Donkey Daemon'LWhi' object                          '
say '    '
say      
say '      A 'LRed'Donkey Daemon'LWhi' object will be added to your startup folder.  If you'
say '      don''t intend to use it -- that is, you don''t want to set the initial'
say '      keyboard state and you don''t want to use 'LRed'Donkey'LWhi'''s special features --'
say '      you don''t have to create it.'
say
call charout ,"      Do you want to create it ? [Y/n] :"
key = ''
do until pos(key,"yYnN"||"0d"x) > 0
   key = SysGetKey("ECHO")
   call charout ,"082008"x
end /* do */
say key
if key ='N' | key = 'n' then signal step2

objtitle = "Donkey Daemon"
objdest = '<WP_START>'
objid = '<ML_DONKEYDAEMON>'
helppanel = 4321
parameters = '-gluey:5 -initial:N -lock:shift'
exename = getfilepath(LRed"Donkey Daemon"LWhi, "DK.EXE", SysSearchPath("PATH","DK.EXE"))

call createobj

call SysOpenObject objid, 'DEFAULT', 0

step2:
'@cls'
say '    Ŀ'
say '     'LBro'Step 2'LWhi' - Creating the 'LRed'Donkey'LWhi' object                                 '
say '    '
say      
say '      A 'LRed'Donkey'LWhi' object will be added to your system setup folder.  It will'
say '      allow you to set the various 'LRed'Donkey'LWhi' settings.'
say

objtitle = "Donkey"
objdest = '<WP_CONFIG>'
objid = '<ML_DONKEY>'
helppanel = 10001
parameters = '-answer:'YES
exename = getfilepath(LRed"Donkey"LWhi" object", "DONKEY.EXE", SysSearchPath("PATH","DONKEY.EXE"))

call createobj

exit

isnotcorrect:
   call charout ,"      Is this correct ? [Y/n] :"
   key = ''
   do until pos(key,"yYnN"||"0d"x) > 0
      key = SysGetKey("ECHO")
      call charout ,"082008"x
   end /* do */
   if key = '0d'x then
      say ' '
   else
      say LGre||key||LWhi
   return key = "n" | key = "N"

getfilepath: /* arg(1) = title, arg(2) = file name & arg(3) = default path */
   _exename = arg(3)
   say
   say '      Path of the 'arg(1)' ('arg(2)') :'LGre _exename||LWhi
   say
   /* Read the DK.EXE path */
   if isnotcorrect() then _exename = getname(arg(2))
   if translate(right(_exename,length(arg(2)))) \= arg(2) then
      if right(_exename,1) = "\" then
         _exename = _exename||arg(2)
      else
         _exename = _exename"\"arg(2)
   return _exename
 
getname:
   say "      Please enter the complete path for" arg(1)
   do forever
      call charout, "      "LGre
      pull name
      call charout, LWhi
      if translate(right(name,length(arg(1)))) \= arg(1) then
         if right(name,1) = "\" then
            name = name||arg(1)
         else
            name = name"\"arg(1)
      if stream(name,"c","query exists") = '' then
         say "0d0a"x"      The path"LGre name LWhi"is invalid!  Please enter it again."
      else
         leave
   end
   return name

createobj:
   /* Create the program object */
   if debug = 1 then
      do
         say
         say '      Creating a program object:'
         say      
         say '              Class = WPProgram'
         say '               Name ='LGre objtitle LWhi
         say '        Destination ='LGre objdest LWhi
         say '         Parameters = PROGTYPE    = PM'
         say '                      EXENAME     ='LGre exename LWhi
         say '                      PARAMETERS  ='LGre parameters LWhi
         say '                      STARTUPDIR  ='LGre startupdir LWhi
         say '                      HELPPANEL   ='LGre helppanel LWhi
         say '                      HELPLIBRARY ='LGre hlpname LWhi
         say '                      OBJECTID    ='LGre objid LWhi
         say '             Option = REPLACE'
         say
         if isnotcorrect() then
            return
      end
   
   if makeobj() then
      say '      Installation successful!  '
   else
      say '      Cannot create Program Object!  Installation failed!'
   return

makeobj:
   if opt = '/SAVE' | opt = '-SAVE' then
      do
         call lineout file, 'objtitle="'objtitle'"'
         call lineout file, 'objdest="'objdest'"'
         call lineout file, 'objid="'objid'"'
         call lineout file, 'helppanel="'helppanel'"'
         call lineout file, 'exename="'exename'"'
         call lineout file, 'parameters="'parameters'"'
         call lineout file, 'call SysCreateObject "WPProgram",objtitle,objdest,"OBJECTID="objid";HELPPANEL="helppanel";HELPLIBRARY="hlpname";PARAMETERS="parameters";PROGTYPE=PM;EXENAME="exename";STARTUPDIR="startupdir,"REPLACE"'
         return 1
      end
   else
   return SysCreateObject("WPProgram", ,
                          objtitle, ,
                          objdest, ,
                          "OBJECTID="objid";HELPPANEL="helppanel";HELPLIBRARY="hlpname";PARAMETERS="parameters";PROGTYPE=PM;EXENAME="exename";STARTUPDIR="startupdir, ,
                          "REPLACE")

remove:
   call SysDestroyObject('<ML_DONKEYDAEMON>')
   call SysDestroyObject('<ML_DONKEY>')
   exit
 
halt:
   say '0d0a'x'Installation aborted!'
   exit
 
header:
   '@cls'
   say '    Ŀ'
   say '                                                                         '
   say '                         'LRed'Donkey'LWhi' installation script                      '
   say '                                                                         '
   say '     You can specify the following command-line options to:              '
   say '                                                                         '
   say '       'LGre'/DEBUG'LWhi'   -   display additional informations when creating objects'
   say '       'LGre'/SAVE f'LWhi'  -   create a REXX script, 'LGre'f'LWhi', which can be used to install'
   say '                    'LRed'Donkey'LWhi' in a non-interactive way. It does not actually'
   say '                    create objects, it only creates the REXX script.     '
   say '       'LGre'/REMOVE'LWhi'  -   remove 'LRed'Donkey'LWhi'''s objects.                             '
   say '                                                                         '
   say '                                                                         '
   say '     WARNING  --  This script does not move/copy files.  It only creates '
   say '                  objects in your desktop.                               '
   say '                                                                         '
   say '    '
   say '                      (Use Ctrl+C to stop the installation.)'
   parse value SysTextScreenSize() with row col .
   call SysCurPos row-1, 5
   call charout ,LBro'Copyright (c) 1995 Martin Lafaix.'LWhi
   call SysCurPos row-1, col-29
   call charout ,'Press any key to continue...'
   call sysgetkey('noecho')
   return
  
AnsiSetup: /* ANSI control */
Esc=d2c(27)d2c(91)
                                        /* Attributes */
Bli=esc'5m'
Hig=esc'1m'
Non=esc'0m'
                                        /* Foreground colors */
Bla=esc'30m'
Red=esc'31m'
Gre=esc'32m'
Bro=esc'33m'
Blu=esc'34m'
Cya=esc'35m'
Tur=esc'36m'
Whi=esc'37m'
LBla=Hig||esc'30m'
LRed=Hig||esc'31m'
LGre=Hig||esc'32m'
LBro=Hig||esc'33m'
LBlu=Hig||esc'34m'
LCya=Hig||esc'35m'
LTur=Hig||esc'36m'
LWhi=Hig||esc'37m'
                                        /* Background colors */
BBla=esc'40m'
BRed=esc'41m'
BGre=esc'42m'
BBro=esc'43m'
BBlu=esc'44m'
BCya=esc'45m'
BTur=esc'46m'
BWhi=esc'47m'
Return
