/*  ͻ
      PUTWPS puts WPS objects selected list for multiple drive support.    
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */

'@echo off'
version = '1.0'
parse upper source source
parse value value('PATH',,'OS2ENVIRONMENT') with preBoot ":\OS2;" postBoot
bootPath = right(preBoot,1)':\'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
datFile = 'getwps.din'
linenum = 0
creatednum = 0
_d_ = '"'
fixFlag = 0

sysver = translate('3241', Sysos2ver(), '1234')    /* positional bug in sysos2ver */
curpath = directory()
ecspath = directory(bootpath'ecs')
select
   when sysver<4.51 then sysos = 'WARP' 
   when ecspath=bootpath'ECS' then sysos = 'eCS' 
otherwise sysos = 'SWC' 
end  /* select */
call directory(curpath)

line = 'PUTWPS' version 'with bootpath' '"'bootpath'"' 'running' sysos sysver 'on' date() time()
say line

/* read dat file */
if exists(datfile) then do
    linenum = 1
    say linein(datfile)
    do while lines(datFile)                                                           
        linenum = linenum + 1
        call putwps
    end
    call close datfile
end /* do */

say source 'read:' linenum-1 'updated/created:' creatednum 'Errors:' creatednum-linenum+1
exit 0;


/* put class, title, setup, loc for obj and write it to datfile */
putwps: procedure expose datfile creatednum bootPath _d_ linenum
    parse value linein(datfile) with (_d_) class (_d_) (_d_) title (_d_) (_d_) loc (_d_) (_d_) setup (_d_)
    setup = repstr('C:\', setup, bootPath)
    loc = repstr('C:\', loc, bootPath)
    rc = SysCreateObject( class, title, loc, setup, 'u')
    if rc=0 then do
        say 'can not create object for' class title loc 'line' linenum
        return 0
    end /* do */
    creatednum = creatednum + 1
    return 1


/* return str that find is replace by rep */
repstr: procedure 
    parse arg find, str, rep
    f = pos(find, str)
    if f=0 then return str
        s = 1
        pstr = ''
        do forever
            pstr = pstr||substr(str, s, f-s)||rep
            s = f + length(find)
            f = pos(find, str, s)
            if f=0 then leave
        end /* do */
    return pstr||substr(str,s)


/* return substr of setup */
subsetup: procedure
    parse arg sub, setup
    b = pos(sub, setup)
    if b=0 then do
        say 'no' sub 'in' setup
        return ''
    end /* do */
    e = pos(';', setup, b)
    return substr(setup, b, e-b)


/* return true if file succesfully closed */
close: procedure
    ret = stream(arg(1),'C','CLOSE')
    if ret='READY:' then return 1
    say 'error closing file stream' arg(1) ret
    exit -1
    return 0


/* return true if file exists */
exists: procedure
  ret = stream(arg(1),'C','QUERY EXISTS')
    if ret='' then return 0
    else return 1
