/*  ͻ
      PUTINI puts selected USER and SYSTEM INI data for multiple drive     
      support.                                                             
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */

'@echo off'
version = '1.0'
parse upper source source                          /* who am I ?              */
parse value value('PATH',,'OS2ENVIRONMENT') with preBoot ":\OS2;" postBoot
bootPath = right(preBoot,1)':\'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
listFile = 'getini.lst'
datFile = 'getini.din'
readnum = 0
newnum = 0
updnum = 0

os2 = translate('3241', Sysos2ver(), '1234')    /* positional bug in sysos2ver */
curpath = directory()
ecspath = directory(bootpath'ecs')
select
   when os2<4.51 then os2 = 'WARP' os2
   when ecspath=bootpath'ECS' then os2 = 'eCS' os2
otherwise os2 = 'SWC' os2
end  /* select */
call directory(curpath)

_d_ = '"'
parse arg file '(' switch
if file<>'' then datfile = file
writeflag = wordpos('WRITE', translate(switch))>0

line = 'PUTINI' version 'with bootpath' bootpath 'running' os2 'on' date() time()
say line
say 'reading' datfile 'and write =' writeflag

/* table translation
    tran.1  printable ascii and graphic char for null
    tran.2  all codes with tran.1 first but actual null
    tran.3  pad char for binary char
    tran.4  begin quote char
    tran.5  end quote char          */
tran.3 = d2c(2)
tran.4 = d2c(16)
tran.5 = d2c(17)
do i = 32 to 126
    tran.1 = tran.1||d2c(i)
end /* do */
tran.2 = tran.1
tran.1 = tran.1||d2c(232)
do i = 0 to 31
   tran.2 = tran.2||d2c(i)
end /* do */
do i = 127 to 255
   tran.2 = tran.2||d2c(i)
end /* do */
tran.0 = 5

/* read dat file */
say linein(datfile)
do while lines(datFile)                                                           
    call putkey
end
call close datfile

say source 'read:' readnum 'new:' newnum 'updated:' updnum
exit 0;





/* read linein and put key value for ini & app & key & val if changed and return true */
putkey: procedure expose datfile tran. readnum newnum updnum _d_ writeFlag
    readnum = readnum + 1
    parse value Linein(datfile) with ini (_d_) app (_d_) key rest
    ini = strip(ini)     /* bug - trailing space */
    i = pos(tran.5, rest) 
    if i=0 then do
        say 'missing' tran.5 'in' readnum ini '"'app'"' key
        return 0
    end /* do */
    asc = left(rest,i)
    if length(rest)<>3*i-3 then do
        say 'missing part of hex value in' readnum ini '"'app'"' key
        return 0
    end /* do */
    val = x2c(substr(rest,i+2))
    if pos(tran.3,valfmt)=0 then do
        val = repstr('C:\', val, BootPath)
        asc = tran.4||translate(val,tran.1,tran.2,tran.3)||tran.5
    end /* do */
    oldval = SysIni(ini, app, key)
    if oldval=val then return 0
    if writeFlag then call sysini ini, app, key, val
    if oldval='ERROR:' then do
        op = 'new'
        newnum = newnum + 1
    end
    else do
        op = 'updated'
        updnum = updnum + 1
    end
    if length(val)>60 then asc = 'length(value)='|| length(val)
    say op ini '"'app'"' key asc
    return 1


/* return str that find is replace by rep */
repstr: procedure 
    parse arg find, str, rep
    f = pos(find, str)
    if f=0 then return str
        s = 1
        pstr = ''
        do forever
            pstr = pstr||substr(str, s, f-s)||rep
            s = f + length(find)
            f = pos(find, str, s)
            if f=0 then leave
        end /* do */
    return pstr||substr(str,s)



/* return true if file succesfully closed */
close: procedure
    ret = stream(arg(1),'C','CLOSE')
    if ret='READY:' then return 1
    say 'error closing file stream' arg(1) ret
    exit -1
    return 0


/* return true if file exists */
exists: procedure
  ret = stream(arg(1),'C','QUERY EXISTS')
    if ret='' then return 0
    else return 1
