/*  ͻ
      GETWPS gets selected desktop and startup objects and their decedents 
      with multiple drive support.                                         
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */

'@echo off'
version = '1.0'
parse upper source source
parse value value('PATH',,'OS2ENVIRONMENT') with preBoot ":\OS2;" postBoot
bootPath = right(preBoot,1)':\'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs
listFile = 'getwps.lst'
datFile = 'getwps.din'
newnum = 0
creatednum = 0
_d_ = '"'

sysver = translate('3241', Sysos2ver(), '1234')    /* positional bug in sysos2ver */
curpath = directory()
ecspath = directory(bootpath'ecs')
select
   when sysver<4.51 then sysos = 'WARP' 
   when ecspath=bootpath'ECS' then sysos = 'eCS' 
otherwise sysos = 'SWC' 
end  /* select */
call directory(curpath)
wptversion = WPToolsVersion()

line = 'GETWPS' version 'with WPTOOLS.DLL' wptversion 'running' '"'bootpath'"' sysos sysver 'on' date() time()
say line

/* read list file */
lists.0 = 0
if exists(listfile) then do
    call vback listfile 'backing existing'
    i = 0
    do while lines(listFile)                                                           
        i = i + 1
        lists.i = linein(listfile)
    end
    lists.0 = i
    call close listfile
end /* do */

if exists(datfile) then do
    call vback datfile "backing existing"
    address cmd 'del' datfile
end /* do */
call lineout datfile, 'from' line

tops.1 = '<WP_DESKTOP>'
tops.2 = '<WP_START>'
tops.0 = 2


/* main loop */
do j = 1 to tops.0
    rc = WPToolsFolderContent(tops.j, "objs.", 'F')
    if rc = 0 Then iterate
    do i = 1 to objs.0
        obj = objs.i
        rc=WPToolsQueryObject(obj, "class", "title", , "loc")
        if \rc Then iterate
        f = inlist(class, title, loc)
        if f>0 then do
           if pos('INC',translate(lists.f))=1 then call getclass obj
        end /* do */
        else do
            call lineout listFile,'EXC' '"'class'"' '"'title'"' '"'loc'"' 
            newnum = newnum + 1
        end /* do */
    end
end    
call getwps "<WP_DESKTOP>"
    

if newnum>0 then call close listfile
call close datFile
call vback datfile "backing new"
say source 'read:' lists.0 'new:' newnum 'created:' creatednum
exit 0;




/* return index to lists. with matching obj & class else returns 0 if nothing matches */
inlist: procedure expose lists. _d_
    parse arg class, title, loc
    /*say '"'obj'"' '"'class'"' '"'title'"' '"'setup'"' '"'loc'"'*/
    do i = 1 to lists.0
       parse var lists.i lverb (_d_) lclass (_d_) (_d_) ltitle (_d_) (_d_) lloc (_d_) rest
       if class<>lclass then iterate
       if title<>ltitle then iterate
       if loc<>lloc then iterate
       return i
    end /* do */
    return 0


/* get all objects from obj including subfolders */
getclass: procedure expose datfile creatednum bootPath
    parse arg obj, class
    rc=WPToolsQueryObject(obj, "class", , , )
    if rc = 0 Then return
    call getwps obj
    if class='WPFolder' then do
        rc = WPToolsFolderContent(obj, "objs.", 'F')
        if rc = 0 Then return
        do i = 1 to objs.0
            call getclass objs.i
        end
    end    
    return



/* get class, title, setup, loc for obj and write it to datfile */
getwps: procedure expose datfile creatednum bootPath
    parse arg obj
    rc = WPToolsQueryObject(obj, "class", "title", "setup", "loc") 
    if rc=0 then return 0
    setup = repstr(bootPath, setup, 'C:\')
    loc = repstr(BootPath, loc, 'C:\')
    if class='WPShadow' then setup = subsetup('SHADOWID=', setup)
    call lineout datfile, '"'class'"' '"'title'"' '"'loc'"' '"'setup'"'
    creatednum = creatednum + 1
    return 1


/* return str that find is replace by rep */
repstr: procedure 
    parse arg find, str, rep
    f = pos(find, str)
    if f=0 then return str
        s = 1
        pstr = ''
        do forever
            pstr = pstr||substr(str, s, f-s)||rep
            s = f + length(find)
            f = pos(find, str, s)
            if f=0 then leave
        end /* do */
    return pstr||substr(str,s)


/* return substr of setup */
subsetup: procedure
    parse arg sub, setup
    b = pos(sub, setup)
    if b=0 then do
        say 'no' sub 'in' setup
        return ''
    end /* do */
    e = pos(';', setup, b)
    return substr(setup, b, e-b)


/* return true if file succesfully closed */
close: procedure
    ret = stream(arg(1),'C','CLOSE')
    if ret='READY:' then return 1
    say 'error closing file stream' arg(1) ret
    exit -1
    return 0


/* return true if file exists */
exists: procedure
  ret = stream(arg(1),'C','QUERY EXISTS')
    if ret='' then return 0
    else return 1
