/*  ͻ
      GETINI gets selected USER and SYSTEM INI data for multiple drive     
      support.                                                             
                                                                           
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */

'@echo off'
version = '1.0'
parse upper source source                          /* who am I ?              */
parse value value('PATH',,'OS2ENVIRONMENT') with preBoot ":\OS2;" postBoot
bootPath = right(preBoot,1)':\'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
listFile = 'getini.lst'
datFile = 'getini.din'
newnum = 0
keynum = 0

os2 = translate('3241', Sysos2ver(), '1234')    /* positional bug in sysos2ver */
curpath = directory()
ecspath = directory(bootpath'ecs')
select
   when os2<4.51 then os2 = 'WARP' os2
   when ecspath=bootpath'ECS' then os2 = 'eCS' os2
otherwise os2 = 'SWC' os2
end  /* select */
call directory(curpath)

_d_ = '"'

line = 'GETINI' version 'with bootpath' bootpath 'running' os2 'on' date() time()
say line

/* table translation
    tran.1  printable ascii and graphic char for null
    tran.2  all codes with tran.1 first but actual null
    tran.3  pad char for binary char
    tran.4  begin quote char
    tran.5  end quote char          */
tran.3 = d2c(2)
tran.4 = d2c(16)
tran.5 = d2c(17)
do i = 32 to 126
    tran.1 = tran.1||d2c(i)
end /* do */
tran.2 = tran.1
tran.1 = tran.1||d2c(232)
do i = 0 to 31
   tran.2 = tran.2||d2c(i)
end /* do */
do i = 127 to 255
   tran.2 = tran.2||d2c(i)
end /* do */
tran.0 = 5

/* read list file */
i = 0
lists.0 = 0
do while lines(listFile)                                                           
    i = i + 1
    lists.i = linein(listfile)
end
lists.0 = i
call close listfile

if exists(datfile) then do
    call vback datfile "backing existing"
    address cmd 'del' datfile
end /* do */
call lineout datfile, 'from' line

inifile.1 = 'USER'
inifile.2 = 'SYSTEM'
inifile.0 = 2

/* main loop */
do j = 1 to 2
    call SysIni inifile.j, 'All:', 'Apps.'
    if Result = 'ERROR:' then exit -1;
    do i = 1 to Apps.0
        f = inlist(inifile.j, apps.i)
        if f>0 then do
           if pos('INC',translate(lists.f))=1 then call getapp inifile.j, apps.i
        end /* do */
        else do
            call lineout listFile,'EXC' inifile.j '"'Apps.i'"'
            newnum = newnum + 1
        end /* do */
    end
end /* do */
    
if newnum>0 then call close listfile
call close datFile
call vback datfile "backing new"
say source 'read:' lists.0 'new:' newnum 'keys:' keynum
exit 0;




/* return index to lists. with matching ini & app else returns 0 if nothing matches */
inlist: procedure expose lists. _d_
    parse arg ini, app
    do i = 1 to lists.0
       parse var lists.i lverb lini (_d_) lapp (_d_)
       if ini<>lini then iterate
       if app=lapp then return i
    end /* do */
    return 0


/* get all keys for ini & app and calls getkey */
getapp: procedure expose datfile tran. keynum
    parse arg ini, app
    say app
    call SysIni ini, app, 'All:', 'Keys'
    if Result \= 'ERROR:' then
        do j=1 to Keys.0
           call getkey  ini, app, keys.j
        end
   return



/* get key value for ini & app & key and write it to datfile */
getkey: procedure expose datfile tran. keynum
    parse arg ini, app, key
    val = SysIni(ini, app, key)
    if pos(tran.3,valfmt)=0 then do
        val = repstr(BootPath, val, 'C:\')
        valfmt = tran.4||translate(val,tran.1,tran.2,tran.3)||tran.5
    end /* do */
    call lineout datfile, ini '"'app'"' key valfmt c2x(val) 
    keynum = keynum + 1
    return


/* return str that find is replace by rep */
repstr: procedure 
    parse arg find, str, rep
    f = pos(find, str)
    if f=0 then return str
        s = 1
        pstr = ''
        do forever
            pstr = pstr||substr(str, s, f-s)||rep
            s = f + length(find)
            f = pos(find, str, s)
            if f=0 then leave
        end /* do */
    return pstr||substr(str,s)



/* return true if file succesfully closed */
close: procedure
    ret = stream(arg(1),'C','CLOSE')
    if ret='READY:' then return 1
    say 'error closing file stream' arg(1) ret
    exit -1
    return 0


/* return true if file exists */
exists: procedure
  ret = stream(arg(1),'C','QUERY EXISTS')
    if ret='' then return 0
    else return 1
    

