/************************************************************************/
/* cron.cmd                                                          */
/* Created: 18 Jan 1998                                                 */
/* Author: J. Pedone                                                    */
/* jpedone@flash.net                                                    */
/************************************************************************/
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call sysloadfuncs

Signal on Halt
tab='09'x
cr = '0d'x
lf = '0a'x

/* Get present working directory */
	workdir = Directory()
	cworkdir = workdir
	fworkdir = workdir||'\'

/* get time info */
	currMin = time('m')-time('h')*60
	disp_min = currMin
	if disp_min < 10 then disp_min = '0'disp_min
	currHour = time('h')
	today = date('s')
	currYear = substr(today,1,4)
	currMonth = substr(today,5,2)
	CurrDay = substr(today,7,2)
	today = date('w')
	say 'Cron started at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear

do forever
/* determine current time and date */
	currMin = time('m')-time('h')*60
	currHour = time('h')
	today = date('s')
	currYear = substr(today,1,4)
	currMonth = substr(today,5,2)
	CurrDay = substr(today,7,2)
	today = date('w')
	disp_min = currMin
	if disp_min < 10 then disp_min = '0'disp_min
	currDow = wordPos(today,'Sunday Monday Tuesday Wednesday Thursday Friday Saturday')

/* Parse and check the crontab file */
	do while rc <> 'READY:'
		rc=Stream(fworkdir'crontab','C','Open')
		call SysSleep 1
	End
	do while lines(fworkdir'crontab') > 0
		line = linein(fworkdir'crontab')
		parse var line minutes''hours''days''months''dows''years''session''type''file''parameters''pworkdir''close
		isMin   = matches(minutes, currMin)
		isHour  = matches(hours, currHour)
		isDay   = matches(days,currDay)
		isMonth = matches(months,currMonth)
		isDow   = matches(dows,currDow)
		isYear = matches(years,curryear)

/* check the time and launch if it's time */
		if isMin & isHour & isDay & isMonth & isDow & isYear then do
			if type = 'Message' Then Do
				say 'Launching message at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear
				'@detach 'fworkdir'\DRREXX.EXE 'fworkdir'\msgbox.RES 'file''parameters
			End
			Else Do
				If session <> 'Detached' Then Do
					start_string = '@Start'
					If close = 'Yes' Then start_string = start_string' /c'
					if session = 'Minimized' then start_string = start_string' /min'
					if session = 'Full Screen' then start_string = start_string' /fs'
					if session = 'Window' then start_string = start_string' /win'
				End
				If session = 'Detached' Then Do
					start_string = 'Detach'
				End
				wd = strip(pworkdir,'B')
				if lastpos('\',wd) = length(wd) then do
					plen = length(wd)-1
					if plen > 1 Then Do
						wd = substr(wd,1,plen)
					End
				End
				rc = directory(wd)
				start_string||' '||strip(file,'B')||' '||strip(parameters,'B')
		 		call SysSleep 2
				rc = directory(cworkdir)
				say 'launching '||start_string||' '||strip(file,'B')||' '||strip(parameters,'B')||' at '||currHour||':'||disp_min||' on '||currMonth||'/'||currDay||'/'||currYear
			End 	/* Else */
		End 	/* if time */
	End 	/* While */
	call stream fworkdir'crontab','c','close' 
	call sysSleep 60-(time('s')-time('m')*60)

End  /* main loop */

matches:
	args = arg(1)
	if args='*' then return 1
	matched = 0
	parse var args value ',' args
	do while value<>''
		if value=arg(2) then matched = 1
		parse var value from '-' to
		if from<=arg(2) & arg(2)<=to then matched = 1
		parse var args value ',' args
	end
return matched

halt:
	say 'Cron stopped at 'currHour':'disp_min' on 'currMonth'/'currDay'/'currYear
/* end of file */
