/******************************************************************************/
/*                    Russian Codepage text-file converter                    */
/******************************************************************************/

 signal ON Halt name BreakHandler;
 break = 0;
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
 '@echo off'

 call setColor White;
 say '[ Convert ][ Version 0.0.2 ]'
 say ' Copyleft (L) 1996 by FRIENDS software  No Rights Reserved '
 call setColor Gray;
 parse arg fMask _from SrcC _to DstC
 if (DstC = '') | (Abbrev('FROM', Translate(_from), 1) = 0) | (Abbrev('TO', Translate(_to), 1) = 0)
  then signal Help;

 codeTable = xRange('80'x, 'FF'x);
 codeTable = Translate(codeTable, GetTable(SrcC, FROM), xRange('80'x, 'FF'x));
 codeTable = Translate(codeTable, GetTable(DstC, TO), xRange('80'x, 'FF'x));

 fName = ''; oName = ''; /* for Expose to work properly in Convert */
 call SysFileTree fMask, 'files', 'FO', '*----'
 do I = 1 to files.0
  if Convert(files.I) <> 0
   then Leave;
 end;

Done:
 call setColor DGray;
 say d2c(13)'Done'
 exit

Help:
 say ' Usage: Convert [FileMask] FROM [CodeTable] TO [CodeTable]'
 say ' [CodeTable] = ALT|KOI8|WIN|GOST|BOLG'
 call setColor DGray;
 say 'Done'
 exit 1

BreakHandler:
 break = 1;
 if fName <> 'FNAME' then signal wError;
 return -1;

Convert:
 procedure expose break codeTable;
 parse arg fName;

 ProgressBarLen = 30;

 oName = FileSpec('P', fName)'$codtmp$.$$$'
 call SysFileDelete oName
 lMax = chars(fName);
 oPos = -1;
 do while (lines(fName) > 0)
  lCur = chars(fName);
  if lineOut(oName, Translate(lineIn(fName), codeTable, xRange('80'x, 'FF'x))) <> 0
   then signal wError;
  if lCur <= lMax
   then nPos = ((lMax - lCur) * ProgressBarLen) % lMax
   else nPos = ProgressBarLen;
  if nPos <> oPos
   then do
         oPos = nPos;
         call SetColor White
         call charOut ,d2c(13)' Processing ';
         call SetColor LGreen
         call charOut ,FileSpec('N', fName);
         call SetColor Gray
         call charOut ,' [';
         call SetColor Cyan
         call charOut ,copies('', nPos)||copies('',ProgressBarLen - nPos);
         call SetColor Gray
         call charOut ,']';
        end;
  if break <> 0 then signal wError;
 end;
 call charOut fName
 call charOut oName

 if SysFileDelete(fName) <> 0 then signal wError;
 'copy "'oName'" "'fName'" 1>nul 2>nul'
 if rc <> 0 then signal wError;
 call SysFileDelete oName;

 call LastLine;
 call SetColor Yellow
 say ' ok'
 return 0;

wError:
 call charOut fName;
 call charOut oName;
 call SysFileDelete oName

 call LastLine;
 call SetColor LRed
 say ' ERROR'
 return -1;

LastLine:
 call SetColor White
 call charOut ,d2c(13)copies(' ',79)d2c(13)'';
 call SetColor LGreen
 call charOut ,right(copies(' ', 55)||fName, 55);
 return;

GetTable:
 procedure expose break;
 arg Name, Mode
 select
  when Abbrev('ALT', Name, 1)
   then Table = xRange('80'x, 'BF'x)' 'xRange('C0'x,'FF'x);
  when Abbrev('BOLG', Name, 1)
   then Table = ' ',
                '߰';
  when Abbrev('GOST', Name, 1)
   then Table = 'ߛ',
                '';
  when Abbrev('WIN', Name, 1)
   then Table = '                ',
                '                                                ';
  when Abbrev('KOI8', Name, 1)
   then Table = 'а',
                '                ';
  otherwise do
   say ' ERROR: Invalid translation table specified'
   signal Help;
  end;
 end;
 Table = DelStr(table, 65, 1); /* !%@$^! */
 Table1 = '';
 if Mode = 'FROM'
  then do i = 128 to 255
        Ch = 127 + Pos(d2c(i), Table);
        if Ch = 127 then Ch = i;
        Table1 = Table1||d2c(Ch);
       end;
  else do i = 128 to 255
        Ch = Substr(Table, i-127, 1);
        if Ch = ' ' then Ch = d2c(i);
        Table1 = Table1||Ch;
       end;

 drop Table;
 return Table1;

SetColor:
 procedure expose break;
 arg Col;
 Col = ColorNo(Col);

 if Col = -1 then return -1;
 if Col > 7
  then Col = '1;3'Col-8;
  else Col = '0;3'Col;
 call charOut ,d2c(27)'['Col'm';
 return 0;
 
ColorNo:
 procedure expose break;
 arg ColName;
 if Substr(ColName, 1, 1) = 'L'
  then do
        ColName = right(ColName, length(ColName) - 1);
        Light = 8;
       end
  else Light = 0;
 select
  when Abbrev('BLACK', ColName, 3)
   then return Light + 0;
  when Abbrev('BLUE', ColName, 3)
   then return Light + 4;
  when Abbrev('GREEN', ColName, 3)
   then return Light + 2;
  when Abbrev('CYAN', ColName, 3)
   then return Light + 6;
  when Abbrev('RED', ColName, 3)
   then return Light + 1;
  when Abbrev('MAGENTA', ColName, 3)
   then return Light + 5;
  when Abbrev('BROWN', ColName, 3)
   then return Light + 3;
  when Abbrev('GRAY', ColName, 3)
   then return Light + 7;
  when Abbrev('DGRAY', ColName, 3)
   then return 8;
  when Abbrev('YELLOW', ColName, 3)
   then return 11;
  when Abbrev('WHITE', ColName, 3)
   then return 15;
 end;
 return -1;
