/* CFGinst - Install / UnInstall for ConfigTool */

PARSE ARG action
IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END
CALL SysCls
action = TRANSLATE(LEFT(action,1))
SELECT
    WHEN action = 'I' THEN CALL InstallMe
    WHEN action = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL WhatAction
END
Exit /* End of CFGinst.cmd */

/* WhatAction - no action selected */

WhatAction:     PROCEDURE

CALL SysCls
SAY 'Please enter installation parameter (I=Install, U=UnInstall, other=Exit):'
PARSE PULL action
SELECT
    WHEN TRANSLATE(LEFT(action,1)) = 'I' THEN CALL InstallMe
    WHEN TRANSLATE(LEFT(action,1)) = 'U' THEN CALL UnInstallMe
    OTHERWISE CALL NoAction 'Installation failed.'
END
RETURN /* End of WhatAction */

/* NoAction - abort Install */

NoAction:   PROCEDURE

CALL SysCls
PARSE ARG noinstmsg
SAY noinstmsg
SAY 'Press any key to exit ...'
PULL answer
CALL SysCls
Exit /* End of NoAction */

/* InstallMe - install ConfigTool */

InstallMe:  PROCEDURE

prgname = 'ConfigTool 0.92'
cfgfiles = 'CFGtool.exe CFGTOOL.DAT CFGTOOL.CHK Cfgbmp32.dll'
IF RIGHT(Directory(),2) = ':\' THEN DO
    SAY 'Problem! '||prgname||' can not be installed in root directory.'
    SAY 'Create directory for '||prgname||', copy files: '||cfgfiles||' there and start this procedure again.'
    SAY 'Press any key to exit ...'
    PULL answer
    Exit
END

CALL SysCls
SAY 'Welcome to '||prgname||' Installation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Create Program Object for '||prgname||' on your Desktop,'
SAY '- Associate CONFIG.* files with '||prgname||','
SAY '- Add '||prgname||' specific entry in OS2.INI file, in App ToolsByGoran.'
SAY 'Press "Y" (and Enter) to start Installation, any other key to exit...'
PARSE PULL answer

IF TRANSLATE(LEFT(answer,1)) <> "Y" THEN DO
    CALL NoAction 'Installation aborted'
END

SAY ' '
SAY 'Checking files:'
DO i = 1 TO WORDS(cfgfiles)
    CALL SysFiletree Directory()||'\'||WORD(cfgfiles,i), 'chkfile', 'FO'
    SELECT
	WHEN chkfile.0 = 1 THEN SAY '- '||LEFT(WORD(cfgfiles,i),12)||' - OK'
	OTHERWISE CALL NoAction LEFT(WORD(cfgfiles,i),12)||' - Missing file. Installation failed!'
    END
END

SAY ' '
SAY 'Writing entry to OS2.INI'
CALL SysIni 'USER','ToolsByGoran','CFGtoolWorkDir',Directory()
CALL SysIni 'USER','ToolsByGoran','CFGtoolINIfile',Directory()||'\CFGTOOL.INI'

SAY ' '
InstallDir = Directory()
WorkDir = Directory()

FoldTitle=prgname
Icon1=Directory()||'\CFGtool1.ico'
Icon2=Directory()||'\CFGtool2.ico'
Icon='ICONFILE='Icon1||';ICONNFILE=1,'||Icon2
Setup='OBJECTID=<CONFIGTOOL_FOLDER>;'||Icon||''
Action = 'U'
SAY 'Creating '||prgname||' Folder'
CALL SysCreateObject 'WPFolder',FoldTitle,'<WP_DESKTOP>',Setup,Action

ProgTitle = prgname
EXE = 'CFGtool.exe'
ICO = 'CFGtool.ico'
Setup = 'OBJECTID=<CONFIGTOOL_PROGRAM>;EXENAME='InstallDir'\'EXE';ASSOCFILTER=CONFIG.*;ICONFILE='InstallDir'\'ICO';STARTUPDIR='WorkDir''
Action = 'U'
SAY 'Creating '||prgname||' Program object'
CALL SysCreateObject 'WPProgram',ProgTitle,'<CONFIGTOOL_FOLDER>',Setup,Action

ProgTitle = prgname||' Help'
EXE = 'View.exe'
INF = 'CFGTOOL.INF'
Setup = 'OBJECTID=<CONFIGTOOL_HELP>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
SAY 'Creating '||prgname||' Help object'
CALL SysCreateObject 'WPProgram',ProgTitle,'<CONFIGTOOL_FOLDER>',Setup,Action

ProgTitle = prgname||'^Database (INF)'
EXE = 'View.exe'
INF = 'CFGDAT.INF'
Setup = 'OBJECTID=<CONFIGTOOL_DAT_INF>;EXENAME='EXE';PARAMETERS='InstallDir'\'INF';STARTUPDIR='WorkDir''
Action = 'U'
SAY 'Creating '||prgname||' Database object'
CALL SysCreateObject 'WPProgram',ProgTitle,'<CONFIGTOOL_FOLDER>',Setup,Action

SAY ' '
SAY 'Installation finished! Press any key to exit ...'
PULL answer
CALL SysCls
RETURN /* End of InstallMe */

/* UnInstallMe - uninstall ConfigTool */

UnInstallMe: PROCEDURE

prgname = 'ConfigTool 0.92'
CALL SysCls
SAY 'This is '||prgname||' UnInstallation procedure!'
SAY 'Your files are in directory: '||Directory()
SAY 'This procedure will:'
SAY '- Remove '||prgname||' specific entry in OS2.INI file, App ToolsByGoran.'
SAY '- Destroy '||prgname||' Program object'
SAY 'Press "Y" (and Enter) to start UnInstall, any other key to exit...'
PULL answer
IF answer <> "Y" THEN DO
    CALL NoAction 'UnInstall terminated.'
END
SAY ' '
SAY 'Removing entries from OS2.INI'
CALL SysIni 'USER','ToolsByGoran','CFGtoolWorkDir','DELETE:'
CALL SysIni 'USER','ToolsByGoran','CFGtoolINIfile','DELETE:'
SAY ' '
SAY 'Destroying Program object'
CALL SysDestroyObject '<CONFIGTOOL_DAT_INF>'
CALL SysDestroyObject '<CONFIGTOOL_DAT_TXT>'
CALL SysDestroyObject '<CONFIGTOOL_DAT_HTM>'
CALL SysDestroyObject '<CONFIGTOOL_HELP>'
CALL SysDestroyObject '<CONFIGTOOL_PROGRAM>'
CALL SysDestroyObject '<CONFIGTOOL_FOLDER>'
SAY ' '
SAY 'UnInstallation complete.'
SAY 'You can delete files in directory '||Directory()
SAY 'To install '||prgname||' again, start CFGinst I. Press any key to exit...'
PULL answer
RETURN /* End of UnInstallMe */

