@echo off
echo Ctrl-Alt-Del Commander 2.52 Update Procedure
echo (C) 1995-1998 Perez Computing Services.  All Rights Reserved.
echo This updates Ctrl-Alt-Del Commander 2.50 and 2.51 to 2.52.

IF NOT EXIST CADCMDR.EXE GOTO DIRECTIONS
IF NOT EXIST PATCH\CC251252.PIT GOTO DIRECTIONS
IF NOT EXIST PATCH\CC250252.PIT GOTO DIRECTIONS
IF NOT EXIST PATCH\PK250252.PIT GOTO DIRECTIONS
IF NOT EXIST PATCH\SL250252.PIT GOTO DIRECTIONS
IF NOT EXIST PATCH\SL251252.PIT GOTO DIRECTIONS
IF NOT EXIST CCPRUNE.EXE GOTO DIRECTIONS
IF NOT EXIST PATCHIT.EXE GOTO DIRECTIONS

:PATCHIT
md archive
echo Archiving version 2.50 or 2.51 to the \CADCMDR\archive directory
copy CADCMDR.EXE archive > NUL
copy PKM_DMN.EXE archive > NUL
copy CADCSTAT.EXE archive > NUL
copy CADCMDR.EXE UPDATE > NUL
copy PKM_DMN.EXE UPDATE > NUL
copy CADCSTAT.EXE UPDATE > NUL
cd update

REM Try to update from 2.50 to 2.52
echo PCS PatchIt (tm) for OS/2 patching CADCMDR.EXE
PATCHIT ..\PATCH\CC250252.PIT /Q
IF ERRORLEVEL 4 GOTO CC_TRY_NEXT_VERSION
IF ERRORLEVEL 1 GOTO CC_FAILURE
del CADCMDR.PBK
GOTO PK_PATCH

REM Try update from 2.51 to 2.52
:CC_TRY_NEXT_VERSION
PATCHIT ..\PATCH\CC251252.PIT /Q
IF ERRORLEVEL 1 GOTO CC_FAILURE
del CADCMDR.PBK

REM Update PKM_DMN.EXE (only 1 update from 2.50 to 2.52)
:PK_PATCH
echo PCS PatchIt (tm) for OS/2 patching PKM_DMN.EXE
PATCHIT ..\PATCH\PK250252.PIT /Q
IF ERRORLEVEL 1 GOTO PK_FAILURE
del PKM_DMN.PBK


REM Try to update status line from 2.50 to 2.52
echo PCS PatchIt (tm) for OS/2 patching CADCSTAT.EXE
PATCHIT ..\PATCH\SL250252.PIT /Q
IF ERRORLEVEL 4 GOTO SL_TRY_NEXT_VERSION
IF ERRORLEVEL 1 GOTO SL_FAILURE
del CADCSTAT.PBK
GOTO DONE_PATCH

REM Try to update from 2.51 to 2.52
:SL_TRY_NEXT_VERSION
PATCHIT ..\PATCH\SL251252.PIT /Q
IF ERRORLEVEL 1 GOTO SL_FAILURE
del CADCSTAT.PBK

:DONE_PATCH
GOTO GOODFINISH


:SL_FAILURE
cd ..
echo You're update was nearly complete when an error was detected
echo while trying to update the CAD Commander Status Line.  CAD Commander
echo will function correctly with the 2.50 or 2.51 Status Line.  However,
echo you should contact PCS technical support via the PCS website and
echo provide the following:
echo.
echo * Your name
echo * Your CAD Commander serial number
echo * Your CAD Commander version
echo * The date, time, and size of the file \CADCMDR\CADCSTAT.EXE
echo.
echo Please shutdown and restart your system to continue updating to
echo CAD Commander 2.52.
GOTO END

:CC_FAILURE
set ERRMOD=CAD Commander PM Shell
GOTO FAILURE

:PK_FAILURE
set ERRMOD=CAD Commander Daemon
GOTO FAILURE


:FAILURE
cd ..
echo Error patching %ERRMOD%.
echo An error was detected applying this patch to CAD Commander 2.50 or
echo CAD Commander 2.51.  Please retry the process after verifying you are
echo running CAD Commander 2.50 (CADCMDR.EXE file date: 1-1-98, size 61025).
echo or CAD Commander 2.51 (CADCMDR.EXE file date: 1-20-98, size 60513).
echo.
GOTO DIRECTIONS


:GOODFINISH
echo Cleaning up patch files...
cd ..
del patch\*.PIT
echo.
echo CAD Commander 2.52 updated successfully.  Please shutdown and reboot
echo your system to finish the update process.
echo.
echo Also please review the README.252 that describes the changes made
echo to CAD Commander.
GOTO END

:DIRECTIONS
echo You must start this program from your \CADCMDR directory.
echo Be sure to unzip the CC252UPD.ZIP file into your \CADCMDR directory.
echo Then type CC252UPD to update the CAD Commander 2.5x software.
echo When the update finishes, shutdown and restart your system.
GOTO END

:END


