/*
 * Pgm Name    : E:\DB\BATCH\CMD\PPWIZARD.CMD
 * Pgm Version : 98.297
 * Time        : Wednesday, 4 Nov 1998  2:59:48pm
 * Input File  : E:\DB\PROJECTS\OS2\archive\ARCHIVE.x
 * Output File : .\OUT\ARCHIVE.CMD
 */

/*
*$Header:V:/SUEPVCS/SUPPORT/TEMPLATE.X_V 1.4 08 Mar 1996 11:52:14 Dennis_Bareis $
*/
PgmVersion= "98.304"
PgmParameters=translate(strip(arg(1)))
parse var PgmParameters Command Parameters
address cmd '@echo off'
EscapeChar=d2c(27)
NlChar=d2c(10)
Reset=EscapeChar|| '[0m'
HighlightColor=EscapeChar|| '[1;33m'
TitleColor=EscapeChar|| '[0;32m'
ErrorColor=EscapeChar|| '[1;31m'
NormalColor=EscapeChar|| '[0;32m'
call DisplayCopyright
call RxFuncAdd 'SysIni',           'RexxUtil', 'SysIni'
call RxFuncAdd 'SysCreateObject',  'RexxUtil', 'SysCreateObject'
call RxFuncAdd 'SysSetObjectData', 'RexxUtil', 'SysSetObjectData'
call RxFuncAdd 'SysSearchPath',    'RexxUtil', 'SysSearchPath'
call RxFuncAdd 'RxMessageBox',     'RexxUtil', 'RxMessageBox'
call RxFuncAdd 'SysFileDelete',    'RexxUtil', 'SysFileDelete'
/*
*BASEDATE.XH Version 98.118 by Dennis Bareis
*http://www.ozemail.com.au/~dbareis(db0@anz.com)
*/
signal EndBASEDATEXh
BaseDate:Procedure
TheDate=translate(arg(1), ' ', '/-')
if TheDate= '' then
TheDate=date('Sorted')
parse var TheDate Year MM DD
if length(Year)>=8 then
do
DD=substr(Year,7,2)
MM=substr(Year,5,2)
Year=left(Year,4)
end
DaysInMonth= '31  28  31  30  31  30  31  31  30  31  30  31'
if datatype(Year, 'WholeNumber')<>1 then
return(-10)
if datatype(MM, 'WholeNumber')<>1 then
return(-20)
if datatype(DD, 'WholeNumber')<>1 then
return(-30)
if MM<0|MM>12 then
return(-21)
DaysThisMonth=word(DaysInMonth,MM)
if MM=2 then
DaysThisMonth=DaysThisMonth+1
if DD<0|DD>DaysThisMonth then
return(-31)
if length(strip(Year))=2 then
do
if Year>=80 then
Year= '19' ||Year
else
Year= '20' ||Year
end
y=Year-0001
b=y*365
b=b+y%4
b=b-y%100
b=b+y%400
m=mm-01
do i=1 to m
b=b+word(DaysInMonth,i)
end
if mm>2 then
do
if 0=Year//4 then
do
if 0=Year//100 then
do
if 0=Year//400 then
b=b+1
end
else
b=b+1
end
end
d=dd-01
b=b+d
return(b)
EndBASEDATEXh:
signal on NOVALUE name RexxTrapUninitializedVariable
signal on SYNTAX name RexxTrapSyntaxError
signal on HALT name RexxCtrlC
parse source . . RexxCmdName
ArchivePgmDir=filespec('drive', RexxCmdName) || filespec('Path',RexxCmdName)
ArchiveIniFile=ArchivePgmDir|| "ARCHIVE.INI"
PatchDetails=SysIniRead("Configuration", "PatchDetails", '')
if PatchDetails= '' then
do
if Command<> "INSTALL" then
do
call Error "We can't access the configuration details stored in '" || ArchiveIniFile || "'."
exit(GetLineNumber())
end
end
parse var PatchDetails HexValueOff HexValueOn HexOffset ArchiveFile
ExitRc=0
select
when Command= "INSTALL" then
ExitRc=ProcessInstallCommand()
when Command= "ON" then
do
if PatchFile(ArchiveFile,HexOffset,HexValueOn)=0 then
call DisplayPmMessage "I", "Archiving will take place on following boot."
else
call DisplayPmMessage "I", "Archiving was already turned on!"
end
when Command= "OFF" then
do
PatchRc=PatchFile(ArchiveFile,HexOffset,HexValueOff)
TurnOnPeriod=Parameters
if TurnOnPeriod= '' then
do
if PatchRc=0 then
call DisplayPmMessage "I", "Archiving turned off."
else
call DisplayPmMessage "I", "Archiving was already turned off!"
end
else
do
BaseDateToday=BaseDate()
if PatchRc=0 then
do
call SysIniWrite "LastArchive", "BaseDate",BaseDateToday
end
if TurnOnPeriod<>0 then
do
LastArchiveBaseDate=SysIniRead("LastArchive", "BaseDate", '0')
DaysDiff=BaseDateToday-LastArchiveBaseDate
if DaysDiff>=TurnOnPeriod|DaysDiff<0 then
do
call PatchFile ArchiveFile,HexOffset,HexValueOn
TheMsg= 'Archiving will take place on following boot.' ||NlChar||NlChar
TheMsg=TheMsg|| 'You have requested that archiving occur every ' || TurnOnPeriod || ' day(s).'
call DisplayPmMessage "I",TheMsg
end
end
end
end
otherwise
Error('Unknown command of "' || Command || '" specified!')
end
exit(ExitRc)
PatchFile:
Os2ArchiveFileName=arg(1)
PatchLocation=x2d(arg(2))+1
PatchValue=x2c(arg(3))
if stream(Os2ArchiveFileName, 'c', 'query exists') = '' then
Error('The file "' || Os2ArchiveFileName || '" does not exist!')
call Normal 'Remove write protection.'
address cmd 'attrib.exe -r ' || Os2ArchiveFileName || ' >nul'
OriginalByte=charin(Os2ArchiveFileName,PatchLocation,1)
if OriginalByte=PatchValue then
do
PatchRc=1
CloseRc=stream(Os2ArchiveFileName, 'c', 'close')
end
else
do
PatchRc=0
WriteRc=charout(Os2ArchiveFileName,PatchValue,PatchLocation)
CloseRc=stream(Os2ArchiveFileName, 'c', 'close')
if WriteRc<>0 then
Error('Patch of archive file failed.')
end
call Normal 'Restore write protection.'
address cmd 'attrib.exe +r ' || Os2ArchiveFileName || ' >nul'
say 'Patching successful.'
return(PatchRc)
ProcessInstallCommand:
call Normal 'Archive software is installed at "' || ArchivePgmDir || '".'
CmdExe=SysSearchPath('PATH', 'CMD.EXE')
if CmdExe= '' then
Error("Can't find OS/2 directory.")
Os2Path=filespec('drive', CmdExe) || filespec('path',CmdExe)
ArchiveFile=Os2Path|| 'BOOT\ARCHBASE.$$$'
call Normal 'The OS/2 archive file is "' || ArchiveFile || '".'
if PatchDetails= '' then
do
ArchiveFileBu=Os2Path|| 'BOOT\ARCHBASE.ORG'
if stream(ArchiveFileBu, 'c', 'query exists') = '' then
do
call Normal 'Backing it up to "' || ArchiveFileBu || '".'
address cmd 'copy ' || ArchiveFile || ' ' || ArchiveFileBu || ' >nul'
if Rc<>0 then
Error("Copy failed (RC=" || RC || ')')
end
call OpenDesktopProperties
call Highlight 'Select "ARCHIVE" tab, Ensure "Create archive at system startup" is OFF.'
call Pause
call Normal 'Recording current state (OFF)...'
WhenOff=GetFileContents(ArchiveFile)
do until WhenOff<>WhenOn
call OpenDesktopProperties
call Highlight 'Set the "Create archive at system startup" option to ON.'
call Pause
call Normal 'Recording current state (ON)...'
WhenOn=GetFileContents(ArchiveFile)
end
if length(WhenOn)<>length(WhenOff)then
Error("File sizes appear to differ (not expected)")
DiffPos=compare(WhenOff,WhenOn)
if DiffPos=0 then
Error("Can't find difference (unexpected)")
HexOffset=d2x(DiffPos-1)
HexValueOff=c2x(substr(WhenOff,DiffPos,1))
HexValueOn=c2x(substr(WhenOn,DiffPos,1))
NewValue=HexValueOff|| ' ' || HexValueOn || ' ' || HexOffset  || ' ' ||ArchiveFile
call SysIniWrite "Configuration", "PatchDetails",NewValue
end
call Normal 'Patch offset is x' || HexOffset || ' (OFF=x' || HexValueOff || ', ON=x' || HexValueOn || ').'
call charout,NormalColor|| "Days between automatic archives (0=OFF) : " ||Reset
NumberOfDays=linein()
if NumberOfDays= '' then
NumberOfDays=0
if datatype(NumberOfDays, 'W')=0 then
NumberOfDays=7
Title= "Turn on Archiving"
Location= "<WP_DESKTOP>"
Class= "WPProgram"
ObjMode= "ReplaceIfExists"
SetupString= "EXENAME=*;"
SetupString=SetupString|| 'EXENAME=CMD.EXE;'
SetupString=SetupString|| 'PARAMETERS=/c ' || RexxCmdName || ' ON;'
SetupString=SetupString|| "ICONFILE=" || ArchivePgmDir || 'ON.ICO;'
SetupString=SetupString|| "MINIMIZED=YES;"
SetupString=SetupString|| "PROGTYPE=PM;"
SetupString=SetupString|| "OBJECTID=<TurnArchiveOn>;"
Rc=SysCreateObject(Class,Title,Location,SetupString,ObjMode)
call Normal 'Creating icon - ' ||Title
if Rc=0 then
Error("Could not create the icon")
Title= "Turn off Archiving"
Location= "<WP_DESKTOP>"
Class= "WPProgram"
SetupString= "EXENAME=*;"
SetupString=SetupString|| 'EXENAME=CMD.EXE;'
SetupString=SetupString|| 'PARAMETERS=/c ' || RexxCmdName || ' OFF;'
SetupString=SetupString|| "ICONFILE="   || ArchivePgmDir || 'OFF.ICO;'
SetupString=SetupString|| "MINIMIZED=YES;"
SetupString=SetupString|| "PROGTYPE=PM;"
SetupString=SetupString|| "OBJECTID=<TurnArchiveOff>;"
Rc=SysCreateObject(Class,Title,Location,SetupString,ObjMode)
call Normal 'Creating icon - ' ||Title
if Rc=0 then
Error("Could not create the icon")
if NumberOfDays=0 then
Title= "Turn off Archiving"
else
Title= "Turn off Archiving (turn on every " || NumberOfDays || ' days)'
Location= "<WP_START>"
Class= "WPProgram"
SetupString= "EXENAME=*;"
SetupString=SetupString|| 'EXENAME=CMD.EXE;'
SetupString=SetupString|| 'PARAMETERS=/c ' || RexxCmdName || ' OFF ' || NumberOfDays || ';'
SetupString=SetupString|| "ICONFILE="   || ArchivePgmDir || 'OFF.ICO;'
SetupString=SetupString|| "MINIMIZED=YES;"
SetupString=SetupString|| "PROGTYPE=PM;"
SetupString=SetupString|| "OBJECTID=<TurnArchiveOffInStartupFolder>;"
Rc=SysCreateObject(Class,Title,Location,SetupString,ObjMode)
call Normal 'Creating icon - ' ||Title
if Rc=0 then
Error("Could not create the icon")
say ''
call Highlight 'STARTUP FOLDER updated so that archiving is automatically'
call Highlight 'turned off after boot.  Delete this icon icon if you wish.'
say ''
call Normal 'Setup Completed'
return(0)
SysIniRead:
IniApp=arg(1)
IniKey=arg(2)
IniDefault=arg(3)
IniValue=SysIni(ArchiveIniFile,IniApp,IniKey)
if IniValue= 'ERROR:' then
IniValue=IniDefault
return(IniValue)
SysIniWrite:
IniApp=arg(1)
IniKey=arg(2)
IniValue=arg(3)
WriteRc=SysIni(ArchiveIniFile,IniApp,IniKey,IniValue)
if WriteRc= 'ERROR:' then
do
call Error "We couldn't update the configuration details stored in '" || ArchiveIniFile || "'."
exit(GetLineNumber())
end
return
GetFileContents:
Contents=charin(arg(1),1,9999)
CloseRc=stream(arg(1), 'c', 'close')
if length(Contents)<512 then
Error("Only read " || length(Contents) " bytes from file")
return(Contents)
OpenDesktopProperties:
call Normal 'Opening Desktop Properties...'
call SysSetObjectData "<WP_DESKTOP>", "OPEN=SETTINGS"
return
Pause:
address cmd '@pause'
return
Error:
ErrorRc=SIGL
say ErrorColor||arg(1)||Reset|| ''
call DisplayPmMessage "E", "An error occurred." ||NlChar||NlChar||arg(1)
exit(ErrorRc)
Normal:
say NormalColor||arg(1)||Reset
return
HighLight:
say HighlightColor||arg(1)||Reset
return
GetLineNumber:
return(SIGL)
DisplayCopyright:
call charout,HighlightColor
say '[]-------------------------------------------------------------[]'
say '| ARCHIVE.CMD: Version ' || PgmVersion || ' (C)opyright Dennis Bareis 1997    |'
say '|             http://www.ozemail.com.au/~dbareis (db0@anz.com) |'
say '[]-------------------------------------------------------------[]'
say Reset
return
CommonTrapHandler:
FailingLine=arg(1)
TrapHeading= 'BUG: ' ||arg(2)
TextDescription=arg(3)
Text=arg(4)
parse source . . RexxCmdName
say ErrorColor||copies('=+',39)
say TrapHeading
say copies('~',length(TrapHeading))
say substr(TextDescription,1,16)|| ': ' ||Text
say 'Failing Module  : ' ||RexxCmdName
say 'Failing Line #  : ' ||FailingLine
say 'Failing Command : ' ||strip(SourceLine(FailingLine))
say copies('=+', 39) || Reset || ''
call DisplayPmMessage "E", "Line #" || FailingLine || " failed." || NlChar || NlChar || TextDescription || ' : ' ||Text
exit(FailingLine)
RexxTrapUninitializedVariable:
call CommonTrapHandler SIGL, 'NoValue Abort!', 'Unknown Variable', condition('D')
RexxTrapSyntaxError:
call CommonTrapHandler SIGL, 'Syntax Error!', 'Reason',errortext(Rc)
RexxCtrlC:
LineCtrlC=SIGL
say ''
say ErrorColor||copies('=+',39)
say "Come on, you pressed Ctrl+C or Break didn't you!"
say copies('=+', 39) || Reset || ''
exit(LineCtrlC)
DisplayPmMessage:
MsgType=arg(1)
Text=arg(2)
Title= "ARCHIVE.CMD v" || PgmVersion || "  Dennis Bareis 1998"
if MsgType= 'E' then
do
Button= "ENTER"
Icon= "ERROR"
end
else
do
Button= "OK"
Icon= "INFORMATION"
end
AddText=NlChar||NlChar||NlChar|| 'Please report any suggestions or bugs to "db0@anz.com". '
AddText=AddText|| 'The latest version of this program is available at "http://www.ozemail.com.au/~dbareis".'
signal ON SYNTAX NAME RxBoxCantBeUsed
call RxMessageBox NlChar||Text||AddText,Title,Button,Icon
RxBoxCantBeUsed:
return
