/*
 * Decompiled with CFR 0.152.
 */
package kasper.util;

import java.util.Enumeration;
import java.util.Vector;
import kasper.util.TimerEvent;
import kasper.util.TimerListener;

public class Timer
implements Runnable,
Cloneable {
    protected long millisBetweenEvents = -1L;
    protected int nanosBetweenEvents = -1;
    protected Vector timerListeners;

    public Timer(long l) {
        this(l, 0);
    }

    public Timer(long l, int n) {
        if (l < 0L) {
            throw new IllegalArgumentException("Passed a negative value of " + l + " to the first parameter of Timer().");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("Passed an out-of-range value of " + n + " to the second parameter of Timer().");
        }
        this.millisBetweenEvents = l;
        this.nanosBetweenEvents = n;
        this.timerListeners = new Vector();
    }

    public void addTimerListener(TimerListener timerListener) {
        this.timerListeners.addElement(timerListener);
    }

    public void removeTimerListener(TimerListener timerListener) {
        this.timerListeners.removeElement(timerListener);
    }

    public void run() {
        boolean bl = true;
        while (bl) {
            try {
                Thread.sleep(this.millisBetweenEvents, this.nanosBetweenEvents);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
                bl = false;
            }
            Enumeration enumeration = this.timerListeners.elements();
            while (enumeration.hasMoreElements()) {
                TimerEvent timerEvent = new TimerEvent(this);
                ((TimerListener)enumeration.nextElement()).timingCycleComplete(timerEvent);
            }
        }
    }

    public long getMillisBetweenEvents() {
        return this.millisBetweenEvents;
    }

    public int getNanosBetweenEvents() {
        return this.nanosBetweenEvents;
    }

    public void setTimeBetweenEvents(long l) {
        this.setTimeBetweenEvents(l, 0);
    }

    public void setTimeBetweenEvents(long l, int n) {
        if (l < 0L) {
            throw new IllegalArgumentException("Passed a negative value of " + l + " to the first parameter of " + "setTimeBetweenEvents().");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("Passed an out-of-range value of " + n + " to the second parameter of " + "setTimeBetweenEvents().");
        }
        this.millisBetweenEvents = l;
        this.nanosBetweenEvents = n;
    }
}

