/*
 * Decompiled with CFR 0.152.
 */
package kasper.util;

import java.io.Serializable;
import java.util.Date;
import kasper.util.CurrentlyTimingException;

public class Timekeeper
implements Cloneable,
Serializable {
    protected Date beginDate;
    protected Date endDate;
    protected long timeExpired;
    protected boolean timing = false;

    public void start() {
        if (this.timing) {
            throw new CurrentlyTimingException("Attempted to call start() while timing.");
        }
        this.beginDate = new Date();
        this.timing = true;
    }

    public void stop() {
        if (this.timing) {
            this.endDate = new Date();
            this.timing = false;
            this.timeExpired += this.endDate.getTime() - this.beginDate.getTime();
        }
    }

    public boolean isTiming() {
        return this.timing;
    }

    public long getTimeExpired() throws CurrentlyTimingException {
        if (this.timing) {
            throw new CurrentlyTimingException("Attempted to call timeExpired() while timing.");
        }
        if (this.beginDate == null) {
            return -1L;
        }
        return this.timeExpired;
    }

    public void reset() {
        this.timing = false;
        this.beginDate = null;
        this.endDate = null;
    }
}

