/*
 * Decompiled with CFR 0.152.
 */
package kasper.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import kasper.net.NumericServerResponse;
import kasper.net.RemoteFile;

public class FTPServerResponse
extends NumericServerResponse {
    public static final int RESTART_MARKER = 110;
    public static final int SERVER_NOT_READY = 120;
    public static final int DATA_CONNECTION_ALREADY_OPEN = 125;
    public static final int FILE_STATUS_OKAY = 150;
    public static final int COMMAND_OKAY = 200;
    public static final int SUPERFLUOUS_COMMAND = 202;
    public static final int SYSTEM_STATUS = 211;
    public static final int DIRECTORY_STATUS = 212;
    public static final int FILE_STATUS = 213;
    public static final int HELP_MESSAGE = 214;
    public static final int NAME_SYSTEM_TYPE = 215;
    public static final int SERVER_READY = 220;
    public static final int CLOSING_CONTROL_CONNECTION = 221;
    public static final int DATA_CONNECTION_OPEN = 225;
    public static final int CLOSING_DATA_CONNECTION = 226;
    public static final int ENTERING_PASSIVE_MODE = 227;
    public static final int USER_LOGGED_IN = 230;
    public static final int FILE_ACTION_OKAY = 250;
    public static final int PATHNAME_CREATED = 257;
    public static final int PASSWORD_NEEDED = 331;
    public static final int ACCOUNT_NEEDED = 332;
    public static final int FILE_ACTION_PENDING = 350;
    public static final int SERVICE_NOT_AVAILABLE = 421;
    public static final int CANT_OPEN_DATA_CONNECTION = 425;
    public static final int TRANSFER_ABORTED = 426;
    public static final int FILE_ACTION_NOT_TAKEN = 450;
    public static final int SERVER_PROCESSING_ERROR = 451;
    public static final int INSUFFICIENT_STORAGE_SPACE = 452;
    public static final int SYNTAX_ERROR_UNRECOGNIZED = 500;
    public static final int SYNTAX_ERROR_PARAMETERS = 501;
    public static final int COMMAND_NOT_IMPLEMENTED = 502;
    public static final int BAD_COMMAND_SEQUENCE = 503;
    public static final int COMMAND_NOT_IMPLEMENTED_FOR_PARAMETER = 504;
    public static final int NOT_LOGGED_IN = 530;
    public static final int ACCOUNT_NEEDED_FOR_FILE_STORAGE = 532;
    public static final int FILE_UNAVAILABLE = 550;
    public static final int PAGE_TYPE_UNKNOWN = 551;
    public static final int EXCEEDED_STORAGE_ALLOCATION = 552;
    public static final int FILENAME_NOT_ALLOWED = 553;
    protected String[] responseArray;
    protected Vector remoteFileVector = new Vector();

    public FTPServerResponse(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public FTPServerResponse(Reader reader) throws IOException {
        super(reader);
        Vector<String> vector = new Vector<String>();
        vector.addElement(super.getResponse());
        if (this.response.substring(3).startsWith("-")) {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = String.valueOf(String.valueOf(this.responseCode)) + " ";
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith(string)) {
                vector.addElement(string2);
            }
            vector.addElement(string2);
        }
        this.responseArray = new String[vector.size()];
        vector.copyInto(this.responseArray);
    }

    public void addRemoteFile(String string) {
        this.addRemoteFile(new RemoteFile(string));
    }

    public void addRemoteFile(RemoteFile remoteFile) {
        this.remoteFileVector.addElement(remoteFile);
    }

    public RemoteFile[] getRemoteFiles() {
        Object[] objectArray = new RemoteFile[this.remoteFileVector.size()];
        this.remoteFileVector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getResponses() {
        return this.responseArray;
    }

    public String toString() {
        String string = "";
        String string2 = System.getProperty("line_separator");
        if (string2 == null) {
            string2 = "\n";
        }
        int n = this.responseArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.responseArray[n2] + string2;
            ++n2;
        }
        string = String.valueOf(string) + this.responseArray[this.responseArray.length - 1];
        return string;
    }
}

