/*
 * Decompiled with CFR 0.152.
 */
package kasper.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import kasper.io.EBCDICReader;
import kasper.io.EBCDICWriter;
import kasper.net.AlreadyConnectedException;
import kasper.net.NotConnectedException;
import kasper.net.RemoteFile;
import kasper.net.ftp.FTPServerResponse;

public class FTPClient {
    public static final String TELNET_ENDLINE = "\r\n";
    public static final int STREAM = 0;
    public static final int BLOCK = 1;
    public static final int COMPRESSED = 2;
    public static final int ASCII = 4096;
    public static final int EBCDIC = 4097;
    public static final int IMAGE = 4098;
    public static final int LOCAL = 4099;
    public static final int FILE = 8192;
    public static final int RECORD = 8193;
    public static final int PAGE = 8194;
    public static final int NON_PRINT = 12288;
    public static final int TELNET_EFFECTOR = 12289;
    public static final int CARRIAGE_CONTROL = 12290;
    public static final int ACTIVE = 16384;
    public static final int PASSIVE = 16385;
    public static final int DEFAULT_FTP_PORT = 21;
    protected boolean connected = false;
    protected String remoteHostName;
    protected int remoteHostPort = -1;
    protected String remoteDataIP;
    protected int remoteDataPort = -1;
    protected transient Socket controlConnection;
    protected transient InputStreamReader controlIn;
    protected transient BufferedWriter controlOut;
    protected transient ServerSocket dataServer;
    protected transient Socket dataConnection;
    protected int currentRepresentationType = 4096;
    protected int currentFormatType = 12288;
    protected int currentStructureType = 8192;
    protected int currentTransferMode = 0;
    protected boolean dontSwitch = false;
    protected boolean openConnection = false;
    protected boolean appendFile = false;
    protected long amountTransferred = -1L;

    protected FTPServerResponse execute(String string, String string2) throws IOException {
        if (!this.connected) {
            throw new NotConnectedException("Attempted to call " + string + "() without " + "without a control connection established.");
        }
        String string3 = String.valueOf(string) + string2 + TELNET_ENDLINE;
        this.controlOut.write(string3, 0, string3.length());
        this.controlOut.flush();
        return new FTPServerResponse(this.controlIn);
    }

    public FTPServerResponse getResponse() throws IOException {
        return new FTPServerResponse(this.controlIn);
    }

    protected String checkEmpty(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        return " " + string;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getRemoteHost() {
        if (!this.connected) {
            return null;
        }
        return this.remoteHostName;
    }

    public int getRemotePort() {
        if (!this.connected) {
            return -1;
        }
        return this.remoteHostPort;
    }

    public long getAmountTransferred() {
        return this.amountTransferred;
    }

    public FTPServerResponse connect(String string) throws UnknownHostException, IOException {
        return this.connect(string, 21);
    }

    public FTPServerResponse connect(String string, int n) throws UnknownHostException, IOException {
        if (this.connected) {
            throw new AlreadyConnectedException("Tried to connect to " + string + ":" + n + " while connected to " + this.remoteHostName + ":" + this.remoteHostPort + ".", string, n);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.controlConnection = new Socket(string, n);
        this.controlIn = new InputStreamReader(this.controlConnection.getInputStream());
        this.controlOut = new BufferedWriter(new OutputStreamWriter(this.controlConnection.getOutputStream()));
        this.remoteHostName = string;
        this.remoteHostPort = n;
        this.connected = true;
        return new FTPServerResponse(this.controlIn);
    }

    public FTPServerResponse user(String string) throws IOException {
        return this.execute("user", this.checkEmpty(string));
    }

    public FTPServerResponse pass(String string) throws IOException {
        return this.execute("pass", this.checkEmpty(string));
    }

    public FTPServerResponse acct(String string) throws IOException {
        return this.execute("acct", this.checkEmpty(string));
    }

    public FTPServerResponse cwd(String string) throws IOException {
        return this.execute("cwd", this.checkEmpty(string));
    }

    public FTPServerResponse cdup() throws IOException {
        return this.execute("cdup", "");
    }

    public FTPServerResponse smnt(String string) throws IOException {
        return this.execute("smnt", this.checkEmpty(string));
    }

    public FTPServerResponse quit() throws IOException {
        FTPServerResponse fTPServerResponse = this.execute("quit", "");
        if (fTPServerResponse.getResponseCode() == 221) {
            this.controlIn.close();
            this.controlOut.close();
            this.controlConnection.close();
            this.connected = false;
            this.remoteHostName = null;
            this.remoteHostPort = -1;
            this.remoteDataIP = null;
            this.remoteDataPort = -1;
            this.controlConnection = null;
            this.controlIn = null;
            this.controlOut = null;
            this.dataServer = null;
            this.dataConnection = null;
            this.currentRepresentationType = 4096;
            this.currentFormatType = 12288;
            this.currentStructureType = 8192;
            this.currentTransferMode = 0;
            this.dontSwitch = false;
            this.openConnection = false;
            this.appendFile = false;
        }
        return fTPServerResponse;
    }

    public FTPServerResponse rein() throws IOException {
        return this.execute("rein", "");
    }

    public FTPServerResponse port() throws IOException {
        this.dataServer = new ServerSocket(0, 0);
        this.openConnection = true;
        this.dontSwitch = true;
        return this.port(InetAddress.getLocalHost().getHostAddress(), this.dataServer.getLocalPort());
    }

    public FTPServerResponse port(String string, int n) throws IOException {
        String string2 = InetAddress.getByName(string).getHostAddress().replace('.', ',');
        String string3 = String.valueOf(string2) + "," + ((n & 0xFF00) >> 8) + "," + (n & 0xFF);
        if (!this.dontSwitch) {
            this.dontSwitch = true;
            this.openConnection = false;
        }
        return this.port(string3);
    }

    public FTPServerResponse port(FTPServerResponse fTPServerResponse) throws IOException, NotConnectedException {
        int n = fTPServerResponse.getResponse().indexOf(40) + 1;
        int n2 = fTPServerResponse.getResponse().indexOf(41);
        this.dontSwitch = false;
        if (fTPServerResponse.getResponseCode() != 227 || n < 0 || n2 < 0) {
            return this.port((String)null);
        }
        return this.port(fTPServerResponse.getResponse().substring(n, n2));
    }

    public FTPServerResponse port(String string) throws IOException {
        FTPServerResponse fTPServerResponse = this.execute("port", this.checkEmpty(string));
        if (fTPServerResponse.getResponseCode() == 200) {
            this.currentTransferMode = 16384;
        }
        if (!this.dontSwitch) {
            this.openConnection = false;
        }
        this.dontSwitch = false;
        return fTPServerResponse;
    }

    public FTPServerResponse pasv() throws IOException {
        return this.pasv(true);
    }

    public FTPServerResponse pasv(boolean bl) throws IOException {
        FTPServerResponse fTPServerResponse = this.execute("pasv", "");
        if (fTPServerResponse.getResponseCode() == 227) {
            this.currentTransferMode = 16385;
            String string = fTPServerResponse.getResponse();
            this.remoteDataIP = string.substring(string.lastIndexOf(40) + 1);
            this.remoteDataIP = this.remoteDataIP.substring(0, this.remoteDataIP.lastIndexOf(41));
            int n = 0;
            int n2 = 0;
            while (n2 < 4) {
                if (this.remoteDataIP.charAt(n) == ',') {
                    ++n2;
                }
                ++n;
            }
            String string2 = this.remoteDataIP.substring(n);
            this.remoteDataIP = this.remoteDataIP.substring(0, n - 1);
            this.remoteDataIP = this.remoteDataIP.replace(',', '.');
            this.remoteDataPort = (Integer.parseInt(string2.substring(0, string2.indexOf(44))) << 8) + Integer.parseInt(string2.substring(string2.indexOf(44) + 1, string2.length()));
        }
        this.openConnection = bl;
        return fTPServerResponse;
    }

    public FTPServerResponse type(int n) throws IOException {
        return this.type(n, 12288);
    }

    public FTPServerResponse type(int n, int n2) throws IOException {
        String string = "";
        String string2 = "";
        switch (n) {
            case 4096: {
                string = "A";
                break;
            }
            case 4097: {
                string = "E";
                break;
            }
            case 4098: {
                string = "I";
                break;
            }
            case 4099: {
                string = "L";
                break;
            }
            default: {
                throw new IllegalArgumentException("An invalid representation type was passed to type().");
            }
        }
        if (n == 4099) {
            string2 = String.valueOf(n2);
        } else if (n != 4098) {
            switch (n2) {
                case 12288: {
                    string2 = "N";
                    break;
                }
                case 12289: {
                    string2 = "T";
                    break;
                }
                case 12290: {
                    string2 = "C";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("An invalid format type was passed to type().");
                }
            }
        }
        FTPServerResponse fTPServerResponse = this.execute("type", String.valueOf(this.checkEmpty(string)) + this.checkEmpty(string2));
        if (fTPServerResponse.getResponseCode() == 200) {
            this.currentRepresentationType = n;
            this.currentFormatType = n2;
        }
        return fTPServerResponse;
    }

    public FTPServerResponse stru(int n) throws IOException {
        String string = "";
        switch (n) {
            case 8192: {
                string = "F";
                break;
            }
            case 8193: {
                string = "R";
                break;
            }
            case 8194: {
                string = "P";
                break;
            }
            default: {
                throw new IllegalArgumentException("An invalid structure type was passed to stru().");
            }
        }
        FTPServerResponse fTPServerResponse = this.execute("stru", this.checkEmpty(string));
        if (fTPServerResponse.getResponseCode() == 200) {
            this.currentStructureType = n;
        }
        return fTPServerResponse;
    }

    public FTPServerResponse mode(int n) throws IOException {
        String string = "";
        switch (n) {
            case 0: {
                string = "S";
                break;
            }
            case 1: {
                string = "B";
                break;
            }
            case 2: {
                string = "C";
                break;
            }
            default: {
                throw new IllegalArgumentException("An invalid tansfer type was passed to mode().");
            }
        }
        FTPServerResponse fTPServerResponse = this.execute("mode", this.checkEmpty(string));
        if (fTPServerResponse.getResponseCode() == 200) {
            this.currentTransferMode = n;
        }
        return fTPServerResponse;
    }

    public FTPServerResponse[] retr(String string) throws IOException, UnknownHostException {
        return this.retr(string, string);
    }

    public FTPServerResponse[] retr(RemoteFile remoteFile) throws IOException, UnknownHostException {
        return this.retr(remoteFile.getName(), remoteFile.getName());
    }

    public FTPServerResponse[] retr(String string, File file) throws IOException, UnknownHostException {
        return this.retr(string, file.getName());
    }

    public FTPServerResponse[] retr(RemoteFile remoteFile, String string) throws IOException, UnknownHostException {
        return this.retr(remoteFile.getName(), string);
    }

    public FTPServerResponse[] retr(RemoteFile remoteFile, File file) throws IOException, UnknownHostException {
        return this.retr(remoteFile.getName(), file.getName());
    }

    public FTPServerResponse[] retr(String string, String string2) throws IOException, UnknownHostException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("retr", this.checkEmpty(string));
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("retr", this.checkEmpty(string));
                }
            }
            InputStream inputStream = this.dataConnection.getInputStream();
            switch (this.currentRepresentationType) {
                case 4096: 
                case 4097: {
                    BufferedReader bufferedReader = null;
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
                    if (this.currentRepresentationType == 4097) {
                        bufferedReader = new BufferedReader(new EBCDICReader(bufferedReader), 1024);
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2, this.appendFile));
                    this.appendFile = false;
                    char[] cArray = new char[1024];
                    this.amountTransferred = 0L;
                    int n = bufferedReader.read(cArray);
                    while (n != -1) {
                        bufferedWriter.write(cArray, 0, n);
                        this.amountTransferred += (long)n;
                        n = bufferedReader.read(cArray);
                    }
                    this.amountTransferred = -1L;
                    bufferedReader.close();
                    bufferedWriter.close();
                    break;
                }
                case 4098: {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2, this.appendFile), 1024);
                    this.appendFile = false;
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    this.amountTransferred = 0L;
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                        this.amountTransferred = n;
                    }
                    this.amountTransferred = -1L;
                    ((FilterInputStream)bufferedInputStream).close();
                    bufferedOutputStream.close();
                }
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("retr", this.checkEmpty(string));
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse[] stor(String string) throws IOException, UnknownHostException {
        return this.stor(new File(string), string);
    }

    public FTPServerResponse[] stor(File file) throws IOException, UnknownHostException {
        return this.stor(file, file.getName());
    }

    public FTPServerResponse[] stor(String string, String string2) throws IOException, UnknownHostException {
        return this.stor(new File(string), string2);
    }

    public FTPServerResponse[] stor(String string, RemoteFile remoteFile) throws IOException, UnknownHostException {
        return this.stor(new File(string), remoteFile.getName());
    }

    public FTPServerResponse[] stor(File file, RemoteFile remoteFile) throws IOException, UnknownHostException {
        return this.stor(file, remoteFile.getName());
    }

    public FTPServerResponse[] stor(File file, String string) throws IOException, UnknownHostException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("stor", this.checkEmpty(string));
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("stor", this.checkEmpty(string));
                }
            }
            OutputStream outputStream = this.dataConnection.getOutputStream();
            switch (this.currentRepresentationType) {
                case 4096: 
                case 4097: {
                    BufferedWriter bufferedWriter = null;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream), 1024);
                    if (this.currentRepresentationType == 4097) {
                        bufferedWriter = new BufferedWriter(new EBCDICWriter(bufferedWriter), 1024);
                    }
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 1024);
                    char[] cArray = new char[1024];
                    this.amountTransferred = 0L;
                    int n = bufferedReader.read(cArray);
                    while (n != -1) {
                        bufferedWriter.write(cArray, 0, n);
                        this.amountTransferred += (long)n;
                        n = bufferedReader.read(cArray);
                    }
                    this.amountTransferred = -1L;
                    bufferedWriter.close();
                    bufferedReader.close();
                    break;
                }
                case 4098: {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    this.amountTransferred = 0L;
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                        this.amountTransferred += (long)n;
                    }
                    bufferedOutputStream.close();
                    fileInputStream.close();
                }
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("stor", this.checkEmpty(string));
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse[] stou(String string) throws IOException, UnknownHostException {
        return this.stou(new File(string));
    }

    public FTPServerResponse[] stou(File file) throws IOException, UnknownHostException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("stou", "");
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("stou", "");
                }
            }
            OutputStream outputStream = this.dataConnection.getOutputStream();
            switch (this.currentRepresentationType) {
                case 4096: 
                case 4097: {
                    BufferedWriter bufferedWriter = null;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream), 1024);
                    if (this.currentRepresentationType == 4097) {
                        bufferedWriter = new BufferedWriter(new EBCDICWriter(bufferedWriter), 1024);
                    }
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 1024);
                    char[] cArray = new char[1024];
                    this.amountTransferred = 0L;
                    int n = bufferedReader.read(cArray);
                    while (n != -1) {
                        bufferedWriter.write(cArray, 0, n);
                        this.amountTransferred += (long)n;
                        n = bufferedReader.read(cArray);
                    }
                    bufferedWriter.close();
                    bufferedReader.close();
                    break;
                }
                case 4098: {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    this.amountTransferred = 0L;
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                        this.amountTransferred += (long)n;
                    }
                    this.amountTransferred = -1L;
                    bufferedOutputStream.close();
                    ((FilterInputStream)bufferedInputStream).close();
                }
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("stou", "");
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse[] appe(String string) throws IOException, UnknownHostException {
        return this.appe(new File(string), string);
    }

    public FTPServerResponse[] appe(File file) throws IOException, UnknownHostException {
        return this.appe(file, file.getName());
    }

    public FTPServerResponse[] appe(String string, String string2) throws IOException, UnknownHostException {
        return this.appe(new File(string), string2);
    }

    public FTPServerResponse[] appe(String string, RemoteFile remoteFile) throws IOException, UnknownHostException {
        return this.appe(new File(string), remoteFile.getName());
    }

    public FTPServerResponse[] appe(File file, RemoteFile remoteFile) throws IOException, UnknownHostException {
        return this.appe(file, remoteFile.getName());
    }

    public FTPServerResponse[] appe(File file, String string) throws IOException, UnknownHostException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("appe", this.checkEmpty(string));
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("appe", this.checkEmpty(string));
                }
            }
            OutputStream outputStream = this.dataConnection.getOutputStream();
            switch (this.currentRepresentationType) {
                case 4096: 
                case 4097: {
                    BufferedWriter bufferedWriter = null;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream), 1024);
                    if (this.currentRepresentationType == 4097) {
                        bufferedWriter = new BufferedWriter(new EBCDICWriter(bufferedWriter), 1024);
                    }
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 1024);
                    char[] cArray = new char[1024];
                    this.amountTransferred = 0L;
                    int n = bufferedReader.read(cArray);
                    while (n != -1) {
                        bufferedWriter.write(cArray, 0, n);
                        this.amountTransferred += (long)n;
                        n = bufferedReader.read(cArray);
                    }
                    this.amountTransferred = -1L;
                    bufferedWriter.close();
                    bufferedReader.close();
                    break;
                }
                case 4098: {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 1024);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    this.amountTransferred = 0L;
                    while ((n = bufferedInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                        this.amountTransferred += (long)n;
                    }
                    this.amountTransferred = -1L;
                    bufferedOutputStream.close();
                    ((FilterInputStream)bufferedInputStream).close();
                }
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("appe", this.checkEmpty(string));
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse allo(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value of " + l + " passed as the first argument to " + "allo().");
        }
        return this.execute("allo", this.checkEmpty(String.valueOf(l)));
    }

    public FTPServerResponse allo(long l, long l2) throws IOException, NotConnectedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative value of " + l + " passed as the first argument to " + "allo().");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative value of " + l2 + " passed as the second argument " + " to allo().");
        }
        return this.execute("allo", String.valueOf(this.checkEmpty(String.valueOf(l))) + " R" + this.checkEmpty(String.valueOf(l2)));
    }

    public FTPServerResponse rest(String string) throws IOException, FileNotFoundException {
        return this.rest(new File(string));
    }

    public FTPServerResponse rest(File file) throws IOException {
        return this.rest(file.length());
    }

    public FTPServerResponse rest(long l) throws IOException {
        FTPServerResponse fTPServerResponse = this.execute("rest", this.checkEmpty(String.valueOf(l)));
        if (fTPServerResponse.getResponseCode() == 350) {
            this.appendFile = true;
        }
        return fTPServerResponse;
    }

    public FTPServerResponse rnfr(RemoteFile remoteFile) throws IOException {
        return this.rnfr(remoteFile.getName());
    }

    public FTPServerResponse rnfr(String string) throws IOException {
        return this.execute("rnfr", this.checkEmpty(string));
    }

    public FTPServerResponse rnto(RemoteFile remoteFile) throws IOException {
        return this.rnto(remoteFile.getName());
    }

    public FTPServerResponse rnto(String string) throws IOException {
        return this.execute("rnto", this.checkEmpty(string));
    }

    public FTPServerResponse abor() throws IOException {
        return this.execute("abor", "");
    }

    public FTPServerResponse dele(RemoteFile remoteFile) throws IOException {
        return this.dele(remoteFile.getName());
    }

    public FTPServerResponse dele(String string) throws IOException {
        return this.execute("dele", this.checkEmpty(string));
    }

    public FTPServerResponse rmd(RemoteFile remoteFile) throws IOException {
        return this.rmd(remoteFile.getName());
    }

    public FTPServerResponse rmd(String string) throws IOException {
        return this.execute("rmd", this.checkEmpty(string));
    }

    public FTPServerResponse mkd(RemoteFile remoteFile) throws IOException {
        return this.mkd(remoteFile.getName());
    }

    public FTPServerResponse mkd(String string) throws IOException {
        return this.execute("mkd", this.checkEmpty(string));
    }

    public FTPServerResponse pwd() throws IOException {
        return this.execute("pwd", "");
    }

    public FTPServerResponse[] list() throws IOException {
        return this.list(null);
    }

    public FTPServerResponse[] list(String string) throws IOException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("list", this.checkEmpty(string));
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("list", this.checkEmpty(string));
                }
            }
            Reader reader = null;
            switch (this.currentRepresentationType) {
                case 4097: {
                    reader = new EBCDICReader(new InputStreamReader(this.dataConnection.getInputStream()));
                    break;
                }
                default: {
                    reader = new InputStreamReader(this.dataConnection.getInputStream());
                }
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = bufferedReader.readLine();
            if (!string2.toLowerCase().startsWith("total")) {
                fTPServerResponseArray[0].addRemoteFile(string2);
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                fTPServerResponseArray[0].addRemoteFile(string2);
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("list", this.checkEmpty(string));
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse[] nlst() throws IOException {
        return this.nlst(null);
    }

    public FTPServerResponse[] nlst(String string) throws IOException {
        FTPServerResponse[] fTPServerResponseArray = new FTPServerResponse[2];
        if (this.openConnection) {
            switch (this.currentTransferMode) {
                case 16384: {
                    fTPServerResponseArray[0] = this.execute("nlst", this.checkEmpty(string));
                    this.dataConnection = this.dataServer.accept();
                    this.dataServer = null;
                    break;
                }
                case 16385: {
                    this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                    fTPServerResponseArray[0] = this.execute("nlst", this.checkEmpty(string));
                }
            }
            Reader reader = null;
            switch (this.currentRepresentationType) {
                case 4097: {
                    reader = new EBCDICReader(new InputStreamReader(this.dataConnection.getInputStream()));
                    break;
                }
                default: {
                    reader = new InputStreamReader(this.dataConnection.getInputStream());
                }
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = bufferedReader.readLine();
            if (!string2.toLowerCase().startsWith("total")) {
                fTPServerResponseArray[0].addRemoteFile(string2);
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                fTPServerResponseArray[0].addRemoteFile(string2);
            }
            fTPServerResponseArray[1] = new FTPServerResponse(this.controlIn);
        } else {
            fTPServerResponseArray[0] = this.execute("nlst", this.checkEmpty(string));
            fTPServerResponseArray[1] = null;
        }
        return fTPServerResponseArray;
    }

    public FTPServerResponse site(String string) throws IOException {
        return this.execute("site", this.checkEmpty(string));
    }

    public FTPServerResponse syst() throws IOException {
        return this.execute("syst", "");
    }

    public FTPServerResponse help() throws IOException {
        return this.help(null);
    }

    public FTPServerResponse help(String string) throws IOException {
        return this.execute("help", this.checkEmpty(string));
    }

    public FTPServerResponse noop() throws IOException {
        return this.execute("noop", "");
    }
}

