/*
 * Decompiled with CFR 0.152.
 */
package kasper.net;

import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class RemoteFile
implements Cloneable,
Serializable {
    protected boolean isDirectory = false;
    protected String fileName;
    protected long lastModified = -1L;
    protected long length = -1L;
    protected String ownersGroup;
    protected String owner;
    protected int symbolicLinks = -1;
    protected String protections;
    protected boolean[] isReadable;
    protected boolean[] isWriteable;
    protected boolean[] isExecutable;
    protected boolean[] userProtections;
    protected boolean[] groupProtections;
    protected boolean[] worldProtections;
    protected String stringRepresentation;

    public RemoteFile(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() == 1) {
            this.stringRepresentation = this.fileName = stringTokenizer.nextToken();
            return;
        }
        this.stringRepresentation = string;
        this.protections = stringTokenizer.nextToken();
        if (this.protections.charAt(0) == 'd') {
            this.isDirectory = true;
        }
        this.isReadable = new boolean[3];
        this.isWriteable = new boolean[3];
        this.isExecutable = new boolean[3];
        this.userProtections = new boolean[3];
        this.groupProtections = new boolean[3];
        this.worldProtections = new boolean[3];
        int n = 1;
        while (n < 10) {
            if (this.protections.charAt(n) != '-') {
                switch ((n - 1) % 3) {
                    case 0: {
                        this.isReadable[(n - 1) / 3] = true;
                    }
                    case 1: {
                        this.isWriteable[(n - 1) / 3] = true;
                    }
                    case 2: {
                        this.isExecutable[(n - 1) / 3] = true;
                    }
                }
                switch ((n - 1) / 3) {
                    case 0: {
                        this.userProtections[(n - 1) % 3] = true;
                    }
                    case 1: {
                        this.groupProtections[(n - 1) % 3] = true;
                    }
                    case 2: {
                        this.worldProtections[(n - 1) % 3] = true;
                    }
                }
            }
            ++n;
        }
        this.symbolicLinks = Integer.parseInt(stringTokenizer.nextToken());
        this.owner = stringTokenizer.nextToken();
        this.ownersGroup = stringTokenizer.nextToken();
        this.length = Long.parseLong(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken().toLowerCase();
        int n2 = 0;
        if (string2.equals("feb")) {
            n2 = 1;
        } else if (string2.equals("mar")) {
            n2 = 2;
        } else if (string2.equals("apr")) {
            n2 = 3;
        } else if (string2.equals("may")) {
            n2 = 4;
        } else if (string2.equals("jun")) {
            n2 = 5;
        } else if (string2.equals("jul")) {
            n2 = 6;
        } else if (string2.equals("aug")) {
            n2 = 7;
        } else if (string2.equals("sep")) {
            n2 = 8;
        } else if (string2.equals("oct")) {
            n2 = 9;
        } else if (string2.equals("nov")) {
            n2 = 10;
        } else if (string2.equals("dec")) {
            n2 = 11;
        }
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        String string3 = stringTokenizer.nextToken();
        GregorianCalendar gregorianCalendar = null;
        if (string3.indexOf(":") == -1) {
            int n4 = Integer.parseInt(string3);
            gregorianCalendar = new GregorianCalendar(n4, n2, n3, 0, 0, 0);
        } else {
            int n5 = Integer.parseInt(string3.substring(0, string3.indexOf(":")));
            int n6 = Integer.parseInt(string3.substring(string3.indexOf(":") + 1, string3.length()));
            new GregorianCalendar();
            gregorianCalendar = new GregorianCalendar(1, n2, n3, n5, n6, 0);
        }
        this.lastModified = gregorianCalendar.getTime().getTime();
        this.fileName = stringTokenizer.nextToken();
    }

    public boolean[] canRead() {
        return this.isReadable;
    }

    public boolean[] canWrite() {
        return this.isWriteable;
    }

    public boolean[] canExecute() {
        return this.isExecutable;
    }

    public boolean[] getUserProtections() {
        return this.userProtections;
    }

    public boolean[] getGroupProtections() {
        return this.groupProtections;
    }

    public boolean[] getWorldProtections() {
        return this.worldProtections;
    }

    public String getProtections() {
        return this.protections;
    }

    public String getName() {
        return this.fileName;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.length;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnersGroup() {
        return this.ownersGroup;
    }

    public int getSymbolicLinks() {
        return this.symbolicLinks;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

