/*
 * Decompiled with CFR 0.152.
 */
package kasper.io;

import java.io.IOException;
import java.io.Writer;

public class EBCDICWriter
extends Writer {
    protected Writer output;
    public static final int[] translationArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 110, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, -1, 224, -1, -1, 109, 121, 129, 130, 131, 132, 133, 134, 135, 136, 137, 145, 146, 147, 148, 149, 150, 151, 152, 153, 162, 163, 164, 165, 166, 167, 168, 169, 192, 79, 208, 161, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 255};

    public EBCDICWriter(Writer writer) {
        this.output = writer;
    }

    public void write(int n) throws IOException {
        try {
            int n2 = translationArray[n];
            if (n2 == -1) {
                throw new IOException("Attempted to write the character '" + (char)n + "' " + "which is not supported in the EBCDIC character set.");
            }
            this.output.write(translationArray[n]);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.output.write(-1);
            return;
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        char[] cArray2 = new char[n2];
        int n4 = n;
        try {
            while (n4 < n3) {
                if (translationArray[cArray[n4]] == -1) {
                    throw new IOException("Attempted to write the character '" + cArray[n4] + "' " + "which is not supported in the EBCDIC character set.");
                }
                cArray2[n4 - n] = (char)translationArray[cArray[n4]];
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        this.output.write(cArray2);
    }

    public void write(String string) throws IOException {
        this.write(string.toCharArray(), 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void close() throws IOException {
        this.output.close();
    }
}

