/*
 * Decompiled with CFR 0.152.
 */
package kasper.io;

import java.io.IOException;
import java.io.Reader;

public class EBCDICReader
extends Reader {
    protected boolean endOfStream = false;
    protected boolean passedEOS = true;
    protected Reader input;
    public static final int[] translationArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, 162, 46, 60, 40, 43, 124, 38, -1, -1, -1, -1, -1, -1, -1, -1, -1, 33, 36, 42, 41, 59, 172, 45, 47, -1, -1, -1, -1, -1, -1, -1, -1, 166, 44, 37, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, 96, 58, 35, 64, 39, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, 126, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, 125, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, 92, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, 255};

    public EBCDICReader(Reader reader) {
        this.input = reader;
    }

    public int read() throws IOException {
        if (this.endOfStream && this.passedEOS) {
            this.passedEOS = false;
            return -1;
        }
        int n = this.input.read();
        try {
            if (translationArray[n] == -1) {
                throw new IOException("Attempted to read the character '" + (char)n + "' " + "which is not supported in the EBCDIC character set.");
            }
            return translationArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.endOfStream = true;
            return -1;
        }
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.endOfStream && this.passedEOS) {
            this.passedEOS = false;
            return -1;
        }
        int n3 = 0;
        int n4 = n + n2;
        int n5 = n;
        try {
            while (n5 < n4) {
                int n6 = this.input.read();
                if (translationArray[n6] == -1) {
                    throw new IOException("Attempted to read the character '" + (char)n6 + "' " + "which is not supported in the EBCDIC character set.");
                }
                cArray[n5] = (char)translationArray[n6];
                ++n5;
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.endOfStream = true;
        }
        return n3;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

