/*
 * Decompiled with CFR 0.152.
 */
package kasper.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ImageCanvas
extends Canvas
implements Cloneable {
    protected Dimension minSize;
    protected Image displayImage;
    protected boolean errors = false;

    public ImageCanvas(Image image) throws InterruptedException {
        this.displayImage = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        mediaTracker.waitForAll();
        this.errors = mediaTracker.isErrorAny();
        this.minSize = new Dimension(image.getWidth(this), image.getHeight(this));
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.displayImage, 0, 0, this);
    }

    public Dimension getMinimumSize() {
        return this.minSize;
    }

    public Dimension getPreferredSize() {
        return this.minSize;
    }

    public boolean isError() {
        return this.errors;
    }
}

