/*
 * Decompiled with CFR 0.152.
 */
package anon;

import HTTPClient.Codecs;
import anon.JAPASymCipher;
import anon.JAPAnonChannel;
import anon.JAPAnonService;
import anon.JAPDummyTraffic;
import anon.JAPKeyPool;
import anon.JAPSocket;
import anon.JAPSymCipher;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

final class JAPMuxSocket
implements Runnable {
    private int lastChannelId = 0;
    private Dictionary oSocketList = new Hashtable();
    private DataOutputStream m_outDataStream;
    private DataInputStream m_inDataStream;
    private Socket m_ioSocket;
    private static final int FIREWALL_METHOD_HTTP_1_1 = 11;
    private static final int FIREWALL_METHOD_HTTP_1_0 = 10;
    private static final int[] FIREWALL_METHODS = new int[]{11, 10};
    private byte[] outBuff = new byte[992];
    private JAPASymCipher[] m_arASymCipher = null;
    private JAPKeyPool keypool = JAPKeyPool.start();
    private int chainlen;
    private volatile boolean m_bRunFlag;
    private boolean m_bIsConnected = false;
    private static final String CRLF = "\r\n";
    public static final int KEY_SIZE = 16;
    public static final int DATA_SIZE = 992;
    public static final int PAYLOAD_SIZE = 989;
    private static final int RSA_SIZE = 128;
    private static final short CHANNEL_DATA = 0;
    private static final short CHANNEL_CLOSE = 1;
    private static final short CHANNEL_OPEN = 8;
    public static final int E_ALREADY_CONNECTED = -8;
    public static final int E_NOT_CONNECTED = -9;
    private static JAPMuxSocket ms_MuxSocket = null;
    private int m_RunCount = 0;
    private Thread threadRunLoop = null;
    private long m_TimeLastPacketSend = 0L;
    private static boolean m_bDummyTraffic = false;
    private JAPDummyTraffic m_DummyTraffic = null;

    private JAPMuxSocket() {
        m_bDummyTraffic = false;
        this.m_TimeLastPacketSend = 0L;
    }

    public static JAPMuxSocket create() {
        if (ms_MuxSocket == null) {
            ms_MuxSocket = new JAPMuxSocket();
        }
        return ms_MuxSocket;
    }

    public static boolean isConnected() {
        return ms_MuxSocket != null && JAPMuxSocket.ms_MuxSocket.m_bIsConnected;
    }

    public static void setEnableDummyTraffic(boolean bl) {
        if (bl == m_bDummyTraffic) {
            return;
        }
        if (JAPMuxSocket.isConnected()) {
            if (bl) {
                JAPMuxSocket.ms_MuxSocket.m_DummyTraffic = new JAPDummyTraffic(ms_MuxSocket);
                JAPMuxSocket.ms_MuxSocket.m_DummyTraffic.start();
            } else {
                JAPMuxSocket.ms_MuxSocket.m_DummyTraffic.stop();
                JAPMuxSocket.ms_MuxSocket.m_DummyTraffic = null;
            }
        }
        m_bDummyTraffic = bl;
    }

    public static boolean getEnableDummyTraffic() {
        return m_bDummyTraffic;
    }

    public int connect(String string, int n) {
        return this.connectViaFirewall(string, n, null, -1, null, null);
    }

    private void sendHTTPProxyCommands(int n, Writer writer, String string, int n2, String string2, String string3) throws Exception {
        if (n == 11) {
            writer.write("CONNECT " + string + ":" + Integer.toString(n2) + " HTTP/1.1" + CRLF);
        } else {
            writer.write("CONNECT " + string + ":" + Integer.toString(n2) + " HTTP/1.0" + CRLF);
        }
        if (string2 != null && string3 != null) {
            String string4 = Codecs.base64Encode(string2 + ":" + string3);
            writer.write("Proxy-Authorization: Basic " + string4 + CRLF);
        }
        writer.write("Connection: Keep-Alive\r\n");
        writer.write("Keep-Alive: max=20, timeout=100\r\n");
        writer.write("Proxy-Connection: Keep-Alive\r\n");
        writer.write(CRLF);
        writer.flush();
    }

    public int connectViaFirewall(String string, int n, String string2, int n2, String string3, String string4) {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            int n3;
            Object object;
            Object object2;
            if (this.m_bIsConnected) {
                int n4 = -8;
                return n4;
            }
            if (string2 == null) {
                try {
                    JAPDebug.out(7, 2, "JAPMuxSocket:Try to connect directly to mix (" + string + ":" + n + ")");
                    this.m_ioSocket = new Socket(string, n);
                    this.m_ioSocket.setSoTimeout(10000);
                    this.m_inDataStream = new DataInputStream(this.m_ioSocket.getInputStream());
                    this.m_bIsConnected = true;
                }
                catch (Exception exception) {
                    this.m_bIsConnected = false;
                }
            } else {
                int n5 = 0;
                while (n5 < FIREWALL_METHODS.length) {
                    try {
                        JAPDebug.out(7, 2, "JAPMuxSocket:Try to connect via proxy (" + string2 + ":" + n2 + ") to mix (" + string + ":" + n + ")");
                        this.m_ioSocket = new Socket(string2, n2);
                        this.m_ioSocket.setSoTimeout(10000);
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.m_ioSocket.getOutputStream()));
                        this.m_inDataStream = new DataInputStream(this.m_ioSocket.getInputStream());
                        this.sendHTTPProxyCommands(FIREWALL_METHODS[n5], bufferedWriter, string, n, string3, string4);
                        object2 = null;
                        try {
                            object2 = this.readLine(this.m_inDataStream);
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            this.m_bIsConnected = false;
                            break;
                        }
                        catch (Exception exception) {
                            JAPDebug.out(2, 2, "JAPMuxSocket:Exception while reading response from proxy server: " + exception);
                            this.m_bIsConnected = false;
                            break;
                        }
                        JAPDebug.out(7, 2, "JAPMuxSocket:Response from firewall is <" + (String)object2 + ">");
                        JAPDebug.out(7, 2, "JAPMuxSocket:Reading remainig headers...");
                        object = null;
                        do {
                            object = this.readLine(this.m_inDataStream);
                            JAPDebug.out(7, 2, "JAPMuxSocket: <" + (String)object + ">");
                        } while (object != null && ((String)object).length() != 0);
                        if (((String)object2).indexOf("200") != -1) {
                            this.m_bIsConnected = true;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n5;
                }
            }
            if (!this.m_bIsConnected) {
                JAPDebug.out(7, 2, "JAPMuxSocket:Something goes wrong by trying to connect to Mix!");
                try {
                    this.m_inDataStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_ioSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_inDataStream = null;
                this.m_ioSocket = null;
                int n6 = -1;
                return n6;
            }
            JAPDebug.out(7, 2, "JAPMuxSocket:Connected to Mix! Now starting key exchange...");
            try {
                this.m_outDataStream = new DataOutputStream(new BufferedOutputStream(this.m_ioSocket.getOutputStream(), 998));
                JAPDebug.out(7, 2, "JAPMuxSocket:Reading len...");
                this.m_inDataStream.readUnsignedShort();
                JAPDebug.out(7, 2, "JAPMuxSocket:Reading chainlen...");
                this.chainlen = this.m_inDataStream.readByte();
                JAPDebug.out(7, 2, "JAPMuxSocket:chainlen=" + this.chainlen);
                this.m_arASymCipher = new JAPASymCipher[this.chainlen];
                n3 = this.chainlen - 1;
                while (n3 >= 0) {
                    this.m_arASymCipher[n3] = new JAPASymCipher();
                    int n7 = this.m_inDataStream.readUnsignedShort();
                    object2 = new byte[n7];
                    this.m_inDataStream.readFully((byte[])object2);
                    object = new BigInteger(1, (byte[])object2);
                    n7 = this.m_inDataStream.readUnsignedShort();
                    object2 = new byte[n7];
                    this.m_inDataStream.readFully((byte[])object2);
                    BigInteger bigInteger = new BigInteger(1, (byte[])object2);
                    this.m_arASymCipher[n3].setPublicKey((BigInteger)object, bigInteger);
                    --n3;
                }
                this.m_ioSocket.setSoTimeout(0);
            }
            catch (Exception exception) {
                JAPDebug.out(2, 2, "JAPMuxSocket:Exception during connection: " + exception);
                this.m_arASymCipher = null;
                try {
                    this.m_inDataStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    this.m_outDataStream.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    this.m_ioSocket.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                this.m_inDataStream = null;
                this.m_outDataStream = null;
                this.m_ioSocket = null;
                this.m_bIsConnected = false;
                int n8 = -1;
                return n8;
            }
            this.m_bIsConnected = true;
            JAPMuxSocket.setEnableDummyTraffic(m_bDummyTraffic);
            n3 = 0;
            return n3;
        }
    }

    private String readLine(DataInputStream dataInputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = dataInputStream.read();
        while (n != 10 && n != -1) {
            if (n != 13) {
                stringBuffer.append((char)n);
            }
            n = dataInputStream.read();
        }
        return stringBuffer.toString();
    }

    public int newConnection(JAPSocket jAPSocket, int n) throws ConnectException {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            if (this.m_bIsConnected) {
                try {
                    JAPAnonChannel jAPAnonChannel = new JAPAnonChannel(jAPSocket, this.lastChannelId, n, this);
                    this.oSocketList.put(new Integer(this.lastChannelId), new SocketListEntry(jAPSocket));
                    JAPAnonService.setNrOfChannels(this.oSocketList.size());
                    Thread thread = new Thread(jAPAnonChannel);
                    thread.start();
                    ++this.lastChannelId;
                    int n2 = 0;
                    return n2;
                }
                catch (Exception exception) {
                    throw new ConnectException("Error trying open a new channel!");
                }
            }
            throw new ConnectException("Lost connection to mix or not connected to a mix!");
        }
    }

    public int close(int n) {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            this.oSocketList.remove(new Integer(n));
            this.send(n, 0, null, (short)0);
            JAPAnonService.setNrOfChannels(this.oSocketList.size());
            int n2 = 0;
            return n2;
        }
    }

    private int close() {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            if (!this.m_bIsConnected) {
                int n = -9;
                return n;
            }
            if (m_bDummyTraffic) {
                this.m_DummyTraffic.stop();
                this.m_DummyTraffic = null;
            }
            JAPDebug.out(7, 2, "JAPMuxSocket:close() Closing MuxSocket...");
            this.m_bRunFlag = false;
            try {
                this.threadRunLoop.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.threadRunLoop.isAlive()) {
                JAPDebug.out(7, 2, "JAPMuxSocket:close() Closing MuxSocket harder...");
                try {
                    this.m_inDataStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.threadRunLoop.join(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.threadRunLoop.isAlive()) {
                    JAPDebug.out(7, 2, "JAPMuxSocket:close() Hm...MuxSocket is still alive...");
                    this.threadRunLoop.stop();
                    this.runStoped();
                }
            }
            this.threadRunLoop = null;
            JAPDebug.out(7, 2, "JAPMuxSocket:close() MuxSocket closed!");
            int n = 0;
            return n;
        }
    }

    public int startService() {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            if (!this.m_bIsConnected) {
                int n = -1;
                return n;
            }
            if (this.m_RunCount == 0) {
                this.threadRunLoop = new Thread(this);
                this.threadRunLoop.setPriority(10);
                this.threadRunLoop.start();
            }
            ++this.m_RunCount;
            int n = this.m_RunCount;
            return n;
        }
    }

    public int stopService() {
        JAPMuxSocket jAPMuxSocket = this;
        synchronized (jAPMuxSocket) {
            JAPDebug.out(7, 2, "JAPMuxSocket:stopService()");
            --this.m_RunCount;
            if (this.m_RunCount == 0) {
                this.close();
            }
            int n = this.m_RunCount;
            return n;
        }
    }

    private void runStoped() {
        JAPDebug.out(7, 2, "JAPMuxSocket:runStoped()");
        Enumeration enumeration = this.oSocketList.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            SocketListEntry socketListEntry = (SocketListEntry)this.oSocketList.get(n);
            this.close(n);
            try {
                socketListEntry.inSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.oSocketList.remove(n);
        }
        JAPDebug.out(7, 2, "JAPMuxSocket:MuxSocket all channels closed...");
        this.m_bRunFlag = false;
        this.m_bIsConnected = false;
        try {
            this.m_inDataStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_outDataStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_ioSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JAPDebug.out(7, 2, "JAPMuxSocket:MuxSocket socket closed...");
        this.m_inDataStream = null;
        this.m_outDataStream = null;
        this.m_ioSocket = null;
        JAPDebug.out(7, 2, "JAPMuxSocket:Updating View...");
        JAPAnonService.setNrOfChannels(this.oSocketList.size());
        JAPDebug.out(7, 2, "JAPMuxSocket:All done..");
    }

    public void run() {
        JAPDebug.out(7, 2, "JAPMuxSocket:run()");
        byte[] byArray = new byte[992];
        short s = 0;
        int n = 0;
        int n2 = 0;
        this.m_bRunFlag = true;
        while (this.m_bRunFlag) {
            try {
                n = this.m_inDataStream.readInt();
                s = this.m_inDataStream.readShort();
                this.m_inDataStream.readFully(byArray);
            }
            catch (Exception exception) {
                JAPDebug.out(3, 2, "JAPMuxSocket:run() Exception while receiving!");
                break;
            }
            SocketListEntry socketListEntry = (SocketListEntry)this.oSocketList.get(new Integer(n));
            if (socketListEntry == null) continue;
            if (s == 1) {
                this.oSocketList.remove(new Integer(n));
                JAPAnonService.setNrOfChannels(this.oSocketList.size());
                try {
                    socketListEntry.outStream.close();
                    socketListEntry.inSocket.close();
                }
                catch (Exception exception) {}
                continue;
            }
            if (s != 0) continue;
            int n3 = 0;
            while (n3 < this.chainlen) {
                socketListEntry.arCipher[n3].encryptAES2(byArray);
                ++n3;
            }
            n2 = byArray[0] << 8 | byArray[1] & 0xFF;
            if ((n2 &= 0xFFFF) < 0 || n2 > 992) {
                JAPDebug.out(7, 2, "JAPMuxSocket:Receveived MuxPacket with invalid data size: " + Integer.toString(n2));
                continue;
            }
            int n4 = 0;
            while (n4 < 3) {
                try {
                    socketListEntry.outStream.write(byArray, 3, n2);
                    break;
                }
                catch (Exception exception) {
                    JAPDebug.out(7, 2, "JAPMuxSocket:Fehler bei write to browser...retrying..." + exception.toString());
                    ++n4;
                }
            }
            try {
                socketListEntry.outStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JAPAnonService.increaseNrOfBytes(n2);
        }
        this.runStoped();
        JAPDebug.out(7, 2, "JAPMuxSocket:MuxSocket thread run exited...");
    }

    public synchronized int send(int n, int n2, byte[] byArray, short s) {
        try {
            if (!this.m_bIsConnected) {
                return -9;
            }
            int n3 = 0;
            this.m_TimeLastPacketSend = System.currentTimeMillis();
            if (byArray == null && s == 0) {
                this.m_outDataStream.writeInt(n);
                this.m_outDataStream.writeShort(1);
                this.m_outDataStream.write(this.outBuff);
                this.m_outDataStream.flush();
                return 0;
            }
            if (byArray == null) {
                return -1;
            }
            if (s == 0) {
                return 0;
            }
            SocketListEntry socketListEntry = (SocketListEntry)this.oSocketList.get(new Integer(n));
            if (socketListEntry != null && socketListEntry.arCipher == null) {
                int n4 = 973;
                socketListEntry.arCipher = new JAPSymCipher[this.chainlen];
                socketListEntry.arCipher[this.chainlen - 1] = new JAPSymCipher();
                JAPKeyPool.getKey(this.outBuff);
                this.outBuff[0] = (byte)(this.outBuff[0] & 0x7F);
                this.outBuff[16] = (byte)(s >> 8);
                this.outBuff[17] = (byte)(s % 256);
                this.outBuff[18] = n2 == 2 ? (byte)1 : 0;
                System.arraycopy(byArray, 0, this.outBuff, 19, n4);
                socketListEntry.arCipher[this.chainlen - 1].setEncryptionKeyAES(this.outBuff);
                this.m_arASymCipher[this.chainlen - 1].encrypt(this.outBuff, 0, byArray, 0);
                socketListEntry.arCipher[this.chainlen - 1].encryptAES(this.outBuff, 128, byArray, 128, 864);
                n4 -= 16;
                int n5 = this.chainlen - 2;
                while (n5 >= 0) {
                    socketListEntry.arCipher[n5] = new JAPSymCipher();
                    JAPKeyPool.getKey(this.outBuff);
                    this.outBuff[0] = (byte)(this.outBuff[0] & 0x7F);
                    socketListEntry.arCipher[n5].setEncryptionKeyAES(this.outBuff);
                    System.arraycopy(byArray, 0, this.outBuff, 16, n4);
                    this.m_arASymCipher[n5].encrypt(this.outBuff, 0, byArray, 0);
                    socketListEntry.arCipher[n5].encryptAES(this.outBuff, 128, byArray, 128, 864);
                    n4 -= 16;
                    --n5;
                }
                n3 = 8;
            } else {
                System.arraycopy(byArray, 0, this.outBuff, 3, s);
                this.outBuff[2] = 0;
                this.outBuff[0] = (byte)(s >> 8);
                this.outBuff[1] = (byte)(s % 256);
                int n6 = this.chainlen - 1;
                while (n6 > 0) {
                    socketListEntry.arCipher[n6].encryptAES(this.outBuff);
                    --n6;
                }
                socketListEntry.arCipher[0].encryptAES(this.outBuff, 0, byArray, 0, 992);
            }
            this.m_outDataStream.writeInt(n);
            this.m_outDataStream.writeShort(n3);
            this.m_outDataStream.write(byArray, 0, 992);
            this.m_outDataStream.flush();
            JAPAnonService.increaseNrOfBytes(s);
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPMuxSocket:send() Exception!");
            return -1;
        }
        return 0;
    }

    public final int getChainLen() {
        return this.chainlen;
    }

    public long getTimeLastPacketSend() {
        return this.m_TimeLastPacketSend;
    }

    private final class SocketListEntry {
        public final JAPSocket inSocket;
        public final OutputStream outStream;
        public JAPSymCipher[] arCipher;
        public boolean bIsSuspended;

        SocketListEntry(JAPSocket jAPSocket) throws Exception {
            this.inSocket = jAPSocket;
            try {
                this.outStream = jAPSocket.getOutputStream();
                this.arCipher = null;
                this.bIsSuspended = false;
            }
            catch (Exception exception) {
                JAPDebug.out(3, 2, "JAPMuxSocket:SocketListEntry() oops");
                throw exception;
            }
        }
    }
}

