/*
 * Decompiled with CFR 0.152.
 */
package anon;

import java.security.SecureRandom;

final class JAPKeyPool
implements Runnable {
    private SecureRandom sr;
    private int aktSize;
    private KeyList pool;
    private KeyList aktKey;
    private int keySize;
    private int poolSize;
    private Object l1;
    private Object l2;
    private boolean runflag;
    private static JAPKeyPool m_KeyPool = null;
    private Thread m_KeyPoolThread = null;

    private JAPKeyPool(int n, int n2) {
        this.keySize = n2;
        this.poolSize = n;
        this.pool = null;
        this.aktKey = null;
        this.l1 = new Object();
        this.l2 = new Object();
        this.m_KeyPoolThread = new Thread(this);
        this.m_KeyPoolThread.setPriority(1);
        this.m_KeyPoolThread.start();
    }

    public static synchronized JAPKeyPool start() {
        if (m_KeyPool == null) {
            m_KeyPool = new JAPKeyPool(20, 16);
        }
        return m_KeyPool;
    }

    public void run() {
        KeyList keyList;
        byte[] byArray = null;
        try {
            byArray = SecureRandom.getSeed(20);
            this.sr = new SecureRandom(byArray);
        }
        catch (Throwable throwable) {
            this.sr = new SecureRandom();
        }
        byArray = null;
        this.pool = new KeyList(this.keySize);
        int n = 1;
        while (n < this.poolSize) {
            keyList = new KeyList(this.keySize);
            keyList.next = this.pool;
            this.pool = keyList;
            ++n;
        }
        this.aktKey = null;
        this.runflag = true;
        while (this.runflag) {
            Object object;
            JAPDebug.out(7, 8, "JAPKeyPool:run() loop");
            if (this.pool != null) {
                object = this;
                synchronized (object) {
                    this.sr.nextBytes(this.pool.key);
                    keyList = this.pool;
                    this.pool = this.pool.next;
                    keyList.next = this.aktKey;
                    this.aktKey = keyList;
                    Object object2 = this.l2;
                    synchronized (object2) {
                        this.l2.notify();
                    }
                }
            }
            try {
                object = this.l1;
                synchronized (object) {
                    this.l1.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                JAPDebug.out(7, 8, "JAPKeyPool:run() waiting interrupted!");
            }
        }
    }

    public static void getKey(byte[] byArray) {
        Object object;
        Object object2;
        JAPDebug.out(7, 8, "JAPKeyPool:getKey()");
        if (JAPKeyPool.m_KeyPool.aktKey == null) {
            try {
                object2 = JAPKeyPool.m_KeyPool.l2;
                synchronized (object2) {
                    JAPKeyPool.m_KeyPool.l2.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                JAPDebug.out(7, 8, "JAPKeyPool:getKey() waiting interrupted!");
            }
        }
        object2 = m_KeyPool;
        synchronized (object2) {
            System.arraycopy(JAPKeyPool.m_KeyPool.aktKey.key, 0, byArray, 0, JAPKeyPool.m_KeyPool.keySize);
            object = JAPKeyPool.m_KeyPool.aktKey;
            JAPKeyPool.m_KeyPool.aktKey = JAPKeyPool.m_KeyPool.aktKey.next;
            ((KeyList)object).next = JAPKeyPool.m_KeyPool.pool;
            JAPKeyPool.m_KeyPool.pool = object;
        }
        object = JAPKeyPool.m_KeyPool.l1;
        synchronized (object) {
            JAPKeyPool.m_KeyPool.l1.notify();
        }
    }

    private final class KeyList {
        public byte[] key;
        public KeyList next;

        public KeyList(int n) {
            this.key = new byte[n];
            this.next = null;
        }
    }
}

