/*
 * Decompiled with CFR 0.152.
 */
package anon;

import anon.JAPAnonServiceListener;
import anon.JAPKeyPool;
import anon.JAPMuxSocket;
import anon.JAPSocket;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public final class JAPAnonService
implements Runnable {
    public static final int E_SUCCESS = 0;
    public static final int E_RUNNING = -6;
    public static final int E_INVALID_PROTOCOL = -5;
    public static final int E_INVALID_PORT = -7;
    public static final int E_BIND = -8;
    public static final int E_CONNECT = -10;
    public static final int PROTO_HTTP = 1;
    public static final int PROTO_SOCKS = 2;
    private int m_Port = -1;
    private int m_Protocol = -1;
    private boolean m_bBindToLocalHostOnly = true;
    private volatile boolean m_bIsRunning = false;
    private static String m_AnonHostName = null;
    private static int m_AnonHostPort = -1;
    private String m_FirewallHost = null;
    private int m_FirewallPort = -1;
    private boolean m_connectViaFirewall = false;
    private boolean m_bUseFirewallAuthentication = false;
    private String m_FirewallAuthenticationUserID = null;
    private String m_FirewallAuthenticationPasswd = null;
    private Thread m_threadRunLoop = null;
    private ServerSocket m_socketListener = null;
    private boolean m_bDontChangeListener = false;
    private JAPMuxSocket m_MuxSocket = null;
    private static JAPAnonServiceListener m_AnonServiceListener = null;

    public JAPAnonService() {
    }

    public JAPAnonService(int n) {
        this();
        this.setPort(n);
    }

    public JAPAnonService(int n, int n2) {
        this();
        this.setService(n, n2);
    }

    public JAPAnonService(int n, int n2, boolean bl) {
        this();
        this.setService(n, n2, bl);
    }

    public JAPAnonService(ServerSocket serverSocket, int n) {
        this();
        this.setService(serverSocket, n);
    }

    public int setService(int n, int n2) {
        this.setPort(n);
        return this.setProtocol(n2);
    }

    public int setService(ServerSocket serverSocket, int n) {
        if (serverSocket == null) {
            return -1;
        }
        this.setPort(serverSocket.getLocalPort());
        this.m_socketListener = serverSocket;
        this.m_bDontChangeListener = true;
        return this.setProtocol(n);
    }

    public int setService(int n, int n2, boolean bl) {
        this.setPort(n, bl);
        return this.setProtocol(n2);
    }

    public int setPort(int n) {
        this.m_Port = n;
        return 0;
    }

    public int setPort(int n, boolean bl) {
        this.m_Port = n;
        this.m_bBindToLocalHostOnly = bl;
        return 0;
    }

    public int setProtocol(int n) {
        this.m_Protocol = n;
        return 0;
    }

    public static int setAnonService(String string, int n) {
        if (JAPMuxSocket.isConnected()) {
            return -10;
        }
        m_AnonHostName = string;
        m_AnonHostPort = n;
        return 0;
    }

    public int setAnonServiceListener(JAPAnonServiceListener jAPAnonServiceListener) {
        m_AnonServiceListener = jAPAnonServiceListener;
        return 0;
    }

    public int setFirewall(String string, int n) {
        this.m_FirewallHost = string;
        this.m_FirewallPort = n;
        return 0;
    }

    public int setFirewallAuthorization(String string, String string2) {
        this.m_FirewallAuthenticationUserID = string;
        this.m_FirewallAuthenticationPasswd = string2;
        this.m_bUseFirewallAuthentication = string != null;
        return 0;
    }

    public int connectViaFirewall(boolean bl) {
        this.m_connectViaFirewall = bl;
        return 0;
    }

    public static void setEnableDummyTraffic(boolean bl) {
        JAPMuxSocket.setEnableDummyTraffic(bl);
    }

    public static boolean getEnableDummyTraffic() {
        return JAPMuxSocket.getEnableDummyTraffic();
    }

    public static void init() {
        JAPKeyPool.start();
    }

    public int start() {
        int n;
        if (this.m_bIsRunning) {
            return -6;
        }
        if (this.m_Port < 0 || this.m_Port > 65535) {
            return -7;
        }
        if (this.m_Protocol != 1 && this.m_Protocol != 2) {
            return -5;
        }
        if (!this.m_bDontChangeListener) {
            n = 0;
            int n2 = 0;
            while (n2 < 10) {
                try {
                    if (this.m_bBindToLocalHostOnly) {
                        InetAddress[] inetAddressArray = InetAddress.getAllByName("127.0.0.1");
                        JAPDebug.out(7, 2, "Try binding Listener on localhost: " + inetAddressArray[0]);
                        this.m_socketListener = new ServerSocket(this.m_Port, 50, inetAddressArray[0]);
                    } else {
                        this.m_socketListener = new ServerSocket(this.m_Port);
                    }
                    JAPDebug.out(6, 2, "JAPProxyServer:Listener on port " + this.m_Port + " started.");
                    n = 1;
                    break;
                }
                catch (Exception exception) {
                    JAPDebug.out(7, 2, "Exception: " + exception.getMessage());
                    this.m_socketListener = null;
                    ++n2;
                }
            }
            if (n == 0) {
                return -8;
            }
        }
        JAPDebug.out(7, 2, "JAPProxyServer:Mux starting...");
        this.m_MuxSocket = JAPMuxSocket.create();
        n = -1;
        n = this.m_connectViaFirewall ? this.m_MuxSocket.connectViaFirewall(m_AnonHostName, m_AnonHostPort, this.m_FirewallHost, this.m_FirewallPort, this.m_FirewallAuthenticationUserID, this.m_FirewallAuthenticationPasswd) : this.m_MuxSocket.connect(m_AnonHostName, m_AnonHostPort);
        if (n == -1) {
            if (!this.m_bDontChangeListener) {
                try {
                    this.m_socketListener.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_socketListener = null;
            }
            this.m_MuxSocket = null;
            return -10;
        }
        JAPDebug.out(7, 2, "JAPProxyServer:Mux connected!");
        this.m_MuxSocket.startService();
        this.m_threadRunLoop = new Thread(this);
        this.m_threadRunLoop.start();
        return 0;
    }

    public int stop() {
        try {
            JAPDebug.out(7, 2, "JAPAnonService: stopping...");
            this.m_bIsRunning = false;
            if (!this.m_bDontChangeListener) {
                try {
                    this.m_socketListener.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_socketListener = null;
            }
            JAPDebug.out(7, 2, "JAPAnonService: wait for joining...");
            this.m_threadRunLoop.join(10000L);
            if (this.m_threadRunLoop.isAlive()) {
                JAPDebug.out(7, 2, "JAPAnonService: Still alvie - so stopping harder...");
                try {
                    this.m_threadRunLoop.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_threadRunLoop.join(3000L);
            }
            this.m_threadRunLoop = null;
        }
        catch (Exception exception) {
            JAPDebug.out(7, 2, "Exception: " + exception.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.m_bIsRunning = true;
        try {
            while (this.m_bIsRunning) {
                Socket socket = null;
                try {
                    socket = this.m_socketListener.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                try {
                    socket.setSoTimeout(0);
                }
                catch (SocketException socketException) {
                    socket = null;
                    JAPDebug.out(3, 2, "JAPAnonService.run() Could not set non-Blocking mode for Channel-Socket! Exception: " + socketException);
                    continue;
                }
                try {
                    this.m_MuxSocket.newConnection(new JAPSocket(socket), this.m_Protocol);
                }
                catch (Exception exception) {
                    JAPDebug.out(3, 2, "JAPAnonService.run() Exception: " + exception);
                }
            }
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPProxyServer:ProxyServer.run1() Exception: " + exception);
        }
        JAPDebug.out(6, 2, "JAPProxyServer:ProxyServer on port " + this.m_Port + " stopped.");
        this.m_bIsRunning = false;
        this.m_MuxSocket.stopService();
        this.m_MuxSocket = null;
        if (!this.m_bDontChangeListener) {
            try {
                this.m_socketListener.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socketListener = null;
        }
    }

    protected static void setNrOfChannels(int n) {
        JAPDebug.out(7, 2, "Notify channel listeners");
        if (m_AnonServiceListener != null) {
            m_AnonServiceListener.channelsChanged(n);
        }
        JAPDebug.out(7, 2, "End Notify channel listeners");
    }

    protected static void increaseNrOfBytes(int n) {
        if (m_AnonServiceListener != null) {
            m_AnonServiceListener.transferedBytes(n);
        }
    }
}

