/*
 * Decompiled with CFR 0.152.
 */
package Rijndael;

import java.security.InvalidKeyException;

public final class Rijndael_Algorithm {
    static final int BLOCK_SIZE = 16;
    static final int[] alog;
    static final int[] log;
    static final byte[] S;
    static final byte[] Si;
    static final int[] T1;
    static final int[] T2;
    static final int[] T3;
    static final int[] T4;
    static final int[] T5;
    static final int[] T6;
    static final int[] T7;
    static final int[] T8;
    static final int[] U1;
    static final int[] U2;
    static final int[] U3;
    static final int[] U4;
    static final byte[] rcon;
    static final int[][][] shifts;

    static final int mul(int n, int n2) {
        return n != 0 && n2 != 0 ? alog[(log[n & 0xFF] + log[n2 & 0xFF]) % 255] : 0;
    }

    static final int mul4(int n, byte[] byArray) {
        if (n == 0) {
            return 0;
        }
        n = log[n & 0xFF];
        int n2 = byArray[0] != 0 ? alog[(n + log[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n3 = byArray[1] != 0 ? alog[(n + log[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[2] != 0 ? alog[(n + log[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[3] != 0 ? alog[(n + log[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static Object makeKey(byte[] byArray) throws InvalidKeyException {
        return Rijndael_Algorithm.makeKey(byArray, 16, 16);
    }

    public static void blockEncrypt(byte[] byArray, byte[] byArray2, Object object) {
        int[][] nArray = (int[][])((Object[])object)[0];
        int[] nArray2 = nArray[0];
        int n = ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) ^ nArray2[0];
        int n2 = ((byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF) ^ nArray2[1];
        int n3 = ((byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF) ^ nArray2[2];
        int n4 = ((byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF) ^ nArray2[3];
        int n5 = 1;
        while (n5 < 10) {
            nArray2 = nArray[n5];
            int n6 = T1[n >>> 24 & 0xFF] ^ T2[n2 >>> 16 & 0xFF] ^ T3[n3 >>> 8 & 0xFF] ^ T4[n4 & 0xFF] ^ nArray2[0];
            int n7 = T1[n2 >>> 24 & 0xFF] ^ T2[n3 >>> 16 & 0xFF] ^ T3[n4 >>> 8 & 0xFF] ^ T4[n & 0xFF] ^ nArray2[1];
            int n8 = T1[n3 >>> 24 & 0xFF] ^ T2[n4 >>> 16 & 0xFF] ^ T3[n >>> 8 & 0xFF] ^ T4[n2 & 0xFF] ^ nArray2[2];
            int n9 = T1[n4 >>> 24 & 0xFF] ^ T2[n >>> 16 & 0xFF] ^ T3[n2 >>> 8 & 0xFF] ^ T4[n3 & 0xFF] ^ nArray2[3];
            n = n6;
            n2 = n7;
            n3 = n8;
            n4 = n9;
            ++n5;
        }
        nArray2 = nArray[10];
        int n10 = nArray2[0];
        byArray2[0] = (byte)(S[n >>> 24 & 0xFF] ^ n10 >>> 24);
        byArray2[1] = (byte)(S[n2 >>> 16 & 0xFF] ^ n10 >>> 16);
        byArray2[2] = (byte)(S[n3 >>> 8 & 0xFF] ^ n10 >>> 8);
        byArray2[3] = (byte)(S[n4 & 0xFF] ^ n10);
        n10 = nArray2[1];
        byArray2[4] = (byte)(S[n2 >>> 24 & 0xFF] ^ n10 >>> 24);
        byArray2[5] = (byte)(S[n3 >>> 16 & 0xFF] ^ n10 >>> 16);
        byArray2[6] = (byte)(S[n4 >>> 8 & 0xFF] ^ n10 >>> 8);
        byArray2[7] = (byte)(S[n & 0xFF] ^ n10);
        n10 = nArray2[2];
        byArray2[8] = (byte)(S[n3 >>> 24 & 0xFF] ^ n10 >>> 24);
        byArray2[9] = (byte)(S[n4 >>> 16 & 0xFF] ^ n10 >>> 16);
        byArray2[10] = (byte)(S[n >>> 8 & 0xFF] ^ n10 >>> 8);
        byArray2[11] = (byte)(S[n2 & 0xFF] ^ n10);
        n10 = nArray2[3];
        byArray2[12] = (byte)(S[n4 >>> 24 & 0xFF] ^ n10 >>> 24);
        byArray2[13] = (byte)(S[n >>> 16 & 0xFF] ^ n10 >>> 16);
        byArray2[14] = (byte)(S[n2 >>> 8 & 0xFF] ^ n10 >>> 8);
        byArray2[15] = (byte)(S[n3 & 0xFF] ^ n10);
    }

    public static int blockSize() {
        return 16;
    }

    public static synchronized Object makeKey(byte[] byArray, int n, int n2) throws InvalidKeyException {
        int n3;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        int n4 = Rijndael_Algorithm.getRounds(n, n2);
        int n5 = n2 / 4;
        int[][] nArray = new int[n4 + 1][n5];
        int[][] nArray2 = new int[n4 + 1][n5];
        int n6 = (n4 + 1) * n5;
        int n7 = n / 4;
        int[] nArray3 = new int[n7];
        int n8 = 0;
        int n9 = 0;
        while (n8 < n7) {
            nArray3[n8++] = (byArray[n9++] & 0xFF) << 24 | (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
        }
        int n10 = 0;
        n9 = 0;
        while (n9 < n7 && n10 < n6) {
            nArray[n10 / n5][n10 % n5] = nArray3[n9];
            nArray2[n4 - n10 / n5][n10 % n5] = nArray3[n9];
            ++n9;
            ++n10;
        }
        int n11 = 0;
        while (n10 < n6) {
            n3 = nArray3[n7 - 1];
            nArray3[0] = nArray3[0] ^ ((S[n3 >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n3 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n3 & 0xFF] & 0xFF) << 8 ^ S[n3 >>> 24 & 0xFF] & 0xFF ^ (rcon[n11++] & 0xFF) << 24);
            if (n7 != 8) {
                n8 = 1;
                n9 = 0;
                while (n8 < n7) {
                    int n12 = n8++;
                    nArray3[n12] = nArray3[n12] ^ nArray3[n9++];
                }
            } else {
                n8 = 1;
                n9 = 0;
                while (n8 < n7 / 2) {
                    int n13 = n8++;
                    nArray3[n13] = nArray3[n13] ^ nArray3[n9++];
                }
                n3 = nArray3[n7 / 2 - 1];
                int n14 = n7 / 2;
                nArray3[n14] = nArray3[n14] ^ (S[n3 & 0xFF] & 0xFF ^ (S[n3 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n3 >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[n3 >>> 24 & 0xFF] & 0xFF) << 24);
                n9 = n7 / 2;
                n8 = n9 + 1;
                while (n8 < n7) {
                    int n15 = n8++;
                    nArray3[n15] = nArray3[n15] ^ nArray3[n9++];
                }
            }
            n9 = 0;
            while (n9 < n7 && n10 < n6) {
                nArray[n10 / n5][n10 % n5] = nArray3[n9];
                nArray2[n4 - n10 / n5][n10 % n5] = nArray3[n9];
                ++n9;
                ++n10;
            }
        }
        int n16 = 1;
        while (n16 < n4) {
            n9 = 0;
            while (n9 < n5) {
                n3 = nArray2[n16][n9];
                nArray2[n16][n9] = U1[n3 >>> 24 & 0xFF] ^ U2[n3 >>> 16 & 0xFF] ^ U3[n3 >>> 8 & 0xFF] ^ U4[n3 & 0xFF];
                ++n9;
            }
            ++n16;
        }
        Object[] objectArray = new Object[]{nArray, nArray2};
        return objectArray;
    }

    public static int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                return n2 == 16 ? 10 : (n2 == 24 ? 12 : 14);
            }
            case 24: {
                return n2 != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    static {
        int n;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{{0, 0}, {1, 3}, {2, 2}, {3, 1}}, new int[][]{{0, 0}, {1, 5}, {2, 4}, {3, 3}}, new int[][]{{0, 0}, {1, 7}, {3, 5}, {4, 4}}};
        int n2 = 283;
        int n3 = 0;
        Rijndael_Algorithm.alog[0] = 1;
        int n4 = 1;
        while (n4 < 256) {
            n3 = alog[n4 - 1] << 1 ^ alog[n4 - 1];
            if ((n3 & 0x100) != 0) {
                n3 ^= n2;
            }
            Rijndael_Algorithm.alog[n4] = n3;
            ++n4;
        }
        n4 = 1;
        while (n4 < 255) {
            Rijndael_Algorithm.log[Rijndael_Algorithm.alog[n4]] = n4;
            ++n4;
        }
        byte[][] byArrayArray = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] byArray = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] byArray2 = new byte[256][8];
        byArray2[1][7] = 1;
        n4 = 2;
        while (n4 < 256) {
            n3 = alog[255 - log[n4]];
            n = 0;
            while (n < 8) {
                byArray2[n4][n] = (byte)(n3 >>> 7 - n & 1);
                ++n;
            }
            ++n4;
        }
        byte[][] byArray3 = new byte[256][8];
        n4 = 0;
        while (n4 < 256) {
            n = 0;
            while (n < 8) {
                byArray3[n4][n] = byArray[n];
                n3 = 0;
                while (n3 < 8) {
                    byte[] byArray4 = byArray3[n4];
                    int n5 = n;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArrayArray[n][n3] * byArray2[n4][n3]);
                    ++n3;
                }
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < 256) {
            Rijndael_Algorithm.S[n4] = (byte)(byArray3[n4][0] << 7);
            n = 1;
            while (n < 8) {
                int n6 = n4;
                S[n6] = (byte)(S[n6] ^ byArray3[n4][n] << 7 - n);
                ++n;
            }
            Rijndael_Algorithm.Si[Rijndael_Algorithm.S[n4] & 0xFF] = (byte)n4;
            ++n4;
        }
        byte[][] byArrayArray2 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray5 = new byte[4][8];
        n4 = 0;
        while (n4 < 4) {
            n3 = 0;
            while (n3 < 4) {
                byArray5[n4][n3] = byArrayArray2[n4][n3];
                ++n3;
            }
            byArray5[n4][n4 + 4] = 1;
            ++n4;
        }
        byte[][] byArray6 = new byte[4][4];
        n4 = 0;
        while (n4 < 4) {
            byte by = byArray5[n4][n4];
            if (by == 0) {
                n = n4 + 1;
                while (byArray5[n][n4] == 0 && n < 4) {
                    ++n;
                }
                if (n == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                n3 = 0;
                while (n3 < 8) {
                    byte by2 = byArray5[n4][n3];
                    byArray5[n4][n3] = byArray5[n][n3];
                    byArray5[n][n3] = by2;
                    ++n3;
                }
                by = byArray5[n4][n4];
            }
            n3 = 0;
            while (n3 < 8) {
                if (byArray5[n4][n3] != 0) {
                    byArray5[n4][n3] = (byte)alog[(255 + log[byArray5[n4][n3] & 0xFF] - log[by & 0xFF]) % 255];
                }
                ++n3;
            }
            n = 0;
            while (n < 4) {
                if (n4 != n) {
                    n3 = n4 + 1;
                    while (n3 < 8) {
                        byte[] byArray7 = byArray5[n];
                        int n7 = n3;
                        byArray7[n7] = (byte)(byArray7[n7] ^ Rijndael_Algorithm.mul(byArray5[n4][n3], byArray5[n][n4]));
                        ++n3;
                    }
                    byArray5[n][n4] = 0;
                }
                ++n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < 4) {
            n3 = 0;
            while (n3 < 4) {
                byArray6[n4][n3] = byArray5[n4][n3 + 4];
                ++n3;
            }
            ++n4;
        }
        n = 0;
        while (n < 256) {
            byte by = S[n];
            Rijndael_Algorithm.T1[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[0]);
            Rijndael_Algorithm.T2[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[1]);
            Rijndael_Algorithm.T3[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[2]);
            Rijndael_Algorithm.T4[n] = Rijndael_Algorithm.mul4(by, byArrayArray2[3]);
            by = Si[n];
            Rijndael_Algorithm.T5[n] = Rijndael_Algorithm.mul4(by, byArray6[0]);
            Rijndael_Algorithm.T6[n] = Rijndael_Algorithm.mul4(by, byArray6[1]);
            Rijndael_Algorithm.T7[n] = Rijndael_Algorithm.mul4(by, byArray6[2]);
            Rijndael_Algorithm.T8[n] = Rijndael_Algorithm.mul4(by, byArray6[3]);
            Rijndael_Algorithm.U1[n] = Rijndael_Algorithm.mul4(n, byArray6[0]);
            Rijndael_Algorithm.U2[n] = Rijndael_Algorithm.mul4(n, byArray6[1]);
            Rijndael_Algorithm.U3[n] = Rijndael_Algorithm.mul4(n, byArray6[2]);
            Rijndael_Algorithm.U4[n] = Rijndael_Algorithm.mul4(n, byArray6[3]);
            ++n;
        }
        Rijndael_Algorithm.rcon[0] = 1;
        int n8 = 1;
        n = 1;
        while (n < 30) {
            int n9 = n++;
            n8 = Rijndael_Algorithm.mul(2, n8);
            Rijndael_Algorithm.rcon[n9] = (byte)n8;
        }
    }
}

