/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;

final class JAPView
extends JFrame
implements ActionListener,
JAPObserver {
    private JAPModel model;
    private JLabel meterLabel;
    private JLabel m_labelCascadeName;
    private JLabel statusTextField1;
    private JLabel statusTextField2;
    private JLabel m_labelProxyPort;
    private JLabel m_labelProxyHost;
    private JLabel infoServiceTextField;
    private JLabel anonTextField;
    private JLabel anonNameTextField;
    private JButton portB;
    private JButton httpB;
    private JButton isB;
    private JButton anonB;
    private JButton ano1B;
    private JButton infoB;
    private JButton helpB;
    private JButton startB;
    private JButton quitB;
    private JButton iconifyB;
    private JButton confB;
    private JLabel proxyMustUseLabel;
    private JCheckBox anonCheckBox;
    private JCheckBox ano1CheckBox;
    private JProgressBar userProgressBar;
    private JProgressBar trafficProgressBar;
    private JProgressBar protectionProgressBar;
    private JProgressBar ownTrafficChannelsProgressBar;
    private JLabel m_labelOwnTrafficBytes;
    private ImageIcon[] meterIcons;
    private JAPHelp helpWindow;
    private JAPConf configDialog;
    private Object oValueUpdateSemaphore;
    private boolean m_bIsIconified;
    private String m_Title;
    private static final boolean PROGRESSBARBORDER = true;

    public JAPView(String string) {
        super(string);
        this.m_Title = string;
        this.model = JAPModel.getModel();
        this.model.setView(this);
        this.helpWindow = null;
        this.configDialog = null;
        this.m_bIsIconified = false;
        this.oValueUpdateSemaphore = new Object();
    }

    public void create() {
        JAPDebug.out(6, 1, "JAPView:initializing...");
        this.init();
        JAPDebug.out(7, 1, "JAPView:initialization finished!");
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            JAPDebug.out(2, 1, "JAPView: " + exception);
        }
        ImageIcon imageIcon = JAPUtil.loadImageIcon("icon16.gif", true);
        if (imageIcon != null) {
            ((Frame)this).setIconImage(imageIcon.getImage());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JAPView.this.exitProgram();
            }
        });
        this.loadMeterIcons();
        ImageIcon imageIcon2 = JAPUtil.loadImageIcon(JAPModel.getString("northPath"), true);
        JLabel jLabel = new JLabel(imageIcon2);
        ImageIcon imageIcon3 = JAPUtil.loadImageIcon(JAPModel.getString("westPath"), true);
        JLabel jLabel2 = new JLabel(imageIcon3);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.buildConfigPanel();
        JPanel jPanel2 = this.buildLevelPanel();
        jTabbedPane.addTab(JAPModel.getString("mainMeterTab"), JAPUtil.loadImageIcon("icom.gif", true), jPanel2);
        JPanel jPanel3 = new JPanel();
        this.infoB = new JButton(JAPModel.getString("infoButton"));
        this.helpB = new JButton(JAPModel.getString("helpButton"));
        this.quitB = new JButton(JAPModel.getString("quitButton"));
        this.confB = new JButton(JAPModel.getString("confButton"));
        this.iconifyB = new JButton(JAPUtil.loadImageIcon("iconify.gif", true));
        this.iconifyB.setToolTipText(JAPModel.getString("iconifyWindow"));
        jPanel3.add(this.iconifyB);
        jPanel3.add(this.infoB);
        jPanel3.add(this.helpB);
        jPanel3.add(this.confB);
        jPanel3.add(new JLabel("  "));
        jPanel3.add(this.quitB);
        this.iconifyB.addActionListener(this);
        this.confB.addActionListener(this);
        this.infoB.addActionListener(this);
        this.helpB.addActionListener(this);
        this.quitB.addActionListener(this);
        this.iconifyB.setMnemonic(JAPModel.getString("iconifyButtonMn").charAt(0));
        this.confB.setMnemonic(JAPModel.getString("confButtonMn").charAt(0));
        this.infoB.setMnemonic(JAPModel.getString("infoButtonMn").charAt(0));
        this.helpB.setMnemonic(JAPModel.getString("helpButtonMn").charAt(0));
        this.quitB.setMnemonic(JAPModel.getString("quitButtonMn").charAt(0));
        this.getContentPane().setBackground(jPanel3.getBackground());
        this.getContentPane().add((Component)jPanel3, "South");
        this.getContentPane().add((Component)jLabel, "North");
        this.getContentPane().add((Component)jLabel2, "West");
        this.getContentPane().add((Component)new JLabel("  "), "East");
        this.getContentPane().add((Component)jTabbedPane, "Center");
        jTabbedPane.setSelectedComponent(jPanel2);
        this.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent windowEvent) {
                JAPView.this.m_bIsIconified = false;
                JAPView.this.setTitle(JAPView.this.m_Title);
            }

            public void windowIconified(WindowEvent windowEvent) {
                JAPView.this.m_bIsIconified = true;
                JAPView.this.updateValues();
            }
        });
        try {
            this.pack();
            this.setResizable(false);
        }
        catch (Exception exception) {
            JAPDebug.out(2, 1, "JAPView:Hm.. Error by Pack - Has To be fixed!!");
        }
        this.updateValues();
        JAPUtil.centerFrame(this);
    }

    private JPanel buildLevelPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ownTrafficChannelsProgressBar = new JProgressBar(0, 0, 1);
        this.ownTrafficChannelsProgressBar.setUI(new MyProgressBarUI());
        this.ownTrafficChannelsProgressBar.setStringPainted(true);
        this.ownTrafficChannelsProgressBar.setBorderPainted(false);
        this.ownTrafficChannelsProgressBar.setString(" ");
        this.m_labelOwnTrafficBytes = new JLabel("0 Bytes", 4);
        this.userProgressBar = new JProgressBar(0, 0, 1);
        this.userProgressBar.setStringPainted(true);
        this.userProgressBar.setBorderPainted(true);
        this.trafficProgressBar = new JProgressBar(0);
        this.trafficProgressBar.setStringPainted(true);
        this.trafficProgressBar.setBorderPainted(true);
        this.protectionProgressBar = new JProgressBar(0);
        this.protectionProgressBar.setStringPainted(true);
        this.protectionProgressBar.setBorderPainted(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2, 5, 5));
        jPanel2.setBorder(new TitledBorder(JAPModel.getString("ownTrafficBorder")));
        jPanel2.add(new JLabel(JAPModel.getString("ownTrafficChannels")));
        jPanel2.add(this.ownTrafficChannelsProgressBar);
        jPanel2.add(new JLabel(JAPModel.getString("ownTrafficBytes")));
        jPanel2.add(this.m_labelOwnTrafficBytes);
        this.ano1CheckBox = new JCheckBox(JAPModel.getString("confActivateCheckBox"));
        this.ano1CheckBox.setMnemonic(JAPModel.getString("confActivateCheckBoxMn").charAt(0));
        this.ano1CheckBox.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.ano1CheckBox);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        this.ano1B = new JButton(JAPModel.getString("confActivateButton"));
        this.ano1B.addActionListener(this);
        jPanel3.add(this.ano1B);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(JAPModel.getString("meterBorder")));
        this.meterLabel = new JLabel(this.getMeterImage(-1));
        jPanel4.add((Component)jPanel3, "North");
        jPanel4.add((Component)this.meterLabel, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(3, 2, 5, 5));
        jPanel5.setBorder(new TitledBorder(JAPModel.getString("meterDetailsBorder")));
        this.m_labelCascadeName = new JLabel();
        jPanel5.add(new JLabel(JAPModel.getString("meterDetailsName")));
        jPanel5.add(this.m_labelCascadeName);
        jPanel5.add(new JLabel(JAPModel.getString("meterDetailsUsers")));
        jPanel5.add(this.userProgressBar);
        jPanel5.add(new JLabel(JAPModel.getString("meterDetailsTraffic")));
        jPanel5.add(this.trafficProgressBar);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private JPanel buildConfigPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.setBorder(new TitledBorder(JAPModel.getString("confListenerBorder")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(new JLabel(JAPModel.getString("confPort")));
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        this.m_labelProxyPort = new JLabel(String.valueOf(this.model.getPortNumber()));
        jPanel3.add(this.m_labelProxyPort);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        this.portB = new JButton(JAPModel.getString("confPortButton"));
        this.portB.addActionListener(this);
        jPanel3.add(this.portB);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel4.add(new JLabel(JAPModel.getString("confStatus1")));
        jPanel4.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusTextField1 = new JLabel("unknown");
        jPanel4.add(this.statusTextField1);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add(jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel5.setBorder(new TitledBorder(JAPModel.getString("confProxyBorder")));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(Box.createRigidArea(new Dimension(10, 0)));
        this.proxyMustUseLabel = new JLabel();
        jPanel6.add(this.proxyMustUseLabel);
        jPanel6.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel6.add(Box.createHorizontalGlue());
        this.httpB = new JButton(JAPModel.getString("confProxyButton"));
        this.httpB.addActionListener(this);
        jPanel6.add(this.httpB);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.add(Box.createRigidArea(new Dimension(10, 0)));
        this.m_labelProxyHost = new JLabel();
        jPanel7.add(this.m_labelProxyHost);
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel7);
        jPanel.add(jPanel5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(1, 1));
        jPanel8.setBorder(new TitledBorder(JAPModel.getString("confInfoServiceBorder")));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel9.add(new JLabel(JAPModel.getString("confInfoServiceHost")));
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        this.infoServiceTextField = new JLabel();
        jPanel9.add(this.infoServiceTextField);
        jPanel9.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel9.add(Box.createHorizontalGlue());
        this.isB = new JButton(JAPModel.getString("confInfoServiceButton"));
        this.isB.addActionListener(this);
        jPanel9.add(this.isB);
        jPanel8.add(jPanel9);
        jPanel.add(jPanel8);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayout(4, 1));
        jPanel10.setBorder(new TitledBorder(JAPModel.getString("confActivateBorder")));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        this.anonCheckBox = new JCheckBox(JAPModel.getString("confActivateCheckBox"));
        this.anonCheckBox.setMnemonic(JAPModel.getString("confActivateCheckBoxMn").charAt(0));
        this.anonCheckBox.addActionListener(this);
        jPanel11.add(this.anonCheckBox);
        jPanel11.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel11.add(Box.createHorizontalGlue());
        this.anonB = new JButton(JAPModel.getString("confActivateButton"));
        this.anonB.addActionListener(this);
        jPanel11.add(this.anonB);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BoxLayout(jPanel12, 0));
        jPanel12.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel12.add(new JLabel(JAPModel.getString("confAnonHost")));
        jPanel12.add(Box.createRigidArea(new Dimension(5, 0)));
        this.anonTextField = new JLabel();
        jPanel12.add(this.anonTextField);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        jPanel13.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel13.add(new JLabel(JAPModel.getString("confStatus2")));
        jPanel13.add(Box.createRigidArea(new Dimension(5, 0)));
        this.statusTextField2 = new JLabel("unknown");
        jPanel13.add(this.statusTextField2);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 0));
        jPanel14.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel14.add(new JLabel(JAPModel.getString("confAnonName")));
        jPanel14.add(Box.createRigidArea(new Dimension(5, 0)));
        this.anonNameTextField = new JLabel();
        jPanel14.add(this.anonNameTextField);
        jPanel10.add(jPanel11);
        jPanel10.add(jPanel14);
        jPanel10.add(jPanel12);
        jPanel10.add(jPanel13);
        jPanel.add(jPanel10);
        return jPanel;
    }

    public void disableSetAnonMode() {
        this.anonCheckBox.setEnabled(false);
        this.ano1CheckBox.setEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void loadMeterIcons() {
        this.meterIcons = new ImageIcon[JAPModel.METERFNARRAY.length];
        int n = 0;
        while (n < JAPModel.METERFNARRAY.length) {
            this.meterIcons[n] = JAPUtil.loadImageIcon(JAPModel.METERFNARRAY[n], false);
            ++n;
        }
    }

    private ImageIcon getMeterImage(int n) {
        if (this.model.getAnonMode()) {
            if (n >= 0 && n < 6) {
                return this.meterIcons[n + 2];
            }
            return this.meterIcons[1];
        }
        return this.meterIcons[0];
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.quitB) {
            this.exitProgram();
        } else if (actionEvent.getSource() == this.iconifyB) {
            ((Component)this.model.getIconifiedView()).setVisible(true);
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.confB) {
            this.showConfigDialog();
        } else if (actionEvent.getSource() == this.portB) {
            this.showConfigDialog(0);
        } else if (actionEvent.getSource() == this.httpB) {
            this.showConfigDialog(1);
        } else if (actionEvent.getSource() == this.isB) {
            this.showConfigDialog(2);
        } else if (actionEvent.getSource() == this.anonB) {
            this.showConfigDialog(3);
        } else if (actionEvent.getSource() == this.ano1B) {
            this.showConfigDialog(3);
        } else if (actionEvent.getSource() == this.infoB) {
            JAPModel.aboutJAP();
        } else if (actionEvent.getSource() == this.helpB) {
            this.showHelpWindow();
        } else if (actionEvent.getSource() == this.anonCheckBox) {
            this.model.setAnonMode(this.anonCheckBox.isSelected());
        } else if (actionEvent.getSource() == this.ano1CheckBox) {
            this.model.setAnonMode(this.ano1CheckBox.isSelected());
        } else {
            JAPDebug.out(7, 1, "Event ?????: " + actionEvent.getSource());
        }
    }

    private void showHelpWindow() {
        if (this.helpWindow == null) {
            this.helpWindow = new JAPHelp(this);
        }
        this.helpWindow.show();
    }

    private void showConfigDialog() {
        this.showConfigDialog(-1);
    }

    private void showConfigDialog(int n) {
        if (this.configDialog == null) {
            Cursor cursor = this.getCursor();
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            this.configDialog = new JAPConf(this);
            ((Component)this).setCursor(cursor);
        }
        if (n != -1) {
            this.configDialog.selectCard(n);
        }
        this.configDialog.updateValues();
        this.configDialog.show();
    }

    private void exitProgram() {
        this.model.goodBye();
    }

    private void updateValues() {
        int n;
        AnonServerDBEntry anonServerDBEntry = this.model.getAnonServer();
        JAPDebug.out(7, 1, "Start updateValues");
        this.m_labelProxyPort.setText(String.valueOf(this.model.getPortNumber()));
        if (this.model.getUseFirewall()) {
            this.proxyMustUseLabel.setText(JAPMessages.getString("firewallMustUse"));
            this.m_labelProxyHost.setVisible(true);
            n = this.model.getFirewallPort();
            if (n == -1) {
                this.m_labelProxyHost.setText(JAPMessages.getString("firewallNotConfigured"));
            } else {
                this.m_labelProxyHost.setText(JAPModel.getString("confProxyHost") + " " + this.model.getFirewallHost() + ":" + String.valueOf(n));
            }
        } else {
            this.proxyMustUseLabel.setText(JAPMessages.getString("firewallMustNotUse"));
            this.m_labelProxyHost.setVisible(false);
        }
        this.infoServiceTextField.setText(this.model.getInfoServiceHost() + ":" + String.valueOf(this.model.getInfoServicePort()));
        this.anonTextField.setText(anonServerDBEntry.getHost() + ":" + String.valueOf(anonServerDBEntry.getPort()) + (anonServerDBEntry.getSSLPort() == -1 ? "" : ":" + anonServerDBEntry.getSSLPort()));
        this.anonNameTextField.setText(anonServerDBEntry.getName());
        this.anonNameTextField.setToolTipText(anonServerDBEntry.getName());
        this.statusTextField1.setText(this.model.status1);
        this.statusTextField2.setText(this.model.status2);
        this.anonCheckBox.setSelected(this.model.getAnonMode());
        if (this.model.getAnonMode()) {
            this.anonCheckBox.setForeground(Color.black);
        } else {
            this.anonCheckBox.setForeground(Color.red);
        }
        this.ano1CheckBox.setSelected(this.model.getAnonMode());
        if (this.model.getAnonMode()) {
            this.ano1CheckBox.setForeground(Color.black);
        } else {
            this.ano1CheckBox.setForeground(Color.red);
        }
        this.m_labelCascadeName.setText(anonServerDBEntry.getName());
        this.m_labelCascadeName.setToolTipText(anonServerDBEntry.getName());
        this.meterLabel.setIcon(this.getMeterImage(anonServerDBEntry.getAnonLevel()));
        if (this.model.getAnonMode()) {
            if (anonServerDBEntry.getNrOfActiveUsers() > -1) {
                if (anonServerDBEntry.getNrOfActiveUsers() > this.userProgressBar.getMaximum()) {
                    this.userProgressBar.setMaximum(anonServerDBEntry.getNrOfActiveUsers());
                }
                this.userProgressBar.setValue(anonServerDBEntry.getNrOfActiveUsers());
                this.userProgressBar.setString(String.valueOf(anonServerDBEntry.getNrOfActiveUsers()));
                if (this.m_bIsIconified) {
                    this.setTitle("JAP (" + Integer.toString(anonServerDBEntry.getNrOfActiveUsers()) + " " + JAPModel.getString("iconifiedviewUsers") + ")");
                }
            } else {
                this.userProgressBar.setValue(this.userProgressBar.getMaximum());
                this.userProgressBar.setString(JAPModel.getString("meterNA"));
            }
            if (anonServerDBEntry.getCurrentRisk() > -1) {
                if (anonServerDBEntry.getCurrentRisk() > this.protectionProgressBar.getMaximum()) {
                    this.protectionProgressBar.setMaximum(anonServerDBEntry.getCurrentRisk());
                }
                this.protectionProgressBar.setValue(anonServerDBEntry.getCurrentRisk());
                if (anonServerDBEntry.getCurrentRisk() < 80) {
                    this.protectionProgressBar.setString(String.valueOf(anonServerDBEntry.getCurrentRisk()) + " %");
                } else {
                    this.protectionProgressBar.setString(JAPModel.getString("meterRiskVeryHigh"));
                }
            } else {
                this.protectionProgressBar.setValue(this.protectionProgressBar.getMaximum());
                this.protectionProgressBar.setString(JAPModel.getString("meterNA"));
            }
            n = anonServerDBEntry.getTrafficSituation();
            if (n > -1) {
                this.trafficProgressBar.setMaximum(100);
                this.trafficProgressBar.setValue(n);
                if (n < 30) {
                    this.trafficProgressBar.setString(JAPModel.getString("meterTrafficLow"));
                } else if (n < 60) {
                    this.trafficProgressBar.setString(JAPModel.getString("meterTrafficMedium"));
                } else {
                    this.trafficProgressBar.setString(JAPModel.getString("meterTrafficHigh"));
                }
            } else {
                this.trafficProgressBar.setValue(this.trafficProgressBar.getMaximum());
                this.trafficProgressBar.setString(JAPModel.getString("meterNA"));
            }
        } else {
            this.userProgressBar.setValue(this.userProgressBar.getMaximum());
            this.userProgressBar.setString(JAPModel.getString("meterNA"));
            this.protectionProgressBar.setValue(this.protectionProgressBar.getMaximum());
            if (this.model.getAnonMode()) {
                this.protectionProgressBar.setString(JAPModel.getString("meterNA"));
            } else {
                this.protectionProgressBar.setString(JAPModel.getString("meterRiskVeryHigh"));
            }
            this.trafficProgressBar.setValue(this.trafficProgressBar.getMaximum());
            this.trafficProgressBar.setString(JAPModel.getString("meterNA"));
        }
    }

    public void channelsChanged(int n) {
        if (n > this.ownTrafficChannelsProgressBar.getMaximum()) {
            this.ownTrafficChannelsProgressBar.setMaximum(n);
        }
        this.ownTrafficChannelsProgressBar.setValue(n);
    }

    public void transferedBytes(int n) {
        this.m_labelOwnTrafficBytes.setText(NumberFormat.getInstance().format(n) + " Bytes");
    }

    public void valuesChanged(JAPModel jAPModel) {
        Object object = this.oValueUpdateSemaphore;
        synchronized (object) {
            this.updateValues();
        }
    }

    public class MyProgressBarUI
    extends BasicProgressBarUI {
        public void paint(Graphics graphics, JComponent jComponent) {
            JProgressBar jProgressBar = (JProgressBar)jComponent;
            int n = 13;
            int n2 = jProgressBar.getMaximum();
            int n3 = jProgressBar.getWidth() / n;
            int n4 = jProgressBar.getValue() * n3 / n2;
            int n5 = 0;
            int n6 = 0;
            int n7 = jComponent.getHeight();
            int n8 = 9;
            int n9 = 0;
            while (n9 < n4) {
                graphics.fill3DRect(n5, n6, n8, n7, false);
                n5 += n;
                ++n9;
            }
            int n10 = n4;
            while (n10 < n3) {
                graphics.draw3DRect(n5, n6, n8, n7, false);
                n5 += n;
                ++n10;
            }
        }
    }
}

