/*
 * Decompiled with CFR 0.152.
 */
import anon.JAPAnonService;
import anon.JAPAnonServiceListener;
import java.awt.Component;
import java.awt.Cursor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import rmi.JAPAnonServiceRMIServer;

public final class JAPModel
implements JAPAnonServiceListener {
    public static final String aktVersion = "00.01.037";
    public JAPAnonServerDB anonServerDatabase = null;
    public static final String defaultanonHost = "mix.inf.tu-dresden.de";
    public static final int defaultanonPortNumber = 6544;
    private AnonServerDBEntry currentAnonService = null;
    private ServerSocket m_socketHTTPListener;
    private JAPDirectProxy proxyDirect = null;
    private JAPAnonService proxyAnon = null;
    public static final int defaultPortNumber = 4001;
    private int portNumber = 4001;
    private boolean mblistenerIsLocal = true;
    private boolean isRunningListener = false;
    public static final String defaultinfoServiceHostName = "infoservice.inf.tu-dresden.de";
    private String infoServiceHostName = "infoservice.inf.tu-dresden.de";
    public static final int defaultinfoServicePortNumber = 6543;
    private int infoServicePortNumber = 6543;
    private boolean mbUseProxy = false;
    private String proxyHostName = "";
    private int proxyPortNumber = -1;
    private boolean mb_UseProxyAuthentication = false;
    private String m_ProxyAuthenticationUserID = null;
    private String m_ProxyAuthenticationPasswd = null;
    public boolean autoConnect = false;
    private boolean mbMinimizeOnStartup = false;
    public boolean canStartService = false;
    public boolean alreadyCheckedForNewVersion = false;
    private boolean mbActCntMessageNotRemind = false;
    private boolean mbActCntMessageNeverRemind = false;
    private boolean mbDoNotAbuseReminder = false;
    private boolean mbGoodByMessageNeverRemind = false;
    private static final Object oSetAnonModeSyncObject = new Object();
    public String status1 = " ";
    public String status2 = " ";
    private int nrOfChannels = 0;
    private int nrOfBytes = 0;
    private static JAPView view = null;
    private static JAPViewIconified iconifiedView = null;
    private static JAPInfoService mInfoService = null;
    static final String aktJAPVersionFN = "/aktVersion";
    static final String urlJAPNewVersionDownload = "/~sk13/anon/jap/JAP.jar";
    static final String JAPLocalFilename = "JAP.jar";
    static final int MAXHELPLANGUAGES = 6;
    static final String TITLE = "JAP";
    static final String TITLEOFICONIFIEDVIEW = "JAP";
    static final String AUTHOR = "(c) 2000 The JAP-Team";
    static final String XMLCONFFN = "jap.conf";
    public static final String BUSYFN = "busy.gif";
    public static final String ABOUTFN = "info.gif";
    static final String DOWNLOADFN = "install.gif";
    static final String IICON16FN = "icon16.gif";
    static final String ICONFN = "icon.gif";
    static final String JAPTXTFN = "japtxt.gif";
    static final String JAPEYEFN = "japeye.gif";
    static final String JAPICONFN = "japi.gif";
    static final String CONFIGICONFN = "icoc.gif";
    static final String ICONIFYICONFN = "iconify.gif";
    static final String ENLARGEYICONFN = "enlarge.gif";
    static final String METERICONFN = "icom.gif";
    static final String[] METERFNARRAY = new String[]{"meterD.gif", "meterNnew.gif", "meter1.gif", "meter2.gif", "meter3.gif", "meter4.gif", "meter5.gif", "meter6.gif"};
    private ResourceBundle msg;
    private Locale m_Locale = null;
    private Vector observerVector = new Vector();
    private static JAPModel model = null;
    private static JAPFeedback feedback = null;
    private static JAPAnonServiceRMIServer anonServiceRMIServer = null;

    private JAPModel() {
        this.currentAnonService = new AnonServerDBEntry(defaultanonHost, 6544);
        this.m_Locale = Locale.getDefault();
    }

    public static JAPModel createModel() {
        if (model == null) {
            model = new JAPModel();
        }
        return model;
    }

    public static JAPModel getModel() {
        return model;
    }

    public int setRMISupport(boolean bl) {
        if (bl) {
            if (anonServiceRMIServer == null) {
                anonServiceRMIServer = new JAPAnonServiceRMIServer(this);
            }
        } else {
            if (anonServiceRMIServer != null) {
                anonServiceRMIServer.quitServer();
            }
            anonServiceRMIServer = null;
        }
        return 0;
    }

    public void setIconifiedView(JAPViewIconified jAPViewIconified) {
        iconifiedView = jAPViewIconified;
    }

    public JAPViewIconified getIconifiedView() {
        return iconifiedView;
    }

    public void setView(JAPView jAPView) {
        view = jAPView;
    }

    public static JAPView getView() {
        return view;
    }

    public synchronized void load() {
        this.anonServerDatabase = new JAPAnonServerDB();
        JAPDebug.out(6, 8, "JAPModel:try loading configuration from jap.conf");
        try {
            String string = System.getProperty("user.home", "");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string + "/" + XMLCONFFN);
            }
            catch (Exception exception) {
                fileInputStream = new FileInputStream(XMLCONFFN);
            }
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
            Element element = document.getDocumentElement();
            NamedNodeMap namedNodeMap = element.getAttributes();
            this.portNumber = JAPUtil.parseElementAttrInt(element, "portNumber", this.portNumber);
            this.setListenerIsLocal(JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("listenerIsLocal"), true));
            this.setUseProxy(JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("proxyMode"), false));
            this.setUseFirewallAuthorization(JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("proxyAuthorization"), false));
            this.mbActCntMessageNeverRemind = JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("neverRemindActiveContent"), false);
            this.mbDoNotAbuseReminder = JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("doNotAbuseReminder"), false);
            if (this.mbActCntMessageNeverRemind && this.mbDoNotAbuseReminder) {
                this.mbActCntMessageNotRemind = true;
            }
            this.mbGoodByMessageNeverRemind = JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("neverRemindGoodBye"), false);
            String string2 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("infoServiceHostName"), this.infoServiceHostName);
            int n = JAPUtil.parseElementAttrInt(element, "infoServicePortNumber", this.infoServicePortNumber);
            this.setInfoService(string2, n);
            string2 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("proxyHostName"), this.proxyHostName);
            n = JAPUtil.parseElementAttrInt(element, "proxyPortNumber", this.proxyPortNumber);
            if (string2.equalsIgnoreCase("ikt.inf.tu-dresden.de")) {
                string2 = "";
            }
            this.setProxy(string2, n);
            String string3 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("proxyAuthUserID"), this.m_ProxyAuthenticationUserID);
            this.setFirewallAuthUserID(string3);
            String string4 = model.getAnonServer().getName();
            String string5 = model.getAnonServer().getHost();
            int n2 = model.getAnonServer().getPort();
            int n3 = model.getAnonServer().getSSLPort();
            string4 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("anonserviceName"), string4);
            string5 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("anonHostName"), string5);
            n2 = JAPUtil.parseElementAttrInt(element, "anonPortNumber", n2);
            n3 = JAPUtil.parseElementAttrInt(element, "anonSSLPortNumber", n3);
            model.setAnonServer(new AnonServerDBEntry(string4, string5, n2, n3));
            model.getAnonServer().setName(string4);
            this.autoConnect = JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("autoConnect"), false);
            this.mbMinimizeOnStartup = JAPUtil.parseNodeBoolean(namedNodeMap.getNamedItem("minimizedStartup"), false);
            String string6 = JAPUtil.parseNodeString(namedNodeMap.getNamedItem("Locale"), this.m_Locale.getLanguage());
            this.setLocale(new Locale(string6, ""));
            NodeList nodeList = element.getElementsByTagName("Debug");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element element2;
                Element element3 = (Element)nodeList.item(0);
                if ((nodeList = element3.getElementsByTagName("Level")) != null && nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                    JAPDebug.setDebugLevel(Integer.parseInt(element2.getFirstChild().getNodeValue().trim()));
                }
                if ((nodeList = element3.getElementsByTagName("Type")) != null && nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                    int n4 = 0;
                    if (element2.getAttribute("GUI").equals("true")) {
                        ++n4;
                    }
                    if (element2.getAttribute("NET").equals("true")) {
                        n4 += 2;
                    }
                    if (element2.getAttribute("THREAD").equals("true")) {
                        n4 += 4;
                    }
                    if (element2.getAttribute("MISC").equals("true")) {
                        n4 += 8;
                    }
                    JAPDebug.setDebugType(n4);
                }
                if ((nodeList = element3.getElementsByTagName("Output")) != null && nodeList.getLength() > 0) {
                    element2 = (Element)nodeList.item(0);
                    JAPDebug.showConsole(element2.getFirstChild().getNodeValue().trim().equalsIgnoreCase("Console"), view);
                }
            }
        }
        catch (Exception exception) {
            JAPDebug.out(6, 8, "JAPModel:Error loading configuration! " + exception.toString());
        }
        this.notifyJAPObservers();
    }

    public void save() {
        boolean bl = false;
        JAPDebug.out(6, 8, "JAPModel:try saving configuration to jap.conf");
        try {
            String string = System.getProperty("user.home", "");
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string + "/" + XMLCONFFN);
            }
            catch (Exception exception) {
                fileOutputStream = new FileOutputStream(XMLCONFFN);
            }
            String string2 = this.getConfigurationAsXML();
            if (string2 != null) {
                fileOutputStream.write(string2.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            JAPDebug.out(3, 8, "JAPModel:error saving configuration to jap.conf");
            JOptionPane.showMessageDialog(JAPModel.getView(), JAPModel.getString("errorSavingConfig"), JAPModel.getString("errorSavingConfigTitle"), 0);
        }
    }

    protected String getConfigurationAsXML() {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("JAP");
            document.appendChild(element);
            element.setAttribute("portNumber", Integer.toString(this.portNumber));
            element.setAttribute("listenerIsLocal", this.getListenerIsLocal() ? "true" : "false");
            element.setAttribute("proxyMode", this.mbUseProxy ? "true" : "false");
            element.setAttribute("proxyHostName", this.proxyHostName == null ? "" : this.proxyHostName);
            element.setAttribute("proxyPortNumber", Integer.toString(this.proxyPortNumber));
            element.setAttribute("proxyAuthorization", this.mb_UseProxyAuthentication ? "true" : "false");
            element.setAttribute("proxyAuthUserID", this.m_ProxyAuthenticationUserID == null ? "" : this.m_ProxyAuthenticationUserID);
            element.setAttribute("infoServiceHostName", this.infoServiceHostName == null ? "" : this.infoServiceHostName);
            element.setAttribute("infoServicePortNumber", Integer.toString(this.infoServicePortNumber));
            AnonServerDBEntry anonServerDBEntry = model.getAnonServer();
            element.setAttribute("anonserviceName", anonServerDBEntry.getName() == null ? "" : anonServerDBEntry.getName());
            element.setAttribute("anonHostName", anonServerDBEntry.getHost() == null ? "" : anonServerDBEntry.getHost());
            element.setAttribute("anonPortNumber", Integer.toString(anonServerDBEntry.getPort()));
            element.setAttribute("anonSSLPortNumber", Integer.toString(anonServerDBEntry.getSSLPort()));
            element.setAttribute("autoConnect", this.autoConnect ? "true" : "false");
            element.setAttribute("minimizedStartup", this.mbMinimizeOnStartup ? "true" : "false");
            element.setAttribute("neverRemindActiveContent", this.mbActCntMessageNeverRemind ? "true" : "false");
            element.setAttribute("doNotAbuseReminder", this.mbDoNotAbuseReminder ? "true" : "false");
            element.setAttribute("neverRemindGoodBye", this.mbGoodByMessageNeverRemind ? "true" : "false");
            element.setAttribute("Locale", this.m_Locale.getLanguage());
            Element element2 = document.createElement("Debug");
            element.appendChild(element2);
            Element element3 = document.createElement("Level");
            Text text = document.createTextNode(Integer.toString(JAPDebug.getDebugLevel()));
            element3.appendChild(text);
            element2.appendChild(element3);
            element3 = document.createElement("Type");
            int n = JAPDebug.getDebugType();
            element3.setAttribute("GUI", (n & 1) != 0 ? "true" : "false");
            element3.setAttribute("NET", (n & 2) != 0 ? "true" : "false");
            element3.setAttribute("THREAD", (n & 4) != 0 ? "true" : "false");
            element3.setAttribute("MISC", (n & 8) != 0 ? "true" : "false");
            element2.appendChild(element3);
            if (JAPDebug.isShowConsole()) {
                element3 = document.createElement("Output");
                text = document.createTextNode("Console");
                element3.appendChild(text);
                element2.appendChild(element3);
            }
            return JAPUtil.XMLDocumentToString(document);
        }
        catch (Exception exception) {
            JAPDebug.out(2, 8, "JAPModel:save() Exception: " + exception.getMessage());
            return null;
        }
    }

    public void initialRun() {
        JAPDebug.out(6, 8, "JAPModel:initial run of JAP...");
        JAPAnonService.init();
        if (!this.startHTTPListener()) {
            Object[] objectArray = new Object[]{new Integer(this.portNumber)};
            String string = MessageFormat.format(JAPModel.getString("errorListenerPort"), objectArray);
            JOptionPane.showMessageDialog(JAPModel.getView(), string, JAPModel.getString("errorListenerPortTitle"), 0);
            JAPDebug.out(0, 2, "Cannot start listener!");
            JAPModel.model.status1 = JAPModel.getString("statusCannotStartListener");
            JAPModel.getView().disableSetAnonMode();
            this.notifyJAPObservers();
        } else {
            JAPModel.model.status1 = JAPModel.getString("statusRunning");
            this.setAnonMode(this.autoConnect);
        }
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public void setLocale(Locale locale) {
        JAPMessages.init(locale);
        this.m_Locale = locale;
    }

    public synchronized void setAnonServer(AnonServerDBEntry anonServerDBEntry) {
        if (anonServerDBEntry == null) {
            return;
        }
        AnonServerDBEntry anonServerDBEntry2 = this.getAnonServer();
        if (anonServerDBEntry2 != null && anonServerDBEntry2.equals(anonServerDBEntry)) {
            JAPDebug.out(7, 8, "JAPModel:currentAnonService NOT changed");
        } else {
            this.currentAnonService = anonServerDBEntry;
            if (this.getAnonMode()) {
                this.setAnonMode(false);
                JAPDebug.out(7, 8, "JAPModel:currentAnonService changed");
                this.setAnonMode(true);
            }
        }
        model.notifyJAPObservers();
    }

    public AnonServerDBEntry getAnonServer() {
        return this.currentAnonService;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public static String getString(String string) {
        return JAPMessages.getString(string);
    }

    public void channelsChanged(int n) {
        this.nrOfChannels = n;
        Enumeration enumeration = this.observerVector.elements();
        while (enumeration.hasMoreElements()) {
            JAPObserver jAPObserver = (JAPObserver)enumeration.nextElement();
            jAPObserver.channelsChanged(n);
        }
    }

    public void transferedBytes(int n) {
        this.nrOfBytes += n;
        Enumeration enumeration = this.observerVector.elements();
        while (enumeration.hasMoreElements()) {
            JAPObserver jAPObserver = (JAPObserver)enumeration.nextElement();
            jAPObserver.transferedBytes(this.nrOfBytes);
        }
    }

    public boolean setInfoService(String string, int n) {
        if (!JAPUtil.isPort(n)) {
            return false;
        }
        if (string == null) {
            return false;
        }
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            this.infoServiceHostName = string;
            this.infoServicePortNumber = n;
            if (mInfoService != null) {
                mInfoService.setInfoService(string, n);
            }
            this.notifyJAPObservers();
            boolean bl = true;
            return bl;
        }
    }

    public String getInfoServiceHost() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            String string = this.infoServiceHostName;
            return string;
        }
    }

    public int getInfoServicePort() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            int n = this.infoServicePortNumber;
            return n;
        }
    }

    public JAPInfoService getInfoService() {
        if (mInfoService == null) {
            mInfoService = new JAPInfoService();
        }
        return mInfoService;
    }

    public void setListenerIsLocal(boolean bl) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            this.mblistenerIsLocal = bl;
        }
    }

    public boolean getListenerIsLocal() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            boolean bl = this.mblistenerIsLocal;
            return bl;
        }
    }

    public void setUseProxy(boolean bl) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            this.mbUseProxy = bl;
            if (mInfoService != null) {
                if (this.mbUseProxy) {
                    mInfoService.setProxy(this.proxyHostName, this.proxyPortNumber, null, null);
                } else {
                    mInfoService.setProxy(null, 0, null, null);
                }
            }
        }
        this.notifyJAPObservers();
    }

    public void setMinimizeOnStartup(boolean bl) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            this.mbMinimizeOnStartup = bl;
        }
    }

    public boolean getMinimizeOnStartup() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            boolean bl = this.mbMinimizeOnStartup;
            return bl;
        }
    }

    public boolean setProxy(String string, int n) {
        if (!JAPUtil.isPort(n)) {
            return false;
        }
        if (string == null) {
            return false;
        }
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            this.proxyHostName = string;
            this.proxyPortNumber = n;
            if (mInfoService != null && this.mbUseProxy) {
                mInfoService.setProxy(string, n, null, null);
            }
            this.notifyJAPObservers();
            boolean bl = true;
            return bl;
        }
    }

    public boolean getUseFirewall() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            boolean bl = this.mbUseProxy;
            return bl;
        }
    }

    public String getFirewallHost() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            String string = this.proxyHostName;
            return string;
        }
    }

    public int getFirewallPort() {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            int n = this.proxyPortNumber;
            return n;
        }
    }

    public void setUseFirewallAuthorization(boolean bl) {
        this.mb_UseProxyAuthentication = bl;
    }

    public boolean getUseFirewallAuthorization() {
        return this.mb_UseProxyAuthentication;
    }

    public void setFirewallAuthUserID(String string) {
        this.m_ProxyAuthenticationUserID = string;
    }

    public String getFirewallAuthUserID() {
        return this.m_ProxyAuthenticationUserID;
    }

    public String getFirewallAuthPasswd() {
        if (this.mb_UseProxyAuthentication) {
            if (this.m_ProxyAuthenticationPasswd == null) {
                this.m_ProxyAuthenticationPasswd = JAPFirewallPasswdDlg.getPasswd();
            }
            return this.m_ProxyAuthenticationPasswd;
        }
        return null;
    }

    public synchronized void setAnonMode(boolean bl) {
        Thread thread = new Thread(new SetAnonModeAsync(bl));
        thread.start();
    }

    public boolean getAnonMode() {
        return this.proxyAnon != null;
    }

    private boolean startHTTPListener() {
        JAPDebug.out(7, 8, "JAPModel:startListener");
        if (!this.isRunningListener) {
            boolean bl = false;
            int n = 0;
            while (n < 10) {
                try {
                    if (this.mblistenerIsLocal) {
                        InetAddress[] inetAddressArray = InetAddress.getAllByName("127.0.0.1");
                        JAPDebug.out(7, 2, "Try binding Listener on localhost: " + inetAddressArray[0]);
                        this.m_socketHTTPListener = new ServerSocket(this.portNumber, 50, inetAddressArray[0]);
                    } else {
                        this.m_socketHTTPListener = new ServerSocket(this.portNumber);
                    }
                    JAPDebug.out(6, 2, "JAPProxyServer:Listener on port " + this.portNumber + " started.");
                    try {
                        this.m_socketHTTPListener.setSoTimeout(2000);
                    }
                    catch (Exception exception) {
                        JAPDebug.out(7, 2, "Could not set accept time out: Exception: " + exception.getMessage());
                    }
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    JAPDebug.out(7, 2, "Exception: " + exception.getMessage());
                    this.m_socketHTTPListener = null;
                    ++n;
                }
            }
            this.isRunningListener = bl;
        }
        return this.isRunningListener;
    }

    private void stopHTTPListener() {
        JAPDebug.out(7, 8, "JAPModel:stopListener");
        if (this.isRunningListener) {
            this.setAnonMode(false);
            try {
                this.m_socketHTTPListener.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socketHTTPListener = null;
            this.isRunningListener = false;
        }
    }

    public void goodBye() {
        ((Component)view).setVisible(false);
        ((Component)iconifiedView).setVisible(false);
        Object[] objectArray = new Object[]{JAPModel.getString("okButton")};
        JCheckBox jCheckBox = new JCheckBox(JAPModel.getString("disableGoodByMessageNeverRemind"));
        Object[] objectArray2 = new Object[]{JAPModel.getString("disableGoodByMessage"), jCheckBox};
        if (!this.mbGoodByMessageNeverRemind) {
            JOptionPane.showOptionDialog(JAPModel.getView(), objectArray2, JAPModel.getString("disableGoodByMessageTitle"), -1, 2, null, objectArray, objectArray[0]);
            this.mbGoodByMessageNeverRemind = jCheckBox.isSelected();
        }
        model.save();
        System.exit(0);
    }

    public static void aboutJAP() {
        try {
            new JAPAbout(view);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void fetchAnonServers() {
        JAPDebug.out(6, 8, "JAPModel:Trying to fetch Anon Servers from ...");
        try {
            this.getInfoService().fetchAnonServers();
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPModel:fetchAnonServers: " + exception);
            JOptionPane.showMessageDialog(view, JAPModel.getString("errorConnectingInfoService"), JAPModel.getString("errorConnectingInfoServiceTitle"), 0);
        }
        this.notifyJAPObservers();
    }

    public int versionCheck() {
        JAPDebug.out(6, 8, "JAPModel:Checking for new version of JAP...");
        try {
            int n = 0;
            Versionchecker versionchecker = new Versionchecker();
            String string = this.getInfoService().getNewVersionNumber();
            if (string == null) {
                return -1;
            }
            string = string.trim();
            JAPDebug.out(7, 8, "JAPModel:Version:00.01.037");
            if (string.compareTo(aktVersion) > 0) {
                JAPLoading jAPLoading = new JAPLoading(this, view);
                String string2 = jAPLoading.message(JAPModel.getString("newVersionAvailableTitle"), JAPModel.getString("newVersionAvailable"), JAPModel.getString("newVersionNo"), JAPModel.getString("newVersionYes"), true, false);
                if (string2.equals(JAPModel.getString("newVersionYes"))) {
                    try {
                        versionchecker.registerProgress(jAPLoading);
                        versionchecker.getVersionFromNet("http://anon.inf.tu-dresden.de:80/~sk13/anon/jap/JAP.jar", JAPLocalFilename);
                        Thread thread = new Thread(versionchecker);
                        thread.start();
                        string2 = jAPLoading.message(JAPModel.getString("downloadingProgressTitle"), JAPModel.getString("downloadingProgress"), null, null, true, true);
                        thread.join();
                        n = versionchecker.getResult();
                        if (n != 0) {
                            throw new Exception("Error loading new version");
                        }
                        string2 = jAPLoading.message(JAPModel.getString("newVersionAvailableTitle"), JAPModel.getString("newVersionLoaded"), null, "OK", true, false);
                        this.goodBye();
                    }
                    catch (Exception exception) {
                        JAPDebug.out(3, 8, "JAPModel:versionCheck(): Exception" + exception);
                        JOptionPane.showMessageDialog(view, JAPModel.getString("downloadFailed") + JAPModel.getString("infoURL"), JAPModel.getString("downloadFailedTitle"), 0);
                        this.notifyJAPObservers();
                        return -1;
                    }
                } else {
                    string2 = jAPLoading.message(JAPModel.getString("youShouldUpdateTitle"), JAPModel.getString("youShouldUpdate") + JAPModel.getString("infoURL"), null, "OK", true, false);
                    this.notifyJAPObservers();
                    return -1;
                }
            }
            return 0;
        }
        catch (Exception exception) {
            JAPDebug.out(3, 8, "JAPModel: " + exception);
            JOptionPane.showMessageDialog(view, JAPModel.getString("errorConnectingInfoService"), JAPModel.getString("errorConnectingInfoServiceTitle"), 0);
            this.notifyJAPObservers();
            return -1;
        }
    }

    public void addJAPObserver(JAPObserver jAPObserver) {
        this.observerVector.addElement(jAPObserver);
    }

    public void notifyJAPObservers() {
        Vector vector = this.observerVector;
        synchronized (vector) {
            Enumeration enumeration = this.observerVector.elements();
            while (enumeration.hasMoreElements()) {
                JAPObserver jAPObserver = (JAPObserver)enumeration.nextElement();
                jAPObserver.valuesChanged(this);
            }
        }
    }

    private final class SetAnonModeAsync
    implements Runnable {
        boolean anonModeSelected = false;

        public SetAnonModeAsync(boolean bl) {
            this.anonModeSelected = bl;
        }

        public void run() {
            Object object = oSetAnonModeSyncObject;
            synchronized (object) {
                JAPDebug.out(7, 8, "JAPModel:setAnonMode(" + this.anonModeSelected + ")");
                if (JAPModel.this.proxyAnon == null && this.anonModeSelected) {
                    int n;
                    ((Component)view).setCursor(Cursor.getPredefinedCursor(3));
                    if (!JAPModel.this.alreadyCheckedForNewVersion && (n = JAPModel.this.versionCheck()) != -1) {
                        JAPModel.this.canStartService = true;
                        JAPModel.this.alreadyCheckedForNewVersion = true;
                    }
                    if (JAPModel.this.canStartService) {
                        if (JAPModel.this.proxyDirect != null) {
                            JAPModel.this.proxyDirect.stopService();
                        }
                        JAPModel.this.proxyDirect = null;
                        JAPModel.this.proxyAnon = new JAPAnonService(JAPModel.this.m_socketHTTPListener, 1);
                        AnonServerDBEntry anonServerDBEntry = model.getAnonServer();
                        if (model.getUseFirewall()) {
                            if (anonServerDBEntry.getSSLPort() == -1) {
                                model;
                                JAPView jAPView = JAPModel.getView();
                                model;
                                String string = JAPModel.getString("errorFirewallModeNotSupported");
                                model;
                                JOptionPane.showMessageDialog(jAPView, string, JAPModel.getString("errorFirewallModeNotSupportedTitle"), 0);
                                return;
                            }
                            JAPModel.this.proxyAnon;
                            JAPAnonService.setAnonService(anonServerDBEntry.getHost(), anonServerDBEntry.getSSLPort());
                            JAPModel.this.proxyAnon.setFirewall(model.getFirewallHost(), model.getFirewallPort());
                            if (model.getUseFirewallAuthorization()) {
                                JAPModel.this.proxyAnon.setFirewallAuthorization(model.getFirewallAuthUserID(), model.getFirewallAuthPasswd());
                            }
                            JAPModel.this.proxyAnon.connectViaFirewall(true);
                        } else {
                            JAPModel.this.proxyAnon;
                            JAPAnonService.setAnonService(anonServerDBEntry.getHost(), anonServerDBEntry.getPort());
                        }
                        int n2 = JAPModel.this.proxyAnon.start();
                        if (n2 == 0) {
                            Object[] objectArray = new Object[1];
                            model;
                            objectArray[0] = JAPModel.getString("okButton");
                            Object[] objectArray2 = objectArray;
                            model;
                            JCheckBox jCheckBox = new JCheckBox(JAPModel.getString("disableActCntMessageNeverRemind"));
                            Object[] objectArray3 = new Object[2];
                            model;
                            objectArray3[0] = JAPModel.getString("disableActCntMessage");
                            objectArray3[1] = jCheckBox;
                            Object[] objectArray4 = objectArray3;
                            if (!JAPModel.this.mbActCntMessageNotRemind) {
                                n2 = 0;
                                model;
                                JAPView jAPView = JAPModel.getView();
                                model;
                                n2 = JOptionPane.showOptionDialog(jAPView, objectArray4, JAPModel.getString("disableActCntMessageTitle"), -1, 2, null, objectArray2, objectArray2[0]);
                                JAPModel.this.mbActCntMessageNeverRemind = jCheckBox.isSelected();
                                JAPModel.this.mbDoNotAbuseReminder = jCheckBox.isSelected();
                                if (JAPModel.this.mbActCntMessageNeverRemind) {
                                    JAPModel.this.mbActCntMessageNotRemind = true;
                                }
                            }
                            JAPModel jAPModel = model;
                            model;
                            jAPModel.status2 = JAPModel.getString("statusRunning");
                            JAPModel.this.proxyAnon.setAnonServiceListener(model);
                            feedback = new JAPFeedback();
                            feedback.startRequests();
                            ((Component)view).setCursor(Cursor.getDefaultCursor());
                            JAPModel.this.notifyJAPObservers();
                            JAPSetAnonModeSplash.abort();
                            return;
                        }
                        if (n2 == -8) {
                            Object[] objectArray = new Object[]{new Integer(JAPModel.this.portNumber)};
                            model;
                            String string = MessageFormat.format(JAPModel.getString("errorListenerPort"), objectArray);
                            model;
                            JAPView jAPView = JAPModel.getView();
                            model;
                            JOptionPane.showMessageDialog(jAPView, string, JAPModel.getString("errorListenerPortTitle"), 0);
                            JAPDebug.out(0, 2, "Listener could not be started!");
                            model;
                            JAPModel.getView().disableSetAnonMode();
                        } else {
                            JOptionPane.showMessageDialog(JAPModel.getView(), JAPModel.getString("errorConnectingFirstMix") + "\n" + JAPModel.getString("errorCode") + ": " + Integer.toString(n2), JAPModel.getString("errorConnectingFirstMixTitle"), 0);
                        }
                        JAPModel.this.proxyAnon = null;
                        ((Component)view).setCursor(Cursor.getDefaultCursor());
                        JAPModel jAPModel = model;
                        model;
                        jAPModel.status2 = JAPModel.getString("statusNotRunning");
                        JAPModel.this.notifyJAPObservers();
                        JAPSetAnonModeSplash.abort();
                        JAPModel.this.setAnonMode(false);
                    } else {
                        ((Component)view).setCursor(Cursor.getDefaultCursor());
                        JAPSetAnonModeSplash.abort();
                    }
                } else if (JAPModel.this.proxyDirect == null && !this.anonModeSelected) {
                    if (JAPModel.this.proxyAnon != null) {
                        JAPSetAnonModeSplash.start(false);
                        JAPModel.this.proxyAnon.stop();
                    }
                    JAPModel.this.proxyAnon = null;
                    if (feedback != null) {
                        feedback.stopRequests();
                        feedback = null;
                    }
                    JAPModel jAPModel = model;
                    model;
                    jAPModel.status2 = JAPModel.getString("statusNotRunning");
                    JAPModel.this.proxyDirect = new JAPDirectProxy(JAPModel.this.m_socketHTTPListener);
                    JAPModel.this.proxyDirect.startService();
                    model.getAnonServer().setMixedPackets(-1);
                    model.getAnonServer().setNrOfActiveUsers(-1);
                    model.getAnonServer().setTrafficSituation(-1);
                    model.getAnonServer().setCurrentRisk(-1);
                    JAPModel.this.notifyJAPObservers();
                    JAPSetAnonModeSplash.abort();
                }
            }
        }
    }
}

