/*
 * Decompiled with CFR 0.152.
 */
import HTTPClient.Codecs;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.NVPair;
import java.net.InetAddress;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class JAPInfoService {
    private static final String DP = "%3A";
    JAPModel model = JAPModel.getModel();
    HTTPConnection conInfoService = null;

    public JAPInfoService() {
        this.setInfoService(this.model.getInfoServiceHost(), this.model.getInfoServicePort());
    }

    public int setInfoService(String string, int n) {
        try {
            HTTPConnection.removeDefaultModule(Class.forName("HTTPClient.AuthorizationModule"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conInfoService = new HTTPConnection(string, n);
        NVPair[] nVPairArray = new NVPair[]{new NVPair("Cache-Control", "no-cache"), new NVPair("Pragma", "no-cache")};
        this.replaceHeader(this.conInfoService, nVPairArray[0]);
        this.replaceHeader(this.conInfoService, nVPairArray[1]);
        if (this.model.getUseFirewall()) {
            this.setProxy(this.model.getFirewallHost(), this.model.getFirewallPort(), this.model.getFirewallAuthUserID(), this.model.getFirewallAuthPasswd());
        } else {
            this.setProxy(null, 0, null, null);
        }
        this.conInfoService.setAllowUserInteraction(false);
        this.conInfoService.setTimeout(10000);
        return 0;
    }

    private int replaceHeader(HTTPConnection hTTPConnection, NVPair nVPair) {
        NVPair[] nVPairArray = hTTPConnection.getDefaultHeaders();
        if (nVPairArray == null || nVPairArray.length == 0) {
            nVPairArray = new NVPair[]{nVPair};
            hTTPConnection.setDefaultHeaders(nVPairArray);
            return 0;
        }
        int n = nVPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nVPairArray[n2].getName().equalsIgnoreCase(nVPair.getName())) {
                nVPairArray[n2] = nVPair;
                hTTPConnection.setDefaultHeaders(nVPairArray);
                return 0;
            }
            ++n2;
        }
        NVPair[] nVPairArray2 = new NVPair[n + 1];
        int n3 = 0;
        while (n3 < n) {
            nVPairArray2[n3] = nVPairArray[n3];
            ++n3;
        }
        nVPairArray2[n] = nVPair;
        hTTPConnection.setDefaultHeaders(nVPairArray2);
        return 0;
    }

    public int setProxy(String string, int n, String string2, String string3) {
        if (this.conInfoService == null) {
            return -1;
        }
        HTTPConnection.setProxyServer(string, n);
        this.conInfoService.setCurrentProxy(string, n);
        if (string2 != null) {
            String string4 = Codecs.base64Encode(string2 + ":" + string3);
            NVPair nVPair = new NVPair("Proxy-Authorization", "Basic " + string4);
            this.replaceHeader(this.conInfoService, nVPair);
        }
        return 0;
    }

    public void fetchAnonServers() throws Exception {
        Object object;
        Object object2;
        HTTPResponse hTTPResponse = this.conInfoService.Get("/servers");
        try {
            object2 = hTTPResponse.listHeaders();
            JAPDebug.out(7, 2, "HTTPResponse: " + Integer.toString(hTTPResponse.getStatusCode()));
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                JAPDebug.out(7, 2, (String)object + ": " + hTTPResponse.getHeader((String)object));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(hTTPResponse.getInputStream());
        this.model.anonServerDatabase.clean();
        object = object2.getElementsByTagName("MixCascade");
        int n = 0;
        while (n < object.getLength()) {
            Element element = (Element)object.item(n);
            NodeList nodeList = element.getElementsByTagName("Name");
            String string = nodeList.item(0).getFirstChild().getNodeValue().trim();
            nodeList = element.getElementsByTagName("IP");
            String string2 = nodeList.item(0).getFirstChild().getNodeValue().trim();
            int n2 = JAPUtil.parseNodeInt(element, "Port", -1);
            int n3 = JAPUtil.parseNodeInt(element, "ProxyPort", -1);
            AnonServerDBEntry anonServerDBEntry = new AnonServerDBEntry(string, string2, n2, n3);
            nodeList = element.getElementsByTagName("CurrentStatus");
            if (nodeList != null && nodeList.getLength() > 0) {
                Element element2 = (Element)nodeList.item(0);
                int n4 = JAPUtil.parseElementAttrInt(element2, "ActiveUsers", -1);
                anonServerDBEntry.setNrOfActiveUsers(n4);
                int n5 = JAPUtil.parseElementAttrInt(element2, "CurrentRisk", -1);
                anonServerDBEntry.setCurrentRisk(n5);
                int n6 = JAPUtil.parseElementAttrInt(element2, "TrafficSituation", -1);
                anonServerDBEntry.setTrafficSituation(n6);
                int n7 = JAPUtil.parseElementAttrInt(element2, "MixedPackets", -1);
                anonServerDBEntry.setMixedPackets(n7);
            }
            this.model.anonServerDatabase.addEntry(anonServerDBEntry);
            ++n;
        }
    }

    public void getFeedback(AnonServerDBEntry anonServerDBEntry) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        try {
            byte[] byArray = InetAddress.getByName(anonServerDBEntry.getHost()).getAddress();
            String string = "/feedback/" + Integer.toString(byArray[0] & 0xFF) + "." + Integer.toString(byArray[1] & 0xFF) + "." + Integer.toString(byArray[2] & 0xFF) + "." + Integer.toString(byArray[3] & 0xFF) + DP + Integer.toString(anonServerDBEntry.getPort());
            HTTPResponse hTTPResponse = this.conInfoService.Get(string);
            if (hTTPResponse.getStatusCode() != 200) {
                JAPDebug.out(3, 2, "JAPFeedback: Bad response from server: " + hTTPResponse.getReasonLine());
            } else {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(hTTPResponse.getInputStream());
                Element element = document.getDocumentElement();
                n = JAPUtil.parseElementAttrInt(element, "nrOfActiveUsers", -1);
                n2 = JAPUtil.parseElementAttrInt(element, "trafficSituation", -1);
                n3 = JAPUtil.parseElementAttrInt(element, "currentRisk", -1);
                n4 = JAPUtil.parseElementAttrInt(element, "mixedPackets", -1);
                n5 = JAPUtil.parseElementAttrInt(element, "anonLevel", -1);
            }
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPInfoService - Feedback: " + exception);
        }
        anonServerDBEntry.setNrOfActiveUsers(n);
        anonServerDBEntry.setTrafficSituation(n2);
        anonServerDBEntry.setCurrentRisk(n3);
        anonServerDBEntry.setMixedPackets(n4);
        anonServerDBEntry.setAnonLevel(n5);
        JAPDebug.out(7, 8, "JAPFeedback: " + n + "/" + n2 + "/" + n3 + "/" + n4 + "/" + n5);
    }

    public String getNewVersionNumber() throws Exception {
        try {
            HTTPResponse hTTPResponse = this.conInfoService.Get("/aktVersion");
            if (hTTPResponse == null || hTTPResponse.getStatusCode() != 200) {
                throw new Exception("Versioncheck bad response from server: " + hTTPResponse.getReasonLine());
            }
            byte[] byArray = hTTPResponse.getData();
            String string = new String(byArray).trim();
            JAPDebug.out(7, 2, "New Version: " + string);
            if (string.charAt(2) == '.' && string.charAt(5) == '.') {
                return string;
            }
            throw new Exception("Versionfile has wrong format! Found: \"" + string + "\". Should be \"nn.nn.nnn\"!");
        }
        catch (Exception exception) {
            throw new Exception("Versioncheck getNewVersionnumberFromNet() failed: " + exception);
        }
    }
}

