/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class JAPHelp
extends JDialog
implements ActionListener {
    private JAPModel model = JAPModel.getModel();
    private String helpPath = " ";
    private String helpLang = " ";
    private JComboBox language;
    HtmlPane html;

    public JAPHelp(JFrame jFrame) {
        super(jFrame, JAPModel.getString("helpWindow"), false);
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void init() {
        this.html = new HtmlPane(JAPModel.getString("helpPath1"));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.language = new JComboBox();
        jPanel.add(this.language);
        jPanel.add(new JLabel("   "));
        JButton jButton = new JButton(JAPModel.getString("closeButton"));
        jPanel.add(jButton);
        jPanel.add(new JLabel("   "));
        this.getContentPane().add((Component)this.html, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(this);
        this.language.addActionListener(this);
        int n = 1;
        while (n < 6) {
            try {
                this.helpPath = JAPModel.getString("helpPath" + String.valueOf(n));
                this.helpLang = JAPModel.getString("lang" + String.valueOf(n));
                if (!this.helpLang.equals("lang" + String.valueOf(n))) {
                    this.language.addItem(this.helpLang);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        this.pack();
        JAPUtil.centerFrame(this);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width = Math.min(dimension.width - 50, 600);
        dimension.height = Math.min(dimension.height - 80, 350);
        return dimension;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.language) {
            this.helpPath = JAPModel.getString("helpPath" + String.valueOf(this.language.getSelectedIndex() + 1));
            this.html.load(this.helpPath);
        } else {
            this.closePressed();
        }
    }

    private void closePressed() {
        ((Component)this).setVisible(false);
    }
}

