/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class JAPDirectProxyResponse
implements Runnable {
    private int threadNumber;
    private static int threadCount;
    private OutputStream outputStream;
    private InputStream inputStream;

    public JAPDirectProxyResponse(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public void run() {
        this.threadNumber = this.getThreadNumber();
        JAPDebug.out(7, 2, "R(" + this.threadNumber + ") - Response thread started.");
        try {
            int n;
            byte[] byArray = new byte[1000];
            while ((n = this.inputStream.read(byArray)) != -1) {
                if (n <= 0) continue;
                this.outputStream.write(byArray, 0, n);
            }
            this.outputStream.flush();
            JAPDebug.out(7, 2, "R(" + this.threadNumber + ") - EOF from Server.");
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            JAPDebug.out(5, 2, "R(" + this.threadNumber + ") - Exception during transmission: " + exception);
        }
        try {
            this.inputStream.close();
            this.outputStream.close();
        }
        catch (Exception exception) {
            JAPDebug.out(2, 2, "R(" + this.threadNumber + ") - Exception while closing: " + exception.toString());
        }
        JAPDebug.out(7, 2, "R(" + this.threadNumber + ") - Response thread stopped.");
    }

    private synchronized int getThreadNumber() {
        return threadCount++;
    }
}

