/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import kasper.net.RemoteFile;
import kasper.net.ftp.FTPClient;
import kasper.net.ftp.FTPServerResponse;

final class JAPDirectProxyConnection
implements Runnable {
    private Socket clientSocket;
    private int threadNumber;
    private static int threadCount;
    private DataInputStream inputStream = null;
    private String requestLine = null;
    private String method = "";
    private String uri = "";
    private String protocol = "";
    private String version = "";
    private String host = "";
    private String file = "";
    private int port = -1;

    public JAPDirectProxyConnection(Socket socket) {
        this.clientSocket = socket;
    }

    public void run() {
        Object object;
        this.threadNumber = this.getThreadNumber();
        JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - New connection handler started.");
        try {
            this.inputStream = new DataInputStream(this.clientSocket.getInputStream());
            this.requestLine = JAPUtil.readLine(this.inputStream);
            object = new StringTokenizer(this.requestLine);
            this.method = ((StringTokenizer)object).nextToken();
            this.uri = ((StringTokenizer)object).nextToken();
            if (((StringTokenizer)object).hasMoreTokens()) {
                this.version = ((StringTokenizer)object).nextToken();
            }
        }
        catch (Exception exception) {
            this.badRequest();
            return;
        }
        try {
            if (this.method.equalsIgnoreCase("CONNECT")) {
                int n = this.uri.indexOf(58);
                if (n > 0) {
                    this.host = this.uri.substring(0, n);
                    this.port = Integer.parseInt(this.uri.substring(n + 1));
                    this.handleCONNECT();
                } else {
                    this.badRequest();
                }
            } else if (this.method.equalsIgnoreCase("GET") || this.method.equalsIgnoreCase("POST") || this.method.equalsIgnoreCase("PUT") || this.method.equalsIgnoreCase("DELETE") || this.method.equalsIgnoreCase("TRACE") || this.method.equalsIgnoreCase("OPTIONS") || this.method.equalsIgnoreCase("HEAD")) {
                object = new URL(this.uri);
                this.protocol = ((URL)object).getProtocol();
                this.host = ((URL)object).getHost();
                this.port = ((URL)object).getPort();
                if (this.port == -1) {
                    this.port = 80;
                }
                this.file = ((URL)object).getFile();
                if (this.protocol.equalsIgnoreCase("http")) {
                    this.handleHTTP();
                } else if (this.protocol.equalsIgnoreCase("ftp")) {
                    this.handleFTP();
                } else {
                    this.unknownProtocol();
                }
            } else {
                this.badRequest();
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.cannotConnect();
        }
        catch (Exception exception) {
            JAPDebug.out(5, 2, "C(" + this.threadNumber + ") - Exception: " + exception);
            this.badRequest();
        }
        try {
            this.clientSocket.close();
        }
        catch (Exception exception) {
            JAPDebug.out(2, 2, "C(" + this.threadNumber + ") - Exception while closing socket: " + exception);
        }
    }

    private void responseTemplate(String string, String string2) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
            bufferedWriter.write("HTTP/1.0 " + string + "\r\n");
            bufferedWriter.write("Content-type: text/html\r\n");
            bufferedWriter.write("Pragma: no-cache\r\n");
            bufferedWriter.write("Cache-Control: no-cache\r\n\r\n");
            bufferedWriter.write("<HTML><TITLE>" + string2 + "</TITLE>");
            bufferedWriter.write("<H1>" + string + "</H1>");
            bufferedWriter.write("<P>" + string2 + "</P>");
            bufferedWriter.write("</HTML>\n");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            JAPDebug.out(2, 2, "C(" + this.threadNumber + ") - Exception: " + exception);
        }
    }

    private void cannotConnect() {
        this.responseTemplate("404 Connection error", "Cannot connect to " + this.host + ":" + this.port + ".");
    }

    private void unknownProtocol() {
        this.responseTemplate("501 Not implemented", "Protocol <B>" + this.protocol + "</B> not implemented, supported or unknown.");
    }

    private void badRequest() {
        this.responseTemplate("400 Bad Request", "Bad request: " + this.requestLine);
    }

    private void handleCONNECT() throws Exception {
        int n;
        Socket socket = new Socket(this.host, this.port);
        String string = JAPUtil.readLine(this.inputStream);
        JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Header: >" + string + "<");
        while (string.length() != 0) {
            string = JAPUtil.readLine(this.inputStream);
            JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Header: >" + string + "<");
        }
        OutputStream outputStream = socket.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
        bufferedWriter.write("HTTP/1.0 200 Connection established\r\n\r\n");
        bufferedWriter.flush();
        JAPDirectProxyResponse jAPDirectProxyResponse = new JAPDirectProxyResponse(socket.getInputStream(), this.clientSocket.getOutputStream());
        Thread thread = new Thread(jAPDirectProxyResponse);
        thread.start();
        byte[] byArray = new byte[1000];
        while ((n = this.inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        JAPDebug.out(7, 2, "\n");
        JAPDebug.out(7, 4, "C(" + this.threadNumber + ") - Waiting for resonse thread...");
        thread.join();
        JAPDebug.out(7, 4, "C(" + this.threadNumber + ") -                           ...finished!");
        bufferedWriter.close();
        outputStream.close();
        this.inputStream.close();
        socket.close();
    }

    private void handleHTTP() throws Exception {
        int n;
        Socket socket = new Socket(this.host, this.port);
        OutputStream outputStream = socket.getOutputStream();
        String string = "";
        string = string + this.method + " " + this.file + " " + "HTTP/1.0";
        JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - ProtocolString: >" + string + "<");
        outputStream.write((string + "\r\n").getBytes());
        String string2 = JAPUtil.readLine(this.inputStream);
        JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Header: >" + string2 + "<");
        while (string2.length() != 0) {
            if (!this.filter(string2)) {
                outputStream.write((string2 + "\r\n").getBytes());
            } else {
                JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Header " + string2 + " filtered");
            }
            string2 = JAPUtil.readLine(this.inputStream);
            JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Header: >" + string2 + "<");
        }
        outputStream.write("\r\n".getBytes());
        outputStream.flush();
        JAPDirectProxyResponse jAPDirectProxyResponse = new JAPDirectProxyResponse(socket.getInputStream(), this.clientSocket.getOutputStream());
        Thread thread = new Thread(jAPDirectProxyResponse);
        thread.start();
        JAPDebug.out(7, 2, "C(" + this.threadNumber + ") - Headers sended, POST data may follow");
        byte[] byArray = new byte[1000];
        while ((n = this.inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        JAPDebug.out(7, 2, "\n");
        JAPDebug.out(7, 4, "C(" + this.threadNumber + ") - Waiting for resonse thread...");
        thread.join();
        JAPDebug.out(7, 4, "C(" + this.threadNumber + ") -                  ...finished!");
        outputStream.close();
        this.inputStream.close();
        socket.close();
    }

    private void handleFTP() {
        try {
            String string = "</pre></body></html>";
            String string2 = "</pre></h4><hr><pre>";
            OutputStream outputStream = this.clientSocket.getOutputStream();
            String string3 = JAPUtil.readLine(this.inputStream);
            FTPServerResponse fTPServerResponse = null;
            MyFTPClient myFTPClient = new MyFTPClient();
            fTPServerResponse = myFTPClient.connect(this.host);
            fTPServerResponse = myFTPClient.user("anonymous");
            fTPServerResponse = myFTPClient.pass("JAP@xxx.com");
            String[] stringArray = fTPServerResponse.getResponses();
            fTPServerResponse = myFTPClient.pasv();
            String string4 = this.file;
            fTPServerResponse = myFTPClient.cwd(this.file);
            if (fTPServerResponse.getResponseCode() == 250) {
                String string5 = this.uri;
                if (!string5.endsWith("/")) {
                    string5 = string5 + "/";
                }
                outputStream.write("HTTP/1.0 200 Ok\n\rContent-Type: text/html\r\n\r\n<html><head><title>FTP root at ".getBytes());
                outputStream.write(string5.getBytes());
                outputStream.write("</title></head><body><h2>FTP root at ".getBytes());
                outputStream.write(string5.getBytes());
                outputStream.write("</h2><hr><h4><pre>".getBytes());
                int n = 0;
                while (n < stringArray.length) {
                    outputStream.write(stringArray[n].getBytes());
                    outputStream.write(10);
                    ++n;
                }
                outputStream.write("</pre></h4><hr><pre>".getBytes());
                FTPServerResponse[] fTPServerResponseArray = myFTPClient.list();
                RemoteFile[] remoteFileArray = fTPServerResponseArray[0].getRemoteFiles();
                StringBuffer stringBuffer = new StringBuffer(256);
                stringBuffer.append(' ');
                int n2 = 0;
                while (n2 < remoteFileArray.length) {
                    String string6 = "          " + Long.toString(remoteFileArray[n2].length());
                    string6 = string6.substring(string6.length() - 10);
                    stringBuffer.append(remoteFileArray[n2].getProtections());
                    stringBuffer.append(string6);
                    if (remoteFileArray[n2].isDirectory()) {
                        stringBuffer.append(" Directory ");
                        stringBuffer.append("<a href=\"");
                        stringBuffer.append(string5);
                        stringBuffer.append(remoteFileArray[n2].getName());
                        stringBuffer.append("/\"><b>");
                        stringBuffer.append(remoteFileArray[n2].getName());
                        stringBuffer.append("</b></a><br>");
                    } else {
                        stringBuffer.append("    File   ");
                        stringBuffer.append("<a href=\"");
                        stringBuffer.append(string5);
                        stringBuffer.append(remoteFileArray[n2].getName());
                        stringBuffer.append("\">");
                        stringBuffer.append(remoteFileArray[n2].getName());
                        stringBuffer.append("</a><br>");
                    }
                    outputStream.write(stringBuffer.toString().getBytes());
                    stringBuffer.setLength(1);
                    ++n2;
                }
                outputStream.write(string.getBytes());
            } else {
                FTPServerResponse[] fTPServerResponseArray = null;
                fTPServerResponse = myFTPClient.type(4098);
                fTPServerResponseArray = myFTPClient.list(this.file);
                long l = fTPServerResponseArray[0].getRemoteFiles()[0].length();
                outputStream.write(("HTTP/1.0 200 Ok\r\nContent-Type: application/octet-stream\r\nContent-Length: " + Long.toString(l) + "\r\n\r\n").getBytes());
                fTPServerResponse = myFTPClient.pasv();
                fTPServerResponseArray = myFTPClient.retr(this.file, outputStream);
            }
            myFTPClient.quit();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean filter(String string) {
        String string2 = "Proxy-Connection";
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    private synchronized int getThreadNumber() {
        return threadCount++;
    }

    private class MyFTPClient
    extends FTPClient {
        public FTPServerResponse[] retr(String string, OutputStream outputStream) throws IOException {
            int n;
            if (this.openConnection) {
                this.dataConnection = new Socket(InetAddress.getByName(this.remoteDataIP), this.remoteDataPort);
                this.dataConnection.setSoTimeout(30000);
            }
            FTPServerResponse fTPServerResponse = this.execute("retr ", string);
            InputStream inputStream = this.dataConnection.getInputStream();
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            this.dataConnection.close();
            return null;
        }

        public FTPServerResponse connect(String string, int n) throws UnknownHostException, IOException {
            try {
                FTPServerResponse fTPServerResponse = super.connect(string, n);
                this.controlConnection.setSoTimeout(30000);
                return fTPServerResponse;
            }
            catch (UnknownHostException unknownHostException) {
                throw unknownHostException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
    }
}

