/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class JAPDirectProxy
implements Runnable {
    private volatile boolean runFlag;
    private boolean isRunningProxy = false;
    private int portN;
    private ServerSocket socketListener;
    private Thread threadRunLoop;
    private ThreadGroup threadgroupAll;
    private JAPModel model;
    private boolean warnUser = true;

    public JAPDirectProxy(ServerSocket serverSocket) {
        this.socketListener = serverSocket;
        this.warnUser = true;
        this.isRunningProxy = false;
        this.model = JAPModel.getModel();
    }

    public boolean startService() {
        if (this.socketListener == null) {
            return false;
        }
        this.threadgroupAll = new ThreadGroup("directproxy");
        this.threadRunLoop = new Thread(this);
        this.threadRunLoop.start();
        this.isRunningProxy = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.runFlag = true;
        try {
            while (this.runFlag) {
                Thread thread;
                Runnable runnable;
                Socket socket = null;
                try {
                    socket = this.socketListener.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (SocketException socketException) {
                    JAPDebug.out(3, 2, "JAPDirectProxy:DirectProxy.run() accept socket excpetion: " + socketException);
                    break;
                }
                try {
                    socket.setSoTimeout(0);
                }
                catch (SocketException socketException) {
                    JAPDebug.out(3, 2, "JAPDirectProxy:DirectProxy.run() Colud not set sockt to blocking mode! Excpetion: " + socketException);
                    socket = null;
                    continue;
                }
                if (this.warnUser) {
                    runnable = new JAPDirectConnection(socket);
                    thread = new Thread(this.threadgroupAll, runnable);
                    thread.start();
                    this.warnUser = false;
                    continue;
                }
                if (this.model.getUseFirewall()) {
                    runnable = new JAPDirectConViaProxy(socket);
                    thread = new Thread(this.threadgroupAll, runnable);
                    thread.start();
                    continue;
                }
                runnable = new JAPDirectProxyConnection(socket);
                thread = new Thread(this.threadgroupAll, runnable);
                thread.start();
            }
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPDirectProxy:DirectProxy.run() Exception: " + exception);
        }
        this.isRunningProxy = false;
        JAPDebug.out(6, 2, "JAPDirect:DircetProxyServer stopped.");
    }

    public void stopService() {
        this.runFlag = false;
        try {
            this.threadRunLoop.join(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.threadgroupAll != null) {
            try {
                this.threadgroupAll.stop();
                this.threadgroupAll.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.threadgroupAll = null;
        this.threadRunLoop = null;
    }

    private final class JAPDirectConViaProxy
    implements Runnable {
        private JAPModel model;
        private Socket clientSocket;

        public JAPDirectConViaProxy(Socket socket) {
            this.clientSocket = socket;
            this.model = JAPModel.getModel();
        }

        public void run() {
            try {
                int n;
                Object object;
                InputStream inputStream = this.clientSocket.getInputStream();
                Socket socket = new Socket(this.model.getFirewallHost(), this.model.getFirewallPort());
                JAPDirectProxyResponse jAPDirectProxyResponse = new JAPDirectProxyResponse(socket.getInputStream(), this.clientSocket.getOutputStream());
                Thread thread = new Thread(jAPDirectProxyResponse);
                thread.start();
                OutputStream outputStream = socket.getOutputStream();
                if (this.model.getUseFirewallAuthorization()) {
                    object = JAPUtil.readLine(inputStream);
                    object = (String)object + "\r\n";
                    outputStream.write(((String)object).getBytes());
                    object = JAPUtil.getProxyAuthorization(this.model.getFirewallAuthUserID(), this.model.getFirewallAuthPasswd());
                    outputStream.write(((String)object).getBytes());
                }
                object = new byte[1000];
                while ((n = inputStream.read((byte[])object)) != -1) {
                    if (n <= 0) continue;
                    outputStream.write((byte[])object, 0, n);
                }
                outputStream.flush();
                thread.join();
                outputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                JAPDebug.out(2, 2, "JAPDirectConViaProxy: Exception: " + exception);
            }
        }
    }

    private final class JAPDirectConnection
    implements Runnable {
        private JAPModel model;
        private Socket s;
        private SimpleDateFormat dateFormatHTTP;

        public JAPDirectConnection(Socket socket) {
            this.s = socket;
            this.model = JAPModel.getModel();
            this.dateFormatHTTP = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.dateFormatHTTP.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public void run() {
            try {
                String string = this.dateFormatHTTP.format(new Date());
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream()));
                bufferedWriter.write("HTTP/1.1 200 OK\r\n");
                bufferedWriter.write("Content-type: text/html\r\n");
                bufferedWriter.write("Expires: " + string + "\r\n");
                bufferedWriter.write("Date: " + string + "\r\n");
                bufferedWriter.write("Pragma: no-cache\r\n");
                bufferedWriter.write("Cache-Control: no-cache\r\n\r\n");
                bufferedWriter.write("<HTML><TITLE>JAP</TITLE>\n");
                bufferedWriter.write("<PRE>" + string + "</PRE>\n");
                bufferedWriter.write(JAPModel.getString("htmlAnonModeOff"));
                bufferedWriter.write("</HTML>\n");
                bufferedWriter.flush();
                bufferedWriter.close();
                this.s.close();
            }
            catch (Exception exception) {
                JAPDebug.out(2, 2, "JAPFeedbackConnection: Exception: " + exception);
            }
        }
    }
}

