/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class JAPDebug
extends WindowAdapter
implements ActionListener {
    public static final int NUL = 0;
    public static final int GUI = 1;
    public static final int NET = 2;
    public static final int THREAD = 4;
    public static final int MISC = 8;
    public static final int EMERG = 0;
    public static final int ALERT = 1;
    public static final int EXCEPTION = 2;
    public static final int ERR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;
    private int debugtype = 15;
    private int debuglevel = 7;
    private JTextArea textareaConsole;
    private JDialog frameConsole;
    private boolean m_bConsole = false;
    private static final String[] strLevels = new String[]{"Emergency", "Alert    ", "Exception", "Error    ", "Warning  ", "Notice   ", "Info     ", "Debug    "};
    private static JAPDebug debug;
    private static SimpleDateFormat dateFormatter;

    private JAPDebug() {
        dateFormatter = new SimpleDateFormat("yyyy/MM/dd-hh:mm:ss, ");
    }

    public static JAPDebug create() {
        if (debug != null) {
            JAPDebug.out(1, 6, "Debug inialized twice - Big Bug!");
        } else {
            debug = new JAPDebug();
        }
        return debug;
    }

    public static void out(int n, int n2, String string) {
        if (n <= JAPDebug.debug.debuglevel && (JAPDebug.debug.debugtype & n2) != 0) {
            JAPDebug jAPDebug = debug;
            synchronized (jAPDebug) {
                String string2 = "[" + dateFormatter.format(new Date()) + strLevels[n] + "] " + string + "\n";
                if (!JAPDebug.debug.m_bConsole) {
                    System.err.print(string2);
                } else {
                    JAPDebug.debug.textareaConsole.append(string2);
                    JAPDebug.debug.textareaConsole.setCaretPosition(JAPDebug.debug.textareaConsole.getText().length());
                }
            }
        }
    }

    public static void setDebugType(int n) {
        JAPDebug.debug.debugtype = n;
    }

    public static int getDebugType() {
        return JAPDebug.debug.debugtype;
    }

    public static void setDebugLevel(int n) {
        if (n < 0 || n > 7) {
            return;
        }
        JAPDebug.debug.debuglevel = n;
    }

    public static int getDebugLevel() {
        return JAPDebug.debug.debuglevel;
    }

    public static final String[] getDebugLevels() {
        return strLevels;
    }

    public static void showConsole(boolean bl, Frame frame) {
        debug.internal_showConsole(bl, frame);
    }

    public static void setConsoleParent(Frame frame) {
        if (debug != null && JAPDebug.debug.m_bConsole && JAPDebug.debug.frameConsole != null) {
            JDialog jDialog = new JDialog(frame, "Debug-Console");
            jDialog.setContentPane(JAPDebug.debug.frameConsole.getContentPane());
            jDialog.addWindowListener(debug);
            ((Component)jDialog).setSize(JAPDebug.debug.frameConsole.getSize());
            ((Component)jDialog).setLocation(JAPDebug.debug.frameConsole.getLocation());
            ((Component)jDialog).setVisible(true);
            JAPDebug.debug.frameConsole.dispose();
            JAPDebug.debug.frameConsole = jDialog;
        }
    }

    public static boolean isShowConsole() {
        return JAPDebug.debug.m_bConsole;
    }

    public void internal_showConsole(boolean bl, Frame frame) {
        if (!bl && this.m_bConsole) {
            this.frameConsole.dispose();
            this.textareaConsole = null;
            this.frameConsole = null;
            this.m_bConsole = false;
        } else if (bl && !this.m_bConsole) {
            this.frameConsole = new JDialog(frame, "Debug-Console");
            this.textareaConsole = new JTextArea(null, 20, 30);
            this.textareaConsole.setEditable(false);
            Font font = Font.decode("Courier");
            if (font != null) {
                this.textareaConsole.setFont(font);
            }
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(JAPMessages.getString("bttnSaveAs") + "...", JAPUtil.loadImageIcon("saveicon.gif", true));
            jButton.setActionCommand("saveas");
            jButton.addActionListener(debug);
            JButton jButton2 = new JButton(JAPMessages.getString("bttnCopy"), JAPUtil.loadImageIcon("copyicon.gif", true));
            jButton2.setActionCommand("copy");
            jButton2.addActionListener(debug);
            JButton jButton3 = new JButton(JAPMessages.getString("bttnInsertConfig"));
            jButton3.setActionCommand("insertConfig");
            jButton3.addActionListener(debug);
            JButton jButton4 = new JButton(JAPMessages.getString("bttnDelete"), JAPUtil.loadImageIcon("deleteicon.gif", true));
            jButton4.setActionCommand("delete");
            jButton4.addActionListener(debug);
            JButton jButton5 = new JButton(JAPMessages.getString("bttnClose"), JAPUtil.loadImageIcon("exiticon.gif", true));
            jButton5.setActionCommand("close");
            jButton5.addActionListener(debug);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            jPanel.add(jButton2);
            gridBagConstraints.gridx = 3;
            gridBagLayout.setConstraints(jButton3, gridBagConstraints);
            jPanel.add(jButton3);
            gridBagConstraints.gridx = 4;
            gridBagLayout.setConstraints(jButton4, gridBagConstraints);
            jPanel.add(jButton4);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 5;
            gridBagLayout.setConstraints(jButton5, gridBagConstraints);
            jPanel.add(jButton5);
            this.frameConsole.getContentPane().add("North", jPanel);
            this.frameConsole.getContentPane().add("Center", new JScrollPane(this.textareaConsole));
            this.frameConsole.addWindowListener(this);
            this.frameConsole.pack();
            Dimension dimension = this.frameConsole.getToolkit().getScreenSize();
            Dimension dimension2 = this.frameConsole.getSize();
            ((Component)this.frameConsole).setLocation(dimension.width - dimension2.width, 0);
            ((Component)this.frameConsole).setVisible(true);
            this.m_bConsole = true;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.m_bConsole = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("saveas")) {
            this.saveLog();
        } else if (actionEvent.getActionCommand().equals("copy")) {
            this.textareaConsole.selectAll();
            this.textareaConsole.copy();
            this.textareaConsole.moveCaretPosition(this.textareaConsole.getCaretPosition());
        } else if (actionEvent.getActionCommand().equals("delete")) {
            this.textareaConsole.setText("");
        } else if (actionEvent.getActionCommand().equals("insertConfig")) {
            String string = JAPModel.getModel().getConfigurationAsXML();
            if (string == null) {
                this.textareaConsole.append("Error!! Could not get current configuration!\n");
            } else {
                this.textareaConsole.append(string + "\n");
            }
        } else {
            this.frameConsole.dispose();
            this.m_bConsole = false;
        }
    }

    private void saveLog() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showDialog(JAPDebug.debug.frameConsole, null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                JAPDebug.debug.textareaConsole.write(fileWriter);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(JAPDebug.debug.frameConsole, JAPMessages.getString("errWritingLog"), JAPMessages.getString("error"), 0);
            }
        }
    }

    private static void printDebugSettings() {
        System.out.println("JAPDebug: debugtype =" + Integer.toString(JAPDebug.debug.debugtype));
        System.out.println("JAPDebug: debuglevel=" + Integer.toString(JAPDebug.debug.debuglevel));
    }
}

