/*
 * Decompiled with CFR 0.152.
 */
import anon.JAPAnonService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class JAPConf
extends JDialog {
    public static final int PORT_TAB = 0;
    public static final int HTTP_TAB = 1;
    public static final int INFO_TAB = 2;
    public static final int ANON_TAB = 3;
    public static final int MISC_TAB = 4;
    private JAPModel m_Model;
    private JAPJIntField m_tfListenerPortNumber;
    private JCheckBox m_cbListenerIsLocal;
    private JCheckBox m_cbProxy;
    private JAPJIntField m_tfProxyPortNumber;
    private JTextField m_tfProxyHost;
    private JCheckBox m_cbProxyAuthentication;
    private JTextField m_tfProxyAuthenticationUserID;
    private JCheckBox m_cbAutoConnect;
    private JCheckBox m_cbStartupMinimized;
    private JAPJIntField m_tfMixPortNumber;
    private JAPJIntField m_tfMixPortNumberSSL;
    private JTextField m_tfMixHost;
    private String m_strMixName;
    private String m_strOldMixName;
    private JComboBox m_comboMixCascade;
    private JRadioButton m_rbMixStep1;
    private JRadioButton m_rbMixStep2;
    private JRadioButton m_rbMixStep3;
    private JButton m_bttnFetchCascades;
    private JAPJIntField m_tfInfoPortNumber;
    private JTextField m_tfInfoHost;
    private JCheckBox m_cbDebugGui;
    private JCheckBox m_cbDebugNet;
    private JCheckBox m_cbDebugThread;
    private JCheckBox m_cbDebugMisc;
    private JCheckBox m_cbShowDebugConsole;
    private JSlider m_sliderDebugLevel;
    private JComboBox m_comboLanguage;
    private boolean m_bIgnoreComboLanguageEvents = false;
    private JCheckBox m_cbDummyTraffic;
    private JTabbedPane m_Tabs;
    private JPanel m_pPort;
    private JPanel m_pFirewall;
    private JPanel m_pInfo;
    private JPanel m_pMix;
    private JPanel m_pMisc;
    private JFrame m_frmParent;
    private JAPConf m_JapConf;

    public JAPConf(JFrame jFrame) {
        super(jFrame);
        this.m_frmParent = jFrame;
        this.m_Model = JAPModel.getModel();
        this.setModal(true);
        this.setTitle(JAPModel.getString("settingsDialog"));
        this.m_JapConf = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.m_Tabs = new JTabbedPane();
        this.m_pPort = this.buildportPanel();
        this.m_pFirewall = this.buildhttpPanel();
        this.m_pInfo = this.buildinfoPanel();
        this.m_pMix = this.buildanonPanel();
        this.m_pMisc = this.buildmiscPanel();
        this.m_Tabs.addTab(JAPModel.getString("confListenerTab"), null, this.m_pPort);
        this.m_Tabs.addTab(JAPModel.getString("confProxyTab"), null, this.m_pFirewall);
        this.m_Tabs.addTab(JAPModel.getString("confInfoTab"), null, this.m_pInfo);
        this.m_Tabs.addTab(JAPModel.getString("confAnonTab"), null, this.m_pMix);
        this.m_Tabs.addTab(JAPModel.getString("confMiscTab"), null, this.m_pMisc);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(JAPModel.getString("bttnDefaultConfig"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.resetToDefault();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(JAPModel.getString("cancelButton"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.CancelPressed();
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(JAPModel.getString("okButton"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        jPanel2.add(jButton3);
        jPanel2.add(new JLabel("   "));
        this.getRootPane().setDefaultButton(jButton3);
        jPanel.add((Component)this.m_Tabs, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.updateValues();
        this.m_Tabs.setSelectedComponent(this.m_pMix);
        this.pack();
        JAPUtil.centerFrame(this);
    }

    protected JPanel buildportPanel() {
        Insets insets;
        JLabel jLabel = new JLabel(JAPModel.getString("settingsPort1"));
        JLabel jLabel2 = new JLabel(JAPModel.getString("settingsPort2"));
        this.m_tfListenerPortNumber = new JAPJIntField();
        this.m_tfListenerPortNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_cbListenerIsLocal = new JCheckBox(JAPModel.getString("settingsListenerCheckBox"));
        this.m_cbListenerIsLocal.setForeground(jLabel.getForeground());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(JAPModel.getString("settingsListenerBorder")));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(new EmptyBorder(5, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets = new Insets(0, 0, 3, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.m_tfListenerPortNumber, gridBagConstraints);
        jPanel2.add(this.m_tfListenerPortNumber);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel2.add(jSeparator);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_cbListenerIsLocal, gridBagConstraints);
        jPanel2.add(this.m_cbListenerIsLocal);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected JPanel buildhttpPanel() {
        Insets insets;
        this.m_cbProxy = new JCheckBox(JAPModel.getString("settingsProxyCheckBox"));
        this.m_tfProxyHost = new JTextField();
        this.m_tfProxyPortNumber = new JAPJIntField();
        this.m_tfProxyHost.setEnabled(this.m_Model.getUseFirewall());
        this.m_tfProxyPortNumber.setEnabled(this.m_Model.getUseFirewall());
        this.m_cbProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = JAPConf.this.m_cbProxy.isSelected();
                JAPConf.this.m_tfProxyHost.setEnabled(bl);
                JAPConf.this.m_tfProxyPortNumber.setEnabled(bl);
                JAPConf.this.m_cbProxyAuthentication.setEnabled(bl);
                JAPConf.this.m_tfProxyAuthenticationUserID.setEnabled(bl);
            }
        });
        this.m_tfProxyHost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_tfProxyPortNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_cbProxyAuthentication = new JCheckBox(JAPModel.getString("settingsProxyAuthenticationCheckBox"));
        this.m_tfProxyAuthenticationUserID = new JTextField();
        this.m_cbProxyAuthentication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.m_tfProxyAuthenticationUserID.setEnabled(JAPConf.this.m_cbProxyAuthentication.isSelected());
            }
        });
        JLabel jLabel = new JLabel(JAPModel.getString("settingsProxyHost"));
        JLabel jLabel2 = new JLabel(JAPModel.getString("settingsProxyPort"));
        JLabel jLabel3 = new JLabel(JAPMessages.getString("settingsProxyAuthUserID"));
        this.m_cbProxy.setForeground(jLabel2.getForeground());
        this.m_cbProxyAuthentication.setForeground(jLabel2.getForeground());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(JAPModel.getString("settingsProxyBorder")));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(new EmptyBorder(5, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets = new Insets(0, 0, 3, 0);
        gridBagLayout.setConstraints(this.m_cbProxy, gridBagConstraints);
        jPanel2.add(this.m_cbProxy);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.m_tfProxyHost, gridBagConstraints);
        jPanel2.add(this.m_tfProxyHost);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.m_tfProxyPortNumber, gridBagConstraints);
        jPanel2.add(this.m_tfProxyPortNumber);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel2.add(jSeparator);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_cbProxyAuthentication, gridBagConstraints);
        jPanel2.add(this.m_cbProxyAuthentication);
        gridBagConstraints.gridy = 7;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        gridBagConstraints.gridy = 8;
        gridBagLayout.setConstraints(this.m_tfProxyAuthenticationUserID, gridBagConstraints);
        jPanel2.add(this.m_tfProxyAuthenticationUserID);
        gridBagConstraints.gridy = 9;
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected JPanel buildinfoPanel() {
        Insets insets;
        this.m_tfInfoHost = new JTextField();
        this.m_tfInfoPortNumber = new JAPJIntField();
        this.m_tfInfoHost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_tfInfoPortNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        JLabel jLabel = new JLabel(JAPModel.getString("settingsInfoText"));
        JLabel jLabel2 = new JLabel(JAPModel.getString("settingsInfoHost"));
        JLabel jLabel3 = new JLabel(JAPModel.getString("settingsInfoPort"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(JAPModel.getString("settingsInfoBorder")));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBorder(new EmptyBorder(5, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets = new Insets(0, 0, 3, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.m_tfInfoHost, gridBagConstraints);
        jPanel2.add(this.m_tfInfoHost);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.m_tfInfoPortNumber, gridBagConstraints);
        jPanel2.add(this.m_tfInfoPortNumber);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    protected JPanel buildanonPanel() {
        this.m_cbStartupMinimized = new JCheckBox(JAPModel.getString("settingsstartupMinimizeCheckBox"));
        this.m_cbAutoConnect = new JCheckBox(JAPModel.getString("settingsautoConnectCheckBox"));
        this.m_tfMixHost = new JTextField();
        this.m_tfMixPortNumber = new JAPJIntField();
        this.m_tfMixPortNumberSSL = new JAPJIntField();
        this.m_tfMixHost.setEditable(false);
        this.m_tfMixPortNumber.setEditable(false);
        this.m_tfMixPortNumberSSL.setEditable(false);
        this.m_tfMixHost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_tfMixPortNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        this.m_tfMixPortNumberSSL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPConf.this.OKPressed();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_rbMixStep1 = new JRadioButton(JAPModel.getString("settingsAnonRadio1"), true);
        this.m_rbMixStep2 = new JRadioButton(JAPModel.getString("settingsAnonRadio2"));
        this.m_rbMixStep3 = new JRadioButton(JAPModel.getString("settingsAnonRadio3"));
        this.m_bttnFetchCascades = new JButton(JAPModel.getString("settingsAnonFetch"));
        this.m_bttnFetchCascades.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPDebug.out(7, 1, "JAPConf:m_bttnFetchCascades");
                Cursor cursor = JAPConf.this.getCursor();
                ((Component)JAPConf.this).setCursor(Cursor.getPredefinedCursor(3));
                JAPConf.this.m_Model.fetchAnonServers();
                if (((JAPConf)JAPConf.this).m_Model.anonServerDatabase.size() == 0) {
                    ((Component)JAPConf.this).setCursor(cursor);
                    JAPConf.this.m_Model;
                    JAPView jAPView = JAPModel.getView();
                    JAPConf.this.m_Model;
                    String string = JAPModel.getString("settingsNoServersAvailable");
                    JAPConf.this.m_Model;
                    JOptionPane.showMessageDialog(jAPView, string, JAPModel.getString("settingsNoServersAvailableTitle"), 1);
                } else {
                    JAPConf.this.updateValues();
                    JAPConf.this.m_rbMixStep2.doClick();
                    ((Component)JAPConf.this).setCursor(cursor);
                }
            }
        });
        this.m_comboMixCascade = new JComboBox();
        this.m_comboMixCascade.addItem(JAPModel.getString("settingsAnonSelect"));
        Enumeration enumeration = this.m_Model.anonServerDatabase.elements();
        while (enumeration.hasMoreElements()) {
            this.m_comboMixCascade.addItem(((AnonServerDBEntry)enumeration.nextElement()).getName());
        }
        this.m_comboMixCascade.setEnabled(false);
        this.m_comboMixCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnonServerDBEntry anonServerDBEntry;
                JAPDebug.out(7, 1, "JAPConf:Item " + JAPConf.this.m_comboMixCascade.getSelectedIndex() + " selected");
                if (JAPConf.this.m_comboMixCascade.getSelectedIndex() > 0 && (anonServerDBEntry = ((JAPConf)JAPConf.this).m_Model.anonServerDatabase.getEntry(JAPConf.this.m_comboMixCascade.getSelectedIndex() - 1)) != null) {
                    JAPConf.this.m_strMixName = anonServerDBEntry.getName();
                    JAPConf.this.m_strOldMixName = JAPConf.this.m_strMixName;
                    JAPConf.this.m_tfMixHost.setText(anonServerDBEntry.getHost());
                    JAPConf.this.m_tfMixPortNumber.setText(Integer.toString(anonServerDBEntry.getPort()));
                    int n = anonServerDBEntry.getSSLPort();
                    if (n == -1) {
                        JAPConf.this.m_tfMixPortNumberSSL.setText("");
                    } else {
                        JAPConf.this.m_tfMixPortNumberSSL.setText(Integer.toString(n));
                    }
                }
            }
        });
        buttonGroup.add(this.m_rbMixStep1);
        buttonGroup.add(this.m_rbMixStep2);
        buttonGroup.add(this.m_rbMixStep3);
        this.m_rbMixStep1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPDebug.out(7, 1, "JAPConf:m_rbMixStep1 selected");
                JAPConf.this.m_bttnFetchCascades.setEnabled(true);
                JAPConf.this.m_comboMixCascade.setEnabled(false);
                JAPConf.this.m_tfMixHost.setEditable(false);
                JAPConf.this.m_tfMixPortNumber.setEditable(false);
                JAPConf.this.m_tfMixPortNumberSSL.setEditable(false);
            }
        });
        this.m_rbMixStep2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPDebug.out(7, 1, "JAPConf:m_rbMixStep2 selected");
                JAPConf.this.m_bttnFetchCascades.setEnabled(false);
                JAPConf.this.m_comboMixCascade.setEnabled(true);
                JAPConf.this.m_comboMixCascade.setPopupVisible(true);
                JAPConf.this.m_tfMixHost.setEditable(false);
                JAPConf.this.m_tfMixPortNumber.setEditable(false);
                JAPConf.this.m_tfMixPortNumberSSL.setEditable(false);
            }
        });
        this.m_rbMixStep3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPDebug.out(7, 1, "JAPConf:m_rbMixStep3 selected");
                JAPConf.this.m_bttnFetchCascades.setEnabled(false);
                JAPConf.this.m_comboMixCascade.setEnabled(false);
                JAPConf.this.m_tfMixHost.setEditable(true);
                JAPConf.this.m_tfMixPortNumber.setEditable(true);
                JAPConf.this.m_tfMixPortNumberSSL.setEditable(true);
                JAPConf.this.m_Model;
                JAPConf.this.m_strMixName = JAPModel.getString("manual");
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(JAPModel.getString("settingsAnonBorder")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(JAPModel.getString("settingsAnonBorder2")));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(this.m_rbMixStep1);
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this.m_bttnFetchCascades);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.add(this.m_rbMixStep2);
        jPanel6.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel6.add(Box.createHorizontalGlue());
        jPanel6.add(this.m_comboMixCascade);
        jPanel4.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(8, 1));
        jPanel7.add(this.m_rbMixStep3);
        jPanel7.add(new JLabel(JAPModel.getString("settingsAnonHost")));
        jPanel7.add(this.m_tfMixHost);
        jPanel7.add(new JLabel(JAPModel.getString("settingsAnonPort")));
        jPanel7.add(this.m_tfMixPortNumber);
        jPanel7.add(new JLabel(JAPModel.getString("settingsAnonSSLPort")));
        jPanel7.add(this.m_tfMixPortNumberSSL);
        jPanel7.add(this.m_cbAutoConnect);
        jPanel2.add(jPanel4);
        jPanel3.add(jPanel7);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    protected JPanel buildmiscPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2));
        jPanel2.setBorder(new TitledBorder(JAPModel.getString("settingsLookAndFeelBorder")));
        jPanel2.add(new JLabel(JAPModel.getString("settingsLookAndFeel")));
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEnabled(false);
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            jComboBox.addItem(lookAndFeelInfoArray[n].getName());
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getInstalledLookAndFeels()[((JComboBox)itemEvent.getItemSelectable()).getSelectedIndex()].getClassName());
                        SwingUtilities.updateComponentTreeUI(JAPConf.this.m_frmParent);
                        SwingUtilities.updateComponentTreeUI(SwingUtilities.getRoot((JComboBox)itemEvent.getItemSelectable()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jPanel2.add(jComboBox);
        jPanel2.add(new JLabel(JAPModel.getString("settingsLanguage")));
        this.m_comboLanguage = new JComboBox();
        this.m_comboLanguage.addItem("Deutsch");
        this.m_comboLanguage.addItem("English");
        this.m_comboLanguage.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (!JAPConf.this.m_bIgnoreComboLanguageEvents && itemEvent.getStateChange() == 1) {
                    try {
                        JOptionPane.showMessageDialog(JAPConf.this.m_JapConf, JAPMessages.getString("confLanguageChanged"), JAPMessages.getString("information"), 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jPanel2.add(this.m_comboLanguage);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(JAPModel.getString("miscconfigBorder")));
        JButton jButton = new JButton(JAPModel.getString("bttnPing"));
        JButton jButton2 = new JButton(JAPModel.getString("bttnMonitor"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Cursor cursor = JAPConf.this.getCursor();
                ((Component)JAPConf.this).setCursor(Cursor.getPredefinedCursor(3));
                JAPConf.this.m_Model.fetchAnonServers();
                JAPConf.this.m_Model;
                JAPCascadeMonitorView jAPCascadeMonitorView = new JAPCascadeMonitorView(JAPModel.getView());
                JAPConf.this.updateValues();
                JAPConf.this.OKPressed();
                ((Component)JAPConf.this).setCursor(cursor);
            }
        });
        this.m_cbDummyTraffic = new JCheckBox("Dummy Traffic");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(3, 1));
        jPanel4.add(jButton2);
        jPanel4.add(this.m_cbDummyTraffic);
        jPanel3.add((Component)jPanel4, "North");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.setBorder(new TitledBorder("Debugging"));
        JPanel jPanel6 = new JPanel(new GridLayout(0, 1));
        this.m_cbDebugGui = new JCheckBox("GUI");
        this.m_cbDebugNet = new JCheckBox("NET");
        this.m_cbDebugThread = new JCheckBox("THREAD");
        this.m_cbDebugMisc = new JCheckBox("MISC");
        jPanel6.add(this.m_cbDebugGui);
        jPanel6.add(this.m_cbDebugNet);
        jPanel6.add(this.m_cbDebugThread);
        jPanel6.add(this.m_cbDebugMisc);
        this.m_cbShowDebugConsole = new JCheckBox("Show Console");
        this.m_cbShowDebugConsole.setSelected(JAPDebug.isShowConsole());
        this.m_cbShowDebugConsole.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                JAPConf.this.m_Model;
                JAPDebug.showConsole(bl, JAPModel.getView());
            }
        });
        jPanel6.add(this.m_cbShowDebugConsole);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        this.m_sliderDebugLevel = new JSlider(1, 0, 7, 0);
        this.m_sliderDebugLevel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Dictionary dictionary = JAPConf.this.m_sliderDebugLevel.getLabelTable();
                int n = 0;
                while (n < 8) {
                    ((JLabel)dictionary.get(new Integer(n))).setEnabled(n <= JAPConf.this.m_sliderDebugLevel.getValue());
                    ++n;
                }
            }
        });
        String[] stringArray = JAPDebug.getDebugLevels();
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(stringArray.length, 1.0f);
        int n2 = 0;
        while (n2 < stringArray.length) {
            hashtable.put(new Integer(n2), new JLabel(" " + stringArray[n2]));
            ++n2;
        }
        this.m_sliderDebugLevel.setLabelTable(hashtable);
        this.m_sliderDebugLevel.setPaintLabels(true);
        this.m_sliderDebugLevel.setMajorTickSpacing(1);
        this.m_sliderDebugLevel.setMinorTickSpacing(1);
        this.m_sliderDebugLevel.setSnapToTicks(true);
        this.m_sliderDebugLevel.setPaintTrack(true);
        this.m_sliderDebugLevel.setPaintTicks(false);
        jPanel7.add(this.m_sliderDebugLevel);
        jPanel5.add(jPanel7);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add((Component)jPanel2, "North");
        jPanel8.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel5, "West");
        jPanel.add((Component)jPanel8, "Center");
        return jPanel;
    }

    protected void CancelPressed() {
        ((Component)this).setVisible(false);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, JAPModel.getString("ERROR"), 0);
    }

    private boolean checkValues() {
        int n;
        String string = null;
        string = this.m_tfInfoHost.getText().trim();
        if (string == null || string.equals("")) {
            this.showError(JAPModel.getString("errorInfoServiceHostNotNull"));
            return false;
        }
        try {
            n = Integer.parseInt(this.m_tfInfoPortNumber.getText().trim());
        }
        catch (Exception exception) {
            n = -1;
        }
        if (!JAPUtil.isPort(n)) {
            this.showError(JAPModel.getString("errorInfoServicePortWrong"));
            return false;
        }
        string = this.m_tfMixHost.getText().trim();
        if (string == null || string.equals("")) {
            this.showError(JAPModel.getString("errorAnonHostNotNull"));
            return false;
        }
        try {
            n = Integer.parseInt(this.m_tfMixPortNumber.getText().trim());
        }
        catch (Exception exception) {
            n = -1;
        }
        if (!JAPUtil.isPort(n)) {
            this.showError(JAPModel.getString("errorAnonServicePortWrong"));
            return false;
        }
        if (!this.m_tfMixPortNumberSSL.getText().trim().equals("")) {
            try {
                n = Integer.parseInt(this.m_tfMixPortNumberSSL.getText().trim());
            }
            catch (Exception exception) {
                n = -1;
            }
            if (!JAPUtil.isPort(n)) {
                this.showError(JAPModel.getString("errorAnonServicePortWrong"));
                return false;
            }
        }
        try {
            n = Integer.parseInt(this.m_tfListenerPortNumber.getText().trim());
        }
        catch (Exception exception) {
            n = -1;
        }
        if (!JAPUtil.isPort(n)) {
            this.showError(JAPModel.getString("errorListenerPortWrong"));
            return false;
        }
        int n2 = n;
        if (this.m_cbProxy.isSelected()) {
            string = this.m_tfProxyHost.getText().trim();
            if (string == null || string.equals("")) {
                this.showError(JAPModel.getString("errorFirewallHostNotNull"));
                return false;
            }
            try {
                n = Integer.parseInt(this.m_tfProxyPortNumber.getText().trim());
            }
            catch (Exception exception) {
                n = -1;
            }
            if (!JAPUtil.isPort(n)) {
                this.showError(JAPModel.getString("errorFirewallServicePortWrong"));
                return false;
            }
            if (this.m_cbProxyAuthentication.isSelected() && ((string = this.m_tfProxyAuthenticationUserID.getText().trim()) == null || string.equals(""))) {
                this.showError(JAPModel.getString("errorFirewallAuthUserIDNotNull"));
                return false;
            }
        }
        return true;
    }

    private void resetToDefault() {
        this.m_tfListenerPortNumber.setText(Integer.toString(4001));
        this.m_tfInfoHost.setText("infoservice.inf.tu-dresden.de");
        this.m_tfInfoPortNumber.setText(Integer.toString(6543));
        this.m_tfMixHost.setText("mix.inf.tu-dresden.de");
        this.m_tfMixPortNumber.setText(Integer.toString(6544));
        this.m_cbProxy.setSelected(false);
        this.m_cbStartupMinimized.setSelected(false);
        this.m_cbAutoConnect.setSelected(false);
        this.m_cbListenerIsLocal.setSelected(true);
        this.m_cbShowDebugConsole.setSelected(false);
        this.m_sliderDebugLevel.setValue(0);
        this.m_cbDebugNet.setSelected(false);
        this.m_cbDebugGui.setSelected(false);
        this.m_cbDebugMisc.setSelected(false);
        this.m_cbDebugThread.setSelected(false);
    }

    protected void OKPressed() {
        if (!this.checkValues()) {
            return;
        }
        ((Component)this).setVisible(false);
        this.m_Model.setListenerIsLocal(this.m_cbListenerIsLocal.isSelected());
        this.m_Model.setUseProxy(this.m_cbProxy.isSelected());
        this.m_Model.setUseFirewallAuthorization(this.m_cbProxyAuthentication.isSelected());
        int n = Integer.parseInt(this.m_tfListenerPortNumber.getText().trim());
        if (n != this.m_Model.getPortNumber()) {
            JOptionPane.showMessageDialog(this, JAPModel.getString("confmessageListernPortChanged"));
        }
        this.m_Model.setPortNumber(Integer.parseInt(this.m_tfListenerPortNumber.getText().trim()));
        int n2 = -1;
        try {
            n2 = Integer.parseInt(this.m_tfProxyPortNumber.getText().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Model.setProxy(this.m_tfProxyHost.getText().trim(), n2);
        this.m_Model.setFirewallAuthUserID(this.m_tfProxyAuthenticationUserID.getText().trim());
        this.m_Model.setInfoService(this.m_tfInfoHost.getText().trim(), Integer.parseInt(this.m_tfInfoPortNumber.getText().trim()));
        int n3 = -1;
        if (!this.m_tfMixPortNumberSSL.getText().equals("")) {
            n3 = Integer.parseInt(this.m_tfMixPortNumberSSL.getText().trim());
        }
        if (this.m_rbMixStep3.isSelected()) {
            this.m_strMixName = JAPModel.getString("manual");
        }
        AnonServerDBEntry anonServerDBEntry = new AnonServerDBEntry(this.m_strMixName, this.m_tfMixHost.getText().trim(), Integer.parseInt(this.m_tfMixPortNumber.getText().trim()), n3);
        if (this.m_Model.getAnonServer().equals(anonServerDBEntry)) {
            anonServerDBEntry.setName(this.m_strOldMixName);
        }
        this.m_Model.autoConnect = this.m_cbAutoConnect.isSelected();
        this.m_Model.setMinimizeOnStartup(this.m_cbStartupMinimized.isSelected());
        JAPDebug.setDebugType((this.m_cbDebugGui.isSelected() ? 1 : 0) + (this.m_cbDebugNet.isSelected() ? 2 : 0) + (this.m_cbDebugThread.isSelected() ? 4 : 0) + (this.m_cbDebugMisc.isSelected() ? 8 : 0));
        JAPDebug.setDebugLevel(this.m_sliderDebugLevel.getValue());
        this.m_Model.setAnonServer(anonServerDBEntry);
        this.m_Model.getAnonServer().setName(anonServerDBEntry.getName());
        JAPDebug.out(7, 1, "m_comboLanguage: " + Integer.toString(this.m_comboLanguage.getSelectedIndex()));
        if (this.m_comboLanguage.getSelectedIndex() == 0) {
            this.m_Model.setLocale(Locale.GERMAN);
        } else {
            this.m_Model.setLocale(Locale.ENGLISH);
        }
        JAPAnonService.setEnableDummyTraffic(this.m_cbDummyTraffic.isSelected());
        this.m_Model.notifyJAPObservers();
    }

    public void selectCard(int n) {
        if (n == 1) {
            this.m_Tabs.setSelectedComponent(this.m_pFirewall);
        } else if (n == 2) {
            this.m_Tabs.setSelectedComponent(this.m_pInfo);
        } else if (n == 3) {
            this.m_Tabs.setSelectedComponent(this.m_pMix);
        } else if (n == 4) {
            this.m_Tabs.setSelectedComponent(this.m_pMisc);
        } else {
            this.m_Tabs.setSelectedComponent(this.m_pPort);
        }
    }

    public void updateValues() {
        this.m_cbDummyTraffic.setSelected(JAPAnonService.getEnableDummyTraffic());
        this.m_cbShowDebugConsole.setSelected(JAPDebug.isShowConsole());
        this.m_cbDebugGui.setSelected((JAPDebug.getDebugType() & 1) != 0);
        this.m_cbDebugNet.setSelected((JAPDebug.getDebugType() & 2) != 0);
        this.m_cbDebugThread.setSelected((JAPDebug.getDebugType() & 4) != 0);
        this.m_cbDebugMisc.setSelected((JAPDebug.getDebugType() & 8) != 0);
        this.m_sliderDebugLevel.setValue(JAPDebug.getDebugLevel());
        this.m_bIgnoreComboLanguageEvents = true;
        if (this.m_Model.getLocale().equals(Locale.ENGLISH)) {
            this.m_comboLanguage.setSelectedIndex(1);
        } else {
            this.m_comboLanguage.setSelectedIndex(0);
        }
        this.m_bIgnoreComboLanguageEvents = false;
        this.m_tfListenerPortNumber.setText(String.valueOf(this.m_Model.getPortNumber()));
        this.m_cbListenerIsLocal.setSelected(this.m_Model.getListenerIsLocal());
        this.m_cbProxy.setSelected(this.m_Model.getUseFirewall());
        this.m_tfProxyHost.setEnabled(this.m_cbProxy.isSelected());
        this.m_tfProxyPortNumber.setEnabled(this.m_cbProxy.isSelected());
        this.m_tfProxyHost.setText(this.m_Model.getFirewallHost());
        this.m_tfProxyPortNumber.setText(String.valueOf(this.m_Model.getFirewallPort()));
        this.m_tfProxyAuthenticationUserID.setText(this.m_Model.getFirewallAuthUserID());
        this.m_cbProxyAuthentication.setSelected(this.m_Model.getUseFirewallAuthorization());
        this.m_tfInfoHost.setText(this.m_Model.getInfoServiceHost());
        this.m_tfInfoPortNumber.setText(String.valueOf(this.m_Model.getInfoServicePort()));
        AnonServerDBEntry anonServerDBEntry = this.m_Model.getAnonServer();
        this.m_strOldMixName = this.m_strMixName = anonServerDBEntry.getName();
        this.m_tfMixHost.setText(anonServerDBEntry.getHost());
        this.m_tfMixPortNumber.setText(String.valueOf(anonServerDBEntry.getPort()));
        if (anonServerDBEntry.getSSLPort() == -1) {
            this.m_tfMixPortNumberSSL.setText("");
        } else {
            this.m_tfMixPortNumberSSL.setText(String.valueOf(anonServerDBEntry.getSSLPort()));
        }
        this.m_comboMixCascade.setSelectedIndex(0);
        this.m_cbAutoConnect.setSelected(this.m_Model.autoConnect);
        this.m_cbStartupMinimized.setSelected(this.m_Model.getMinimizeOnStartup());
        this.m_comboMixCascade.removeAllItems();
        this.m_comboMixCascade.addItem(JAPModel.getString("settingsAnonSelect"));
        Enumeration enumeration = this.m_Model.anonServerDatabase.elements();
        while (enumeration.hasMoreElements()) {
            this.m_comboMixCascade.addItem(((AnonServerDBEntry)enumeration.nextElement()).getName());
        }
    }
}

