/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Certificate;
import java.security.Principal;
import java.security.PublicKey;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.security.x509.X509Cert;

final class JAPCertificate
implements Certificate {
    private X509Cert cert;
    public static final int BASE64 = 1;
    public static final int DER = 2;
    public static final int DEFAULT_ENCODING = 2;

    public JAPCertificate(byte[] byArray) {
        try {
            this.cert = new X509Cert(byArray);
        }
        catch (Exception exception) {
            this.cert = null;
        }
    }

    public JAPCertificate() {
        this.cert = null;
    }

    public Principal getPrincipal() {
        return this.cert.getPrincipal();
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public void encode(OutputStream outputStream) {
        try {
            this.encode(outputStream, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void encode(OutputStream outputStream, int n) {
        switch (n) {
            case 1: {
                try {
                    PrintWriter printWriter = new PrintWriter(outputStream);
                    printWriter.println("-----BEGIN CERTIFICATE-----");
                    printWriter.flush();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    BASE64Encoder bASE64Encoder = new BASE64Encoder();
                    this.cert.encode((OutputStream)byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                    bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray(), outputStream);
                    printWriter.println("-----END CERTIFICATE-----");
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    this.cert.encode(outputStream);
                    break;
                }
                catch (Exception exception) {
                    return;
                }
            }
            default: {
                return;
            }
        }
    }

    public void decode(InputStream inputStream) {
        try {
            this.cert = new X509Cert();
            this.cert.decode(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void decode(byte[] byArray, int n) {
        switch (n) {
            case 1: {
                try {
                    BASE64Decoder bASE64Decoder = new BASE64Decoder();
                    String string = new String(byArray);
                    string = string.trim();
                    if (!string.startsWith("-----BEGIN CERTIFICATE-----") || !string.endsWith("-----END CERTIFICATE-----")) {
                        return;
                    }
                    string = string.substring(27, string.length() - 26);
                    BASE64InputFilter bASE64InputFilter = new BASE64InputFilter(string);
                    byte[] byArray2 = bASE64Decoder.decodeBuffer((InputStream)bASE64InputFilter);
                    this.decode(byArray2, 2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    this.cert = new X509Cert(byArray);
                }
                catch (Exception exception) {
                    this.cert = null;
                    exception.printStackTrace();
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getFormat() {
        return this.cert.getFormat();
    }

    public String toString(boolean bl) {
        return this.cert.toString(bl);
    }

    public Principal getGuarantor() {
        return this.cert.getGuarantor();
    }

    public boolean verify(PublicKey publicKey) {
        try {
            this.cert.verify(publicKey);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    final class BASE64InputFilter
    extends InputStream {
        byte[] buff;
        int aktIndex;

        public BASE64InputFilter(String string) {
            this.buff = string.getBytes();
            this.aktIndex = 0;
        }

        public int read() {
            while (this.aktIndex < this.buff.length && (this.buff[this.aktIndex] == 32 || this.buff[this.aktIndex] == 9)) {
                ++this.aktIndex;
            }
            if (this.aktIndex == this.buff.length) {
                return -1;
            }
            return this.buff[this.aktIndex++];
        }
    }
}

