/*
 * Decompiled with CFR 0.152.
 */
import anon.JAPAnonService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class JAPCascadeMonitorView
extends JDialog
implements ListSelectionListener {
    private int IDLETIME = 90000;
    private JAPModel model = JAPModel.getModel();
    private JAPCascadeMonitor cm = null;
    private ServerSocket listener = null;
    private JAPCascadeMonitorView view = this;
    private JButton startButton;
    private JButton stopButton;
    private JButton okButton;
    private JLabel statusTextField;
    private JCheckBox contCheckBox;
    private JScrollPane tableAggregate;
    private JScrollPane scrollpane;
    private JTable tableView;
    private TableModel dataModel;
    private int selectedRow = -1;
    private JAPAnonServerDB db = null;
    private Thread idleThread;
    private Thread monitorThread;
    private boolean runFlag = true;

    JAPCascadeMonitorView(Frame frame) {
        super(frame);
        this.db = this.model.anonServerDatabase;
        this.setModal(true);
        this.setTitle(JAPModel.getString("chkAvailableCascades"));
        Component component = this.createComponents();
        this.getContentPane().add(component, "Center");
        this.pack();
        JAPUtil.centerFrame(this);
        ((Component)this).setVisible(true);
    }

    private Component createComponents() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.statusTextField = new JLabel(JAPModel.getString("chkPressStartToCheck"));
        this.contCheckBox = new JCheckBox(JAPModel.getString("chkChontinouslyCheck"));
        jPanel2.add(this.statusTextField);
        this.tableAggregate = this.createTable();
        JPanel jPanel3 = new JPanel();
        this.startButton = new JButton(JAPModel.getString("chkBttnTest"));
        this.stopButton = new JButton(JAPModel.getString("stopButton"));
        this.okButton = new JButton(JAPModel.getString("chkBttnSelect"));
        this.stopButton.setEnabled(false);
        JButton jButton = new JButton(JAPModel.getString("cancelButton"));
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPCascadeMonitorView.this.stopButton.setEnabled(true);
                JAPCascadeMonitorView.this.startButton.setEnabled(false);
                JAPCascadeMonitorView.this.startTest();
            }
        });
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPCascadeMonitorView.this.startButton.setEnabled(true);
                JAPCascadeMonitorView.this.stopButton.setEnabled(false);
                JAPCascadeMonitorView.this.stopTest();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPCascadeMonitorView.this.stopTest();
                JAPCascadeMonitorView.this.dispose();
            }
        });
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JAPCascadeMonitorView.this.model.setAnonServer(JAPCascadeMonitorView.this.db.getEntry(JAPCascadeMonitorView.this.tableView.getSelectedRow()));
                JAPCascadeMonitorView.this.stopTest();
                JAPCascadeMonitorView.this.dispose();
            }
        });
        jPanel3.add(this.startButton);
        jPanel3.add(this.stopButton);
        jPanel3.add(jButton);
        jPanel3.add(this.okButton);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.tableAggregate, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private JScrollPane createTable() {
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return 5;
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    JAPCascadeMonitorView.this.model;
                    return JAPModel.getString("chkCascade");
                }
                if (n == 1) {
                    JAPCascadeMonitorView.this.model;
                    return JAPModel.getString("chkUsers");
                }
                if (n == 2) {
                    JAPCascadeMonitorView.this.model;
                    return JAPModel.getString("chkDelay");
                }
                if (n == 3) {
                    JAPCascadeMonitorView.this.model;
                    return JAPModel.getString("chkStatus");
                }
                if (n == 4) {
                    JAPCascadeMonitorView.this.model;
                    return JAPModel.getString("chkSelect");
                }
                return " ";
            }

            public int getRowCount() {
                return JAPCascadeMonitorView.this.db.size();
            }

            public Object getValueAt(int n, int n2) {
                AnonServerDBEntry anonServerDBEntry = JAPCascadeMonitorView.this.db.getEntry(n);
                if (n2 == 0) {
                    return anonServerDBEntry.getName();
                }
                if (n2 == 1) {
                    return anonServerDBEntry.getNrOfActiveUsers() == -1 ? " " : Integer.toString(anonServerDBEntry.getNrOfActiveUsers());
                }
                if (n2 == 2) {
                    return anonServerDBEntry.getDelay() == null ? " " : anonServerDBEntry.getDelay();
                }
                if (n2 == 3) {
                    return anonServerDBEntry.getStatus() == null ? "                              " : anonServerDBEntry.getStatus();
                }
                if (n2 == 4) {
                    String string;
                    if (anonServerDBEntry.equals(JAPCascadeMonitorView.this.model.getAnonServer())) {
                        JAPCascadeMonitorView.this.model;
                        string = JAPModel.getString("chkSelected");
                    } else {
                        string = " ";
                    }
                    return string;
                }
                return " ";
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
            }
        };
        this.tableView = new JTable(this.dataModel);
        this.scrollpane = new JScrollPane(this.tableView);
        this.scrollpane.createVerticalScrollBar();
        this.tableView.setSelectionMode(0);
        this.tableView.getSelectionModel().addListSelectionListener(this);
        JAPUtil.setPerfectTableSize(this.tableView, new Dimension(600, 450));
        return this.scrollpane;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JAPDebug.out(7, 1, "JAPCascadeMonitorView:valuesChanged() selected row=" + this.tableView.getSelectedRow());
        this.okButton.setEnabled(true);
    }

    private void startTest() {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.listener == null) {
                this.listener = new ServerSocket(this.model.getAnonServer().getPort() + 1);
            }
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPCascadeMonitor:Cannot establish listener on port " + Integer.toString(this.model.getAnonServer().getPort() + 1));
        }
        if (this.cm == null) {
            this.cm = new JAPCascadeMonitor();
        }
        this.monitorThread = new Thread(this.cm);
        this.monitorThread.setPriority(10);
        this.monitorThread.start();
    }

    private void stopTest() {
        this.statusTextField.setText(JAPModel.getString("chkCancelled"));
        this.runFlag = false;
        try {
            this.idleThread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.monitorThread.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.listener.close();
        }
        catch (Exception exception) {
            JAPDebug.out(3, 2, "JAPCascadeMonitor:Error closing listener on port " + Integer.toString(this.model.getAnonServer().getPort() + 1));
        }
        ((Component)this).setCursor(Cursor.getDefaultCursor());
        this.statusTextField.setText(JAPModel.getString("chkPressStartToCheck"));
    }

    public static void main(String[] stringArray) {
        JAPMessages.init();
        JAPModel jAPModel = JAPModel.createModel();
        JAPDebug.create();
        jAPModel.load();
        jAPModel.fetchAnonServers();
        JAPDebug.setDebugType(15);
        JAPDebug.setDebugLevel(7);
        new JAPCascadeMonitorView(null);
    }

    private final class JAPCascadeMonitor
    implements Runnable {
        public JAPCascadeMonitor() {
            JAPDebug.out(7, 8, "JAPCascadeMonitor:initializing...");
        }

        public synchronized void run() {
            JAPDebug.out(7, 8, "JAPCascadeMonitor:run()");
            while (JAPCascadeMonitorView.this.runFlag) {
                Object object;
                JLabel jLabel = JAPCascadeMonitorView.this.statusTextField;
                JAPCascadeMonitorView.this.model;
                jLabel.setText(JAPModel.getString("chkGettingFeedback"));
                Enumeration enumeration = JAPCascadeMonitorView.this.db.elements();
                while (enumeration.hasMoreElements()) {
                    JAPCascadeMonitorView.this.model.getInfoService().getFeedback((AnonServerDBEntry)enumeration.nextElement());
                    JAPCascadeMonitorView.this.tableView.repaint();
                }
                JLabel jLabel2 = JAPCascadeMonitorView.this.statusTextField;
                JAPCascadeMonitorView.this.model;
                jLabel2.setText(JAPModel.getString("chkFeedbackReceived"));
                int n = JAPCascadeMonitorView.this.db.size();
                if (JAPCascadeMonitorView.this.listener == null) {
                    n = 0;
                    JLabel jLabel3 = JAPCascadeMonitorView.this.statusTextField;
                    JAPCascadeMonitorView.this.model;
                    jLabel3.setText(JAPModel.getString("chkListenerError"));
                }
                int n2 = 0;
                while (n2 < n) {
                    object = JAPCascadeMonitorView.this.db.getEntry(n2);
                    JLabel jLabel4 = JAPCascadeMonitorView.this.statusTextField;
                    StringBuffer stringBuffer = new StringBuffer();
                    JAPCascadeMonitorView.this.model;
                    jLabel4.setText(stringBuffer.append(JAPModel.getString("chkCnctToCasc")).append(" ").append(((AnonServerDBEntry)object).getName()).toString());
                    JAPCascadeMonitorView.this.model;
                    ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkConnecting"));
                    JAPCascadeMonitorView.this.tableView.repaint();
                    JAPAnonService jAPAnonService = new JAPAnonService(JAPCascadeMonitorView.this.listener, 1);
                    if (JAPCascadeMonitorView.this.model.getUseFirewall()) {
                        if (((AnonServerDBEntry)object).getSSLPort() == -1) {
                            JAPAnonService.setAnonService(((AnonServerDBEntry)object).getHost(), ((AnonServerDBEntry)object).getPort());
                            jAPAnonService.setFirewall(JAPCascadeMonitorView.this.model.getFirewallHost(), JAPCascadeMonitorView.this.model.getFirewallPort());
                            jAPAnonService.connectViaFirewall(true);
                        } else {
                            JAPAnonService.setAnonService(((AnonServerDBEntry)object).getHost(), ((AnonServerDBEntry)object).getSSLPort());
                            jAPAnonService.setFirewall(JAPCascadeMonitorView.this.model.getFirewallHost(), JAPCascadeMonitorView.this.model.getFirewallPort());
                            jAPAnonService.connectViaFirewall(true);
                        }
                    } else {
                        JAPAnonService.setAnonService(((AnonServerDBEntry)object).getHost(), ((AnonServerDBEntry)object).getPort());
                    }
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    l3 = System.currentTimeMillis();
                    int n3 = jAPAnonService.start();
                    l4 = System.currentTimeMillis();
                    l = l4 - l3;
                    NumberFormat numberFormat = NumberFormat.getInstance();
                    numberFormat.setMaximumFractionDigits(3);
                    ((AnonServerDBEntry)object).setDelay("" + (l == -1L ? "-" : numberFormat.format((float)l / 1000.0f)) + " s");
                    JAPCascadeMonitorView.this.tableView.repaint();
                    if (n3 == 0) {
                        JAPCascadeMonitorView.this.model;
                        ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkConnected"));
                    } else {
                        l = -1L;
                        if (n3 == -8) {
                            JAPCascadeMonitorView.this.model;
                            ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkBindError"));
                        } else {
                            JAPCascadeMonitorView.this.model;
                            ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkConnectionError"));
                        }
                    }
                    JAPCascadeMonitorView.this.tableView.repaint();
                    if (n3 == 0) {
                        try {
                            StringBuffer stringBuffer2 = new StringBuffer().append("http://").append(JAPCascadeMonitorView.this.model.getInfoServiceHost()).append(":").append(JAPCascadeMonitorView.this.model.getInfoServicePort());
                            JAPCascadeMonitorView.this.model;
                            String string = stringBuffer2.append("/aktVersion").toString();
                            URL uRL = new URL(string);
                            Socket socket = new Socket(InetAddress.getLocalHost().getHostAddress(), JAPCascadeMonitorView.this.model.getAnonServer().getPort() + 1);
                            socket.setSoTimeout(60000);
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                            bufferedWriter.write("GET " + string + " HTTP/1.0\r\n\r\n");
                            bufferedWriter.flush();
                            JAPDebug.out(7, 8, "Sending request: " + string);
                            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                            l3 = System.currentTimeMillis();
                            String string2 = JAPUtil.readLine(dataInputStream);
                            JAPDebug.out(7, 2, "Response:>" + string2 + "<");
                            if (string2 == null || string2.length() == 0 || string2.indexOf("200") == -1) {
                                JAPCascadeMonitorView.this.model;
                                ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkBadResponse"));
                                JAPCascadeMonitorView.this.tableView.repaint();
                                l2 = -1L;
                            } else {
                                String string3 = JAPUtil.readLine(dataInputStream);
                                while (string3.length() != 0) {
                                    JAPDebug.out(7, 2, ">" + string3 + "<");
                                    string3 = JAPUtil.readLine(dataInputStream);
                                }
                                String string4 = JAPUtil.readLine(dataInputStream);
                                JAPDebug.out(7, 2, "Data:>" + string4 + "<");
                                l4 = System.currentTimeMillis();
                                l2 = l4 - l3;
                                JAPCascadeMonitorView.this.model;
                                ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkCascResponding"));
                                JAPCascadeMonitorView.this.tableView.repaint();
                                String string5 = string4.trim();
                                if (string5.charAt(2) == '.' && string5.charAt(5) == '.') {
                                    JAPCascadeMonitorView.this.model;
                                    ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkOK"));
                                    JAPCascadeMonitorView.this.tableView.repaint();
                                }
                            }
                            socket.close();
                            socket = null;
                            bufferedWriter.close();
                            bufferedWriter = null;
                            dataInputStream.close();
                            dataInputStream = null;
                        }
                        catch (Exception exception) {
                            l2 = -1L;
                            JAPCascadeMonitorView.this.model;
                            ((AnonServerDBEntry)object).setStatus(JAPModel.getString("chkConButError"));
                            JAPCascadeMonitorView.this.tableView.repaint();
                            JAPDebug.out(7, 8, "Exception: " + exception);
                        }
                    }
                    ((AnonServerDBEntry)object).setDelay("" + (l == -1L ? "-" : numberFormat.format((float)l / 1000.0f)) + "/" + (l2 == -1L ? "-" : numberFormat.format((float)l2 / 1000.0f)) + " s");
                    JAPCascadeMonitorView.this.tableView.repaint();
                    n3 = jAPAnonService.stop();
                    ++n2;
                }
                ((Component)JAPCascadeMonitorView.this.view).setCursor(Cursor.getDefaultCursor());
                object = new JAPCascadeMonitorIdle();
                JAPCascadeMonitorView.this.idleThread = new Thread((Runnable)object);
                JAPCascadeMonitorView.this.idleThread.setPriority(1);
                JAPCascadeMonitorView.this.idleThread.start();
                try {
                    JAPCascadeMonitorView.this.idleThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((Component)JAPCascadeMonitorView.this.view).setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    private final class JAPCascadeMonitorIdle
    implements Runnable {
        private JAPCascadeMonitorIdle() {
        }

        public void run() {
            boolean bl = true;
            long l = System.currentTimeMillis();
            while (bl) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 < (long)JAPCascadeMonitorView.this.IDLETIME) {
                    JLabel jLabel = JAPCascadeMonitorView.this.statusTextField;
                    StringBuffer stringBuffer = new StringBuffer();
                    JAPCascadeMonitorView.this.model;
                    jLabel.setText(stringBuffer.append(JAPModel.getString("chkIdle")).append(" ").append(((long)JAPCascadeMonitorView.this.IDLETIME - l3) / 1000L).append(" s").toString());
                    try {
                        JAPCascadeMonitorView.this.idleThread;
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                bl = false;
            }
        }
    }
}

