/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

final class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane html = new JEditorPane();
    private URL url;
    private Cursor cursor;

    public HtmlPane(String string) {
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        try {
            this.html.setPage(this.getUrlFor(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getViewport().add(this.html);
        this.cursor = this.html.getCursor();
    }

    private URL getUrlFor(String string) {
        Serializable serializable;
        try {
            serializable = this.getClass().getResource(string);
            if (serializable != null) {
                return serializable;
            }
        }
        catch (Exception exception) {
            JAPDebug.out(7, 8, "JAPHelp:load:Exception: " + exception);
            JAPDebug.out(7, 8, "URL was: " + string);
        }
        try {
            serializable = new File(string);
            String string2 = ((File)serializable).getAbsolutePath();
            string2 = "file:" + string2;
            return new URL(string2);
        }
        catch (Exception exception) {
            JAPDebug.out(7, 8, "JAPHelp:HtmlPane(constructor):Exception: " + exception);
            JAPDebug.out(7, 8, "URL was: " + string);
            return null;
        }
    }

    public void load(String string) {
        URL uRL = this.getUrlFor(string);
        if (uRL != null) {
            this.linkActivated(uRL);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.html.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.html.setCursor(this.cursor);
        }
    }

    protected void linkActivated(URL uRL) {
        Cursor cursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor);
        SwingUtilities.invokeLater(new PageLoader(uRL));
    }

    final class PageLoader
    implements Runnable {
        PageLoader(URL uRL) {
            HtmlPane.this.url = uRL;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (HtmlPane.this.url == null) {
                HtmlPane.this.html.setCursor(HtmlPane.this.cursor);
                HtmlPane.this.html.getParent().repaint();
                return;
            }
            Document document = HtmlPane.this.html.getDocument();
            try {
                try {
                    HtmlPane.this.html.setPage(HtmlPane.this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                    Object var4_3 = null;
                    HtmlPane.this.url = null;
                    SwingUtilities.invokeLater(this);
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                HtmlPane.this.url = null;
                SwingUtilities.invokeLater(this);
                throw throwable;
            }
            HtmlPane.this.url = null;
            SwingUtilities.invokeLater(this);
        }
    }
}

