/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Util;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class ExtBufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    public ExtBufferedInputStream(InputStream in) {
        this(in, 2048);
    }

    public ExtBufferedInputStream(InputStream in, int size) {
        super(in);
        this.buf = new byte[size];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    private void fill() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        this.count = n <= 0 ? this.pos : n + this.pos;
    }

    void initMark() {
        this.mark(this.buf.length);
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    int pastEnd(byte[] search, int[] search_cmp) {
        int idx = Util.findStr(search, search_cmp, this.buf, this.markpos, this.pos);
        if (idx == -1) {
            this.markpos = this.pos - search.length;
        } else {
            this.markpos = idx + search.length;
            idx = this.pos - this.markpos;
        }
        return idx;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.buf.length && this.markpos < 0) {
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail >= n) {
            this.pos = (int)((long)this.pos + n);
            return n;
        }
        this.pos = (int)((long)this.pos + avail);
        return avail + this.in.skip(n - avail);
    }
}

