/* ************************************************************ */
/* Time Series Analyzer Macro File                              */
/*                                                              */
/* Created by    :    Wolfgang Reichenbach                      */
/* Creation Date :    12.02.95                                  */
/* Last updated  :    25.03.96                                  */
/* copyright by  :    Wolfgang Reichenbach 1996                 */
/*                                                              */
/* ************************************************************ */
/*                                                              */
/* This file loads the time series 'E:\NLD\2K\lorenz.ts.nld'    */
/* and calculates the prediction error. After this the          */
/* embedding parameters are displayed and you can change them   */
/* manually                                                     */
/*                                                              */
/* ************************************************************ */
/*                                                              */
/* Used System REXX/2 functions                                 */
/*                                                              */
/*             1)  Say                                          */
/*             2)  Exit                                         */
/*                                                              */
/* Used internal functions                                      */
/*                                                              */
/*    1)  LoadTs              - Loading a time series           */
/*    2)  CalcAutocorrelation - Calculate the autocorrelation   */
/*    3)  GetTsLength         - Get the length of time series   */
/*    4)  GetTsDim            - Get dimension of time series    */
/* ************************************************************ */


/* Display the output dialog box for SAY commands */
VisualMode ON

SAY '******************************************'
SAY '*   Time Series Analyzer REXX programm   *'
SAY '******************************************'

/* Loading the time series */
rc = LoadTs('E:\math\nld\2k\Lorenz.ts.nld')

/* Calculating the prediction error */
rc = CalcPredictionError()

/* Get the used embedding parameters */
delay = GetDelay( 0 )
dim_E = GetEmbeddingDim( 0 )

/* Display the used embedding parameters */
Say 'Used embedding parameters are'
Say 'Delay = ' delay
Say 'dim_E = ' dim_E

/* Change the used embedding parameters */
new_delay = Query('Please enter the new delay',delay)
new_dim_E = Query('Please enter the new dim_E',dim_E)

/* Change the parameters */
rc = SetDelay( new_delay )
rc = SetEmbeddingDim( new_dim_E )

/* Calculate the Lyapunov exponents with the new parameters */
rc = CalcLyapunov()

/* Restore the original embedding parameters */
delay = GetDelay( 1 )
dim_E = GetEmbeddingDim( 1 )
rc = SetDelay( delay )
rc = SetEmbeddingDim( dim_E )


   




