#############################################################################
#                                                                           #
# WATCOM.MK                                                                 #
#                                                                           #
#   This group of makefiles is a modification of the group of makefiles     #
#   'MSOFT.MK' provided with NetCDF-2.3.2.  These specific makefiles are    #
#   set up for watcom C/C++ 10.0 generating code for 32-bit OS/2 but can be #
#   easily modified to drive any C (and FORTRAN) compiler that generates    #
#   code for DOS or OS/2.                                                   #
#                                                                           #
#   The driver names and option strings for compilers, linkers, librarians, #
#   touch and remove utilities, and file locations are specified only in    #
#   the parent makefile.  While this necessitates using the parent makefile #
#   for any update, it also elimiates the frustrating chore of making       #
#   identical changes in multiple makefiles.                                #
#                                                                           #
#   An "uninstall" target has been added to facilitate removal of the       #
#   NetCDF files from your system.                                          #
#                                                                           #
#   These makefiles are for use with the NMAKE utility (Microsoft's, IBM's  #
#   or compatible).  I didn't take the time to generate makefiles for       #
#   watcom's WMAKE utility for watcom purists.                              #
#                                                                           #
#   /---------------------------------+----------------------------------\  #
#   |  Michael D. Perryman            |                                  |  #
#   |  U.S. Army Corps of Engineers   |  perrym@swt02.swt.usace.army.mil |  #
#   |  Tulsa District                 |           (918)669-7138          |  #
#   |  Tulsa, OK  USA                 |                                  |  #
#   \---------------------------------+----------------------------------/  #
#                                                                           #
#############################################################################

!IF $(WANT_FORTRAN_NETCDF)
FORTDIR   = ..\FORTRAN
FTEST     = ftest
!ENDIF

INCLUDES  = -i$(NCDFDIR);$(XDRDIR)

NCGENLIB  = ncgen.lib
LIBS      = $(NCGENLIB),$(NCDFLIB),$(XDRLIB)

.c.obj:
	$(CC) $(CFLAGS) $(INCLUDES) $<

GOAL =  ncgen.exe

SRCS =  main.c generate.c load.c ncgentab.c escapes.c \
	getfill.c init.c close.c genlib.c

MAIN =  main.obj

OBJS =	generate.obj load.obj ncgentab.obj escapes.obj \
	getfill.obj init.obj close.obj genlib.obj getopt.obj

LOBJS1 = -+generate.obj -+load.obj -+ncgentab.obj -+escapes.obj 
LOBJS2 = -+getfill.obj -+init.obj -+close.obj -+genlib.obj -+getopt.obj

all:	$(GOAL)

$(GOAL): $(MAIN) $(NCGENLIB) $(NCDFLIB)
	$(LINK) $(LFLAGS) file $(MAIN) name $(GOAL) libr $(LIBS)

$(NCGENLIB): $(OBJS)
	$(AR) $(ARFLAGS) $@ $(LOBJS1)
	$(AR) $(ARFLAGS) $@ $(LOBJS2)

getopt.obj:	..\util\getopt.c
	$(CC) $(CFLAGS) $(CPPFLAGS) $(INCLUDES) $?

install: $(GOAL)
	copy $(GOAL) $(PUT_EXECUTABLES_IN)

test:   ncgen.exe test0.cdl ntest ctest $(FTEST) FORCE

FORCE:

# test "-b" option of ncgen
ntest:	ncgen.exe test0.cdl test1.cdl
	ncgen -b test1.cdl
	..\ncdump\ncdump test1.nc > test2.cdl
 	echo N | comp test1.cdl test2.cdl
	@echo "*** ncgen -b test successful ***"

# test "-c" option of ncgen
ctest:	ncgen.exe test0.cdl test1.cdl
	ncgen -c -o ctest0.nc test0.cdl > test0.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLUDES) test0.c
	$(LINK) $(LFLAGS) file test0 name test0.exe libr $(LIBS)
	test0
	..\ncdump\ncdump -n test1 ctest0.nc > ctest1.cdl
 	echo N | comp test1.cdl ctest1.cdl
	@echo "*** ncgen -c test successful ***"

# test "-f" option of ncgen
ftest:	ncgen.exe test0.cdl netcdf.inc test1.cdl msoft.int jackets.obj fslen.obj
	ncgen -f -o ftest0.nc test0.cdl > test0.for
	$(F77) $(FFLAGS) test0.for
	$(LINK) $(LFLAGS) test0 jackets fslen,test0.exe,,$(LIBS) $(FORTLIB);
	test0
	..\ncdump\ncdump -n test1 ftest0.nc > ftest1.cdl
 	echo N | comp test1.cdl ftest1.cdl
	@echo "*** ncgen -f test successful ***" 

test1.cdl: test0.nc
	..\ncdump\ncdump -n test1 test0.nc > test1.cdl

test0.nc: ncgen.exe test0.cdl
	ncgen -b test0.cdl

netcdf.inc: $(FORTDIR)\netcdf.inc
	$(RM) $(RMFLAGS) netcdf.inc
	copy $(FORTDIR)\netcdf.inc

fslen.obj: $(FORTDIR)\fslen.asm
	$(RM) $(RMFLAGS) fslen.asm
	copy $(FORTDIR)\fslen.asm
	$(ASM) fslen;

jackets.obj: $(FORTDIR)\jackets.c
	$(RM) $(RMFLAGS) jackets.c
	copy $(FORTDIR)\jackets.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLUDES) jackets.c

msoft.int: $(FORTDIR)\msoft.int
	$(RM) $(RMFLAGS) msoft.int
	copy $(FORTDIR)\msoft.int

ncgentab.c: msofttab.c
	copy msofttab.c ncgentab.c
        touch ncgentab.c

ncgentab.h: msofttab.h
	copy msofttab.h ncgentab.h
        touch ncgentab.h

ncgenyy.c: msoftyy.c
	copy msoftyy.c ncgenyy.c
        touch ncgenyy.c

ncgen: ncgen.exe

clean:
	$(RM) $(RMFLAGS) *.obj *.map *.lst netcdf.inc msoft.int jackets.c fslen.asm \
		*.bak ncgen.lib ncgentab.c ncgentab.h ncgenyy.c $(GOAL) 
	$(RM) $(RMFLAGS) test0.nc test0.for test0.exe test1.nc test1.cdl test2.cdl \
		ftest0.nc ftest1.cdl test0.c ctest0.nc ctest1.cdl

# DO NOT DELETE THIS LINE -- make depend depends on it.

generate.obj: $(NCDFDIR)\netcdf.h generic.h ncgen.h
load.obj: $(NCDFDIR)\netcdf.h generic.h ncgen.h
ncgentab.obj: $(NCDFDIR)\netcdf.h generic.h ncgen.h ncgenyy.c ncgentab.h
getfill.obj: $(NCDFDIR)\netcdf.h generic.h
init.obj: $(NCDFDIR)\netcdf.h ncgen.h
init.obj: generic.h
close.obj: $(NCDFDIR)\netcdf.h ncgen.h
close.obj: generic.h
