#############################################################################
#                                                                           #
# WATCOM.MK                                                                 #
#                                                                           #
#   This group of makefiles is a modification of the group of makefiles     #
#   'MSOFT.MK' provided with NetCDF-2.3.2.  These specific makefiles are    #
#   set up for watcom C/C++ 10.0 generating code for 32-bit OS/2 but can be #
#   easily modified to drive any C (and FORTRAN) compiler that generates    #
#   code for DOS or OS/2.                                                   #
#                                                                           #
#   The driver names and option strings for compilers, linkers, librarians, #
#   touch and remove utilities, and file locations are specified only in    #
#   the parent makefile.  While this necessitates using the parent makefile #
#   for any update, it also elimiates the frustrating chore of making       #
#   identical changes in multiple makefiles.                                #
#                                                                           #
#   An "uninstall" target has been added to facilitate removal of the       #
#   NetCDF files from your system.                                          #
#                                                                           #
#   These makefiles are for use with the NMAKE utility (Microsoft's, IBM's  #
#   or compatible).  I didn't take the time to generate makefiles for       #
#   watcom's WMAKE utility for watcom purists.                              #
#                                                                           #
#   /---------------------------------+----------------------------------\  #
#   |  Michael D. Perryman            |                                  |  #
#   |  U.S. Army Corps of Engineers   |  perrym@swt02.swt.usace.army.mil |  #
#   |  Tulsa District                 |           (918)669-7138          |  #
#   |  Tulsa, OK  USA                 |                                  |  #
#   \---------------------------------+----------------------------------/  #
#                                                                           #
#############################################################################

INCLUDES  = -i$(INCLUDE);$(NCDFDIR);$(XDRINCL)

NCDUMPLIB = ncdump.lib
LIBS      = $(NCDUMPLIB),$(NCDFLIB),$(XDRLIB)

.c.obj:
	$(CC) $(CFLAGS) $(INCLUDES) $<

GOAL =  ncdump.exe

SRCS =  ncdump.c vardata.c dumplib.c

MAIN = ncdump.obj

OBJS =  vardata.obj dumplib.obj getopt.obj
LOBJS = -+vardata.obj -+dumplib.obj -+getopt.obj

all:	$(GOAL)

$(GOAL): $(MAIN) $(NCDUMPLIB) $(NCDFLIB) $(XDRLIB)
	$(LINK) $(LFLAGS) file $(MAIN) name $(GOAL) libr $(LIBS)

$(NCDUMPLIB): $(OBJS)
	$(AR) $(ARFLAGS) $@ $(LOBJS)

getopt.obj:	..\util\getopt.c
	$(CC) $(CFLAGS) $(CPPFLAGS) $(INCLUDES) $?

install: $(GOAL)
	copy $(GOAL) $(PUT_EXECUTABLES_IN)

test:	ncdump.exe test0.cdl FORCE
	..\ncgen\ncgen -o test0.cdf -n test0.cdl
	ncdump test0.cdf > test1.cdl
	..\ncgen\ncgen -o test1.cdf -n test1.cdl
	ncdump -n test0 test1.cdf > test2.cdl
	echo N | comp test1.cdl test2.cdl 
	@echo "Test successful."

ncdump: ncdump.exe

clean:
	$(RM) $(RMFLAGS) *.obj *.map *.lst *.bak ncdump.lib $(GOAL) \
		test0.cdf test1.cdf test1.cdl test2.cdl

FORCE:

# DO NOT DELETE THIS LINE -- make depend depends on it.

ncdump.obj:  $(NCDFDIR)\netcdf.h
vardata.obj: $(NCDFDIR)\netcdf.h

