#############################################################################
#                                                                           #
# WATCOM.MK                                                                 #
#                                                                           #
#   This group of makefiles is a modification of the group of makefiles     #
#   'MSOFT.MK' provided with NetCDF-2.3.2.  These specific makefiles are    #
#   set up for watcom C/C++ 10.0 generating code for 32-bit OS/2 but can be #
#   easily modified to drive any C (and FORTRAN) compiler that generates    #
#   code for DOS or OS/2.                                                   #
#                                                                           #
#   The driver names and option strings for compilers, linkers, librarians, #
#   touch and remove utilities, and file locations are specified only in    #
#   the parent makefile.  While this necessitates using the parent makefile #
#   for any update, it also elimiates the frustrating chore of making       #
#   identical changes in multiple makefiles.                                #
#                                                                           #
#   An "uninstall" target has been added to facilitate removal of the       #
#   NetCDF files from your system.                                          #
#                                                                           #
#   These makefiles are for use with the NMAKE utility (Microsoft's, IBM's  #
#   or compatible).  I didn't take the time to generate makefiles for       #
#   watcom's WMAKE utility for watcom purists.                              #
#                                                                           #
#   /---------------------------------+----------------------------------\  #
#   |  Michael D. Perryman            |                                  |  #
#   |  U.S. Army Corps of Engineers   |  perrym@swt02.swt.usace.army.mil |  #
#   |  Tulsa District                 |           (918)669-7138          |  #
#   |  Tulsa, OK  USA                 |                                  |  #
#   \---------------------------------+----------------------------------/  #
#                                                                           #
#############################################################################

INCLUDES  = -i$(XDRDIR);$(INCLUDE)
DEFINES   = /DSWAP /DNO_SYSTEM_XDR_INCLUDES /DDOS_FS

NCDFLIB   = netcdf.lib
LIBS      = $(NCDFLIB),$(XDRLIB)

MANIFEST = Makefile alloc.h array.c attr.c cdf.c \
	cdftest.c descrip.mms dim.c error.c error.h file.c \
	htons.mar iarray.c local_nc.h netcdf.h ntohs.mar \
	putget.c sharray.c string.c test.cdf.sav var.c globdef.c

CSRCS = array.c attr.c cdf.c dim.c error.c file.c globdef.c iarray.c \
	putget.c putgetg.c sharray.c string.c var.c xdrposix.c

COBJS = array.obj attr.obj cdf.obj dim.obj error.obj file.obj globdef.obj \
	iarray.obj putget.obj putgetg.obj sharray.obj string.obj var.obj \
	xdrposix.obj

LOBJS1 = -+array -+attr -+cdf -+dim -+error -+file -+globdef -+iarray 
LOBJS2 = -+putget -+putgetg -+sharray -+string -+var -+xdrposix

.c.obj:
	$(CC) $(CFLAGS) $(INCLUDES) $(DEFINES) $<

all:	$(NCDFLIB)

$(NCDFLIB): netcdf.h $(COBJS)
	$(AR) $(ARFLAGS) $@ $(LOBJS1)
	$(AR) $(ARFLAGS) $@ $(LOBJS2)

test:	cdftest.exe FORCE
	cdftest

FORCE:

cdftest.exe: cdftest.obj $(NCDFLIB)
	$(LINK) $(LFLAGS) file cdftest.obj libr $(LIBS)

clean:
	$(RM) $(RMFLAGS) *.obj *.map *.lst *.bak netcdf.lib cdftest.exe test.cdf

install: $(NCDFLIB)
	copy $(NCDFLIB) $(PUT_LIBRARIES_IN)
        copy netcdf.h $(PUT_INCLUDES_IN)

array.obj: array.c
array.obj: ./local_nc.h
array.obj: ./netcdf.h
array.obj: ./alloc.h
attr.obj: attr.c
attr.obj: ./local_nc.h
attr.obj: ./netcdf.h
attr.obj: ./alloc.h
cdf.obj: cdf.c
cdf.obj: ./local_nc.h
cdf.obj: ./netcdf.h
cdf.obj: ./alloc.h
cdftest.obj: cdftest.c
cdftest.obj: ./netcdf.h
dim.obj: dim.c
dim.obj: ./local_nc.h
dim.obj: ./netcdf.h
dim.obj: ./alloc.h
error.obj: error.c
error.obj: ./local_nc.h
error.obj: ./netcdf.h
file.obj: file.c
file.obj: ./local_nc.h
file.obj: ./netcdf.h
file.obj: ./alloc.h
globdef.obj: globdef.c
globdef.obj: ./netcdf.h
iarray.obj: iarray.c
iarray.obj: ./local_nc.h
iarray.obj: ./netcdf.h
iarray.obj: ./alloc.h
putget.obj: putget.c
putget.obj: ./local_nc.h
putget.obj: ./netcdf.h
putget.obj: ./alloc.h
putgetg.obj: putgetg.c
putgetg.obj: ./local_nc.h
putgetg.obj: ./netcdf.h
sharray.obj: sharray.c
sharray.obj: ./local_nc.h
sharray.obj: ./netcdf.h
sharray.obj: ./alloc.h
string.obj: string.c
string.obj: ./local_nc.h
string.obj: ./netcdf.h
string.obj: ./alloc.h
var.obj: var.c
var.obj: ./local_nc.h
var.obj: ./netcdf.h
var.obj: ./alloc.h
xdrposix.obj: xdrposix.c
xdrposix.obj: ./netcdf.h
xdrposix.obj: ./local_nc.h
xdrposix.obj: ./netcdf.h
