/*-----------------------------------------------------------------
 *	x_systemid = "@(#)x2sys_datalist.c	1.5  06/28/99"
 *
 * x2sys_datalist will read one or several data files and dump their
 * contents to stdout in ascii or binary (double precision) mode.
 * Input data file formats are determined by the definition file
 * given by the -D option.
 *
 * Author:	Paul Wessel
 * Date:	26-JUN-1999
 * Version:	1.0, based on the spirit of the old xsystem code
 *
 */

#include "x2sys.h"

main (int argc, char **argv)
{
	char *sfile, *def = "x2sys", *mode[2] = {"rb", "r"}, *fflags = CNULL;

	int i, j, k, n_data_col_out, bad;

	BOOLEAN error = FALSE, suppress = FALSE;

	double **data, west, east, south, north, *out;

	struct X2SYS_INFO *s;
	struct X2SYS_FILE_INFO p;		/* File information */

	GMT_begin (argc, argv);

	sfile = def;
	west = east = south = north = 0.0;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				/* Common parameters */
			
				case 'H':
				case 'R':
				case 'V':
				case '\0':
					error += GMT_get_common_args (argv[i], &west, &east, &south, &north);
					break;
				
				/* Supplemental parameters */
				
				case 'D':
					sfile = &argv[i][2];
					break;
				case 'F':
					fflags = &argv[i][2];
					break;
				case 'M':               /* Multiple line segments */
					GMT_multisegment (&argv[i][2]);
					break;
				case 'S':
					suppress = TRUE;
					break;
				case 'b':
					error += GMT_io_selection (&argv[i][2]);
					break;
				default:
					error = TRUE;
					break;
			}
		}
	}

	if (argc == 1 || error) {
		fprintf (stderr, "x2sys_datalist %s - listing of datafiles to stdout\n\n", X2SYS_VERSION);
		fprintf (stderr, "usage: x2sys_datalist <files> [-D<deffile>] [-F<fields>] [-M[<flag>]] [-R<w/e/s/n>] [-S] [-V] [-b]\n\n");
		fprintf (stderr, "	<files> is one or more datafiles\n");
		fprintf (stderr, "\n\tOPTIONS:\n");
		fprintf (stderr, "	-D definition file for this data set\n");
		fprintf (stderr, "	   [Default is %s%cx2sys.def\n", X2SYS_HOME, DIR_DELIM);
		fprintf (stderr, "	-F is comma-separated list of column names to output [Default are all fields]\n");
		GMT_explain_option ('R');
		fprintf (stderr, "	-S Suppress output records where all data columns are NaN [Output all records]\n");
		GMT_explain_option ('V');
		fprintf (stderr, "	-b gives binary output list (double precision)\n");
		exit (EXIT_FAILURE);
	}
	
	s = x2sys_initialize (sfile);	/* Initialize X2SYS and info structure */
	if (fflags) x2sys_pick_fields (fflags, s);

	s->ascii_out = !GMT_io.binary[1];

	if (project_info.region_supplied) {
		/* Supply dummy linear proj */
		project_info.projection = project_info.xyz_projection[0] = project_info.xyz_projection[1] = LINEAR;
		project_info.pars[0] = project_info.pars[1] = 1.0;
		if (west < 0.0 && east < 0.0) {
			west += 360.0;
			east += 360.0;
		}
		GMT_map_setup (west, east, south, north);
	}

	out = (double *) GMT_memory (VNULL, (size_t)s->n_fields, sizeof (double), "x2sys_datalist");

	if (suppress) {	/* Must count output data colums (except t, x, y) */
		for (i = n_data_col_out = 0; i < s->n_out_columns; i++) {
			if (s->out_order[i] == s->t_col) continue;
			if (s->out_order[i] == s->x_col) continue;
			if (s->out_order[i] == s->y_col) continue;
			n_data_col_out++;
		}
	}

	for (i = 1; i < argc; i++) {

		if (argv[i][0] == '-') continue;

		if (gmtdefs.verbose) fprintf (stderr, "x2sys_datalist: Reading file %s\n", argv[i]);

		if (((s->read_file) (argv[i], &data, s, &p)) < 0) {
			fprintf (stderr, "x2sys_datalist: Error reading file %s\n", argv[i]);
			exit (EXIT_FAILURE);
		}

		if (GMT_io.multi_segments) GMT_write_segmentheader (GMT_stdout, s->n_fields);

		for (j = 0; j < p.n_rows; j++) {
			if (project_info.region_supplied && GMT_map_outside (data[s->x_col][j], data[s->y_col][j])) continue;
			if (suppress) {
				for (i = bad = 0; i < s->n_out_columns; i++) {
					if (s->out_order[i] == s->t_col) continue;
					if (s->out_order[i] == s->x_col) continue;
					if (s->out_order[i] == s->y_col) continue;
					if (GMT_is_dnan (data[s->out_order[i]][j])) bad++;
				}
				if (bad == n_data_col_out) continue;
			}

			for (k = 0; k < s->n_fields; k++) out[k] = data[k][j];
			x2sys_output_record (GMT_stdout, out, s);
		}

		x2sys_free_data (data, s->n_fields);
	}

	x2sys_free_info (s);
	free ((void *)out);

	GMT_end (argc, argv);
}
