#	@(#)seamounts.d	1.1  06/11/99
#
# Subset of data from Wessel, P., and S. Lyons, 1997, Distribution
# of large Pacific seamounts from Geosat/ERS-1: Implications for
# the history of intraplate volcanism, J. Geophys. Res., 102,
# 22,459-22,475. Only VGG >= 100 Eotvos has been kept.
# The full data set is available from www.soest.hawaii.edu/wessel
#
# VGG is Vertical Gravity Gradient in Eotvos units
# RADIUS (km) is the zero-crossing radius in the VGG field
# CRUST_AGE is age of seafloor from R.D. Mueller et al,
#   Digital isochrons of the weorld's oceans, J. Geophys. Res,
#   102, 3211-3214, 1997.  NaN means no data available.
#LON		  LAT	 	 VGG	RADIUS	CRUST_AGE
134.38333	0.9436415	120.5	 22.97	37.606796
136.05	7.6325042	102.7	 18.67	NaN
131.28333	1.1423035	129.0	 17.16	NaN
133.58333	3.625631	104.7	 15.19	38.905283
133.01667	3.8243035	105.0	 15.69	40.579796
139.81667	8.6260793	109.7	 13.75	NaN
149.81667	8.6592062	171.4	 34.79	167.84731
148.31667	9.7853413	155.7	 26.31	164.70576
149.13333	5.5627478	127.1	 31.74	167.38746
149.18333	6.870812	141.8	 30.60	168.08358
148.15	9.1891386	203.0	 24.47	165.41789
149.51667	8.4604854	140.3	 28.48	167.95229
149.31667	7.3013299	154.3	 23.61	168.05201
148.91667	8.6260793	112.6	 28.03	168.0377
145.2	8.4108056	150.8	 24.12	NaN
145.68333	8.4604854	150.3	 24.05	NaN
149.45	0.049665281	132.7	 25.03	NaN
145.45	5.9435635	136.8	 22.60	33.06519
148.91667	8.2617674	101.1	 25.16	168.05962
140.48333	9.8184612	116.4	 22.76	NaN
144.51667	8.5929623	151.0	 21.13	NaN
149.08333	1.6720676	121.5	 22.92	159.23429
149.46667	6.2250496	114.8	 24.77	168.07546
149.24167	0.87741758	118.7	 22.39	NaN
149.65	7.7318588	126.3	 20.28	167.96455
149.38333	0.61254209	111.5	 21.04	NaN
147.78333	8.1292836	117.0	 23.09	166.52219
146.88333	9.8184612	119.1	 21.59	161.65516
145.35	9.2553854	131.4	 21.14	NaN
149.18333	1.1423035	107.4	 20.26	NaN
149.05	2.0693955	114.3	 21.57	159.94837
149.01667	2.3342857	124.4	 23.47	160.4365
148.91667	2.7647264	109.5	 20.66	163.49415
149.13333	1.3740731	104.6	 19.74	NaN
149.38333	7.5662748	120.1	 19.28	168.02609
143.81667	7.3675682	118.3	 19.10	NaN
147.21667	8.1955253	100.6	 19.85	165.09617
146.95	8.1624094	102.6	 20.25	164.54404
146.31667	7.5000357	115.1	 18.89	164.3697
145.00833	8.1706859	111.5	 17.84	NaN
145.68333	7.4006825	141.8	 18.34	NaN
144.63333	7.450359	150.4	 18.52	NaN
145.75	8.1955253	139.1	 16.22	NaN
144.45	7.2682158	126.8	 15.61	NaN
149.85	16.906726	164.2	 32.86	153.4802
148.95	19.657517	131.1	 24.56	148.32852
148.38333	15.415697	158.4	 26.37	153.2201
148.28333	10.149027	153.9	 26.18	163.96286
149.25	19.524921	135.8	 25.44	149.05445
147.9	14.239603	131.6	 29.06	155.79153
148.5	19.806683	135.6	 25.42	147.68364
147.88333	12.500536	134.5	 23.03	159.10422
148.85	15.87955	124.0	 26.53	153.03198
146.55417	12.156886	117.7	 29.49	NaN
147.01667	11.573128	163.3	 23.09	159.25112
147.91667	13.163001	142.6	 23.21	158.18849
140.11667	10.513323	132.1	 25.10	NaN
148.43333	13.924892	132.9	 24.68	157.73596
148.78333	18.862014	102.3	 26.23	148.9866
148.41667	16.01208	121.3	 25.95	152.35696
147.78333	14.587449	120.2	 26.55	NaN
147.95	10.645792	147.3	 20.56	162.29245
148.95	16.509095	151.5	 19.39	152.2221
146.75	11.175689	126.0	 19.02	159.42781
144.91667	11.043216	102.8	 20.36	NaN
146.01667	11.076332	109.5	 18.80	NaN
148.01667	12.699274	106.9	 18.30	158.9881
147.675	12.906292	109.7	 17.86	158.24523
148.48333	14.985001	137.4	 18.11	153.96164
149.61667	15.581358	138.9	 18.26	157.05823
149.05	14.488063	144.7	 17.47	157.75947
147.45	12.268673	100.8	 16.50	158.85977
149.68333	12.533655	126.1	 16.05	162.80078
144.81667	11.374407	108.4	 16.33	NaN
147.01667	12.566775	130.7	 16.56	157.85718
149.85	13.394881	103.6	 15.31	161.60136
149.35	16.376558	102.0	 14.52	153.17318
148.15	20.613043	155.4	 35.67	147.3494
147.76667	25.751191	166.9	 33.05	150.43477
149.61667	20.248525	135.1	 30.28	152.49151
148.98333	20.182247	150.1	 31.57	147.76579
145.73333	27.790917	151.8	 27.05	NaN
147.18333	25.751191	141.9	 28.11	149.80845
145.36667	26.066232	122.5	 24.26	NaN
145.18333	27.309952	175.4	 24.58	NaN
146.9	25.834101	135.5	 26.83	146.67897
148.51667	22.999363	157.4	 23.21	151.6716
148.25	25.784359	134.5	 26.64	151.00601
145.65	25.883843	120.1	 23.77	NaN
148.58333	25.088007	184.6	 21.84	152.24717
144.31667	27.376293	122.9	 24.42	NaN
145.11667	26.215466	110.2	 21.82	NaN
148.75	23.828114	174.4	 21.41	154.08149
147.21667	25.253792	114.3	 22.63	148.87575
145.95	25.817517	103.6	 20.51	147.98096
147.18333	25.021688	101.5	 20.11	148.52181
147.45	21.607257	110.7	 20.18	146.66229
148.25	24.889062	126.3	 14.85	152.11628
148.11667	25.253792	125.7	 14.87	151.48531
149.41667	25.51907	122.4	 14.35	157.08077
148.45	25.353269	133.6	 15.80	151.761
148.25	28.371452	115.1	 15.12	151.75198
148.51667	22.435858	113.4	 13.91	152.77774
148.55	23.463447	106.6	 15.88	150.21297
148.21667	31.973659	174.3	 21.46	145.89149
148.95	31.641911	158.6	 21.77	147.44748
144.75	36.885735	129.5	 21.15	134.90339
148.31667	32.803121	161.8	 19.48	144.56053
144.25	34.230048	164.7	 18.48	138.83315
143.38333	33.035385	101.0	 20.03	NaN
144.48333	36.653306	103.8	 16.96	135.00135
144.31667	35.790116	131.7	 16.89	136.03811
149.25	32.040014	124.1	 15.75	147.21481
148.11667	34.130483	133.9	 15.47	141.99287
145.91667	34.064105	108.2	 14.69	139.82056
143.48333	36.022499	101.7	 16.16	NaN
153.42026	-1.7578571	115.1	 34.61	NaN
154.51667	-3.1954623	104.3	 23.21	NaN
159.31667	-6.2084769	123.9	 15.82	NaN
150.30833	8.667483	159.8	 32.58	167.72937
155.23333	7.5497125	171.7	 32.89	167.23759
158.03333	6.870812	136.7	 32.84	163.51357
152.25	8.7254404	166.7	 27.55	165.76965
151.81667	7.4669211	126.9	 27.30	167.5909
153.48333	5.4468444	130.6	 29.71	163.75091
151.68333	8.5598455	149.2	 24.67	166.66544
151.48333	7.3675682	134.3	 28.88	167.72916
151.98333	7.0363892	130.6	 28.09	167.90162
152.61667	6.9039254	143.4	 24.48	167.75083
151.36667	8.6095257	148.5	 24.54	166.94236
151.98333	8.5929623	125.5	 20.75	166.30037
157.15	5.8111072	118.2	 26.08	161.8945
154.21667	8.1292836	193.2	 21.58	166.47243
153.11667	5.8773402	135.7	 20.59	165.00519
159.78333	6.7052264	121.7	 19.42	161.77973
154.91667	3.8574124	120.2	 18.87	159.18904
151.69167	0.1241632	100.3	 20.00	151.38636
150.55	7.4337969	103.0	 19.78	167.94371
152.11667	5.8111072	144.1	 15.61	165.61776
156.45	9.9178313	142.9	 15.24	161.87782
154.91667	4.883916	145.0	 13.95	161.44308
154.25	5.9104518	117.1	 14.46	164.22793
150.91667	7.9636953	121.9	 15.93	167.6317
156.91667	7.0363892	107.5	 14.46	164.77082
154.75	1.0760795	100.7	 15.87	151.34622
159.85	8.2948836	100.3	 13.53	165.72643
156.15	14.09053	197.4	 36.51	161.6729
156.9	12.881449	187.8	 32.88	160.05521
151.975	15.523371	164.0	 35.62	162.58253
156.70758	14.332775	165.0	 29.85	160.89459
154.26667	16.973003	157.3	 29.87	165.93611
155.18333	15.680755	147.1	 28.22	166.66165
156.83333	11.059779	158.9	 31.81	159.84733
150.675	16.981284	154.5	 33.80	156.99258
157.58333	13.924892	207.7	 28.85	160.48117
157.85	19.558075	186.4	 27.65	167.81204
150.68333	19.690662	152.0	 30.93	153.3814
155.36667	15.87955	140.3	 26.92	166.60688
153.4375	19.669948	137.6	 34.33	163.87741
154.98333	15.316303	162.0	 31.09	166.4719
156.56667	11.689053	138.8	 27.78	159.83375
152.15	17.105548	140.7	 24.89	160.12966
152.25	16.873593	134.3	 23.77	160.77337
155.8	14.372111	138.4	 25.60	162.97484
156.35	12.235554	168.0	 24.37	159.86786
152.65	17.436925	205.2	 24.28	160.67096
156.51667	12.732394	138.7	 24.29	159.93892
154.38333	16.542227	141.2	 26.82	166.22182
151.85	17.105548	139.8	 24.73	159.44706
156.61667	11.407534	116.8	 23.37	159.82431
151.93333	16.790745	128.4	 22.71	160.20188
158.61667	12.368039	179.3	 23.42	161.05624
151.98333	18.000304	176.5	 22.87	158.14881
157.41667	19.906129	139.5	 25.35	167.57507
151.07917	18.00445	108.8	 23.21	154.29041
152.65	19.259755	170.0	 22.29	163.42885
151.65	19.723807	166.7	 21.45	162.11807
150.38333	17.436925	123.8	 26.41	153.85405
153.15	17.436925	183.6	 21.54	161.80673
157.85	12.831764	188.8	 21.37	160.67727
159.75	11.970578	127.4	 20.82	161.14369
151.88333	16.144611	171.2	 20.13	161.25176
156.68333	10.380845	181.9	 20.03	160.41013
158.25	19.226603	169.2	 18.35	166.6182
159.35	12.401168	175.5	 18.85	161.72912
154.55	17.40379	100.5	 19.08	166.71728
157.68333	11.871214	157.5	 18.68	160.13429
159.25	15.084391	174.1	 18.22	162.90601
154.55	14.289295	127.3	 17.44	165.62857
156.78333	19.690662	119.3	 17.11	167.15327
152.01667	19.458634	100.2	 16.47	162.6729
153.21667	15.448825	122.0	 17.23	165.54798
158.75	15.316303	153.5	 16.88	161.27882
159.15	11.241932	155.8	 17.15	160.04314
155.21667	18.530571	135.7	 15.66	166.47502
159.51667	19.359194	136.6	 16.18	165.01002
158.51667	15.614487	122.9	 15.92	160.31009
151.61667	17.602623	142.3	 17.22	158.02703
157.78333	16.608501	111.7	 16.31	162.65237
153.41667	22.899918	173.9	 31.43	162.11566
156.53333	20.248525	156.9	 35.58	166.62691
152.98333	23.4303	176.5	 31.91	161.40308
158.36667	21.143272	166.1	 30.25	167.48094
154.6936	21.216278	146.1	 30.93	164.35039
150.18333	20.016571	148.0	 29.72	152.90934
150.1	24.20937	152.9	 30.07	157.19955
153.46667	27.940191	166.2	 28.45	159.55969
155.01226	20.973333	118.5	 28.91	164.78309
159.31667	23.811535	149.5	 27.44	164.43939
159.71667	21.375256	149.4	 24.94	167.78872
159.46667	21.557543	151.4	 25.26	167.99228
153.21667	21.30898	163.3	 25.39	162.38565
151.80833	27.31824	150.4	 27.04	158.69547
157.28333	23.629205	210.7	 24.47	165.08217
157.12026	21.039586	100.8	 32.38	166.62292
153.38333	23.223117	123.5	 22.33	162.14882
151.88333	23.662352	157.8	 23.54	160.34585
159.35	22.071258	192.8	 23.60	167.60451
156.35	20.927858	133.8	 27.50	166.12942
158	23.264547	136.1	 24.55	165.84026
151.65	20.049704	185.4	 23.16	161.85033
154.01667	24.259101	111.5	 25.22	162.2696
156.68333	21.673535	165.6	 21.56	165.88947
156.88333	22.999363	155.2	 20.98	165.15676
155.01667	22.833619	122.1	 20.19	163.92073
152.61667	24.922216	125.5	 20.05	160.84081
158.95	24.027029	113.7	 20.87	164.32984
155.85	23.231401	112.4	 18.50	164.26446
155.51667	23.065653	113.0	 18.69	164.13021
154.48333	24.424876	164.5	 18.32	162.49462
158.11667	23.794966	147.5	 18.67	165.57912
155.98333	20.381071	158.2	 18.31	166.00216
152.88333	27.641647	117.4	 17.92	159.34051
151.15	20.480484	175.4	 18.81	161.03492
152.35	27.144105	128.4	 17.31	159.15965
157.51667	26.911936	119.9	 17.30	158.91243
158.81667	24.65696	138.4	 14.95	162.88298
154.45	22.568439	162.6	 17.46	163.6736
157.65	21.209557	129.3	 15.37	166.90516
155.35	22.104409	137.9	 16.67	164.63664
158.38333	23.662352	106.6	 13.49	165.81628
155.68333	22.833619	105.7	 13.30	164.4025
152.31667	24.259101	120.2	 16.25	160.77532
154.58333	22.13755	118.3	 16.36	163.90432
151.15	31.57556	153.6	 17.88	149.2934
166.95	-0.51359428	136.2	 20.23	138.44749
165.31667	-2.2684037	127.1	 20.59	136.88143
164.95	-2.5994938	104.0	 22.19	136.59589
168.51667	-8.493243	101.4	 20.14	NaN
169.55	-0.84468896	114.8	 16.88	136.97026
163.78333	-2.8312559	113.2	 16.89	136.77174
164.125	-49.526339	120.0	 28.04	NaN
164.75833	-48.778531	119.1	 27.83	NaN
164.33333	-49.23551	101.1	 23.62	NaN
164.58333	-51.07139	116.7	 20.29	NaN
161.51667	-58.652411	119.7	 17.32	NaN
165.675	9.0152512	144.7	 34.18	163.97692
167.6375	9.0111077	149.7	 30.64	162.84661
168.78333	7.4172447	134.4	 29.04	157.39032
162.91667	5.2812805	147.6	 28.45	156.79154
167.11667	9.2885038	138.9	 28.43	164.01888
169.89167	9.4789593	149.1	 25.17	162.59425
168.21667	7.8312141	154.3	 26.56	158.86601
169.41667	6.0097969	125.8	 25.33	151.03636
166.83333	9.3381868	139.8	 28.60	164.35984
163.18333	8.8248023	186.8	 24.19	165.1112
169.68333	6.0097969	118.2	 23.80	150.75973
160.95	8.8579297	155.7	 26.68	166.70024
168.61667	4.6521163	130.1	 26.08	148.44832
167.95	5.7448745	146.2	 22.82	151.88783
161.11667	9.6859723	134.9	 22.07	166.79935
168.06667	8.1789623	117.0	 25.28	159.90856
169.71667	7.5000357	160.8	 21.71	156.92304
160.46667	9.7687765	134.0	 21.91	165.9506
160.63333	8.3445629	126.9	 21.75	165.29268
169.21667	9.8681462	114.5	 19.32	164.40181
169.78333	8.8248023	131.8	 22.24	160.74019
167.35	8.3279998	132.1	 21.22	160.82701
162.18333	8.9572925	125.1	 22.32	166.17849
168.46667	7.2516538	100.1	 21.61	157.19931
168.93333	7.8312141	107.0	 23.12	158.3529
160.81667	9.8515912	114.6	 18.75	165.93964
166.28333	8.9572925	108.5	 21.26	163.37644
161.71667	8.3942425	150.9	 19.75	164.63615
160.55	8.0961678	106.7	 18.29	164.62565
162.31667	9.3878698	104.8	 18.47	167.41434
168.15	5.6124194	107.1	 16.73	151.34637
169.48333	7.3675682	132.1	 17.83	156.18079
169.11667	5.6455307	146.1	 17.51	150.42911
166.08333	9.4209887	126.1	 17.14	165.10288
169.75	5.0494771	145.7	 16.00	148.27555
167.58333	5.9104518	132.2	 15.98	151.97504
167.78333	5.2481599	130.9	 16.23	150.37988
169.41667	7.8312141	122.8	 14.46	158.00149
169.91667	8.1955253	126.5	 16.83	159.00613
169.18333	4.1223146	106.7	 15.72	147.15924
168.01667	4.3209903	108.2	 15.00	148.1534
160.88333	9.2885038	114.6	 14.59	167.92935
168.71667	8.7585676	117.6	 16.46	161.36907
167.42083	14.073963	163.0	 44.59	159.90752
160.45	14.918738	173.9	 33.28	167.38957
162.98333	15.21691	179.9	 31.31	163.70786
160.23333	19.607796	171.1	 32.99	164.86859
163.05	16.144611	172.4	 30.00	161.82187
165.28333	11.639372	149.3	 30.99	162.96061
162.18333	19.657517	182.9	 29.85	165.3902
168.90833	14.595728	167.5	 31.38	162.64621
167.41667	11.374407	155.3	 30.10	165.21445
164.89167	19.19346	147.5	 29.87	166.94317
166.81667	11.374407	142.2	 27.56	164.88947
162.91667	10.149027	146.2	 30.12	166.56143
162.69167	17.080695	171.7	 26.71	160.359
165.85	14.388679	190.2	 26.00	160.08035
164.78333	11.904342	136.3	 28.29	161.68655
161.38333	11.93746	162.8	 22.31	160.70916
162.76667	13.179566	181.4	 25.94	162.86061
164.45	13.560501	163.9	 26.07	160.85234
168.85	12.202436	207.9	 25.93	163.16316
162.3	11.291611	134.0	 26.00	161.84847
169	10	142.9	 24.43	165.02184
160.98333	14.388679	211.3	 24.73	170.13183
165.98333	10.082789	149.6	 26.13	167.36291
163.81667	13.825512	113.6	 24.45	161.87984
167.41667	18.033441	140.2	 27.66	167.69944
160.44167	10.687193	145.7	 23.78	162.483
167.45	19.359194	160.5	 23.89	165.85583
169.54691	11.227475	138.3	 22.53	164.81064
166.28333	11.175689	142.1	 27.54	165.22457
163.55	13.560501	129.0	 27.75	162.08988
165.86667	18.364864	137.1	 26.77	166.3835
169.98333	10.364293	132.2	 28.29	164.98432
161.56667	11.689053	137.7	 26.73	160.02419
165.05	18.497431	183.3	 23.69	165.66489
166.88333	19.690662	153.8	 22.89	165.94053
163.15	14.09053	128.8	 27.25	163.56475
160.78333	10.480198	150.9	 24.63	163.55442
162.08333	11.738734	120.1	 23.31	160.12586
161.45	10.910743	140.9	 24.89	162.53223
167.15	16.509095	204.4	 22.81	164.16732
166.61667	19.326041	173.4	 21.65	166.96455
165.05	11.821533	105.0	 21.80	162.16841
167.28333	17.138682	143.5	 21.46	165.71028
161.68333	13.229253	138.4	 21.68	164.78648
164.05833	14.049118	108.9	 23.44	161.61407
161.11667	11.473767	174.1	 22.01	160.24169
165.98333	17.238095	182.4	 21.39	164.13231
161.11667	13.494257	175.9	 20.84	166.30586
166.91667	11.871214	116.8	 23.26	163.31014
160.48333	10.082789	125.7	 21.29	164.7861
163.48333	14.753087	154.6	 20.88	162.8202
164.75	12.169307	104.3	 21.64	160.76686
163.11667	15.780152	113.9	 19.82	162.41819
161.05	18.530571	118.2	 23.50	160.7259
164.55	19.127166	109.1	 22.10	166.49668
162.68333	10.546438	109.3	 22.51	164.93205
160.35504	15.650886	147.6	 18.97	164.60247
165.31667	16.608501	186.6	 19.42	161.83357
160.71667	10.248378	117.7	 19.21	164.36721
164.48333	13.129879	131.1	 19.07	160.53018
166.21667	12.235554	158.6	 19.02	161.65636
160.0609	15.745015	154.5	 16.85	163.6434
164.63333	12.881449	127.9	 18.60	160.25605
169.79203	11.321568	150.3	 16.27	164.4078
161.45	13.891769	144.8	 18.29	167.88582
164.45	15.846411	105.2	 18.96	160.37426
166.68333	18.530571	118.4	 18.22	167.738
169.45	13.129879	167.0	 18.58	162.14278
166.53333	10.596115	100.0	 20.22	167.32861
162.61667	12.699274	125.1	 17.88	161.8653
163.41667	10.281493	140.6	 18.28	166.46763
162.45	10.778262	101.1	 20.84	163.87742
161.31667	12.401168	126.9	 17.75	162.16743
166.91667	17.900882	134.8	 17.67	166.79332
162.26667	12.185871	150.4	 18.23	160.80324
162.11667	19.160318	127.7	 17.31	164.02431
163.61667	12.136189	107.9	 17.55	160.08954
160.25	11.175689	149.4	 17.67	160.54036
168.31667	17.03927	109.4	 17.10	166.92883
161.78333	15.54822	185.7	 17.63	165.89359
165.85	19.42548	178.3	 17.66	167.73229
162.88333	11.705616	136.3	 14.88	160.85321
168.71667	15.349431	119.5	 15.19	163.95619
160.91667	15.448825	120.7	 15.47	166.55885
168.15	12.599904	143.0	 17.08	161.75451
167.48333	18.762581	115.4	 15.26	166.93875
161.55	18.398003	115.7	 14.77	161.04695
169.55	10.115913	123.2	 13.45	165.02883
161.05	11.142573	132.0	 16.68	161.33279
166.95	15.150646	116.9	 15.05	160.86622
162.75	19.922696	105.5	 14.47	166.5813
164.58333	19.657517	124.8	 16.71	167.62504
166.41667	16.641633	106.6	 14.27	163.42958
160.71667	20.347936	155.7	 31.01	166.25631
163.35	20.215391	163.9	 25.58	167.79324
161.48333	22.369563	179.5	 25.32	165.48105
160.05	21.275833	149.2	 24.84	167.5901
163.90833	20.439068	135.0	 27.84	167.32623
160.78333	23.861263	171.5	 23.66	162.17621
160.61667	21.69011	141.7	 25.85	167.89341
163.01667	20.314802	137.9	 21.51	167.82821
161.93333	21.656971	153.4	 21.94	166.64023
162.25	23.231401	140.0	 23.49	161.45711
160.88333	22.634736	167.7	 21.36	165.88391
162.18333	23.794966	127.0	 21.31	159.98734
168.75	27.774338	169.2	 20.56	137.22138
162.75	21.242695	128.7	 20.26	166.19801
166.48333	21.143272	192.2	 20.13	163.75627
166.15	27.475802	141.9	 19.83	141.60057
161.98333	25.021688	106.9	 20.81	154.19089
161.18333	20.745595	100.6	 20.04	166.9951
162.15	22.336421	124.8	 18.38	164.2306
162.65	21.905544	106.0	 17.79	164.46602
164.21667	24.159639	119.9	 16.80	152.77652
162.71667	22.866764	101.0	 16.78	161.55365
160.71667	21.209557	115.1	 14.47	167.48982
160.48333	21.209557	114.8	 14.42	167.47329
161.68333	20.049704	115.3	 15.29	165.92897
169.08333	21.806114	107.9	 15.07	159.13616
161.88333	27.774338	103.3	 14.96	147.82349
165.78333	27.575312	100.6	 15.67	141.97027
160.25	22.13755	100.4	 13.07	168.01476
169.19167	45.937986	138.4	 37.78	96.562939
169.45	46.428261	117.7	 32.13	92.486609
169.68333	47.05986	129.4	 35.33	87.811437
170	45.564079	138.4	 31.05	94.837974
169.96667	44.882806	101.8	 22.86	99.053341
169.15	48.489552	101.3	 27.66	NaN
168.43333	48.148717	104.5	 28.53	NaN
169.89167	40.290528	101.7	 22.05	117.47641
174.28333	-0.66258859	175.4	 34.76	136.44218
175.55	-1.8379752	172.6	 29.03	134.03808
174.78333	-1.3082271	144.1	 28.56	135.17518
179.15	-8.493243	147.5	 28.91	NaN
177.36667	-6.175369	146.3	 28.00	125.61792
176.38333	-1.3082271	129.5	 27.57	134.5837
176.33333	-6.1588101	167.2	 25.32	125.98881
178.31667	-7.9965364	147.5	 25.23	NaN
176.05	-5.6124807	158.7	 24.03	126.55124
179.81667	-9.3873456	151.0	 23.42	NaN
175.71667	-3.9569841	129.9	 24.71	129.96057
174.64167	-1.0930116	121.5	 24.08	135.58508
178.65	-7.4667316	138.7	 22.03	NaN
175.93333	-1.2585627	116.8	 24.85	134.84832
179.71667	-6.0098103	145.5	 21.42	NaN
175.08333	-1.5399903	117.4	 23.28	134.68619
179.1	-7.4501719	126.5	 23.87	NaN
176.8	-2.6160518	140.9	 21.51	132.37407
175.95	-2.4670598	149.4	 21.00	132.87481
177.11667	-7.2018284	122.8	 21.77	NaN
177.26667	-7.5495101	121.4	 21.52	NaN
176.18333	-2.0697476	128.1	 20.47	133.45281
179.51667	-5.5131489	155.7	 19.46	124.93216
176.75	-6.5064789	139.8	 19.61	NaN
173.61667	-0.18249765	111.5	 20.36	137.67542
178.01667	-0.67914675	155.5	 18.40	127.97096
176.61667	-2.4670598	112.2	 17.13	132.69103
175.68333	-5.5793733	129.8	 17.77	126.96241
178.98333	-4.7185026	106.2	 16.64	125.85407
176.48333	-5.281379	140.1	 16.15	126.75335
175.38333	-2.4008378	133.7	 15.59	133.15336
176.58333	-4.6853959	145.4	 16.71	128.07074
176.38333	-2.6657158	118.1	 15.12	132.42286
178.88333	-9.3542332	125.3	 14.79	NaN
175.51667	-0.84468896	120.5	 15.37	135.67932
179.28333	-5.2151549	119.9	 14.25	125.30783
175.11667	-5.3476031	103.1	 15.00	127.96306
177.88333	-6.7713753	107.8	 13.86	NaN
179.78333	-8.7250501	103.5	 14.63	NaN
176.88333	-2.9637	103.7	 15.84	131.76849
178.45	-2.2684037	116.2	 16.58	126.79162
179.55	-10.477509	170.4	 30.67	NaN
178.36667	-11.1894	149.2	 30.09	NaN
173.65	-11.835096	149.3	 23.99	NaN
172.21667	-11.868215	146.8	 21.95	NaN
174	-11.868215	132.7	 21.33	NaN
179.43333	-11.321855	144.1	 22.60	NaN
179.75	-10.858285	120.6	 21.71	NaN
175.31667	-11.570199	102.2	 22.97	NaN
179.96667	-11.52053	128.9	 24.61	NaN
176.71667	-11.735756	104.4	 23.48	NaN
178.65	-11.139732	108.6	 21.89	NaN
179.68333	-11.934435	103.6	 18.20	NaN
179.35	-11.735756	148.0	 16.06	NaN
170.01667	9.0897741	194.1	 32.77	161.3083
172.71667	3.1951812	185.3	 32.49	145.39989
173.41667	0.23176802	161.5	 29.38	138.42056
171.075	8.7668445	136.8	 29.70	159.52361
172.38333	5.6124194	161.7	 30.05	150.35967
172.01667	6.1422544	151.1	 28.08	151.50124
171.15	7.168864	144.5	 28.99	153.50658
171.6	7.052951	147.0	 29.50	153.33078
171.05	8.2783205	138.4	 30.03	158.27972
176.06667	5.2316095	130.6	 30.71	140.7309
172.91667	1.4071901	134.0	 26.15	140.56744
172.58333	4.4865577	142.7	 24.92	148.32555
171.65	6.0760306	141.3	 26.26	151.44142
176.01667	5.7448745	109.4	 25.73	141.32871
172.98333	1.8045166	128.5	 25.07	141.85076
172.75	1.9369559	137.8	 26.90	141.55179
172.88333	4.3044307	132.9	 23.21	147.83229
173.75	0.41388075	123.4	 22.44	138.52148
170.93333	7.9802481	123.4	 26.77	157.66875
172.94167	3.5180206	131.0	 22.97	145.97564
172.46667	4.7845758	124.6	 21.76	148.90568
172.86667	0.89397604	121.3	 23.68	139.72969
173.48333	2.3011781	166.4	 20.76	142.65351
177.38333	9.1228922	162.2	 20.40	142.50729
175.81667	1.4734044	142.9	 20.16	139.12626
174.15	2.3011781	129.4	 20.75	142.16745
170.25	9.5203557	117.0	 19.75	162.44198
172.1	6.7549009	118.7	 23.82	152.46978
170.58333	5.1819387	165.6	 19.37	147.75181
171.98333	7.1026264	104.1	 20.90	153.13287
174.36667	2.1521792	108.7	 17.44	141.66094
172.85	4.718346	110.8	 17.21	148.55334
173.28333	2.0362881	142.3	 17.75	142.18431
173.48333	5.9104518	162.0	 17.89	150.1361
175.11667	0.9767485	129.2	 17.13	138.76393
173.28333	3.7911947	104.6	 17.66	146.34448
177.3	8.2783205	106.1	 16.82	142.1834
176.45	4.6521163	144.5	 16.18	139.90521
172.75	7.1026264	147.1	 16.39	152.58541
173.55	1.5065216	123.7	 16.49	140.71179
172.31667	7.3675682	135.5	 16.60	153.32918
174.65	2.3673933	111.1	 14.92	141.95736
173.31667	6.1422544	110.1	 13.23	150.62573
171.58333	7.7649838	103.6	 14.11	156.80523
172.78333	5.6786518	104.2	 16.09	150.20683
171.91667	19.723807	171.3	 29.03	158.93648
173.27384	19.225777	122.3	 31.78	157.72652
170.11667	11.0101	140.1	 29.99	164.28187
179.01667	13.361749	173.7	 23.41	138.40054
173.91667	17.33751	144.3	 22.50	160.46526
179.48333	19.491777	150.3	 22.78	125.50238
170.81667	18.398003	101.7	 28.48	163.07836
178.71667	10.049675	131.3	 21.85	139.3924
172.61667	17.834598	105.1	 23.16	161.44152
173.61667	18.116301	127.2	 21.71	159.32403
175.55	13.361749	164.4	 20.02	165.50712
170.07853	12.311221	133.0	 18.90	163.42829
175.35	13.726134	137.7	 20.16	165.71845
178.48333	18.000304	109.2	 21.83	132.04681
172.28333	16.442821	121.6	 20.51	164.76235
172.55	16.04521	125.8	 20.27	165.17727
176.15	19.690662	104.8	 22.45	142.4569
174.05	18.298576	108.1	 22.75	158.29957
179.73333	14.604007	111.6	 20.41	134.22662
177.21667	18.464292	123.9	 19.28	137.0541
173.15	19.856406	138.0	 18.57	156.17876
174.78333	14.819349	106.6	 18.55	164.33299
178.01667	14.123654	108.9	 18.25	142.78602
172.18333	18.729431	134.5	 18.70	160.38524
170.85	10.281493	127.7	 18.40	163.23468
177.98333	18.497431	105.5	 17.67	132.73427
175.65	12.831764	119.4	 17.88	166.1247
177.48333	19.326041	134.1	 18.55	133.22491
173.18333	12.268673	103.7	 17.73	160.07506
171.08333	11.341291	129.4	 17.54	162.78959
172.88333	19.922696	131.6	 17.71	157.05655
174.48333	14.289295	107.4	 17.23	165.88545
173.68333	13.958015	139.9	 17.33	167.79032
179.66667	19.243179	112.4	 17.04	125.53832
170.15227	12.00454	151.4	 16.91	163.57953
172.18333	14.09053	139.6	 16.63	166.49282
175.58333	14.189912	116.5	 15.74	162.58856
173.95	19.591219	123.8	 16.64	153.58397
176.65	19.359194	129.8	 16.59	138.69061
172.68333	18.729431	104.1	 15.91	159.60559
179.88333	13.428003	106.7	 14.02	135.29472
178.91667	13.096758	116.2	 15.67	138.93738
170.78333	10.579552	114.5	 16.49	163.31668
170.38333	10.513323	108.4	 16.43	164.10693
172.08333	20.215391	136.1	 22.95	157.75934
175.63333	22.94964	158.5	 21.86	143.15429
176.48333	22.601593	166.4	 21.67	142.26204
175.55	21.971826	115.7	 22.39	145.63408
173.75	21.209557	132.2	 20.44	150.69462
173.38333	20.811877	113.0	 22.88	152.13846
176.38333	21.706685	131.0	 20.10	144.50165
179.05	29.831303	154.1	 18.56	124.23329
174.31667	21.275833	109.1	 19.95	149.54585
178.1	22.054692	113.4	 21.43	124.91186
179.31667	29.665399	150.9	 18.17	123.79485
174.71667	29.366771	137.5	 18.32	132.72161
174.21667	20.347936	121.3	 18.64	151.57585
171.63333	22.054692	121.6	 17.92	152.45676
172.91667	20.811877	100.1	 20.28	152.96485
173.51667	20.082837	104.0	 17.43	153.36256
176.18333	28.835908	121.6	 15.74	130.72107
171.55	29.068159	113.1	 14.34	135.7088
177.21667	20.016571	122.0	 16.30	133.36333
179.06667	20.132542	103.8	 15.34	124.96989
175.58333	29.20087	129.4	 16.95	131.3506
171.45	28.802734	102.4	 13.91	136.62294
176.08333	20.248525	101.0	 16.24	143.36067
171.11666	38.679031	200.6	 36.51	118.5982
171.9	34.835764	137.4	 29.75	121.75357
170.88333	38.147616	154.9	 28.19	119.34813
170.34166	37.989868	149.8	 27.26	119.85155
172.28333	32.670394	176.4	 27.30	124.86636
173.11667	32.006842	203.1	 26.33	124.26882
171.01666	35.690524	130.2	 28.21	121.42092
171.4625	36.723868	157.4	 26.08	119.63562
171.09166	37.78231	138.6	 25.23	119.36611
171.775	34.48726	125.5	 27.19	122.6801
172.81667	32.27225	184.8	 23.97	124.49923
175.78333	30.995047	133.3	 25.69	120.37545
171.68333	36.354492	128.9	 21.36	119.69254
171.65	33.234479	195.5	 20.11	125.17519
172.25	32.106371	178.7	 19.96	125.65882
170.10833	38.330288	106.1	 19.30	119.69856
171.31666	33.765425	145.5	 18.60	125.07181
171.64357	33.744976	149.1	 14.55	124.57683
171.92013	33.764967	155.4	 13.96	124.10791
177.55	30.381413	160.9	 15.78	126.62303
178.68334	30.281911	161.8	 16.69	124.62179
171.41666	34.296428	130.0	 13.89	123.67228
175.88333	33.134931	118.5	 16.59	118.51213
170.35	44.533892	151.3	 33.57	99.486884
170.6	41.045959	140.9	 27.74	114.15855
170.11667	45.198512	136.5	 30.28	96.525699
170	45.564079	139.5	 30.96	94.837974
170.46667	43.088627	147.2	 32.04	106.7382
170.51667	40.747094	130.2	 25.63	115.14912
170.41667	44.268064	124.3	 27.58	100.74581
170.51667	42.349524	126.8	 27.59	109.86832
170.66667	41.328232	128.7	 25.35	113.14615
170.3	40.514658	133.7	 26.33	116.16619
170.61667	41.84301	124.7	 27.13	111.53076
170.21667	42.507308	110.1	 23.96	110.22834
170.3	40.249021	116.9	 23.01	116.69881
170.7625	42.536366	109.2	 23.76	108.29516
170.16667	40.049803	114.9	 22.62	117.30759
170.25	43.636787	160.0	 20.43	104.80003
170.18333	41.743372	130.4	 14.53	113.2146
187.78333	-4.519843	178.2	 24.28	NaN
185.2125	-1.751063	130.7	 28.64	NaN
188.28333	-2.7981499	146.2	 24.24	NaN
188.88333	-3.1292402	151.2	 25.07	NaN
186.08333	-5.463483	152.1	 24.19	NaN
184.68333	-1.6724347	127.7	 27.98	NaN
185.48333	-4.6853959	168.7	 22.50	NaN
188.15	-9.1886525	139.0	 22.53	NaN
187.51667	-8.5263638	122.5	 24.85	NaN
186.25	-7.2183879	132.6	 24.79	NaN
184.88333	-2.6988218	153.6	 22.25	NaN
185.15	-4.155642	127.5	 23.35	NaN
188.75	-9.3873456	116.7	 22.59	NaN
189.28333	-3.6921042	141.5	 20.32	NaN
183.78333	-0.92746985	123.5	 22.86	127.88436
188.71667	-4.4536299	180.6	 20.16	NaN
185.85	-3.5927757	162.1	 19.96	NaN
189.78333	-5.5793733	116.0	 21.29	NaN
186.7	-3.8576553	106.6	 22.57	NaN
187.08333	-8.1621074	127.2	 19.24	NaN
185.28333	-3.3941188	154.0	 18.84	NaN
188.48333	-3.5596695	166.4	 18.43	NaN
188.98333	-0.61292387	139.3	 17.38	NaN
186.4	-6.4237036	120.1	 17.02	NaN
185.88333	-5.7780375	109.1	 16.81	NaN
186.35	-6.1422611	118.9	 16.84	NaN
183.88333	-0.34804122	159.7	 17.42	128.00214
189.41667	-0.57981726	143.2	 16.37	NaN
184.05	-1.5399903	130.3	 14.57	127.67248
183.75	-0.57981726	121.7	 13.27	127.99402
189.08333	-3.8907616	115.6	 16.60	NaN
186.58333	-6.6720401	118.6	 16.80	NaN
183.85	-1.3082271	109.4	 16.43	127.77862
187.925	-13.929643	163.9	 33.96	NaN
182.51667	-12.464264	149.2	 34.03	NaN
183.85	-13.325254	140.4	 31.80	NaN
183.25	-12.530486	182.9	 27.29	NaN
189.11667	-14.318772	158.7	 26.98	NaN
181.71667	-11.801986	147.4	 25.28	NaN
186.81667	-13.225905	138.4	 28.68	NaN
186.01667	-12.265579	151.8	 23.43	NaN
187.15	-13.490839	145.6	 22.62	NaN
187.35	-13.656426	101.9	 21.12	NaN
182.11667	-11.702647	143.6	 24.63	NaN
185.68333	-12.530486	155.5	 23.99	NaN
180.58333	-12.3318	130.0	 24.82	NaN
184.25	-12.199348	150.7	 22.48	NaN
189.88333	-14.020709	159.1	 21.95	NaN
182.98333	-13.590189	142.6	 24.39	NaN
180.2	-11.735756	120.9	 23.09	NaN
180.71667	-12.795407	141.0	 22.52	NaN
180.31667	-12.133117	110.8	 21.15	NaN
189.89167	-14.442967	120.8	 20.54	NaN
184.31667	-12.894753	143.8	 20.36	NaN
185.39612	-13.035695	126.5	 18.75	NaN
188.61667	-14.037272	104.3	 21.62	NaN
183.35	-13.656426	127.6	 21.82	NaN
182.01667	-12.596718	109.5	 22.26	NaN
189.35	-14.881801	152.7	 19.89	NaN
189.54167	-14.293934	111.1	 18.88	NaN
185.15	-12.265579	127.7	 19.70	NaN
184.61667	-12.762296	130.7	 18.51	NaN
187.76667	-13.242467	119.2	 17.76	NaN
185.73333	-13.076884	117.9	 17.72	NaN
185.38333	-12.166237	110.0	 16.97	NaN
180.78333	-10.643058	165.8	 16.36	NaN
183.08333	-11.040396	164.2	 17.12	NaN
180.28333	-10.179513	160.5	 15.38	NaN
186.38333	-13.225905	133.8	 16.51	NaN
188.88333	-11.040396	143.1	 16.16	NaN
188.78333	-14.418128	101.6	 11.64	NaN
183.88333	-12.232458	100.4	 14.98	NaN
185.78333	-27.595914	202.0	 26.89	NaN
185.35	-26.535072	153.1	 29.98	NaN
186.55	-28.607187	145.7	 26.13	NaN
188.98333	-27.562764	125.1	 23.05	NaN
186.11667	-27.993773	136.1	 18.28	NaN
186.61667	-29.618609	141.8	 17.32	NaN
185.55	-27.264386	111.6	 14.86	NaN
186.38333	-28.159558	118.4	 15.91	NaN
186.78333	-29.320142	118.7	 16.23	NaN
187.78333	-31.439951	161.3	 30.48	NaN
189.66667	-35.486259	153.8	 26.51	NaN
188.26667	-32.600525	133.7	 22.22	NaN
188.91667	-36.83007	133.7	 20.78	NaN
186.81667	-30.395605	141.8	 18.83	NaN
188.55	-33.678375	162.8	 18.08	NaN
186.68333	-30.130395	142.1	 18.87	NaN
188.51667	-33.346712	158.5	 17.61	NaN
187.08333	-30.627665	135.5	 18.00	NaN
188.08333	-32.219166	139.9	 17.68	NaN
188.38334	-32.981896	123.6	 16.75	NaN
189.35	-34.739824	155.9	 17.17	NaN
183.51667	-34.109563	117.6	 14.20	NaN
188.75	-33.943723	117.5	 16.40	NaN
189.18334	-35.005206	105.0	 15.51	NaN
183.38333	0.81120364	175.5	 20.35	128.77994
186.5	5.3475019	116.1	 20.89	NaN
180.71667	0.9105345	110.4	 22.77	130.44739
183.48333	0.21521954	152.0	 17.97	128.42756
188.05	1.8045166	134.2	 15.78	NaN
182.48333	1.7051848	155.2	 17.31	130.02204
186.2	5.62898	126.3	 16.14	133.27898
182.38333	2.7978442	106.3	 15.71	130.96192
186.05	6.0760306	138.4	 17.13	133.34974
180.75	5.4468444	100.2	 14.88	134.51494
188.91667	15.167214	165.6	 29.31	124.15382
187.95	15.415697	191.1	 24.63	123.79497
186.96667	14.951864	110.9	 29.13	126.52072
180.85	12.599904	137.8	 22.34	133.40173
189.6	15.829851	106.6	 24.41	120.83706
189.60833	14.065684	110.9	 26.34	126.51736
188.01667	13.858635	141.0	 20.48	126.84478
188.59167	10.008276	100.7	 24.19	133.24777
189.88333	10.811387	105.4	 21.74	125.23571
189.01667	19.392337	127.1	 21.12	114.48033
188.11667	18.232289	118.3	 20.79	115.73494
188.18333	12.202436	169.2	 20.56	126.89926
187.01667	11.672489	132.3	 19.62	128.77439
182.88333	15.87955	123.4	 19.62	123.13991
186.51667	14.504621	108.4	 20.56	126.62819
183.5	18.480856	104.2	 21.81	119.96264
181.65	18.331715	107.7	 19.09	122.81169
186.26667	17.851171	108.2	 18.60	117.64797
188.81667	15.680755	146.0	 18.99	122.13325
187.25	12.268673	152.5	 18.30	127.17496
184.11667	19.657517	117.4	 18.04	118.79953
184.98333	19.19346	105.9	 18.11	118.1375
184.98333	18.63	104.1	 17.65	118.54693
186.58333	13.494257	149.9	 17.59	126.84402
187.75	10.811387	144.1	 17.66	135.27031
184.51667	16.475963	117.5	 17.59	119.8815
188.28333	15.647616	139.8	 17.68	122.63221
185.21667	13.295506	110.5	 17.24	126.57304
189.15	10.976974	146.3	 17.60	125.99443
180.25	19.259755	136.7	 17.34	124.53104
189.3	19.591219	100.5	 16.69	114.14721
187.68333	14.918738	104.7	 16.72	125.87474
180.71667	13.494257	141.9	 14.85	132.64846
184.95	16.177752	157.2	 17.14	120.97709
184.41667	19.42548	131.2	 15.98	118.613
188.75	11.109457	126.9	 15.55	126.32767
188.18333	10.281493	118.8	 14.91	134.38059
188.55	11.506894	116.9	 14.06	126.57932
187.01667	17.967166	111.5	 14.94	116.88778
181.28333	18.69629	111.0	 14.94	123.17484
188.31667	15.018128	102.2	 13.17	125.00208
182.35	18.59686	103.8	 13.05	121.45829
188.61667	14.09053	124.2	 16.84	126.81268
186.05	14.620574	105.3	 15.74	126.35351
182.78333	15.54822	101.2	 16.09	123.6736
189.35	25.452747	172.7	 41.61	114.19865
184.13333	27.890432	178.0	 33.34	118.9172
186.03333	26.016489	160.0	 31.82	118.73015
187.59251	25.635025	167.7	 32.45	116.17544
182.55	28.271929	158.5	 30.07	119.7844
188.28333	25.817517	204.9	 27.59	115.76222
186.61667	26.016489	186.3	 25.60	118.32768
181.61667	28.404624	192.3	 26.83	120.30932
183.51667	26.945099	193.8	 26.09	120.05763
185.95	29.167694	205.8	 25.13	117.49542
183.33333	28.553912	184.9	 25.01	119.23752
189.73333	25.170899	107.9	 25.99	111.78244
180.98333	28.835908	145.0	 23.61	121.02859
181.38333	28.93544	144.6	 23.54	120.30967
185.48333	26.314957	163.1	 21.61	118.99654
184.38333	27.011437	186.4	 22.84	119.48487
182.05	27.940191	189.1	 22.00	120.17574
188.85	25.485913	132.9	 21.20	115.53628
180.41667	28.968624	189.4	 20.83	122.15981
186.01667	29.864492	187.3	 21.20	117.29968
186.21667	24.756428	165.4	 21.57	117.13401
187.51667	25.253792	119.3	 20.13	116.30507
186.93333	24.01045	117.4	 24.18	114.68363
188.95	27.97337	168.5	 20.73	116.19191
183.78333	20.579898	117.8	 22.78	118.76614
189.28333	20.679314	112.8	 23.89	113.21404
184.45	27.74116	101.9	 19.09	118.83917
187.95	25.353269	192.9	 17.47	116.04446
187.15	20.546763	115.5	 18.92	115.44738
187.01667	20.281658	114.1	 18.70	115.67395
180.65	21.242695	103.4	 18.93	121.99965
187.2	24.706694	117.1	 17.52	114.32248
187.05	25.651708	153.4	 14.66	116.92902
183.75	20.977568	138.7	 15.21	118.68256
184.78333	27.907022	132.3	 14.59	118.5136
188.91667	28.703204	124.4	 15.44	116.01837
182.71667	27.011437	139.0	 16.43	120.83039
185.01667	27.575312	108.7	 15.45	118.88046
182.11667	24.690123	116.6	 12.62	124.42045
183.15	27.011437	119.4	 16.08	120.26311
182.11667	26.480783	135.4	 16.64	122.73762
187.41667	23.496604	112.8	 13.24	114.34876
186.21667	24.325412	111.1	 14.93	115.26192
181.88333	29.101334	107.1	 13.67	119.97161
189.38761	20.183003	119.6	 16.11	113.89204
184.83333	32.720164	134.5	 26.21	116.71031
185.71667	31.807788	131.5	 24.70	116.37395
184.08333	33.599505	101.8	 23.31	115.52037
181.95	33.864983	121.9	 19.89	108.0238
184.7	32.985613	106.9	 20.83	116.72083
185.41667	30.746271	181.9	 19.63	117.49302
186.98333	30.679929	152.2	 18.48	116.54485
186.25	31.210664	103.6	 18.74	116.72431
185.21667	31.807788	102.2	 16.74	116.72516
180.31666	31.177486	169.6	 17.02	120.44689
198.18333	-8.2614485	158.3	 27.15	NaN
199.98333	-9.5529281	140.7	 21.99	113.51026
197.45	-7.1024917	153.2	 22.37	NaN
199.48333	-7.4667316	120.0	 26.41	113.88319
199.85	-8.3939008	125.4	 22.08	113.62934
198.11667	-7.6654083	123.6	 21.19	NaN
197.81667	-5.8442624	157.8	 18.98	NaN
197.93333	-9.5363668	105.3	 18.65	NaN
197.25	-6.0098103	159.7	 18.79	NaN
199.98333	-0.34804122	152.8	 17.80	112.40766
197.71667	-8.5263638	106.3	 16.08	NaN
191.25	-2.0366315	105.6	 15.19	NaN
197.21667	-5.3144861	104.4	 15.10	NaN
190.01667	-19.05567	143.6	 26.95	NaN
190.28333	-14.153188	165.4	 22.81	NaN
196.88333	-18.061741	135.3	 20.97	NaN
194.08333	-10.907952	171.4	 21.36	NaN
192.21667	-19.983429	157.6	 21.32	NaN
198.98333	-10.378177	125.0	 21.49	NaN
196.81667	-13.292141	119.4	 22.81	NaN
190.18333	-14.583726	121.8	 20.71	NaN
196.55	-17.962354	123.4	 19.11	NaN
190.55	-14.219417	124.6	 17.18	NaN
194.38333	-11.106623	136.0	 18.06	NaN
191.81667	-14.517485	161.3	 18.09	NaN
190.95	-14.219417	107.4	 17.42	NaN
193.55	-12.464264	133.9	 17.59	NaN
194.58333	-11.570199	127.7	 17.54	NaN
194.11667	-10.179513	118.7	 17.56	NaN
191.61667	-18.260519	163.7	 17.74	NaN
190.45	-19.254468	151.3	 17.30	NaN
191.11667	-17.796707	120.9	 15.31	NaN
195.41667	-18.326782	139.5	 16.96	NaN
197.81667	-14.252542	110.9	 15.05	NaN
192.35	-19.353869	114.7	 15.51	NaN
190.58333	-18.923143	107.5	 14.34	NaN
193.85	-16.239794	100.1	 15.27	NaN
196.18333	-14.981161	102.7	 15.50	NaN
190.68333	-20.239179	123.2	 14.91	NaN
193.25	-20.106685	127.0	 16.19	NaN
190.8	-37.57676	159.6	 29.21	NaN
192.55	-39.15341	163.7	 26.37	89.11272
191.98333	-38.423122	143.7	 25.42	NaN
190.21666	-36.896432	185.4	 22.76	NaN
191.71667	-37.991622	143.2	 25.32	NaN
190.48333	-36.033702	142.8	 21.83	NaN
193.68333	-39.684586	125.7	 20.25	87.287908
193.85833	-39.958494	111.0	 17.88	86.768551
194.15	-39.983396	107.2	 17.26	86.375622
192.75	-39.485388	126.3	 14.09	88.505766
191.35	-38.15758	116.7	 13.96	NaN
193.31667	-39.618193	127.0	 16.02	87.7798
195.75	-41.480017	169.5	 26.05	83.852321
194.58333	-40.716641	181.0	 24.38	85.254836
198.55	-43.538293	172.6	 22.26	76.307034
194.28333	-40.451149	148.0	 19.94	85.794458
197.11667	-42.276684	172.5	 18.93	81.989149
196.31667	-41.878337	144.2	 18.27	83.182279
193.81667	-40.052922	112.0	 18.24	86.719342
199.31667	-43.969954	166.3	 17.37	74.381539
195.05	-40.93237	121.1	 16.31	84.641749
198.05	-42.774654	132.0	 16.32	80.546372
190.85	-41.015341	101.7	 14.50	88.192726
198.75	7.3013299	134.6	 32.33	110.04559
194.88333	9.6859723	169.4	 26.95	116.7933
195.80833	8.3694026	143.9	 27.92	115.32801
195.68333	0.48009456	146.3	 24.47	NaN
199.975	8.2783205	137.6	 25.78	106.57211
197.58333	6.4071821	134.9	 25.83	112.78359
196.88333	9.3547511	141.2	 24.48	113.08494
196.8125	7.4627782	123.6	 28.65	113.79174
197.15	8.2948836	141.2	 23.22	112.93125
199.85	3.5594038	149.4	 22.94	109.18686
197.15	6.2747228	125.3	 23.99	113.56598
196.01667	0.5132114	137.0	 22.93	NaN
199.55	8.0961678	123.7	 23.18	107.69905
198.91667	4.8176858	133.1	 24.41	110.88389
198.51667	5.2481599	135.3	 24.35	111.58775
198.31667	6.6721134	115.3	 23.44	111.41527
195.06667	9.3381868	128.5	 20.44	116.49843
199.43333	4.701786	117.1	 21.48	109.6547
194.98333	2.7978442	170.2	 20.65	NaN
198.15	9.5534848	135.8	 20.54	110.39199
198.76667	5.5627478	114.5	 21.00	110.87668
195.3	0.31455013	112.8	 18.87	NaN
199.18333	5.8773402	107.2	 20.67	109.68654
199.18333	5.1819387	113.3	 20.78	110.03484
198.05	7.0032757	118.6	 19.74	111.7765
197.55	7.0198374	110.5	 20.95	112.64173
196.58333	0.74497979	121.1	 19.29	NaN
195.55	2.102513	156.1	 18.71	NaN
198.43333	7.8808919	147.4	 19.12	110.53232
199.85	4.3540997	111.1	 20.39	108.78846
197.75	5.8773402	108.3	 19.49	112.67169
199.35	0.81120364	152.7	 18.67	111.83593
199.31667	7.168864	122.9	 20.03	108.72046
199.61667	7.0695128	108.5	 17.69	108.02989
198.25	4.6190065	100.1	 17.73	112.25043
195.98333	9.5534848	149.7	 17.94	114.73426
197.88333	5.2481599	137.0	 17.77	112.65166
195.25	9.7522216	106.9	 17.01	116.08859
198.71667	1.0760795	151.7	 17.80	112.86209
195.5	9.1394562	106.2	 16.90	115.7262
197.76667	9.8681462	169.7	 17.15	111.16285
197.76667	9.8681462	164.0	 16.57	111.16285
197.48333	8.8579297	144.5	 16.87	112.13427
198.98333	9.5203557	142.8	 15.42	108.39305
199.65	4.0892054	145.4	 15.46	109.42119
198.45	1.837624	143.5	 15.22	112.94086
197.46667	0.96019996	100.5	 16.01	114.94505
199.55	6.4402946	117.3	 16.92	108.50216
197.48333	2.102513	114.9	 15.76	114.40604
195.31667	2.2680605	107.7	 13.09	NaN
199.68333	6.0429088	103.8	 15.54	108.3663
193.08333	9.1891386	104.9	 15.98	120.17999
194.61667	10.115913	190.8	 29.47	117.24996
191.51667	17.105548	161.2	 27.54	114.36353
190.45	16.741041	181.2	 25.92	116.38297
190.78333	15.680755	134.9	 25.21	119.6672
190.15	19.060882	132.2	 31.22	113.49205
194.05833	14.297573	148.1	 27.10	116.80405
190.31667	14.156778	141.9	 26.28	124.48774
199.01667	11.705616	171.0	 23.83	107.82396
191.05	18.000304	141.3	 24.15	112.91111
193.68333	13.659878	141.4	 26.41	117.96071
191.76667	16.741041	137.2	 23.44	115.22968
195.825	10.769986	138.6	 22.88	114.83598
191.4	19.558075	109.2	 25.78	112.13148
194.51667	13.726134	150.5	 21.14	116.50691
192.05	10.546438	135.7	 22.83	121.93282
191.68333	10.579552	133.2	 22.41	122.53373
190.98333	15.481963	121.0	 22.60	119.9401
191.33333	17.304375	122.7	 20.97	113.87851
193.03333	15.125798	117.6	 21.52	117.31702
191.65	15.349431	146.6	 20.92	119.09639
193.45	15.051254	121.4	 22.22	116.84348
193.7	14.686836	121.4	 22.22	116.94526
192.70833	10.405683	122.7	 20.64	120.86259
194.41667	10.778262	174.6	 20.54	117.56499
192.71667	14.189912	137.9	 20.09	119.23702
190.28333	16.973003	131.3	 18.79	115.64463
191.21667	17.702041	116.2	 19.86	112.83321
192.26667	15.99551	113.9	 19.47	116.64267
190.41667	15.763582	108.6	 20.29	119.9903
191.91667	16.40969	111.6	 19.08	115.99865
194.25	11.573128	165.3	 19.19	117.77816
191.78333	14.355544	137.5	 19.30	120.85919
190.45	18.398003	107.5	 18.32	113.39906
190.25	18.232289	112.0	 19.08	113.64765
194.51667	11.241932	156.7	 18.19	117.3097
190.98333	14.454928	119.9	 18.13	122.27116
193.68333	10.18214	113.3	 17.50	119.05088
192.08333	16.210883	100.5	 17.18	116.33445
190.75	10.778262	109.4	 17.44	124.09131
190.05	15.680755	145.0	 17.39	120.79121
191.95	15.21691	121.0	 17.26	118.87665
198.18333	16.144611	104.4	 16.77	111.53971
192.25	13.991149	121.1	 16.99	120.47745
192.18333	15.614487	121.0	 17.12	117.61874
194.11667	12.10307	128.6	 17.03	117.91979
197.35	11.043216	140.7	 16.46	111.58294
194.51667	13.262374	139.6	 16.64	116.74959
193.41667	11.804979	125.4	 15.96	119.41817
195.08333	11.639372	127.2	 15.20	116.16553
191.75	14.6537	119.2	 15.86	120.46025
194.75	12.931135	123.9	 14.45	116.48403
196.98333	15.084391	109.8	 15.44	112.90057
191.98333	12.699274	109.5	 14.91	122.00347
190.15	17.967166	111.8	 14.52	113.82883
192.18333	11.175689	105.0	 15.84	121.79086
193.25	15.448825	103.4	 13.88	116.51641
190.95	10.612677	101.8	 13.88	123.70527
198.51667	12.069942	103.2	 15.11	111.40928
193.28333	10.248378	103.5	 13.47	119.83544
193	24.341993	191.2	 33.95	105.35958
193.3	24.01045	184.0	 32.68	104.82179
193.8	23.794966	180.3	 32.03	103.78623
199.83333	21.92211	158.1	 29.62	92.265501
190.46667	25.552227	172.0	 33.93	110.41455
196.8	23.214823	199.7	 30.58	97.017006
195.55174	23.396417	131.3	 27.55	99.94126
192.01667	24.988534	132.4	 30.21	107.28996
197.76667	23.01593	181.5	 27.79	94.767658
194.51667	23.944151	166.7	 29.61	102.12815
195.48333	23.761807	171.0	 26.28	99.96536
198.98333	22.734177	168.3	 28.45	93.982888
192.05	24.723276	123.8	 28.25	107.32189
192.05	24.491189	127.5	 29.09	107.41636
192.73333	24.706694	159.2	 28.27	105.80916
198.1	23.131954	162.4	 24.87	93.924638
195.11035	23.639548	163.0	 25.12	100.90422
194.1	23.828114	126.2	 22.41	103.10356
193.95	24.325412	161.4	 28.67	103.2494
192.2	25.734617	115.6	 26.38	106.58439
197.38333	23.264547	132.6	 20.31	95.599635
191.45	25.286957	109.6	 25.01	108.42435
196.38333	23.33085	171.3	 19.81	97.973082
196.58333	29.632211	111.1	 20.09	108.44988
199.38333	21.673535	160.5	 17.79	93.444352
198.01667	26.182306	102.1	 20.79	93.073336
192.75626	25.496428	117.5	 17.94	105.4491
197.91667	25.220636	129.7	 18.48	93.637563
192.11667	21.607257	100.1	 19.62	108.44993
197.88333	29.001799	104.2	 17.15	105.87532
192.81667	25.121161	179.4	 16.35	105.46196
198.75	26.646602	128.8	 14.90	91.191723
192.98333	26.812435	131.6	 15.86	112.96863
198.21667	28.703204	112.5	 15.21	105.25606
199.91667	26.911936	116.0	 14.10	88.366569
197.38333	28.703204	110.0	 14.16	107.05725
197.91667	30.348249	108.5	 19.40	105.8758
197.61667	31.177486	117.4	 15.99	106.21248
202.05	-8.9899615	145.4	 29.46	112.66055
208.88333	-8.2283381	162.7	 23.84	105.72034
204.05	-5.6124807	144.2	 21.72	108.10312
205.05	-4.0231967	147.8	 20.60	104.26328
208.75	-7.9303164	137.3	 20.12	105.83638
209.03333	-8.8409446	120.4	 19.21	105.82189
208.41667	-7.5329603	132.0	 19.35	106.40603
202.91667	-0.24871118	106.8	 20.80	106.91627
201.06667	-5.2317135	111.8	 20.90	112.78071
203.08333	-9.5860409	128.9	 18.90	112.4351
204.23333	-1.3247852	103.0	 20.53	104.3661
204.81667	-3.8907616	130.8	 18.22	104.77098
203.08333	-0.74535973	101.7	 18.47	106.86497
208.11667	-7.3011656	122.2	 17.91	107.01926
203.15	-8.8243939	149.9	 18.09	112.17675
209.75	-9.9503248	122.4	 17.78	104.7826
200.78333	-4.1887484	138.1	 17.37	112.92242
203.68333	-1.9041973	126.7	 17.14	106.20539
209.58333	-9.3542332	127.3	 17.05	104.74566
204.28333	-3.3610127	138.2	 16.62	105.75859
208.85	-8.5263638	156.9	 17.60	106.0591
204.91667	-7.9303164	131.9	 15.04	111.10697
200.55	-1.473778	126.7	 15.57	112.53665
204.95	-4.519843	122.6	 14.75	104.89972
209.28333	-9.0893067	118.0	 15.41	105.34817
201.85	-8.6257067	126.9	 16.08	112.68645
206.55	-8.6919289	117.7	 13.67	111.52155
208.08333	-7.7316375	105.3	 15.64	107.46988
200.21667	-18.890004	155.7	 25.50	111.67449
208.45	-19.221338	189.6	 24.12	91.987437
208.5	-16.885723	120.4	 23.72	89.606365
205.35	-16.53791	136.5	 23.24	98.828085
208.95	-16.736659	126.1	 21.50	88.084627
208.18333	-16.206664	117.3	 23.11	89.942183
208.15	-11.371523	136.6	 21.22	110.4163
202.28333	-19.850889	151.1	 20.74	111.04483
200.98333	-19.254468	158.9	 20.76	111.59502
205.88333	-18.359909	195.7	 20.87	99.059068
207.75	-18.724352	127.0	 21.42	93.678551
208.95	-19.287598	155.2	 20.62	90.486317
205.88333	-17.796707	156.2	 20.64	98.486958
206.95	-18.359909	113.7	 20.82	95.789454
207.2	-18.24395	110.5	 20.23	94.905071
207.71667	-16.405407	120.1	 18.45	91.54918
209.15	-12.828519	106.9	 22.43	108.92348
206.01667	-16.802903	141.3	 18.77	97.084735
209.38333	-17.664198	137.3	 18.50	87.6026
209.65	-13.126558	100.2	 23.21	107.77927
201.85	-19.983429	154.9	 18.05	111.51999
207.25	-16.471658	116.2	 17.85	93.029266
204.78333	-16.836035	117.9	 18.11	100.8301
203.98333	-15.676704	116.8	 17.88	112.33515
205.78333	-10.477509	130.4	 17.84	112.17282
205.45	-15.809189	132.3	 17.34	97.805046
201.68333	-19.784614	125.4	 14.62	111.53267
207.78333	-11.437742	135.8	 15.26	111.43193
209.61667	-14.252542	133.0	 15.20	96.84992
201.68333	-11.404633	133.6	 16.56	113.00734
203.15	-15.213001	106.8	 15.80	112.14822
207.35	-10.742392	104.0	 14.72	111.5967
204.25	-15.809189	102.2	 15.65	103.12041
205.15	-17.498556	103.1	 15.07	100.40444
204.35	-17.001656	106.5	 13.10	102.23186
201.78333	-13.225905	106.1	 13.75	112.9122
206.21667	-15.411727	106.9	 15.85	94.998024
200.16667	-21.216412	135.3	 23.70	111.42937
202.08333	-21.928684	147.1	 21.69	111.5236
208.61667	-22.458793	133.5	 21.20	94.70203
209.25	-23.353413	170.1	 20.44	93.577042
203.54156	-24.12138	100.3	 21.25	111.51922
206.93333	-22.442223	100.7	 20.34	100.06505
205.31667	-21.796166	139.1	 18.67	104.28373
202.65	-20.139806	131.3	 18.34	110.30544
209.18333	-20.769195	120.4	 17.45	91.190343
208.65	-22.690719	105.0	 16.67	94.83643
204.55	-21.531127	122.3	 17.22	106.26894
206.08333	-24.181845	124.7	 14.47	104.51258
209.25	-21.266104	122.3	 15.90	91.468626
206.45	-24.115564	124.3	 13.94	103.32571
209	-22.57475	136.1	 16.24	93.588143
207.18333	-22.62445	131.5	 15.69	99.46351
209.71667	-29.850756	107.3	 14.23	83.79961
209.51667	-25.573806	129.9	 16.94	77.215069
205.21667	-22.889521	103.0	 13.46	105.73833
206.98333	-25.838973	101.7	 16.03	87.806109
203.88333	-38.854644	109.8	 14.68	81.818922
200.88333	-39.05382	101.9	 15.67	82.510263
202.35833	-45.389689	165.2	 27.17	67.255691
205.68333	-46.128756	126.7	 17.52	69.750476
204.08333	-46.195186	141.9	 15.74	68.092571
202.01667	9.222257	171.6	 25.78	101.15684
200.7	9.5038011	147.6	 22.76	104.23707
201.41667	9.3216224	146.0	 21.93	102.57407
200.58333	3.9567492	104.3	 24.86	107.14489
200.41667	8.3279998	113.5	 21.23	105.46956
201.15	1.4899629	102.2	 24.03	106.92719
200.27083	9.2264005	104.1	 23.51	105.40686
200.05	0.31455013	129.3	 18.66	111.7202
201.25	2.8971781	108.3	 19.68	105.98015
200.18333	4.6190065	105.3	 18.13	107.823
200.05	1.2747417	136.8	 16.71	109.84287
200.68333	4.7845758	120.7	 15.50	106.49205
200.41667	3.5262952	102.1	 15.59	107.77691
200.95	4.4534383	102.3	 14.94	105.98428
200.08333	3.1289548	100.0	 13.98	108.81509
204.15	19.19346	180.2	 40.94	96.791655
205.2	19.541498	166.2	 37.77	94.070482
204.96667	19.856406	133.8	 30.41	94.633011
204.48333	19.259755	117.3	 26.67	95.931974
204.11667	19.690662	105.9	 24.08	96.819953
200.55	10.645792	129.5	 22.29	104.08234
200.21667	10.579552	128.4	 22.11	104.91734
202.91667	18.762581	109.1	 20.68	100.00168
201.71667	18.69629	134.4	 17.65	102.92368
202.28333	17.668905	106.0	 14.21	101.718
201.15	10.115913	100.4	 13.77	102.86992
201.55	18.331715	102.2	 15.91	103.36355
201.76667	21.557543	191.4	 38.78	87.760388
200.21667	22.054692	181.6	 32.46	91.293674
203.27917	21.031424	130.5	 26.43	88.785856
201.38333	21.706685	130.4	 26.42	88.625122
204.175	20.223672	121.9	 26.19	96.611132
202.675	21.134991	126.5	 25.63	85.71579
202.18333	20.811877	124.5	 25.23	88.314817
203.38333	21.275833	120.3	 24.38	83.947994
204.08333	20.745595	113.9	 24.14	96.782544
203.48333	20.513629	109.9	 22.26	98.33946
202.35	20.977568	112.5	 22.79	86.426791
203.15	20.513629	105.9	 21.45	99.189491
204.41667	20.745595	107.3	 22.74	95.935762
204.68333	20.629606	108.7	 23.04	95.271932
201.18333	21.839254	102.0	 20.67	89.056436
209.55	54.605684	100.5	 18.64	40.374092
208.65	52.576732	107.0	 15.54	45.321101
218.98333	-7.8971965	158.6	 22.82	71.636484
219.95	-9.4204679	143.0	 22.14	68.634458
219.31667	-7.9965364	149.3	 21.48	70.134693
219.75	-8.7912726	130.5	 21.78	68.911141
219.31667	-8.6919289	176.6	 21.70	70.900956
219.65	-7.8309768	132.5	 19.07	68.339429
219.98333	-7.8640866	129.7	 18.66	67.090723
218.61667	-8.1289971	129.4	 18.04	73.663543
219.08333	-8.3607901	132.2	 17.37	71.664029
213.51667	-9.7516253	101.0	 16.68	93.763954
219.38333	-7.6322987	116.6	 13.32	69.410967
219.38333	-9.1224285	141.4	 16.93	71.055258
210.11667	-9.9172113	115.8	 13.54	103.74366
210.5	-17.680765	122.7	 32.68	84.13927
219.58333	-19.618946	131.3	 25.89	51.829883
211.75	-12.960987	154.5	 22.27	101.68746
218.75	-19.188198	123.9	 25.68	54.097018
218.11667	-18.658086	113.2	 23.46	55.625101
214.36667	-17.283236	102.6	 21.59	65.998566
214.73333	-17.614506	103.6	 21.81	65.17201
210.95	-11.371523	155.0	 19.78	102.62819
211.73333	-15.825754	130.0	 19.60	75.784176
210.61667	-10.77551	138.2	 19.23	103.06544
210.88333	-14.815559	111.9	 20.16	78.582281
211.51667	-12.033776	160.1	 18.99	101.58062
216.81667	-15.113639	111.6	 19.99	56.654034
219.4	-18.442732	100.9	 23.14	51.472965
211.4	-19.502972	100.7	 19.93	82.437359
210.45	-10.576842	126.2	 17.56	103.36486
217.55	-14.881801	143.9	 17.34	54.28868
211.38333	-13.656426	139.8	 17.21	99.742737
211.45	-18.326782	127.7	 15.73	80.610778
210.18333	-10.212619	138.3	 14.63	103.80279
210.75	-13.755777	117.5	 15.68	103.11313
216.88333	-17.862967	120.8	 15.23	58.768693
210.48333	-13.722653	113.6	 15.16	105.75222
211.91667	-17.862967	137.9	 16.88	77.702572
216.31667	-15.213001	109.0	 15.16	58.261833
212.11667	-13.391489	103.7	 15.41	100.50162
211.08333	-19.353869	109.0	 13.69	83.789592
211.61667	-25.076649	147.3	 27.24	66.191641
211.41667	-24.413818	131.2	 28.62	66.014818
210.57565	-23.348423	135.4	 26.76	89.243345
219.35	-21.66365	119.1	 23.51	54.27311
215.35	-27.496453	118.1	 21.96	54.693035
215.58333	-27.629075	117.0	 21.77	54.134827
213.51667	-26.667667	113.6	 23.03	60.383646
214	-24.629235	148.9	 19.18	55.694567
213.95	-26.999168	150.6	 19.15	58.944684
213.31667	-26.999168	103.3	 22.94	61.760421
214.95	-27.496453	100.5	 18.69	55.839396
215.45	-27.297535	104.4	 19.42	54.183776
216.41667	-20.437929	118.1	 17.21	62.465549
211.05	-26.40247	123.0	 15.05	70.996511
210.08333	-23.287138	106.0	 15.64	90.793852
219.75	-28.955363	120.6	 15.86	42.596225
213.11667	-25.37494	109.9	 15.40	60.249716
215.98333	-27.430153	106.2	 13.18	52.725299
216.48333	-27.894307	104.6	 13.22	51.719981
214.18333	-27.662226	106.3	 16.24	58.868494
211.21667	-48.18866	127.5	 15.90	60.030824
212.21667	29.599032	115.7	 15.11	56.236594
213.88333	38.413317	127.0	 16.05	62.458999
218.11667	55.836694	111.0	 17.47	28.08823
215.65	56.069613	126.5	 16.87	32.869752
217.38333	56.235996	118.1	 16.54	29.526383
215.51667	50.847702	123.9	 14.38	31.999483
213.58333	56.468931	118.7	 14.53	37.553647
214.71667	56.302552	118.5	 15.42	34.563241
217.41667	50.315799	115.1	 14.76	29.069568
216.68333	50.94744	110.5	 15.80	30.134107
220.51667	-8.9237383	180.2	 24.68	66.173568
221.05	-9.4204679	149.9	 25.05	64.860484
220.875	-9.8261373	125.8	 21.03	65.696797
221.18333	-9.7185123	121.0	 20.22	64.657759
220.01667	-8.8740661	101.2	 16.74	67.728415
220.38333	-8.0627667	166.2	 17.39	65.972686
220.35	-9.8178615	130.5	 14.87	67.325858
220.21667	-9.5860409	124.1	 14.04	67.577241
221.85	-9.9834383	102.1	 16.18	62.773088
221.35	-10.477509	133.7	 20.15	64.683949
220.75	-19.353869	110.6	 18.54	47.93534
222.08333	-10.212619	127.8	 16.59	62.21272
220.58333	-19.850889	107.3	 15.92	48.838721
224.88333	-15.279246	110.1	 15.20	34.298546
223.01667	-14.881801	100.3	 15.41	40.527253
221.55	-10.345059	105.6	 15.91	63.967406
225.01231	-23.131519	106.5	 24.52	28.938194
221.45	-20.818885	116.3	 23.02	46.726047
221.91667	-20.073564	123.7	 20.80	44.738237
229.25	-23.916733	111.0	 18.75	24.491007
220.65	-20.504184	106.8	 18.67	49.12933
225.51667	-23.353413	123.4	 17.32	28.431525
225.65	-23.65164	114.3	 17.15	28.339547
221.01667	-20.272311	121.8	 16.78	47.772655
222.18333	-21.597388	144.3	 17.05	41.165996
223.98333	-23.485954	132.1	 14.64	30.118549
222.55	-22.988924	127.1	 15.28	31.577459
229.85	-25.076649	137.7	 16.55	23.999504
220.31667	-20.371686	120.0	 15.22	50.093955
226.21667	-23.717908	117.0	 13.46	27.737116
226.65	-23.81732	114.3	 14.26	27.284456
222.08333	-22.326258	106.2	 15.66	31.946657
224.41667	-23.519087	111.6	 14.01	29.654042
222.11667	-20.636684	107.0	 15.11	44.340893
228.95	-24.77837	102.4	 12.79	24.937106
229.58334	-34.308584	105.1	 23.59	28.512829
229.81667	-32.782915	106.3	 16.71	25.157768
228.88334	-33.114549	111.3	 15.06	27.609543
226.41667	-34.739824	120.2	 16.04	32.348141
225.2	0.066223686	107.2	 19.65	41.34707
227.58333	16.608501	128.8	 22.70	48.480943
228.91667	22.502153	100.1	 12.62	43.108821
227.45	32.869476	140.7	 17.69	38.250063
229.15	32.736757	135.3	 16.29	35.327316
224.48333	34.395996	102.9	 14.72	47.638451
229.18333	46.760671	110.3	 14.29	3.9359853
227.18333	48.057275	112.4	 13.60	8.7501357
229.61667	40.813511	111.5	 13.19	5.5436943
236.65	-10.378177	116.0	 14.83	26.42006
230.71667	-25.341799	112.6	 13.38	23.090852
234.78333	-36.133243	154.2	 25.00	22.779729
233.95	-35.038387	112.1	 27.55	23.564694
235.06285	-33.733022	104.4	 29.04	21.964764
238.41667	-34.673475	197.1	 21.32	17.939214
237.38333	-37.128735	104.0	 28.10	19.871502
236.01667	-33.44621	165.4	 20.36	20.287391
230.61666	-34.275416	104.2	 22.22	27.298596
234.25	-32.915565	102.0	 19.41	20.053984
239.05	-35.005206	106.1	 16.57	17.168016
233.81667	-32.451297	149.2	 15.48	20.443436
233.75	-33.081388	116.3	 15.40	20.50051
237.65	-34.209072	112.6	 15.69	18.885312
239.58334	-35.204256	106.2	 14.61	16.466864
232.81667	-32.451297	112.8	 14.13	21.606592
233.31667	-33.081388	106.1	 15.06	20.991798
238.15	-34.308584	126.3	 16.72	18.207033
239.48333	-45.132288	107.8	 12.84	17.943377
239.45	13.958015	148.0	 15.94	22.756561
239.18333	14.25616	113.8	 14.27	23.030347
235.01667	19.292898	104.3	 15.46	33.084831
237.71667	26.182306	117.6	 13.66	24.367424
234.11667	22.236985	116.4	 15.01	33.721786
238.21667	26.016489	116.6	 14.22	23.849232
235.91667	22.469001	105.7	 12.00	30.122786
238.51667	20.381071	100.5	 12.89	26.274238
234.55	22.402715	117.0	 16.36	32.434592
232.21667	32.438143	180.1	 16.40	30.40991
237.25	30.447752	110.9	 12.99	23.028676
244.58333	-13.590189	102.2	 19.11	4.0974758
240.75	-24.77837	102.5	 16.68	5.9634514
240.88333	-25.408081	103.0	 16.15	6.2201254
245.23333	-37.394221	113.8	 22.92	8.0032036
243.95	-35.867802	144.1	 19.43	10.68755
241.41666	-35.005206	113.1	 19.91	13.770314
245.95	-36.29914	121.0	 19.04	6.8988829
241.85	-35.436494	108.6	 18.23	13.46872
246.68333	-36.763699	118.5	 18.33	5.1858248
242.51667	-35.635557	125.4	 17.27	12.580483
246.01667	-36.896432	108.6	 16.87	6.531939
247.01667	-36.995987	105.2	 17.00	4.626067
240.85	-34.905684	139.6	 15.54	14.542138
242.71667	-35.370138	133.2	 15.08	12.263446
240.41666	-35.237438	129.2	 15.42	15.358762
244.88333	-36.465052	109.6	 14.01	9.1272364
241.35	-35.436494	110.0	 14.79	14.122405
244.41667	-35.768266	124.7	 16.80	10.116823
248.88333	6.9370387	102.7	 16.29	5.4783517
249.61667	13.361749	131.1	 26.76	6.2206863
248.91667	18.828863	106.6	 23.75	5.7176571
245.31667	18.364864	132.1	 19.66	8.5243154
240.11667	13.494257	160.2	 19.12	21.997754
240.48333	18.431142	136.6	 15.21	22.719167
242.48333	16.873593	120.5	 14.39	15.451917
240.38333	12.169307	117.5	 15.71	22.046794
247.91667	19.02773	114.3	 14.80	7.0304218
242.85	18.331715	110.6	 12.51	13.446289
244.125	24.91393	130.0	 24.27	12.52972
245.31667	28.106058	103.0	 21.02	NaN
244.31667	28.338271	102.4	 17.28	8.0073557
240.48333	25.353269	106.0	 14.37	21.699352
242.91667	24.590655	101.0	 14.96	16.342076
255.41667	5.9435635	139.5	 19.48	1.3372978
252.21667	10.281493	115.6	 22.47	4.4045959
251.68333	19.060882	148.2	 16.12	0.74613742
252.86667	14.338986	122.7	 16.07	2.5082173
250.65	16.210883	106.9	 14.02	3.6887435
198.1	23.05	223.2	24.36	93.930789
199	22.73	165.7	19.50	93.943635
199.85	21.88	190.1	19.70	92.241949
199.45	21.72	121.9	18.00	93.266576
200.45	22.08	240.5	30.40	90.722904
201.3	21.78	105.0	18.00	88.79799
201.8	21.58	160.3	21.20	87.671854
202.2	21.35	160.5	23.22	86.797044
202.3	20.88	113.7	17.97	87.564918
202.75	21.19	194.2	20.23	85.53117
203.2	21.1	198.8	21.07	84.750221
202.9	20.45	128.5	17.11	99.834343
203.1	20.6	179.6	18.06	99.308159
203.5	20.99	141.9	17.76	95.50896
203.65	21.25	105.8	17.49	83.012884
203.38	20.5	151.1	18.24	98.605164
203.8	20.75	277.8	23.15	97.541513
204.3	20.1	151.1	21.16	96.307022
204.2	19.65	125.1	19.45	96.612094
204.55	19.85	206.0	21.11	95.696837
205.1	19.6	169.9	22.39	94.321091
204.35	19.25	314.7	28.96	96.273567
204.83	19.33	160.8	18.35	95.037953
