.TH BACKTRACKER l "1 July 1999"
.SH NAME
backtracker \- Forward and Backward flowlines and hotspot tracks
.SH SYNOPSIS
\fBbacktracker\fP [\fIinfile(s)\fP] \fB\-E\fP\fIstage_file\fP
[ \fB\-Df|b\fP ] [ \fB\-H\fP[\fInrec\fP] ]
[ \fB\-Lf|t\fP\fIstep\fP ] [ \fB\-N\fP\fIupper_age\fP ]
[ \fB\-T\fP\fIzero_age\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ]
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBbacktracker\fP reads (longitude, latitude, age) positions from \fIinfiles\fP
[or standard input] and computes projected (x,y,t) coordinates using the
specified stage pole (Euler) rotations.  You can either calculate just final
positions [Default] or create a sampled track between initial and final
position.  The former mode allows additional data fields after the first 3
columns which must have (longitude,latitude,age).
See option \fB\-:\fP on how to read (latitude,longitude,age) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfile(s)\fP
Data file(s) to be projected.  If not given, standard input is read.
.TP
.B \-E
Give file with stage poles and opening angles.  This file must contain
one record for each stage; each record must be of the following format:
.br
.sp
	lon lat tstart tstop ccw-angle
.br
.sp
where time is in Ma and the rest is in degrees.  Oldest stage must be
listed first.  tstart is the time when the stage begins (oldest age).
Blank lines and records whose first column contains # will be ignored.
.SH OPTIONS
.TP
.B \-D
Set the direction to go: \fB\-Df\fP will go forward in time, while
\fB\-Db\fP will go backward in time [Default].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-L
Specify a sampled path between initial and final position: \fB\-Lf\fP will
draw flowlines, while \fB\-Lb\fP will draw backtrack (hotspot track) paths.
Append sampling interval in km.
.TP
.B \-N
Set the maximum age to extend the oldest stage back in time [no extension].
.TP
.B \-T
Set the current time [0 Ma].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 3 input columns]
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To backtrack the (x,y,t) points in the file seamounts.d to their origin
(presumably the hotspot), using the DC85.d Euler poles, run
.br
.sp
backtracker seamounts.d \fB\-Db \-E\fPDC85.d > newpos.d
.br
.sp
To project flowlines forward from the (x,y,t) points stored in several 3-column,
binary, double precision files, run
.br
.sp
backtracker points.* \fB\-Df \-E\fPDC85.d \fB\-Lf\fP25 \fB\-bo \-bi\fP\fI3\fP > lines.b
.br
This file can then be plotted with psxy \fB\-M\fP.
.SH SEE ALSO
gmt, project, mapproject, hotspotter
.SH REFERENCES
Wessel, P., 1999, "Hotspotting" tools released, EOS Trans. AGU, 80 (??), p. ??.
.br
