.TH PSPROJSTATIONS l "2 February 1996"
.SH NAME
pspolar \fR\- Plot polarities on the inferior focal half-sphere on maps
.SH SYNOPSIS
.br
pspolar \fIfiles \fB\-J\fIparameters \fB\-R\fIwest/east/south/north
\fR[ \fB\-D\fIlongitude/latitude\fR \fB\-Msize\fR \fB\-S\fIsymbol/size\fR
[ \fB\-B\fItickinfo\fR ] [ \fB\-C\fIlongitude/latitude\fR [/tiret_width/pointsize\fR ] ] 
[ \fB\-F\fIred/green/blue\fR ] [ \fB\-G\fIfill\fR ] [ \fB\-g\fIfill\fR ] [ \fB\-H\fR ]
[ \fB\-h\fR ] [ \fB\-K\fR ] [ \fB\-L\fP ] [ \fB\-N\fR ] [ \fB\-O\fP ] [ \fB\-P\fP ]
[ \fB\-s\fR\fIHalf-size\fB[v[\fI[<v_width/h_length/h_width/shape>]\fB][g\fI[<r/g/b>]\fB][l\fB]
[ \fB\-U\fP[label] ] [ \fB\-V\fP ] [ \fB\-W\fIpen\fR ] [ \fB\-X\fIx-shift\fR ] [ \fB\-Y\fIy-shift\fR ]
[ \fB\-c\fIcopies\fR ]
.SH DESCRIPTION
.br
pspolar \fRreads data values from \fIfiles\fP [or standard input]
and generates \fIPostScript\fP code that will plot stations on focal mechanisms
on a map.
The \fIPostScript\fP code is written to standard output.
.br
.sp
.SH ARGUMENTS
\fIfiles\fP
List one or more file-names. If no files are given, pspolar will read standard input.
.br
.sp
\fB\-J\fR Selects the map projection. 
Scale is cm/degree, 1:xxxxx. or width in cm (upper case modifier).
.br
.sp
See \fBpsbasemap\fP manpages for details.
.sp
\fB\-R
\fIwest, east, south,\fR and \fInorth\fP specify the Region of
interest.  To specify your boundaries in degrees and minutes, use the
dd:mm format.
.br
.sp
\fB\-D\fIlongitude/latitude \fR
Maps the bubble at given longitude and latitude point.
.br
.sp
\fB\-M\fIsize \fR
\fRSets the size of the beach ball to plot polarities in.
.br
Size is in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
.br
.sp
\fB\-S<symbol type>\fIsize\fRSelects symbol type and symbol size .  
.br
Size is in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
.br
Choose symbol type between
.br
   st(a)r, (c)ircle, (d)iamond, (h)exagon, (i)nvtriangle
.br
(p)oint, (s)quare, (t)riangle, (x)cross
.br
.LP
.SH OPTIONS
No space between the option flag and the associated arguments.
.br
.sp
\fB\-B
\fRSets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.br
.sp
\fB\-C 
\fROffsets focal mechanisms to the latitude and longitude specified in the last
two columns of the input file.
.br
.sp
\fB\-E\fIfill\fP
\fRSelects filling of symbols for stations in extensive quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 250/250/250].
If Efill is the same as Ffill, use \fB-e\fP to outline.
.br
.sp
\fB\-e\fI[<pen attributes>]\fP
Outline symbols in extensive quadrants.
.br
Default pen attributes is W pen attributes.
.br
.sp
\fB\-F\fP\fIfill\fP
\fRSets background color of the beach ball. Default is no fill.
.br
.sp
\fB\-f\fI[<pen attributes>]\fP
\fROutline the beach ball. Default pen attributes is W pen attributes.
.br
.sp
\fB\-G\fP\fIfill\fP
\fRSelects filling of symbols for stations in compressional quadrants.
Set the shade (0\-255) or color (r/g/b) [Default is 0/0/0].
.br
.sp
\fB\-g\fI[<pen attributes>]\fP
\fROutline symbols in compressional quadrants.
Default pen attributes is W pen attributes.
.br
.sp
\fB\-H\fP\fI[n]\fP
\fRInput file(s) has \fIn\fR Header record(s). Number of header records
can be changed by editing your .gmtdefaults file. 
If used, \fBGMT-SYSTEM\fP default is 1 header record.
.br
.sp
\fB\-h\fP
.br
Use special format derived from HYPO71 output
.br
.sp
\fB\-K
\fRMeans more \fIPostScript\fP code will be appended later. [Default terminates the plot system]
.br
.sp
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.br
.sp
\fB\-O
\fRSelects Overlay plot mode. [Default initializes a new plot system]
.br
.sp
\fB\-P
\fRSelects Portrait plotting mode. [Default is Landscape]
.br
.sp
\fB\-s\fIhalf-size/[V[<v_width/h_length/h_width/shape>]][G<r/g/b>][L]
.br
Plots S polarity azimuth.
.br
S polarity is in last column.
It may be a vector (V option) or a segment. 
Give half-size,v_width,h_length,h_width in inch
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
[L] option is for outline.
.br
.sp
\fB\-T\fIangle/form/justify/fontsize in points\fP
.br
To write station code. Default is 0.0/0/5/12.
.br
.sp
\fB\-t\fI<pen attributes>
.br
To write station code. Default attributes is W attributes.
.br
.sp
\fB\-U
\fRDraws Unix System time stamp on plot.  Append c to plot the command line or a text string of your
choice.
.br
.sp
\fB\-V
\fRVerbose.  Reports the name of the current file being plotted, as well as number of records, and
any scaling information.
.br
\fP.
\fB\-W
\fRSet current pen attributes 
 [Defaults: width = 1, color = 0/0/0, texture = solid].
.br
.sp
\fB\-X \-Y
\fRShift origin of plot by (\fIx-shift,y-shift\fP) inches  [Default is (1,1) for new plots, (0,0) for overlays].
.br
.sp
\fB\-:
\fRToggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.br
.sp
\fB\-c
\fRSpecifies the number of plot copies. [Default is 1]
.br
.sp
Parameters are expected to be in the following columns
.TP
.B 1,2,3,4
station_code, azimuth, take-off angle, polarity
.br
.sp
polarity : 
.br
- compression can be c,C,u,U,+
.br
- rarefaction can be d,D,r,R,-
.br
- not defined is anything else
.br

.SH EXAMPLES
.sp
pspolar << END -R239/240/34/35.2 -JM8 -N -Sc0.4 -H1 -D239.5/34.5 -M5 >! test.ps
.br
stat azim  ih pol
.br
0481   11  147   c
.br
6185  247  120   d
.br
0485  288  114   +
.br
0490  223  112   -
.br
0487  212  109   .
.br
END
.br
or
.br
pspolar << END -R239/240/34/35.2 -JM8 -N -Sc0.4 -H1 -D239.5/34.5 -M5 -h >! test.ps
.br
Date   Or. time stat azim  ih                                    
.br
910223   1 22   0481   11  147   ipu0
.br
910223   1 22   6185  247  120   ipd0
.br
910223   1 22   0485  288  114   epu0
.br
910223   1 22   0490  223  112   epd0
.br
910223   1 22   0487  212  109   epu0
.br
END
.br
.sp
.SH SEE ALSO
.br
\fRgmtsystem, psbasemap, psxy.
.br
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismolgy, Freeman, 1980.
.SH AUTHORS
\fRGenevieve Patau
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@.ipgp.jussieu.fr)
.br
