.TH PSMECA l "28 July 1998"
.SH NAME
psmeca \fR\- Plot focal mechanisms on maps
.SH SYNOPSIS
.br
psmeca \fIfiles \fB\-J\fIparameters \fB\-R\fIwest/east/south/north
\fR[\fB\-B\fItickinfo\fR] [\fB\-C\fIpen\fR] [\fB\-D\fIdepmin/depmax\fR]
[\fB\-E\fIfill\fR] [\fB\-G\fIfill\fR] [\fB\-H\fR[n]]
[\fB\-K\fR] [\fB\-L\fIpen\fP] [\fB\-M\fR] [\fB\-N\fR] [\fB\-O\fP]
[\fB\-P\fP] 
[\fB\-S\fI<symbol><scale>\fR[/d]] [\fB\-T\fInum_of_plane\fR[<pen>]]
[\fB\-U\fP[label]] [\fB\-V\fP] [\fB\-W\fIpen\fR] [\fB\-X\fIx-shift\fR]
[\fB\-Y\fIy-shift\fR] [\fB\-Z\fIcptfile\fP] [\fB\-z\fP] 
[\fB\-a\fI<size>\fP [\fIP_symbol>\fP[\fIT_symbol\fP]] 
[\fB\-g\fIfill\fR] [\fB\-e\fIfill\fR] [\fB\-p\fIpen\fR] [\fB\-t\fIpen\fR]
[\fB\-:\fP] [\fB\-c\fIcopies\fR]
.SH DESCRIPTION
.br
psmeca \fRreads data values from \fIfiles\fP [or standard input]
and generates \fIPostScript\fP code that will plot focal mechanisms
on a map.  Most options are the same as for psxy.
The \fIPostScript\fP code is written to standard output.
.br
.sp
.SH ARGUMENTS
\fIfiles\fP
List one or more file-names. If no files are given, psvelomeca will read standard input.
.br
.sp
\fB\-J\fR Selects the map projection. 
Scale is cm/degree, 1:xxxxx. or width in cm (upper case modifier).
.br
.sp
See \fBpsbasemap\fP manpages for details.
.sp
\fB\-R
\fIwest, east, south,\fR and \fInorth\fP specify the Region of
interest.  To specify your boundaries in degrees and minutes, use the
dd:mm format.
.br
.sp
\fB\-S\fRSelects the meaning of the columns in the data file 
.br
.sp
In order to use the same file to plot cross-sections, depth is in third column.
Nevetheless, it is possible to use "old style" psvelomeca input files
without depth in third column using -o option.
.br
.sp
\fB\-Sa\fIscale[c/i][/fontsize[/offset[u]]].\fR Focal mechanisms in Aki and Richard convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size for 
magnitude = 5. in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference.  The color or shade of the compressive
quadrants can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.TP
.B 1,2
longitude, latitude of event (\fB-:\fP option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6
strike, dip and rake in degrees
.TP
.B 7
magnitude
.TP
.B 8,9
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using 0,0 in columns
8 and 9 will plot the beach ball at the latitude, longitude given in
columns 1 and 2.  The \fB-:\fR option will interchange the order of
columns (1,2) and (8,9).
.TP
.B 10
Text string to appear above the beach ball (optional).
.br
.sp
.LP
\fB\-Sc\fIscale[c/i][/fontsize[/offset[u]]].\fR Focal mechanisms in Harvard CMT convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size for 
magnitude = 5 (that is M0 = 4.0E23 dynes-cm) 
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6
strike, dip, and rake of plane 1
.TP
.B 7,8,9
strike, dip, and rake of plane 2
.TP
.B 10,11
mantissa and exponent of moment in dyne-cm
.TP
.B 12,13
longitude,longitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using (0,0) in
columns 11 and 12 will plot the beach ball at the latitude, longitude
given in columns 1 and 2.  The -: option will interchange the order of
columns (1,2) and (12,13).
.TP
.B 14
Text string to appear above the beach ball (optional).
.LP
\fB\-Sm\fIscale[c/i][/fontsize[/offset[u]]]\fR. Seismic moment tensor (Harvard CMT, with zero trace). \fIscale\fP adjusts the
scaling of the radius of the "beachball", which will be proportional 
to the magnitude. Scale is the size for magnitude = 5 (that is scalar seismic
moment = 4.0E23 dynes-cm)
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sd\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part of moment tensor.
Put \fB\-Sz\fIscale[/fontsize[/offset[u]]]\fR to plot anisotropic part of moment tensor (zero trace).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6,7,8,9
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.TP
.B 10
exponent
.TP
.B 11,12
latitude,longitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the latitude, longitude given in
columns 1 and 2.  The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.TP
.B 13
Text string to appear above the beach ball (optional).
.br
.sp
.LP
\fB\-Sp\fIscale[c/i][/fontsize[/offset[u]]].\fR Focal mechanisms given with partial data on both
palnes.  \fIscale\fP adjusts the scaling of the radius of the "beach
ball", which will be proportional to the magnitude. Scale is the size
for magnitude = 5 in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5
strike, dip of plane 1
.TP
.B 6
strike of plane 2
.TP
.B 7
must be -1/+1 for a normal/inverse fault
.TP
.B 8
magnitude
.TP
.B 9,10
latitude,longitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the latitude, longitude given in
columns 1 and 2.  The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.TP
.B 11
Text string to appear above the beach ball (optional).
.br
.sp
.LP
\fB\-Sx\fIscale[c/i][/fontsize[/offset[u]]]\fR. principal axis. \fIscale\fP adjusts
 the
scaling of the radius of the "beachball", which will be proportional
to the magnitude. Scale is the size for magnitude = 5 (that is seismic
scalar moment = 4*10e+23 dynes-cm)
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sy\fIscale[c/i][/fontsize[/offset[u]]]\fR to plot the only double couple part of
moment tensor.
Put \fB\-St\fIscale[c/i][/fontsize[/offset[u]]]\fR to plot zero trace moment tensor.
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6,7,8,9,10,11,12
value (in 10*exponent dynes-cm), azimuth, plunge of T, N, P axis.
.TP
.B 13
exponent
.TP
.B 14,15
latitude,longitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the latitude, longitude given in
columns 1 and 2.  The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.TP
.B 16
Text string to appear above the beach ball (optional).
.br
.sp
.LP
\fB\-R
\fIwest, east, south,\fR and \fInorth\fP specify the region of interest.  To specify your boundaries
in degrees and minutes, use the dd:mm format by appending 'm'.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.br
.sp
\fB\-B
\fRSets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.br
.sp
\fB\-C\fR[\fIpen\fP]
\fROffsets focal mechanisms to the latitude and longitude specified in the last
two columns of the input file.
.br
.sp
\fB\-D
\fIdepmin/depmax \fR
Plots events between depmin and depmax.
.br
.sp
\fB\-E\fP\fIfill\fP
\fRSelects filling of extensive quadrants. Usually white.
Set the shade (0\255) or color (r/g/b) [Default is 255/255/255].  
.br
.sp
\fB\-G\fP\fIfill\fP
\fRSelects filling of focal mechanisms.  By
convention, the compressional quadrants of the focal mechanism beach
balls are shaded.  Set the shade (0\-255) or color (r/g/b) [Default is
0/0/0]. 
.br
.sp
\fB\-H\fP\fI[n]\fP
\fRInput file(s) has \fIn\fR Header record(s). Number of header records
can be changed by editing your .gmtdefaults file. 
If used, \fBGMT-SYSTEM\fP default is 1 header record.
.br
.sp
\fB\-K
\fRMeans more \fIPostScript\fP code will be appended later. [Default terminates the plot system]
.br
.sp
\fB\-L\fR[\fIpen\fP]
\fRDraws the "beach ball" outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
.sp
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside frame boundary specified by
\fB\-R\fR [Default plots symbols inside frame only].
.br
.sp
\fB\-O
\fRSelects Overlay plot mode. [Default initializes a new plot system]
.br
.sp
\fB\-P
\fRSelects Portrait plotting mode. [Default is Landscape]
.br
.sp
\fB\-T\fR[\fInum_of_plane\fR]
\fRPlots the nodal planes and outline the bubble which is transparent.
.br
      num_of_plane equal  \fI0\fR : both nodal planes are plotted;
      num_of_plane equal  \fI1\fR : the only first nodal plane is plotted;
      num_of_plane equal  \fI2\fR : the only second nodal plane is plotted;
.br
.sp
\fB\-U
\fRDraws Unix System time stamp on plot.  Append c to plot the command line or a text string of your
choice.
.br
.sp
\fB\-V
\fRVerbose.  Reports the name of the current file being plotted, as well as number of records.
.br
.sp
\fB\-W
\fRSet default pen attributes for fault plane edges, label, ....
 [Defaults: width = 1, color = 0/0/0, texture = solid].
.br
.sp
\fB\-X \-Y
\fRShift origin of plot by (\fIx-shift,y-shift\fP) inches  [Default is (1,1) for new plots, (0,0) for overlays].
.br
.sp
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column. 
.br
.sp
\fB\-z
\fROverlay zero trace moment tensor.
.br
.sp
\fB\-a\fR[\fIaxis_symbol_size[c/i]\fR[\fI/P_axis_symbol\fR[\fIT_axis_symbol\fR]]]
.br
\fRComputes and plots P and T axis.
- axis_symbol_size in inch [default is 0.2 cm or 0.08 inches].
inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended)
.br
- default P and T axis symbols is 'c'
.br
Choose between the following :
(\fIc\fP) circle, (\fPd\fP) diamond, (\fPh\fP) hexagon, 
(\fPi\fP) inverse triangle, 
(\fPp\fP)point, (\fPs\fP) square, (\fPt\fP) triangle, 
(\fPx\fP) cross.
.br
.sp
\fB\-e\fP\fIfill\fP
\fRSelects filling of T axis symbol.
Set the shade (0\255) or color (r/g/b) [Default is color of extensive parts.  
.br
.sp
\fB\-g\fP\fIfill\fP
\fRSelects filling of P axis symbol.
Set the shade (0\255) or color (r/g/b) [Default is color of compressive parts.
.br
.sp
\fB\-p\fR[\fIpen\fP]
\fRDraws the P axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
sp.
\fB\-t\fR[\fIpen\fP]
\fRDraws the T axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
sp.
\fB\-:
\fRToggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)]
.br
.sp
\fB\-c
\fRSpecifies the number of plot copies. [Default is 1]
.SH EXAMPLES
.sp
The following file should give a normal-faulting CMT mechanism:
.br
psmeca << END -R239/240/34/35.2 -Jm4 \\
.br
-Sc0.4 -H1 >! test.ps
.br
lon     lat    depth str dip slip  st dip slip mant exp plon plat
.br
239.384 34.556  12.  180  18  -88   0  72  -90  5.5  0   0    0
.br
END
.br
.sp
.SH SEE ALSO
.br
\fRgmtsystem, psbasemap, psxy.
.br
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismolgy, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
.br
Cliff Frohlich, Cliff'Nodes Concerning Plotting Nodal Lines for P, Sh and Sv
.br
Seismological Reasearch Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in
 C, Cambridge University press (routine jacobi)
.SH AUTHORS
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@.ipgp.jussieu.fr)
.br
