.TH PSCOUPE "2 April 1999"   
.SH NAME
pscoupe \fR- Plot cross-sections of focal mechanisms. 
.SH SYNOPSIS
.br
pscoupe \fIfiles \fP\-J\fPparameters \fP\-R\fPwest/east/south/north
 \fP\-A\fPparameters 
.br
[ \fB\-B\fItickinfo\fR ]  [ \fB\-F\fIfill\fR ] [ \fB\-G\fIfill\fR ] [ \fB\-H\fP ]
[ \fP\-K\fP ] [ \fP\-L\fIpen\fP ] [\fB\-M\fR] [ \fP\-N\fR ] [ \fP\-O\fP ] 
[ \fP\-P\fP ] [\fB\-S\fI<symbol><scale>\fR[/d]] [s\fI<symbol><size>\fR[/d]] 
[ \fP\-T\fIn\fR ] [ \fB\-U\fP[\fIlabel\fP] ] [ \fB\-V\fP ] 
[ \fP\-W\fIpen\fR ] [ \fP\-X\fIx-shift\fR ] [ \fB\-Y\fIy-shift\fR ] [ \fB\-Z<cpt>\fP ]
[\fB\-a\fI<size>\fP [\fIP_symbol>\fP[\fIT_symbol\fP]]
[\fB\-g\fIfill\fR] [\fB\-e\fIfill\fR] [\fB\-p\fIpen\fR] [\fB\-t\fIpen\fR]
[ \fB\-:\fP ] [ \fP\-#\fIcopies\fP ]
.SH DESCRIPTION
.br
pscoupe \fRreads data values from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot symbols, lines or polygons on a cross-section.
Focal mechanisms  may be specified and require additional columns of data.
The \fIPostScript\fP code is written to standard output. 
.sp
\fIfiles\fP list one or more file-names. If no files are given, \fBpscoupe \fPwill read standard input.
.sp
A \fInew file\fR is created with the new coordinates (\fBx\fR, \fBy\fR) and the mechamism 
(from lower focal half-sphere for horizontal plane, to half-sphere behind a vertical plane).
When the plane is not horizontal,
- north direction becomes upwards steepest descent direction of the plane (u)
- east direction becomes strike direction of the plane (s)
- down direction (= north^east) becomes u^s
.br
Axis angles are defined in the same way as in horizontal plane in the new system.
.br
Moment tensor (initially in r, t, f system that is up, south, east)
is defined in (-u^s, -u, s) system.
A \fI file\fR  is created with extracted events.
.sp 
\fB\-J\fR Selects the map projection.
Scale is user_unit/km, 1:xxxxx. or width in user_unit (upper case modifier).
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
\fB\-Jx\fP\fIx-scale[/fI/y-scale]\fP
x-scale must be positive and y-scale negative to plot depth downwards.
.sp
\fB\-R\fIwest/east/south/north\fR. South and north are <= 0.;
If frame is defined from cross-section parameters (see \fB-A\fP) this option is not taken into account,
but must be present.
.sp
\fP\-A\fP selects the cross-section.
.br
\fP\-Aa\fIlon1/lat1/lon2/lat2/dip/p_width/dmin/dmax[f]
.br
lon \fRand \fPlat\fP are the longitude and latitude of points 1 and 2 limiting the length ot the cross-section.
.br
\fPdip\fP is the dip of the plane on which the cross-section is made.
.br
\fPp_width\fP is the width of the cross-section on each side of a vertical plane
or above and under an oblic plane. 
.br
\fPdmin\fP and\fP dmax\fP are the distances min and max from horizontal plane, 
along steepest descent direction.
.br
Add \fBf\fP to get the frame from the cross-section parameters.
.br
\fB\-Ab\fIlon1/lat1/strike/p_length/dip/p_width/dmin/dmax[f]
.br
lon1 \fRand \fPlat1\fP are the longitude and latitude of the beginning of the cross-section.
.br
\fPstrike\fP is the azimut of the direction of the cross-section.
.br
\fPp_length\fP is the length along which the cross-section is made.
.br
The other parameters are the same as for \fB-Aa \fPoption.
.br
\fP\-Ac\fIx1/y1/x2/y2/dip/p_width/dmin/dmax[f]
.br
\fRThe same as \fB-Aa \fPoption with \fIx \fPand \fPy \fPcartesian coordinates.
.br
\fB\-Ad\fIx1/y1/strike/p_length/dip/p_width/dmin/dmax[f]
.br
\fRThe same as \fB-Ab \fPoption with \fIx \fPand \fPy \fPcartesian coordinates.
.sp
\fB\-S\fP selects the meaning of the columns in the data file and the figure to be plotted.
.br
\fP\-Sa\fIscale[/fontsize[/offset[u]]].\fR Focal mechanisms in Aki and Richard convention.
.br
\fPscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude.  Scale is the size for magnitude = 5. 
in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference.  The color or shade of the compressive
quadrants can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.TP
.B 1,2:     longitude, latitude of event (\fB-:\fP option interchanges order)
.TP
.B 3:       depth of event in kilometers
.TP
.B 4,5,6:  strike, dip and rake
.TP
.B 7:       magnitude
.TP
.B 8,9:    not used; can be 0 0; it is to used the same file as for psmeca.
.TP
.B 10:      text string to appear above the beach ball default) or under (add u). 
.br
.sp
.LP
\fB\-Sc\fIscale\fR. Focal mechanisms in Harvard CMT convention.  
.br
\fPscale\fP adjusts
the scaling of the radius of the "beach ball", which will be proportional to the magnitude. 
Scale is the size for magnitude = 5 (that is M0 = 4E+23 dynes-cm.) 
in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
Use the \fB-T\fR option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.TP
.B 1,2:      longitude, latitude of event (\fB-:\fP option interchanges order)
.TP
.B 3:        depth of event in kilometers
.TP
.B 4,5,6:   strike, dip, and slip of plane 1
.TP
.B 7,8,9:   strike, dip, and slip of plane 2
.TP
.B 10,11:   mantissa and exponent of moment in dyne-cm (if magnitude is uses instead of scalar moment, magnitude is in column 10 and 0 must be in column 11)
.TP
.B 12,13:   not used; can be 0 0; it is to used the same file as for psmeca.
.TP
.B 14:       text string to appear above the beach ball (default) or under (add u).
.sp
.LP
\fP\-Sp\fIscale[/fontsize[/offset[u]]].\fR Focal mechanisms given with partial data on both planes.
\fPscale\fP adjusts
the scaling of the radius of the "beach ball", which will be proportional to the magnitude.
Scale is the size for magnitude = 5. in MEASURE_UNIT 
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns:
.TP
.B 1,2:    longitude, latitude of event (\fB-:\fP option interchanges order)
.TP
.B 3:       depth
.TP
.B 4,5:    strike, dip of plane 1
.TP
.B 6:       strike of plane 2
.TP
.B 7:       must be -1/+1 for a normal/inverse fault
.TP
.B 8:       magnitude
.TP
.B 9,10:   not used; can be 0 0; it is to use the same file as for psmeca.
.TP
.B 11:      text string to appear above the beach ball (default) or under (add u). 
.sp
.LP
\fB\-Sm\fIscale[/fontsize[/offset[u]]]\fR. Seismic moment tensor. \fIscale\fP ad
justs the
scaling of the radius of the "beachball", which will be proportional
to the magnitude. Scale is the size for magnitude = 5 (that is seismic
scalar moment = 4E+23 dynes-cm.) in MEASURE_UNIT 
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sd\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part
of moment tensor.
Put \fB\-Sz\fIscale[/fontsize[/offset[u]]]\fR to plot anisotropic part of moment tensor (zero trace).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6,7,8,9
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.TP
.B 10
exponent
.TP
.B 11,12
Not used; can be 0 0; it is to use the same file as for psmeca.
.TP
.B 13
Text string to appear above the beach ball (default) or under (add u).
.br
.sp
.LP
\fB\-Sx\fIscale[/fontsize[/offset[u]]]\fR. principal axis. \fIscale\fP adjusts  the
scaling of the radius of the "beachball", which will be proportional
to the magnitude. Scale is the size for magnitude = 5 (that is seismic
scalar moment = 4*10e+23 dynes-cm.)
in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
(\fB-T\fI0\fR option overlays best double couple transparently.)
Put \fB\-Sy\fIscale[/fontsize[/offset[u]]]\fR to plot the only double couple part of
moment tensor.
Put \fB\-St\fIscale[/fontsize[/offset[u]]]\fR to plot anisotropic part of moment tensor (zero trace).
The color or shade of the compressive quadrants
can be specified with the \fB-G\fR option.  The color or shade
 of the extensive quadrants can be specified with the \fB-E\fR option.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4,5,6,7,8,9,10,11,12
value (in 10*exponent dynes-cm), azimuth, plunge of T, N, P axis.
.TP
.B 13
exponent
.TP
.B 14,15
latitude,longitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fR option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the latitude, longitude given in
columns 1 and 2.  The \fB-:\fR option will interchange the order of
columns (1,2) and (9,10).
.TP
.B 16
Text string to appear above the beach ball (optional).
.br
.sp
\fB\-s\fIsymbol[size[/fontsize[/offset[u]]] selects symbol instead of mechanism.
.br
 Choose between the following :
(\fIc\fP) circle, (\fPd\fP) diamond, (\fPi\fP) itriangle, (\fPs\fP) square, (\fPt\fP) triangle, (\fPx\fP) cross.
Parameters are expected to be in the following columns
.TP
.B 1,2
longitude, latitude of event (\fB-:\fR option interchanges order)
.TP
.B 3
depth of event in kilometers
.TP
.B 4
Text string to appear above the beach ball (default) or under (add u).
.br
If size must be read, size must be in column 4 and Text string starts in column 5.
.br
\fIscale\R is the symbol size 
in MEASURE_UNIT (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended
to indicate that the size information is in units of cm, inch, meter, or point, respectively).
.sp
\fBOPTIONS
.br
\fPNo space between the option flag and the associated arguments.
.br
.sp
\fB\-B\fP sets map boundary tickmark intervals. See \fPpsbasemap\fP for details.
.br
.sp
\fB\-E\fP\fIfill\fP
\fRSelects filling of extensive quadrants. Usually white.
Set the shade (0\255) or color (r/g/b) [Default is 255/255/255].
.br
.sp
\fB\-G\fP selects filling of focal mechanisms. By convention, the
compressional quadrants are shaded.  Set the shade (0\-255) or color
(\fIr/g/b\fP) [Default is \fP0/0/0\fP].  Optionally, specify
\fB\-Gp\fIicon_size/pattern\fR, where \fPpattern\fP gives the
number of the image pattern (1-32) OR the name of a icon-format file.
\fPicon_size\fP sets the unit size in inches.  To invert black and
white pixels, use \fB\-GP\fR instead of \fP\-Gp\fP.  See
\fIpspatterns\fR for information on individual patterns.
.br
.sp
\fB\-H\fR
\fRInput file(s) has \fIn\fR Header record(s). Number of header records
can be changed by editing your .gmtdefaults file.
If used, \fBGMT-SYSTEM\fP default is 1 header record.
.br
.sp
\fB\-K
\fRMeans more \fIPostScript\fP code will be appended later. [Default terminates the plot system]
.br
.sp
\fB\-L\fR
\fRDraws the "beach ball" outline using current pen (see \fB\-W\fP) or sets pen attributes..
.br
.sp
\fB\-M
\fR Same size for any magnitude.
.br
.sp
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside map border [Default plots points inside border only].
.br
.sp
\fB\-O
\fRSelects Overlay plot mode. [Default initializes a new plot system]
.br
.sp
\fB\-P
\fRSelects Portrait plotting mode. [Default is Landscape]
.br
.sp
\fB\-T\fR[\fInum_of_plane\fR]
\fRPlots the nodal planes and outline the bubble which is transparent.
.br
      default num_of_plane is \fI0\fR : both nodal planes are plotted;
      num_of_plane equal      \fI1\fR : the only first nodal plane is plotted;
      num_of_plane equal      \fI2\fR : the only second nodal plane is plotted;
.br
.sp
\fP\-U
\fPDraws Unix System time stamp on plot. Append \fIc\fP to plot the command line or a text string of your
choice.
.br
.sp
\fB\-V\fP reports the name of the current file being plotted (Verbose mode).
.br
.sp
\fP\-W\fP set pen attributes for text string or default pen attribute for fault plane edges. 
 [Defaults: width = \fI1\fP, color = \fP0/0/0\fP, texture = \fPsolid\fP]. 
.br
.sp
\fB\-X \-Y\fP shifts origin of plot by (\fIx-shift,y-shift\fP) user_unit  [Default is (\fI1\fP,\fP1\fP) inch or (2.5,2.5) cm for new plots, (\fP0\fP,\fP0\fP) for overlays].
.br
.sp
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column.
.br
.sp
\fB\-a\fR[\fIaxis_symbol_size\fR[\fIP_axis_symbol\fR[\fIT_axis_symbol\fR]]]
.br
\fRComputes and plots P and T axis.
- axis_symbol_size in user unit [default is 0.2 cm or 0.08 inches].
.br
- default P and T axis symbols is 'c'
.br
Choose between the following :
(\fIc\fP) circle, (\fPd\fP) diamond, (\fPh\fP) hexagon,
(\fPi\fP) inverse triangle,
(\fPp\fP)point, (\fPs\fP) square, (\fPt\fP) triangle,
(\fPx\fP) cross.
.br
.sp
\fB\-e\fP\fIfill\fP
\fRSelects filling of T axis symbol.
Set the shade (0\255) or color (r/g/b) [Default is color of extensive parts. 
.br
.sp
\fB\-g\fP\fIfill\fP
\fRSelects filling of P axis symbol.
Set the shade (0\255) or color (r/g/b) [Default is color of compressive parts.
.br
.sp
\fB\-p\fR[\fIpen\fP]
\fRDraws the P axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
sp.
\fB\-t\fR[\fIpen\fP]
\fRDraws the T axis outline using current pen (see \fB\-W\fP), or sets
pen attributes.
.br
.sp
\fB\-:\fR toggles between (\fIlongitude\fR,\fPlatitude\fP) and (\fPlatitude\fP,\fPlongitude\fP) input/output.  [Default is (\fPlongitude\fP,\fPlatitude\fP)]
.br
.sp
\fB\-c\fR specifies the number of plot copies. [Default is \fI1\fP]
.br
.sp
\fBSEE ALSO
.br
\fRgmtsystem, psbasemap, psxy, psmeca
.sp
\fBREFERENCES
.br
Wessel P. and W.H.F. Smith, 1992, The GMT-SYSTEM.
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismolgy, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
Definition of scalar moment.
.br
Cliff Frohlich, Cliff'Nodes Concerning Plotting Nodal Lines for P, Sh and Sv
.br
Seismological Reasearch Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in C, Cambridge University press (routine jacobi)
.sp
\fBAUTHOR
.br
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@ipgp.jussieu.fr)
