/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmtdefaults.c	2.28  02/06/99
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * gmtdefaults will list the users default settings for the GMT-SYSTEM or
 * (by using the -D option), get the GMT-SYSTEM's default settings.
 *
 * Author:	Paul Wessel
 * Date:	1-MAY-1991
 * Version:	2.0
 * Modified:	12-JUN-1998, for GMT 3.1
 */
 
#include "gmt.h"

main (int argc, char **argv)
{
	int i;
	
	BOOLEAN error = FALSE, get_sys_defaults = FALSE, get_user_defaults = FALSE;
	
	GMT_stdout = stdout;	GMT_stdin = stdin;

	for (i = 1; !error && i < argc; i++) {
		if (argv[i][0] != '-') continue;
		switch (argv[i][1]) {
			case '\0':
				error += GMT_get_common_args (argv[i], 0, 0, 0, 0);
				break;
			case 'D':	/* Get GMT defaults settings */
				get_sys_defaults = TRUE;
				break;
			case 'L':	/* List the user's current GMT defaults settings */
				get_user_defaults = TRUE;
				break;
			default:
				error = TRUE;
                                GMT_default_error (argv[i][1]);
				break;
		}
	}
	
	if (argc == 1 || GMT_quick) {
		fprintf (stderr, "gmtdefaults %s - List GMT-SYSTEM default parameters\n\n", GMT_VERSION);
		fprintf (stderr, "usage: gmtdefaults [-D | -L]\n\n");
		if (GMT_quick) exit (EXIT_FAILURE);
		fprintf (stderr, "	-D prints the default settings for the GMT system\n");
		fprintf (stderr, "	-L prints the users current GMT default settings\n");
		exit (EXIT_FAILURE);
	}
	
	if (!(get_user_defaults || get_sys_defaults)){
		fprintf (stderr, "%s: GMT SYNTAX ERROR: Must specify one of -D or -L\n", GMT_program);
		error++;
	}
	
	if (error) exit (EXIT_FAILURE);
	
	if (get_user_defaults) GMT_getdefaults (CNULL);
	
	GMT_savedefaults (CNULL);

	exit (EXIT_SUCCESS);
}
