/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)gmt_win32.h	1.8  06/20/99
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * gmt_win32.h is an optional include file for the GMT-SYSTEM.  It
 * contains definitions for some constants, structures, and parameters
 * used by the programs that are not supported by WIN32.  Note that
 * all of these entities are part of POSIX.  This file is only included
 * by gmt.h and pslib_inc.h if the preprocessor flag WIN32 is defined.
 *
 * Author:	Paul Wessel
 * Date:	21-SEPT-1998
 *
 */

/* WIN32 versus _WIN32:
 *
 * In GMT, the WIN32 flag is predefined by the MicroSoft C compiler.
 * If set, we assume we are in a non-posix environment and must make
 * up the missing functions with homespun code.
 * WIN32 will set _WIN32 but the converse is not true.
 *
 * _WIN32 is set whenever we are compiling GMT on a PC not running
 * a Unix flavor.  This is true when GMT is to be installed under
 * Cygwin32.  _WIN32, when set, causes the directory delimiter to
 * be set to \ instead of /, and also attempts to deal with the fact
 * that DOS file systems have both TEXT and BINARY file modes.
 * Because i/o redirection in Cygwin and DOS is in TEXT mode the
 * user is warned not to attempt binary redirection.  See Appendix L.
 */

#ifndef _WIN32
#define _WIN32
#endif

#ifndef _GMT_PWD_
#define _GMT_PWD_

/* GMT normally gets these macros from unistd.h */

#define R_OK 04
#define W_OK 02
#define X_OK 01
#define F_OK 00

/* This structure is normally taken from pwd.h */

struct passwd {
	char	*pw_name;
	int	pw_uid;
	int	pw_gid;
	char	*pw_dir;
	char	*pw_shell;
};

/* These three functions prototypes are normally in pwd.h & unistd.h;
 * Here, they are defined at the bottom of gmt_init.c */

struct passwd *getpwnam (const char *name);
struct passwd *getpwuid (const int uid);
int getuid (void);

/* access is usually in unistd.h; we use a macro here
 * since the same function under WIN32 is prefixed with _ */

extern int _access (const char *path, int mode);
#define access(path, mode) _access(path, mode)

#endif
